/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewerlib.ui;

import com.android.hierarchyviewerlib.device.IHvDevice;
import com.android.hierarchyviewerlib.models.ViewNode;
import com.android.utils.SdkUtils;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class DevicePropertyEditingSupport {
    private static final List<IDevicePropertyEditor> sDevicePropertyEditors = Arrays.asList(new LayoutPropertyEditor(), new PaddingPropertyEditor());

    public boolean canEdit(ViewNode.Property p) {
        return this.getPropertyEditorFor(p) != null;
    }

    private IDevicePropertyEditor getPropertyEditorFor(ViewNode.Property p) {
        for (IDevicePropertyEditor pe : sDevicePropertyEditors) {
            if (!pe.canEdit(p)) continue;
            return pe;
        }
        return null;
    }

    public PropertyType getPropertyType(ViewNode.Property p) {
        return this.getPropertyEditorFor(p).getType(p);
    }

    public String[] getPropertyRange(ViewNode.Property p) {
        return this.getPropertyEditorFor(p).getPropertyRange(p);
    }

    public boolean setValue(Collection<ViewNode.Property> properties, ViewNode.Property p, Object newValue, ViewNode viewNode, IHvDevice device) {
        return this.getPropertyEditorFor(p).setValue(properties, p, newValue, viewNode, device);
    }

    private static String stripCategoryPrefix(String name) {
        return name.substring(name.indexOf(58) + 1);
    }

    private static class PaddingPropertyEditor
    implements IDevicePropertyEditor {
        private static final String PADDING_LEFT = "mPaddingLeft";
        private static final String PADDING_RIGHT = "mPaddingRight";
        private static final String PADDING_TOP = "mPaddingTop";
        private static final String PADDING_BOTTOM = "mPaddingBottom";
        private static final Set<String> sPaddingProperties = ImmutableSet.of((Object)"mPaddingLeft", (Object)"mPaddingRight", (Object)"mPaddingTop", (Object)"mPaddingBottom");

        private PaddingPropertyEditor() {
        }

        @Override
        public boolean canEdit(ViewNode.Property p) {
            return sPaddingProperties.contains(DevicePropertyEditingSupport.stripCategoryPrefix(p.name));
        }

        @Override
        public PropertyType getType(ViewNode.Property p) {
            return PropertyType.INTEGER;
        }

        @Override
        public String[] getPropertyRange(ViewNode.Property p) {
            return new String[0];
        }

        @Override
        public boolean setValue(Collection<ViewNode.Property> properties, ViewNode.Property prop, Object newValue, ViewNode viewNode, IHvDevice device) {
            int v;
            try {
                v = Integer.parseInt((String)newValue);
            }
            catch (NumberFormatException e) {
                return false;
            }
            int pLeft = 0;
            int pRight = 0;
            int pTop = 0;
            int pBottom = 0;
            String propName = DevicePropertyEditingSupport.stripCategoryPrefix(prop.name);
            for (ViewNode.Property p : properties) {
                String name = DevicePropertyEditingSupport.stripCategoryPrefix(p.name);
                if (!sPaddingProperties.contains(name)) continue;
                if (name.equals(PADDING_LEFT)) {
                    pLeft = propName.equals(PADDING_LEFT) ? v : SdkUtils.parseLocalizedInt((String)p.value, (int)0);
                    continue;
                }
                if (name.equals(PADDING_RIGHT)) {
                    pRight = propName.equals(PADDING_RIGHT) ? v : SdkUtils.parseLocalizedInt((String)p.value, (int)0);
                    continue;
                }
                if (name.equals(PADDING_TOP)) {
                    pTop = propName.equals(PADDING_TOP) ? v : SdkUtils.parseLocalizedInt((String)p.value, (int)0);
                    continue;
                }
                if (!name.equals(PADDING_BOTTOM)) continue;
                pBottom = propName.equals(PADDING_BOTTOM) ? v : SdkUtils.parseLocalizedInt((String)p.value, (int)0);
            }
            device.invokeViewMethod(viewNode.window, viewNode, "setPadding", Arrays.asList(pLeft, pTop, pRight, pBottom));
            prop.value = Integer.toString(v);
            return true;
        }
    }

    private static class LayoutPropertyEditor
    implements IDevicePropertyEditor {
        private static final Set<String> sLayoutPropertiesWithStringValues = ImmutableSet.of((Object)"layout_width", (Object)"layout_height", (Object)"layout_gravity");
        private static final int MATCH_PARENT = -1;
        private static final int FILL_PARENT = -1;
        private static final int WRAP_CONTENT = -2;

        private LayoutPropertyEditor() {
        }

        @Override
        public boolean canEdit(ViewNode.Property p) {
            String name = DevicePropertyEditingSupport.stripCategoryPrefix(p.name);
            if (!name.startsWith("layout_")) {
                return false;
            }
            if (sLayoutPropertiesWithStringValues.contains(name)) {
                return true;
            }
            try {
                SdkUtils.parseLocalizedInt((String)p.value);
                return true;
            }
            catch (ParseException e) {
                return false;
            }
        }

        @Override
        public PropertyType getType(ViewNode.Property p) {
            String name = DevicePropertyEditingSupport.stripCategoryPrefix(p.name);
            if (sLayoutPropertiesWithStringValues.contains(name)) {
                return PropertyType.INTEGER_OR_CONSTANT;
            }
            return PropertyType.INTEGER;
        }

        @Override
        public String[] getPropertyRange(ViewNode.Property p) {
            return new String[0];
        }

        @Override
        public boolean setValue(Collection<ViewNode.Property> properties, ViewNode.Property p, Object newValue, ViewNode viewNode, IHvDevice device) {
            String name = DevicePropertyEditingSupport.stripCategoryPrefix(p.name);
            if (p.value.equals(newValue)) {
                return false;
            }
            int value = -1;
            String textValue = null;
            if ("layout_gravity".equals(name)) {
                value = 0;
                StringBuilder sb = new StringBuilder(20);
                for (String attr : Splitter.on((char)'|').split((CharSequence)((String)newValue))) {
                    LayoutGravity g;
                    try {
                        g = LayoutGravity.valueOf(attr);
                    }
                    catch (IllegalArgumentException e) {
                        continue;
                    }
                    value |= g.mValue;
                    if (sb.length() > 0) {
                        sb.append('|');
                    }
                    sb.append(g.name());
                }
                textValue = sb.toString();
            } else if ("layout_height".equals(name) || "layout_width".equals(name)) {
                String s = (String)newValue;
                if (s.equalsIgnoreCase("match_parent")) {
                    textValue = "match_parent";
                    value = -1;
                } else if (s.equalsIgnoreCase("fill_parent")) {
                    textValue = "fill_parent";
                    value = -1;
                } else if (s.equalsIgnoreCase("wrap_content")) {
                    textValue = "wrap_content";
                    value = -2;
                }
            }
            if (textValue == null) {
                try {
                    value = Integer.parseInt((String)newValue);
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            if (device.setLayoutParameter(viewNode.window, viewNode, name = name.substring("layout_".length()), value)) {
                p.value = textValue != null ? textValue : (String)newValue;
            }
            return true;
        }

        private static enum LayoutGravity {
            top(48),
            bottom(80),
            left(3),
            right(5),
            center_vertical(16),
            fill_vertical(112),
            center_horizontal(1),
            fill_horizontal(7),
            center(17),
            fill(119),
            clip_vertical(128),
            clip_horizontal(8),
            start(0x800003),
            end(0x800005);

            private final int mValue;

            private LayoutGravity(int v) {
                this.mValue = v;
            }
        }
    }

    private static interface IDevicePropertyEditor {
        public boolean canEdit(ViewNode.Property var1);

        public PropertyType getType(ViewNode.Property var1);

        public String[] getPropertyRange(ViewNode.Property var1);

        public boolean setValue(Collection<ViewNode.Property> var1, ViewNode.Property var2, Object var3, ViewNode var4, IHvDevice var5);
    }

    public static enum PropertyType {
        INTEGER,
        INTEGER_OR_CONSTANT,
        ENUM;

    }
}

