/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewerlib.ui;

import com.android.hierarchyviewerlib.models.PixelPerfectModel;
import com.android.hierarchyviewerlib.models.ViewNode;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class PixelPerfect
extends ScrolledComposite
implements PixelPerfectModel.IImageChangeListener {
    private Canvas mCanvas;
    private PixelPerfectModel mModel;
    private Image mImage;
    private Color mCrosshairColor;
    private Color mMarginColor;
    private Color mBorderColor;
    private Color mPaddingColor;
    private int mWidth;
    private int mHeight;
    private Point mCrosshairLocation;
    private ViewNode mSelectedNode;
    private Image mOverlayImage;
    private double mOverlayTransparency;
    private DisposeListener mDisposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            PixelPerfect.this.mModel.removeImageChangeListener(PixelPerfect.this);
            PixelPerfect.this.mCrosshairColor.dispose();
            PixelPerfect.this.mBorderColor.dispose();
            PixelPerfect.this.mPaddingColor.dispose();
        }
    };
    private MouseListener mMouseListener = new MouseListener(){

        public void mouseDoubleClick(MouseEvent e) {
        }

        public void mouseDown(MouseEvent e) {
            PixelPerfect.this.handleMouseEvent(e);
        }

        public void mouseUp(MouseEvent e) {
            PixelPerfect.this.handleMouseEvent(e);
        }
    };
    private MouseMoveListener mMouseMoveListener = new MouseMoveListener(){

        public void mouseMove(MouseEvent e) {
            if (e.stateMask != 0) {
                PixelPerfect.this.handleMouseEvent(e);
            }
        }
    };
    private KeyListener mKeyListener = new KeyListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void keyPressed(KeyEvent e) {
            boolean crosshairMoved = false;
            PixelPerfect pixelPerfect = PixelPerfect.this;
            synchronized (pixelPerfect) {
                if (PixelPerfect.this.mImage != null) {
                    switch (e.keyCode) {
                        case 0x1000001: {
                            if (((PixelPerfect)PixelPerfect.this).mCrosshairLocation.y == 0) break;
                            --((PixelPerfect)PixelPerfect.this).mCrosshairLocation.y;
                            crosshairMoved = true;
                            break;
                        }
                        case 0x1000002: {
                            if (((PixelPerfect)PixelPerfect.this).mCrosshairLocation.y == PixelPerfect.this.mHeight - 1) break;
                            ++((PixelPerfect)PixelPerfect.this).mCrosshairLocation.y;
                            crosshairMoved = true;
                            break;
                        }
                        case 0x1000003: {
                            if (((PixelPerfect)PixelPerfect.this).mCrosshairLocation.x == 0) break;
                            --((PixelPerfect)PixelPerfect.this).mCrosshairLocation.x;
                            crosshairMoved = true;
                            break;
                        }
                        case 0x1000004: {
                            if (((PixelPerfect)PixelPerfect.this).mCrosshairLocation.x == PixelPerfect.this.mWidth - 1) break;
                            ++((PixelPerfect)PixelPerfect.this).mCrosshairLocation.x;
                            crosshairMoved = true;
                        }
                    }
                }
            }
            if (crosshairMoved) {
                PixelPerfect.this.mModel.setCrosshairLocation(((PixelPerfect)PixelPerfect.this).mCrosshairLocation.x, ((PixelPerfect)PixelPerfect.this).mCrosshairLocation.y);
            }
        }

        public void keyReleased(KeyEvent e) {
        }
    };
    private PaintListener mPaintListener = new PaintListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paintControl(PaintEvent e) {
            PixelPerfect pixelPerfect = PixelPerfect.this;
            synchronized (pixelPerfect) {
                e.gc.setBackground(Display.getDefault().getSystemColor(2));
                e.gc.fillRectangle(0, 0, ((PixelPerfect)PixelPerfect.this).mCanvas.getSize().x, ((PixelPerfect)PixelPerfect.this).mCanvas.getSize().y);
                if (PixelPerfect.this.mImage != null) {
                    int leftOffset = ((PixelPerfect)PixelPerfect.this).mCanvas.getSize().x / 2 - PixelPerfect.this.mWidth / 2;
                    int topOffset = ((PixelPerfect)PixelPerfect.this).mCanvas.getSize().y / 2 - PixelPerfect.this.mHeight / 2;
                    e.gc.drawImage(PixelPerfect.this.mImage, leftOffset, topOffset);
                    if (PixelPerfect.this.mOverlayImage != null) {
                        e.gc.setAlpha((int)(PixelPerfect.this.mOverlayTransparency * 255.0));
                        int overlayTopOffset = ((PixelPerfect)PixelPerfect.this).mCanvas.getSize().y / 2 + PixelPerfect.this.mHeight / 2 - ((PixelPerfect)PixelPerfect.this).mOverlayImage.getBounds().height;
                        e.gc.drawImage(PixelPerfect.this.mOverlayImage, leftOffset, overlayTopOffset);
                        e.gc.setAlpha(255);
                    }
                    if (PixelPerfect.this.mSelectedNode != null) {
                        int leftShift = 0;
                        int topShift = 0;
                        int nodeLeft = ((PixelPerfect)PixelPerfect.this).mSelectedNode.left;
                        int nodeTop = ((PixelPerfect)PixelPerfect.this).mSelectedNode.top;
                        int nodeWidth = ((PixelPerfect)PixelPerfect.this).mSelectedNode.width;
                        int nodeHeight = ((PixelPerfect)PixelPerfect.this).mSelectedNode.height;
                        int nodeMarginLeft = ((PixelPerfect)PixelPerfect.this).mSelectedNode.marginLeft;
                        int nodeMarginTop = ((PixelPerfect)PixelPerfect.this).mSelectedNode.marginTop;
                        int nodeMarginRight = ((PixelPerfect)PixelPerfect.this).mSelectedNode.marginRight;
                        int nodeMarginBottom = ((PixelPerfect)PixelPerfect.this).mSelectedNode.marginBottom;
                        int nodePadLeft = ((PixelPerfect)PixelPerfect.this).mSelectedNode.paddingLeft;
                        int nodePadTop = ((PixelPerfect)PixelPerfect.this).mSelectedNode.paddingTop;
                        int nodePadRight = ((PixelPerfect)PixelPerfect.this).mSelectedNode.paddingRight;
                        int nodePadBottom = ((PixelPerfect)PixelPerfect.this).mSelectedNode.paddingBottom;
                        ViewNode cur = PixelPerfect.this.mSelectedNode;
                        while (cur.parent != null) {
                            leftShift += cur.parent.left - cur.parent.scrollX;
                            topShift += cur.parent.top - cur.parent.scrollY;
                            cur = cur.parent;
                        }
                        if (cur.width > cur.height) {
                            e.gc.setForeground(PixelPerfect.this.mPaddingColor);
                            e.gc.drawRectangle(leftOffset + PixelPerfect.this.mWidth - nodeTop - topShift - nodeHeight + nodePadBottom, topOffset + leftShift + nodeLeft + nodePadLeft, nodeHeight - nodePadBottom - nodePadTop, nodeWidth - nodePadRight - nodePadLeft);
                            e.gc.setForeground(PixelPerfect.this.mMarginColor);
                            e.gc.drawRectangle(leftOffset + PixelPerfect.this.mWidth - nodeTop - topShift - nodeHeight - nodeMarginBottom, topOffset + leftShift + nodeLeft - nodeMarginLeft, nodeHeight + nodeMarginBottom + nodeMarginTop, nodeWidth + nodeMarginRight + nodeMarginLeft);
                            e.gc.setForeground(PixelPerfect.this.mBorderColor);
                            e.gc.drawRectangle(leftOffset + PixelPerfect.this.mWidth - nodeTop - topShift - nodeHeight, topOffset + leftShift + nodeLeft, nodeHeight, nodeWidth);
                        } else {
                            e.gc.setForeground(PixelPerfect.this.mPaddingColor);
                            e.gc.drawRectangle(leftOffset + leftShift + nodeLeft + nodePadLeft, topOffset + topShift + nodeTop + nodePadTop, nodeWidth - nodePadRight - nodePadLeft, nodeHeight - nodePadBottom - nodePadTop);
                            e.gc.setForeground(PixelPerfect.this.mMarginColor);
                            e.gc.drawRectangle(leftOffset + leftShift + nodeLeft - nodeMarginLeft, topOffset + topShift + nodeTop - nodeMarginTop, nodeWidth + nodeMarginRight + nodeMarginLeft, nodeHeight + nodeMarginBottom + nodeMarginTop);
                            e.gc.setForeground(PixelPerfect.this.mBorderColor);
                            e.gc.drawRectangle(leftOffset + leftShift + nodeLeft, topOffset + topShift + nodeTop, nodeWidth, nodeHeight);
                        }
                    }
                    if (PixelPerfect.this.mCrosshairLocation != null) {
                        e.gc.setForeground(PixelPerfect.this.mCrosshairColor);
                        e.gc.drawLine(leftOffset, topOffset + ((PixelPerfect)PixelPerfect.this).mCrosshairLocation.y, leftOffset + PixelPerfect.this.mWidth - 1, topOffset + ((PixelPerfect)PixelPerfect.this).mCrosshairLocation.y);
                        e.gc.drawLine(leftOffset + ((PixelPerfect)PixelPerfect.this).mCrosshairLocation.x, topOffset, leftOffset + ((PixelPerfect)PixelPerfect.this).mCrosshairLocation.x, topOffset + PixelPerfect.this.mHeight - 1);
                    }
                }
            }
        }
    };

    public PixelPerfect(Composite parent) {
        super(parent, 768);
        this.mCanvas = new Canvas((Composite)this, 0);
        this.setContent((Control)this.mCanvas);
        this.setExpandHorizontal(true);
        this.setExpandVertical(true);
        this.mModel = PixelPerfectModel.getModel();
        this.mModel.addImageChangeListener(this);
        this.mCanvas.addPaintListener(this.mPaintListener);
        this.mCanvas.addMouseListener(this.mMouseListener);
        this.mCanvas.addMouseMoveListener(this.mMouseMoveListener);
        this.mCanvas.addKeyListener(this.mKeyListener);
        this.addDisposeListener(this.mDisposeListener);
        this.mCrosshairColor = new Color((Device)Display.getDefault(), new RGB(0, 255, 255));
        this.mBorderColor = new Color((Device)Display.getDefault(), new RGB(255, 0, 0));
        this.mMarginColor = new Color((Device)Display.getDefault(), new RGB(0, 255, 0));
        this.mPaddingColor = new Color((Device)Display.getDefault(), new RGB(0, 0, 255));
        this.imageLoaded();
    }

    public boolean setFocus() {
        return this.mCanvas.setFocus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMouseEvent(MouseEvent e) {
        PixelPerfect pixelPerfect = this;
        synchronized (pixelPerfect) {
            if (this.mImage == null) {
                return;
            }
            int leftOffset = this.mCanvas.getSize().x / 2 - this.mWidth / 2;
            int topOffset = this.mCanvas.getSize().y / 2 - this.mHeight / 2;
            e.x -= leftOffset;
            e.y -= topOffset;
            e.x = Math.max(e.x, 0);
            e.x = Math.min(e.x, this.mWidth - 1);
            e.y = Math.max(e.y, 0);
            e.y = Math.min(e.y, this.mHeight - 1);
        }
        this.mModel.setCrosshairLocation(e.x, e.y);
    }

    private void doRedraw() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                PixelPerfect.this.mCanvas.redraw();
            }
        });
    }

    private void loadImage() {
        this.mImage = this.mModel.getImage();
        if (this.mImage != null) {
            this.mWidth = this.mImage.getBounds().width;
            this.mHeight = this.mImage.getBounds().height;
        } else {
            this.mWidth = 0;
            this.mHeight = 0;
        }
        this.setMinSize(this.mWidth, this.mHeight);
    }

    @Override
    public void imageLoaded() {
        Display.getDefault().syncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                7 var1_1 = this;
                synchronized (var1_1) {
                    PixelPerfect.this.loadImage();
                    PixelPerfect.this.mCrosshairLocation = PixelPerfect.this.mModel.getCrosshairLocation();
                    PixelPerfect.this.mSelectedNode = PixelPerfect.this.mModel.getSelected();
                    PixelPerfect.this.mOverlayImage = PixelPerfect.this.mModel.getOverlayImage();
                    PixelPerfect.this.mOverlayTransparency = PixelPerfect.this.mModel.getOverlayTransparency();
                }
            }
        });
        this.doRedraw();
    }

    @Override
    public void imageChanged() {
        Display.getDefault().syncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                8 var1_1 = this;
                synchronized (var1_1) {
                    PixelPerfect.this.loadImage();
                }
            }
        });
        this.doRedraw();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void crosshairMoved() {
        PixelPerfect pixelPerfect = this;
        synchronized (pixelPerfect) {
            this.mCrosshairLocation = this.mModel.getCrosshairLocation();
        }
        this.doRedraw();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void selectionChanged() {
        PixelPerfect pixelPerfect = this;
        synchronized (pixelPerfect) {
            this.mSelectedNode = this.mModel.getSelected();
        }
        this.doRedraw();
    }

    @Override
    public void treeChanged() {
        Display.getDefault().syncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                9 var1_1 = this;
                synchronized (var1_1) {
                    PixelPerfect.this.mSelectedNode = PixelPerfect.this.mModel.getSelected();
                }
            }
        });
        this.doRedraw();
    }

    @Override
    public void zoomChanged() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void overlayChanged() {
        PixelPerfect pixelPerfect = this;
        synchronized (pixelPerfect) {
            this.mOverlayImage = this.mModel.getOverlayImage();
            this.mOverlayTransparency = this.mModel.getOverlayTransparency();
        }
        this.doRedraw();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void overlayTransparencyChanged() {
        PixelPerfect pixelPerfect = this;
        synchronized (pixelPerfect) {
            this.mOverlayTransparency = this.mModel.getOverlayTransparency();
        }
        this.doRedraw();
    }
}

