/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewerlib.ui;

import com.android.ddmuilib.ImageLoader;
import com.android.hierarchyviewerlib.models.TreeViewModel;
import com.android.hierarchyviewerlib.ui.util.DrawableViewNode;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class TreeViewOverview
extends Canvas
implements TreeViewModel.ITreeChangeListener {
    private TreeViewModel mModel;
    private DrawableViewNode mTree;
    private DrawableViewNode.Rectangle mViewport;
    private Transform mTransform;
    private Transform mInverse;
    private DrawableViewNode.Rectangle mBounds = new DrawableViewNode.Rectangle();
    private double mScale;
    private boolean mDragging = false;
    private DrawableViewNode mSelectedNode;
    private static Image sNotSelectedImage;
    private static Image sSelectedImage;
    private static Image sFilteredImage;
    private static Image sFilteredSelectedImage;
    private DisposeListener mDisposeListener = new DisposeListener(){

        public void widgetDisposed(DisposeEvent e) {
            TreeViewOverview.this.mModel.removeTreeChangeListener(TreeViewOverview.this);
            TreeViewOverview.this.mTransform.dispose();
            TreeViewOverview.this.mInverse.dispose();
        }
    };
    private MouseListener mMouseListener = new MouseListener(){

        public void mouseDoubleClick(MouseEvent e) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseDown(MouseEvent e) {
            boolean redraw = false;
            TreeViewOverview treeViewOverview = TreeViewOverview.this;
            synchronized (treeViewOverview) {
                if (TreeViewOverview.this.mTree != null && TreeViewOverview.this.mViewport != null) {
                    TreeViewOverview.this.mDragging = true;
                    redraw = true;
                    TreeViewOverview.this.handleMouseEvent(TreeViewOverview.this.transformPoint(e.x, e.y));
                }
            }
            if (redraw) {
                TreeViewOverview.this.mModel.removeTreeChangeListener(TreeViewOverview.this);
                TreeViewOverview.this.mModel.setViewport(TreeViewOverview.this.mViewport);
                TreeViewOverview.this.mModel.addTreeChangeListener(TreeViewOverview.this);
                TreeViewOverview.this.doRedraw();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseUp(MouseEvent e) {
            boolean redraw = false;
            TreeViewOverview treeViewOverview = TreeViewOverview.this;
            synchronized (treeViewOverview) {
                if (TreeViewOverview.this.mTree != null && TreeViewOverview.this.mViewport != null) {
                    TreeViewOverview.this.mDragging = false;
                    redraw = true;
                    TreeViewOverview.this.handleMouseEvent(TreeViewOverview.this.transformPoint(e.x, e.y));
                    TreeViewOverview.this.setBounds();
                    TreeViewOverview.this.setTransform();
                }
            }
            if (redraw) {
                TreeViewOverview.this.mModel.removeTreeChangeListener(TreeViewOverview.this);
                TreeViewOverview.this.mModel.setViewport(TreeViewOverview.this.mViewport);
                TreeViewOverview.this.mModel.addTreeChangeListener(TreeViewOverview.this);
                TreeViewOverview.this.doRedraw();
            }
        }
    };
    private MouseMoveListener mMouseMoveListener = new MouseMoveListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mouseMove(MouseEvent e) {
            boolean moved = false;
            TreeViewOverview treeViewOverview = TreeViewOverview.this;
            synchronized (treeViewOverview) {
                if (TreeViewOverview.this.mDragging) {
                    moved = true;
                    TreeViewOverview.this.handleMouseEvent(TreeViewOverview.this.transformPoint(e.x, e.y));
                }
            }
            if (moved) {
                TreeViewOverview.this.mModel.removeTreeChangeListener(TreeViewOverview.this);
                TreeViewOverview.this.mModel.setViewport(TreeViewOverview.this.mViewport);
                TreeViewOverview.this.mModel.addTreeChangeListener(TreeViewOverview.this);
                TreeViewOverview.this.doRedraw();
            }
        }
    };
    private Listener mResizeListener = new Listener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleEvent(Event arg0) {
            TreeViewOverview treeViewOverview = TreeViewOverview.this;
            synchronized (treeViewOverview) {
                TreeViewOverview.this.setTransform();
            }
            TreeViewOverview.this.doRedraw();
        }
    };
    private PaintListener mPaintListener = new PaintListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paintControl(PaintEvent e) {
            TreeViewOverview treeViewOverview = TreeViewOverview.this;
            synchronized (treeViewOverview) {
                if (TreeViewOverview.this.mTree != null) {
                    e.gc.setBackground(Display.getDefault().getSystemColor(2));
                    e.gc.setForeground(Display.getDefault().getSystemColor(1));
                    e.gc.fillRectangle(0, 0, TreeViewOverview.this.getBounds().width, TreeViewOverview.this.getBounds().height);
                    e.gc.setTransform(TreeViewOverview.this.mTransform);
                    e.gc.setLineWidth((int)Math.ceil(0.7 / TreeViewOverview.this.mScale));
                    Path connectionPath = new Path((Device)Display.getDefault());
                    TreeViewOverview.this.paintRecursive(e.gc, TreeViewOverview.this.mTree, connectionPath);
                    e.gc.drawPath(connectionPath);
                    connectionPath.dispose();
                    if (TreeViewOverview.this.mViewport != null) {
                        e.gc.setAlpha(50);
                        e.gc.setBackground(Display.getDefault().getSystemColor(1));
                        e.gc.fillRectangle((int)((TreeViewOverview)TreeViewOverview.this).mViewport.x, (int)((TreeViewOverview)TreeViewOverview.this).mViewport.y, (int)Math.ceil(((TreeViewOverview)TreeViewOverview.this).mViewport.width), (int)Math.ceil(((TreeViewOverview)TreeViewOverview.this).mViewport.height));
                        e.gc.setAlpha(255);
                        e.gc.setForeground(Display.getDefault().getSystemColor(16));
                        e.gc.setLineWidth((int)Math.ceil(2.0 / TreeViewOverview.this.mScale));
                        e.gc.drawRectangle((int)((TreeViewOverview)TreeViewOverview.this).mViewport.x, (int)((TreeViewOverview)TreeViewOverview.this).mViewport.y, (int)Math.ceil(((TreeViewOverview)TreeViewOverview.this).mViewport.width), (int)Math.ceil(((TreeViewOverview)TreeViewOverview.this).mViewport.height));
                    }
                }
            }
        }
    };

    public TreeViewOverview(Composite parent) {
        super(parent, 0);
        this.mModel = TreeViewModel.getModel();
        this.mModel.addTreeChangeListener(this);
        this.loadResources();
        this.addPaintListener(this.mPaintListener);
        this.addMouseListener(this.mMouseListener);
        this.addMouseMoveListener(this.mMouseMoveListener);
        this.addListener(11, this.mResizeListener);
        this.addDisposeListener(this.mDisposeListener);
        this.mTransform = new Transform((Device)Display.getDefault());
        this.mInverse = new Transform((Device)Display.getDefault());
        this.loadAllData();
    }

    private void loadResources() {
        ImageLoader loader = ImageLoader.getLoader(this.getClass());
        sNotSelectedImage = loader.loadImage("not-selected.png", Display.getDefault());
        sSelectedImage = loader.loadImage("selected-small.png", Display.getDefault());
        sFilteredImage = loader.loadImage("filtered.png", Display.getDefault());
        sFilteredSelectedImage = loader.loadImage("selected-filtered-small.png", Display.getDefault());
    }

    private void handleMouseEvent(DrawableViewNode.Point pt) {
        this.mViewport.x = pt.x - this.mViewport.width / 2.0;
        this.mViewport.y = pt.y - this.mViewport.height / 2.0;
        if (this.mViewport.x < this.mBounds.x) {
            this.mViewport.x = this.mBounds.x;
        }
        if (this.mViewport.y < this.mBounds.y) {
            this.mViewport.y = this.mBounds.y;
        }
        if (this.mViewport.x + this.mViewport.width > this.mBounds.x + this.mBounds.width) {
            this.mViewport.x = this.mBounds.x + this.mBounds.width - this.mViewport.width;
        }
        if (this.mViewport.y + this.mViewport.height > this.mBounds.y + this.mBounds.height) {
            this.mViewport.y = this.mBounds.y + this.mBounds.height - this.mViewport.height;
        }
    }

    private DrawableViewNode.Point transformPoint(double x, double y) {
        float[] pt = new float[]{(float)x, (float)y};
        this.mInverse.transform(pt);
        return new DrawableViewNode.Point(pt[0], pt[1]);
    }

    private void paintRecursive(GC gc, DrawableViewNode node, Path connectionPath) {
        if (this.mSelectedNode == node && node.viewNode.filtered) {
            gc.drawImage(sFilteredSelectedImage, node.left, (int)Math.round(node.top));
        } else if (this.mSelectedNode == node) {
            gc.drawImage(sSelectedImage, node.left, (int)Math.round(node.top));
        } else if (node.viewNode.filtered) {
            gc.drawImage(sFilteredImage, node.left, (int)Math.round(node.top));
        } else {
            gc.drawImage(sNotSelectedImage, node.left, (int)Math.round(node.top));
        }
        int N = node.children.size();
        if (N == 0) {
            return;
        }
        float childSpacing = 80.0f / (float)N;
        for (int i = 0; i < N; ++i) {
            DrawableViewNode child = node.children.get(i);
            this.paintRecursive(gc, child, connectionPath);
            float x1 = node.left + 180;
            float y1 = (float)node.top + 10.0f + childSpacing * (float)i + childSpacing / 2.0f;
            float x2 = child.left;
            float y2 = (float)child.top + 50.0f;
            float cx1 = x1 + 17.5f;
            float cy1 = y1;
            float cx2 = x2 - 17.5f;
            float cy2 = y2;
            connectionPath.moveTo(x1, y1);
            connectionPath.cubicTo(cx1, cy1, cx2, cy2, x2, y2);
        }
    }

    private void doRedraw() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                TreeViewOverview.this.redraw();
            }
        });
    }

    public void loadAllData() {
        Display.getDefault().syncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                7 var1_1 = this;
                synchronized (var1_1) {
                    TreeViewOverview.this.mTree = TreeViewOverview.this.mModel.getTree();
                    TreeViewOverview.this.mSelectedNode = TreeViewOverview.this.mModel.getSelection();
                    TreeViewOverview.this.mViewport = TreeViewOverview.this.mModel.getViewport();
                    TreeViewOverview.this.setBounds();
                    TreeViewOverview.this.setTransform();
                }
            }
        });
    }

    @Override
    public void treeChanged() {
        Display.getDefault().syncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                8 var1_1 = this;
                synchronized (var1_1) {
                    TreeViewOverview.this.mTree = TreeViewOverview.this.mModel.getTree();
                    TreeViewOverview.this.mSelectedNode = TreeViewOverview.this.mModel.getSelection();
                    TreeViewOverview.this.mViewport = TreeViewOverview.this.mModel.getViewport();
                    TreeViewOverview.this.setBounds();
                    TreeViewOverview.this.setTransform();
                }
            }
        });
        this.doRedraw();
    }

    private void setBounds() {
        if (this.mViewport != null && this.mTree != null) {
            this.mBounds.x = Math.min(this.mViewport.x, this.mTree.bounds.x);
            this.mBounds.y = Math.min(this.mViewport.y, this.mTree.bounds.y);
            this.mBounds.width = Math.max(this.mViewport.x + this.mViewport.width, this.mTree.bounds.x + this.mTree.bounds.width) - this.mBounds.x;
            this.mBounds.height = Math.max(this.mViewport.y + this.mViewport.height, this.mTree.bounds.y + this.mTree.bounds.height) - this.mBounds.y;
        } else if (this.mTree != null) {
            this.mBounds.x = this.mTree.bounds.x;
            this.mBounds.y = this.mTree.bounds.y;
            this.mBounds.width = this.mTree.bounds.x + this.mTree.bounds.width - this.mBounds.x;
            this.mBounds.height = this.mTree.bounds.y + this.mTree.bounds.height - this.mBounds.y;
        }
    }

    private void setTransform() {
        if (this.mTree != null) {
            this.mTransform.identity();
            this.mInverse.identity();
            DrawableViewNode.Point size = new DrawableViewNode.Point();
            size.x = this.getBounds().width;
            size.y = this.getBounds().height;
            this.mScale = this.mBounds.width == 0.0 || this.mBounds.height == 0.0 || size.x == 0.0 || size.y == 0.0 ? 1.0 : Math.min(size.x / this.mBounds.width, size.y / this.mBounds.height);
            this.mTransform.scale((float)this.mScale, (float)this.mScale);
            this.mInverse.scale((float)this.mScale, (float)this.mScale);
            this.mTransform.translate((float)(-this.mBounds.x), (float)(-this.mBounds.y));
            this.mInverse.translate((float)(-this.mBounds.x), (float)(-this.mBounds.y));
            if (size.x / this.mBounds.width < size.y / this.mBounds.height) {
                this.mTransform.translate(0.0f, (float)(size.y / this.mScale - this.mBounds.height) / 2.0f);
                this.mInverse.translate(0.0f, (float)(size.y / this.mScale - this.mBounds.height) / 2.0f);
            } else {
                this.mTransform.translate((float)(size.x / this.mScale - this.mBounds.width) / 2.0f, 0.0f);
                this.mInverse.translate((float)(size.x / this.mScale - this.mBounds.width) / 2.0f, 0.0f);
            }
            this.mInverse.invert();
        }
    }

    @Override
    public void viewportChanged() {
        Display.getDefault().syncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                9 var1_1 = this;
                synchronized (var1_1) {
                    TreeViewOverview.this.mViewport = TreeViewOverview.this.mModel.getViewport();
                    TreeViewOverview.this.setBounds();
                    TreeViewOverview.this.setTransform();
                }
            }
        });
        this.doRedraw();
    }

    @Override
    public void zoomChanged() {
        this.viewportChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void selectionChanged() {
        TreeViewOverview treeViewOverview = this;
        synchronized (treeViewOverview) {
            this.mSelectedNode = this.mModel.getSelection();
        }
        this.doRedraw();
    }
}

