/*
 * Decompiled with CFR 0.152.
 */
package com.android.hierarchyviewerlib.ui.util;

import com.android.hierarchyviewerlib.models.ViewNode;
import java.util.ArrayList;

public class DrawableViewNode {
    public ViewNode viewNode;
    public final ArrayList<DrawableViewNode> children = new ArrayList();
    public static final int NODE_HEIGHT = 100;
    public static final int NODE_WIDTH = 180;
    public static final int CONTENT_LEFT_RIGHT_PADDING = 9;
    public static final int CONTENT_TOP_BOTTOM_PADDING = 8;
    public static final int CONTENT_INTER_PADDING = 3;
    public static final int INDEX_PADDING = 7;
    public static final int LEAF_NODE_SPACING = 9;
    public static final int NON_LEAF_NODE_SPACING = 15;
    public static final int PARENT_CHILD_SPACING = 50;
    public static final int PADDING = 30;
    public int treeHeight;
    public int treeWidth;
    public boolean leaf;
    public DrawableViewNode parent;
    public int left;
    public double top;
    public int topSpacing;
    public int bottomSpacing;
    public boolean treeDrawn;
    public Rectangle bounds = new Rectangle();

    public DrawableViewNode(ViewNode viewNode) {
        this.viewNode = viewNode;
        boolean bl = this.treeDrawn = !viewNode.willNotDraw;
        if (viewNode.children.size() == 0) {
            this.treeHeight = 100;
            this.treeWidth = 180;
            this.leaf = true;
        } else {
            this.leaf = false;
            int N = viewNode.children.size();
            this.treeHeight = 0;
            this.treeWidth = 0;
            for (int i = 0; i < N; ++i) {
                DrawableViewNode child = new DrawableViewNode(viewNode.children.get(i));
                this.children.add(child);
                child.parent = this;
                this.treeHeight += child.treeHeight;
                this.treeWidth = Math.max(this.treeWidth, child.treeWidth);
                if (i != 0) {
                    DrawableViewNode prevChild = this.children.get(i - 1);
                    if (prevChild.leaf && child.leaf) {
                        this.treeHeight += 9;
                        prevChild.bottomSpacing = 9;
                        child.topSpacing = 9;
                    } else {
                        this.treeHeight += 15;
                        prevChild.bottomSpacing = 15;
                        child.topSpacing = 15;
                    }
                }
                this.treeDrawn |= child.treeDrawn;
            }
            this.treeWidth += 230;
        }
    }

    public void setLeft() {
        if (this.parent == null) {
            this.left = 30;
            this.bounds.x = 0.0;
            this.bounds.width = this.treeWidth + 60;
        } else {
            this.left = this.parent.left + 180 + 50;
        }
        int N = this.children.size();
        for (int i = 0; i < N; ++i) {
            this.children.get(i).setLeft();
        }
    }

    public void placeRoot() {
        this.top = 30.0 + (double)(this.treeHeight - 100) / 2.0;
        double currentTop = 30.0;
        int N = this.children.size();
        for (int i = 0; i < N; ++i) {
            DrawableViewNode child = this.children.get(i);
            child.place(currentTop, this.top - currentTop);
            currentTop += (double)(child.treeHeight + child.bottomSpacing);
        }
        this.bounds.y = 0.0;
        this.bounds.height = this.treeHeight + 60;
    }

    private void place(double treeTop, double rootDistance) {
        this.top = (double)this.treeHeight <= rootDistance ? treeTop + (double)this.treeHeight - 100.0 : (rootDistance <= -100.0 ? treeTop : (this.children.size() == 0 ? treeTop : rootDistance + treeTop - 100.0 + 200.0 / (double)(this.treeHeight + 100) * ((double)this.treeHeight - rootDistance)));
        int N = this.children.size();
        double currentTop = treeTop;
        for (int i = 0; i < N; ++i) {
            DrawableViewNode child = this.children.get(i);
            child.place(currentTop, rootDistance);
            currentTop += (double)(child.treeHeight + child.bottomSpacing);
            rootDistance -= (double)(child.treeHeight + child.bottomSpacing);
        }
    }

    public DrawableViewNode getSelected(double x, double y) {
        if (x >= (double)this.left && x < (double)(this.left + 180) && y >= this.top && y <= this.top + 100.0) {
            return this;
        }
        int N = this.children.size();
        for (int i = 0; i < N; ++i) {
            DrawableViewNode selected = this.children.get(i).getSelected(x, y);
            if (selected == null) continue;
            return selected;
        }
        return null;
    }

    public void move(double distance) {
        double treeTop;
        this.top -= distance;
        DrawableViewNode root = this;
        while (root.parent != null) {
            root = root.parent;
        }
        if (this.top + 100.0 <= root.top) {
            treeTop = this.top + 100.0 - (double)this.treeHeight;
        } else if (this.top >= root.top + 100.0) {
            treeTop = this.top;
        } else if (this.leaf) {
            treeTop = this.top;
        } else {
            double distanceRatio = 1.0 - (root.top + 100.0 - this.top) / 200.0;
            treeTop = root.top - (double)this.treeHeight + distanceRatio * (double)(this.treeHeight + 100);
        }
        DrawableViewNode node = this;
        while (node.parent != null) {
            int index = node.viewNode.index;
            for (int i = 0; i < index; ++i) {
                DrawableViewNode sibling = node.parent.children.get(i);
                treeTop -= (double)(sibling.treeHeight + sibling.bottomSpacing);
            }
            node = node.parent;
        }
        root.bounds.y = Math.min(root.top - 30.0, treeTop - 30.0);
        root.bounds.height = Math.max(treeTop + (double)root.treeHeight + 30.0, root.top + 100.0 + 30.0) - root.bounds.y;
        double currentTop = treeTop;
        int N = root.children.size();
        for (int i = 0; i < N; ++i) {
            DrawableViewNode child = root.children.get(i);
            child.place(currentTop, root.top - currentTop);
            currentTop += (double)(child.treeHeight + child.bottomSpacing);
        }
    }

    public static class Point {
        public double x;
        public double y;

        public Point() {
        }

        public Point(double x, double y) {
            this.x = x;
            this.y = y;
        }

        public String toString() {
            return "(" + this.x + ", " + this.y + ")";
        }
    }

    public static class Rectangle {
        public double x;
        public double y;
        public double width;
        public double height;

        public Rectangle() {
        }

        public Rectangle(Rectangle other) {
            this.x = other.x;
            this.y = other.y;
            this.width = other.width;
            this.height = other.height;
        }

        public Rectangle(double x, double y, double width, double height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        public String toString() {
            return "{" + this.x + ", " + this.y + ", " + this.width + ", " + this.height + "}";
        }
    }
}

