/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import java.io.File;
import lombok.ast.AstVisitor;
import lombok.ast.MethodDeclaration;
import lombok.ast.MethodInvocation;
import lombok.ast.Node;
import lombok.ast.Select;

public class ColorUsageDetector
extends Detector
implements Detector.JavaScanner {
    public static final Issue ISSUE = Issue.create("ResourceAsColor", "Should pass resolved color instead of resource id", "Looks for calls to setColor where a resource id is passed instead of a resolved color", "Methods that take a color in the form of an integer should be passed an RGB triple, not the actual color resource id. You must call `getResources().getColor(resource)` to resolve the actual color value first.", Category.CORRECTNESS, 7, Severity.ERROR, new Implementation(ColorUsageDetector.class, Scope.JAVA_FILE_SCOPE));

    @Override
    public boolean appliesTo(@NonNull Context context, @NonNull File file) {
        return true;
    }

    @Override
    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public boolean appliesToResourceRefs() {
        return true;
    }

    @Override
    public void visitResourceReference(@NonNull JavaContext context, @Nullable AstVisitor visitor, @NonNull Node select, @NonNull String type, @NonNull String name, boolean isFramework) {
        if (type.equals("color")) {
            while (select.getParent() instanceof Select) {
                select = select.getParent();
            }
            for (Node current = select.getParent(); current != null; current = current.getParent()) {
                if (current.getClass() == MethodInvocation.class) {
                    MethodInvocation call = (MethodInvocation)current;
                    String methodName = call.astName().astValue();
                    if (!methodName.endsWith("Color") || !methodName.startsWith("set")) break;
                    context.report(ISSUE, select, context.getLocation(select), String.format("Should pass resolved color instead of resource id here: getResources().getColor(%1$s)", select.toString()), null);
                    break;
                }
                if (current.getClass() == MethodDeclaration.class) break;
            }
        }
    }
}

