/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.resources.ResourceFolderType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.SdkUtils;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MissingClassDetector
extends LayoutDetector
implements Detector.ClassScanner {
    public static final Issue MISSING = Issue.create("MissingRegistered", "Missing registered class", "Ensures that classes referenced in the manifest are present in the project or libraries", "If a class is referenced in the manifest, it must also exist in the project (or in one of the libraries included by the project. This check helps uncover typos in registration names, or attempts to rename or move classes without updating the manifest file properly.", Category.CORRECTNESS, 8, Severity.ERROR, new Implementation(MissingClassDetector.class, EnumSet.of(Scope.MANIFEST, Scope.CLASS_FILE, Scope.JAVA_LIBRARIES, Scope.RESOURCE_FILE))).addMoreInfo("http://developer.android.com/guide/topics/manifest/manifest-intro.html");
    public static final Issue INSTANTIATABLE = Issue.create("Instantiatable", "Registered class is not instantiatable", "Ensures that classes registered in the manifest file are instantiatable", "Activities, services, broadcast receivers etc. registered in the manifest file must be \"instantiatable\" by the system, which means that the class must be public, it must have an empty public constructor, and if it's an inner class, it must be a static inner class.", Category.CORRECTNESS, 6, Severity.WARNING, new Implementation(MissingClassDetector.class, Scope.CLASS_FILE_SCOPE));
    public static final Issue INNERCLASS = Issue.create("InnerclassSeparator", "Inner classes should use `$` rather than `.`", "Ensures that inner classes are referenced using '$' instead of '.' in class names", "When you reference an inner class in a manifest file, you must use '$' instead of '.' as the separator character, i.e. Outer$Inner instead of Outer.Inner.\n\n(If you get this warning for a class which is not actually an inner class, it's because you are using uppercase characters in your package name, which is not conventional.)", Category.CORRECTNESS, 3, Severity.WARNING, new Implementation(MissingClassDetector.class, Scope.MANIFEST_SCOPE));
    private Map<String, Location.Handle> mReferencedClasses;
    private Set<String> mCustomViews;
    private boolean mHaveClasses;

    @Override
    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Override
    public Collection<String> getApplicableElements() {
        return ALL;
    }

    @Override
    public boolean appliesTo(@NonNull ResourceFolderType folderType) {
        return folderType == ResourceFolderType.VALUES || folderType == ResourceFolderType.LAYOUT || folderType == ResourceFolderType.XML;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void visitElement(@NonNull XmlContext context, @NonNull Element element) {
        String fqcn;
        String className;
        Attr attr;
        String pkg = null;
        String tag = element.getTagName();
        ResourceFolderType folderType = context.getResourceFolderType();
        if (folderType == ResourceFolderType.VALUES) {
            if (!tag.equals("string")) {
                return;
            }
            attr = element.getAttributeNode("name");
            if (attr == null) {
                return;
            }
            className = attr.getValue();
            Attr attr2 = attr;
        } else if (folderType == ResourceFolderType.LAYOUT) {
            if (tag.indexOf(46) > 0) {
                className = tag;
                Element element2 = element;
            } else {
                if (!tag.equals("fragment") && !tag.equals("view")) return;
                attr = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
                if (attr == null) {
                    attr = element.getAttributeNode("class");
                }
                if (attr == null) {
                    return;
                }
                className = attr.getValue();
                Attr attr3 = attr;
            }
        } else if (folderType == ResourceFolderType.XML) {
            if (!tag.equals("header")) {
                return;
            }
            attr = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "fragment");
            if (attr == null) {
                return;
            }
            className = attr.getValue();
            Attr attr4 = attr;
        } else {
            if (!"application".equals(tag) && !"activity".equals(tag) && !"service".equals(tag) && !"receiver".equals(tag) && !"provider".equals(tag)) return;
            attr = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
            if (attr == null) {
                return;
            }
            className = attr.getValue();
            Attr attr5 = attr;
            pkg = context.getMainProject().getPackage();
        }
        if (className.isEmpty()) {
            return;
        }
        int dotIndex = className.indexOf(46);
        if (dotIndex <= 0) {
            if (pkg == null) {
                return;
            }
            fqcn = dotIndex == 0 ? pkg + className : pkg + '.' + className;
        } else {
            fqcn = className;
            if (folderType == ResourceFolderType.VALUES && !SdkUtils.endsWith((CharSequence)context.file.getPath(), (CharSequence)"analytics.xml")) {
                return;
            }
        }
        String signature = ClassContext.getInternalName(fqcn);
        if (signature.isEmpty() || signature.startsWith("android.")) {
            return;
        }
        if (!context.getProject().getReportIssues()) {
            return;
        }
        Location.Handle handle = null;
        if (!context.getDriver().isSuppressed(MISSING, element)) {
            if (this.mReferencedClasses == null) {
                this.mReferencedClasses = Maps.newHashMapWithExpectedSize((int)16);
                this.mCustomViews = Sets.newHashSetWithExpectedSize((int)8);
            }
            handle = context.parser.createLocationHandle(context, element);
            this.mReferencedClasses.put(signature, handle);
            if (folderType == ResourceFolderType.LAYOUT && !tag.equals("fragment")) {
                this.mCustomViews.add(ClassContext.getInternalName(className));
            }
        }
        if (signature.indexOf(36) == -1) return;
        if (pkg != null && className.indexOf(36) == -1 && className.indexOf(46, 1) > 0) {
            boolean haveUpperCase = false;
            int n = pkg.length();
            for (int i = 0; i < n; ++i) {
                if (!Character.isUpperCase(pkg.charAt(i))) continue;
                haveUpperCase = true;
                break;
            }
            if (!haveUpperCase) {
                void var4_13;
                String message = "Use '$' instead of '.' for inner classes (or use only lowercase letters in package names)";
                Location location = context.getLocation((Node)var4_13);
                context.report(INNERCLASS, element, location, message, null);
            }
        }
        if (handle == null) return;
        signature = signature.replace('$', '/');
        this.mReferencedClasses.put(signature, handle);
    }

    @Override
    public void afterCheckProject(@NonNull Context context) {
        if (!context.getProject().isLibrary() && this.mHaveClasses && this.mReferencedClasses != null && !this.mReferencedClasses.isEmpty() && context.getDriver().getScope().contains((Object)Scope.CLASS_FILE)) {
            ArrayList<String> classes = new ArrayList<String>(this.mReferencedClasses.keySet());
            Collections.sort(classes);
            for (String owner : classes) {
                Location.Handle handle = this.mReferencedClasses.get(owner);
                String fqcn = ClassContext.getFqcn(owner);
                String signature = ClassContext.getInternalName(fqcn);
                if (!signature.equals(owner) ? !this.mReferencedClasses.containsKey(signature) : signature.indexOf(36) != -1 && !this.mReferencedClasses.containsKey(signature = signature.replace('$', '/'))) continue;
                this.mReferencedClasses.remove(owner);
                if (owner.startsWith("android/")) continue;
                String message = String.format("Class referenced in the manifest, %1$s, was not found in the project or the libraries", fqcn);
                Location location = handle.resolve();
                File parentFile = location.getFile().getParentFile();
                if (parentFile != null) {
                    String parent = parentFile.getName();
                    ResourceFolderType type = ResourceFolderType.getFolderType((String)parent);
                    if (type == ResourceFolderType.LAYOUT) {
                        message = String.format("Class referenced in the layout file, %1$s, was not found in the project or the libraries", fqcn);
                    } else if (type == ResourceFolderType.XML) {
                        message = String.format("Class referenced in the preference header file, %1$s, was not found in the project or the libraries", fqcn);
                    } else if (type == ResourceFolderType.VALUES) {
                        message = String.format("Class referenced in the analytics file, %1$s, was not found in the project or the libraries", fqcn);
                    }
                }
                context.report(MISSING, location, message, null);
            }
        }
    }

    @Override
    public void checkClass(@NonNull ClassContext context, @NonNull ClassNode classNode) {
        if (!this.mHaveClasses && !context.isFromClassLibrary() && context.getProject() == context.getMainProject()) {
            this.mHaveClasses = true;
        }
        String curr = classNode.name;
        if (this.mReferencedClasses != null && this.mReferencedClasses.containsKey(curr)) {
            boolean isCustomView = this.mCustomViews.contains(curr);
            this.mReferencedClasses.remove(curr);
            if ((classNode.access & 1) == 0) {
                context.report(INSTANTIATABLE, context.getLocation(classNode), String.format("This class should be public (%1$s)", ClassContext.createSignature(classNode.name, null, null)), null);
                return;
            }
            if (classNode.name.indexOf(36) != -1 && !LintUtils.isStaticInnerClass(classNode)) {
                context.report(INSTANTIATABLE, context.getLocation(classNode), String.format("This inner class should be static (%1$s)", ClassContext.createSignature(classNode.name, null, null)), null);
                return;
            }
            boolean hasDefaultConstructor = false;
            List methodList = classNode.methods;
            for (Object m : methodList) {
                MethodNode method = (MethodNode)m;
                if (!method.name.equals("<init>") || !method.desc.equals("()V")) continue;
                if ((method.access & 1) != 0) {
                    hasDefaultConstructor = true;
                    continue;
                }
                context.report(INSTANTIATABLE, context.getLocation(method, classNode), "The default constructor must be public", null);
                hasDefaultConstructor = true;
            }
            if (!hasDefaultConstructor && !isCustomView && !context.isFromClassLibrary() && context.getProject().getReportIssues()) {
                context.report(INSTANTIATABLE, context.getLocation(classNode), String.format("This class should provide a default constructor (a public constructor with no arguments) (%1$s)", ClassContext.createSignature(classNode.name, null, null)), null);
            }
        }
    }
}

