/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.Clazz;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.DoubleConstant;
import proguard.classfile.constant.FloatConstant;
import proguard.classfile.constant.IntegerConstant;
import proguard.classfile.constant.InvokeDynamicConstant;
import proguard.classfile.constant.LongConstant;
import proguard.classfile.constant.MethodHandleConstant;
import proguard.classfile.constant.MethodTypeConstant;
import proguard.classfile.constant.NameAndTypeConstant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.Utf8Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.SimplifiedVisitor;

class ComparableConstant
extends SimplifiedVisitor
implements Comparable,
ConstantVisitor {
    private static final int[] PRIORITIES = new int[19];
    private final Clazz clazz;
    private final int thisIndex;
    private final Constant thisConstant;
    private Constant otherConstant;
    private int result;

    public ComparableConstant(Clazz clazz, int n, Constant constant) {
        this.clazz = clazz;
        this.thisIndex = n;
        this.thisConstant = constant;
    }

    public int getIndex() {
        return this.thisIndex;
    }

    public Constant getConstant() {
        return this.thisConstant;
    }

    public int compareTo(Object object) {
        int n;
        ComparableConstant comparableConstant = (ComparableConstant)object;
        this.otherConstant = comparableConstant.thisConstant;
        if (this.thisConstant == this.otherConstant) {
            int n2 = comparableConstant.thisIndex;
            return this.thisIndex < n2 ? -1 : (this.thisIndex == n2 ? 0 : 1);
        }
        int n3 = this.thisConstant.getTag();
        if (n3 != (n = this.otherConstant.getTag())) {
            return PRIORITIES[n3] < PRIORITIES[n] ? -1 : 1;
        }
        this.thisConstant.accept(this.clazz, this);
        return this.result;
    }

    public void visitIntegerConstant(Clazz clazz, IntegerConstant integerConstant) {
        int n;
        int n2 = integerConstant.getValue();
        this.result = n2 < (n = ((IntegerConstant)this.otherConstant).getValue()) ? -1 : (n2 == n ? 0 : 1);
    }

    public void visitLongConstant(Clazz clazz, LongConstant longConstant) {
        long l;
        long l2 = longConstant.getValue();
        this.result = l2 < (l = ((LongConstant)this.otherConstant).getValue()) ? -1 : (l2 == l ? 0 : 1);
    }

    public void visitFloatConstant(Clazz clazz, FloatConstant floatConstant) {
        this.result = Float.compare(floatConstant.getValue(), ((FloatConstant)this.otherConstant).getValue());
    }

    public void visitDoubleConstant(Clazz clazz, DoubleConstant doubleConstant) {
        this.result = Double.compare(doubleConstant.getValue(), ((DoubleConstant)this.otherConstant).getValue());
    }

    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        this.result = stringConstant.getString(clazz).compareTo(((StringConstant)this.otherConstant).getString(clazz));
    }

    public void visitUtf8Constant(Clazz clazz, Utf8Constant utf8Constant) {
        this.result = utf8Constant.getString().compareTo(((Utf8Constant)this.otherConstant).getString());
    }

    public void visitInvokeDynamicConstant(Clazz clazz, InvokeDynamicConstant invokeDynamicConstant) {
        int n;
        InvokeDynamicConstant invokeDynamicConstant2 = (InvokeDynamicConstant)this.otherConstant;
        int n2 = invokeDynamicConstant.getBootstrapMethodAttributeIndex();
        this.result = n2 < (n = invokeDynamicConstant2.getBootstrapMethodAttributeIndex()) ? -1 : (n2 > n ? 1 : (invokeDynamicConstant.getName(clazz) + ' ' + invokeDynamicConstant.getType(clazz)).compareTo(invokeDynamicConstant2.getName(clazz) + ' ' + invokeDynamicConstant2.getType(clazz)));
    }

    public void visitMethodHandleConstant(Clazz clazz, MethodHandleConstant methodHandleConstant) {
        int n;
        MethodHandleConstant methodHandleConstant2 = (MethodHandleConstant)this.otherConstant;
        int n2 = methodHandleConstant.getReferenceKind();
        this.result = n2 < (n = methodHandleConstant.getReferenceKind()) ? -1 : (n2 > n ? 1 : (methodHandleConstant.getName(clazz) + ' ' + methodHandleConstant.getType(clazz)).compareTo(methodHandleConstant2.getName(clazz) + ' ' + methodHandleConstant2.getType(clazz)));
    }

    public void visitAnyRefConstant(Clazz clazz, RefConstant refConstant) {
        RefConstant refConstant2 = (RefConstant)this.otherConstant;
        this.result = (refConstant.getClassName(clazz) + ' ' + refConstant.getName(clazz) + ' ' + refConstant.getType(clazz)).compareTo(refConstant2.getClassName(clazz) + ' ' + refConstant2.getName(clazz) + ' ' + refConstant2.getType(clazz));
    }

    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        this.result = classConstant.getName(clazz).compareTo(((ClassConstant)this.otherConstant).getName(clazz));
    }

    public void visitMethodTypeConstant(Clazz clazz, MethodTypeConstant methodTypeConstant) {
        MethodTypeConstant methodTypeConstant2 = (MethodTypeConstant)this.otherConstant;
        this.result = methodTypeConstant.getType(clazz).compareTo(methodTypeConstant2.getType(clazz));
    }

    public void visitNameAndTypeConstant(Clazz clazz, NameAndTypeConstant nameAndTypeConstant) {
        NameAndTypeConstant nameAndTypeConstant2 = (NameAndTypeConstant)this.otherConstant;
        this.result = (nameAndTypeConstant.getName(clazz) + ' ' + nameAndTypeConstant.getType(clazz)).compareTo(nameAndTypeConstant2.getName(clazz) + ' ' + nameAndTypeConstant2.getType(clazz));
    }

    public boolean equals(Object object) {
        return object != null && this.getClass().equals(object.getClass()) && this.getConstant().getClass().equals(((ComparableConstant)object).getConstant().getClass()) && this.compareTo(object) == 0;
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    static {
        ComparableConstant.PRIORITIES[3] = 0;
        ComparableConstant.PRIORITIES[4] = 1;
        ComparableConstant.PRIORITIES[8] = 2;
        ComparableConstant.PRIORITIES[7] = 3;
        ComparableConstant.PRIORITIES[5] = 4;
        ComparableConstant.PRIORITIES[6] = 5;
        ComparableConstant.PRIORITIES[9] = 6;
        ComparableConstant.PRIORITIES[10] = 7;
        ComparableConstant.PRIORITIES[11] = 8;
        ComparableConstant.PRIORITIES[18] = 9;
        ComparableConstant.PRIORITIES[15] = 10;
        ComparableConstant.PRIORITIES[12] = 11;
        ComparableConstant.PRIORITIES[16] = 12;
        ComparableConstant.PRIORITIES[1] = 13;
    }
}

