/*
 * Decompiled with CFR 0.152.
 */
package antenna.preprocessor.v3.parser;

public class Literal {
    private static final String BOOLEAN_TRUE = "true";
    private static final String BOOLEAN_FALSE = "false";
    public static final int NUMBER = 55;
    public static final int STRING = 56;
    public static final int SYMBOL = 54;
    public static final int BOOLEAN = -1;
    public static final int DEBUG_LEVEL = -2;
    private int m_type;
    private String m_value;

    public Literal(int type, String value) {
        this.m_type = type;
        if (value == null) {
            throw new IllegalArgumentException("Unsupported : empty value");
        }
        switch (type) {
            case 54: {
                break;
            }
            case 55: {
                try {
                    Double.parseDouble(value);
                    break;
                }
                catch (NumberFormatException e1) {
                    throw new IllegalArgumentException("Unsupported numerical value : " + value);
                }
            }
            case 56: {
                if (value.startsWith("\"") || value.startsWith("'")) {
                    value = value.substring(1);
                }
                if (value.endsWith("\"") || value.endsWith("'")) {
                    value = value.substring(0, value.length() - 1);
                }
                if (value.toLowerCase().equals(BOOLEAN_FALSE) || value.toLowerCase().equals(BOOLEAN_TRUE)) {
                    this.m_type = -1;
                    break;
                }
                try {
                    Double.parseDouble(value);
                    this.m_type = 55;
                }
                catch (NumberFormatException numberFormatException) {}
                break;
            }
            case -1: 
            case 43: 
            case 44: {
                this.m_type = -1;
                if (!value.toLowerCase().equals(BOOLEAN_FALSE) && !value.toLowerCase().equals(BOOLEAN_TRUE)) {
                    throw new IllegalArgumentException("Invalid boolean value : " + value);
                }
                value = value.toLowerCase();
                break;
            }
            case -2: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                this.m_type = -2;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported type : " + type);
            }
        }
        this.m_value = value;
    }

    public String toString() {
        switch (this.m_type) {
            case 56: {
                return "\"" + this.m_value + "\"";
            }
        }
        return this.m_value;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Literal) {
            Literal other = (Literal)obj;
            return other.m_type == this.m_type && other.m_value.equals(this.m_value);
        }
        return false;
    }

    public boolean isFalse() {
        return this.m_type == -1 && this.m_value.equals(BOOLEAN_FALSE);
    }

    public boolean isTrue() {
        return this.m_type == -1 && this.m_value.equals(BOOLEAN_TRUE);
    }

    public String getValue() {
        return this.m_value;
    }

    public boolean isDebugLevel() {
        return this.m_type == -2;
    }

    public boolean isNumber() {
        return this.m_type == 55;
    }

    public boolean isString() {
        return this.m_type == 56;
    }

    public boolean isSymbol() {
        return this.m_type == 54;
    }

    public boolean isBoolean() {
        return this.m_type == -1;
    }
}

