/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.in;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.util.Arrays;
import java.util.function.IntUnaryOperator;
import org.basex.io.in.DecodingException;
import org.basex.io.in.TextInput;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

abstract class TextDecoder {
    final String encoding;
    boolean validate;

    TextDecoder(String encoding) {
        this.encoding = encoding;
    }

    abstract int read(TextInput var1) throws IOException;

    static TextDecoder get(String encoding) throws IOException {
        return switch (encoding) {
            case "UTF-8" -> new UTF8();
            case "UTF-32" -> new UTF32();
            case "UTF-16LE" -> new UTF16LE();
            case "UTF-16", "UTF-16BE" -> new UTF16BE();
            default -> new Generic(encoding);
        };
    }

    final int readUTF16(TextInput ti, boolean be) throws IOException {
        int l;
        int cp;
        int a = ti.readByte();
        if (a < 0) {
            return a;
        }
        int b = ti.readByte();
        if (b < 0) {
            return this.invalid(true, (byte)a);
        }
        int n = cp = be ? a << 8 | b : a | b << 8;
        if (cp < 55296 || cp > 57343) {
            return cp;
        }
        if (cp >= 56320 && cp <= 57343) {
            return this.invalid(true, (byte)a, (byte)b);
        }
        int c = ti.readByte();
        if (c < 0) {
            return this.invalid(true, (byte)a, (byte)b);
        }
        int d = ti.readByte();
        if (d < 0) {
            return this.invalid(true, (byte)a, (byte)b, (byte)c);
        }
        int n2 = l = be ? c << 8 | d : c | d << 8;
        if (l < 56320 || l > 57343) {
            return this.invalid(true, (byte)a, (byte)b, (byte)c, (byte)d);
        }
        return 65536 + ((cp & 0x3FF) << 10) + (l & 0x3FF);
    }

    final int invalid(boolean incomplete, byte ... bytes) throws IOException {
        if (this.validate) {
            TokenBuilder tb = new TokenBuilder();
            IntUnaryOperator toHex = c -> c + (c > 9 ? 55 : 48);
            for (byte b : bytes) {
                if (!tb.isEmpty()) {
                    tb.add(", ");
                }
                tb.add(toHex.applyAsInt(b >> 4 & 0xF)).add(toHex.applyAsInt(b & 0xF));
            }
            if (incomplete) {
                tb.add(", ??");
            }
            throw new DecodingException("Invalid " + this.encoding + " character encoding: " + String.valueOf(tb));
        }
        return 65533;
    }

    private static final class UTF8
    extends TextDecoder {
        UTF8() {
            super("UTF-8");
        }

        @Override
        int read(TextInput ti) throws IOException {
            int cp = ti.readByte();
            if (cp < 128) {
                return cp;
            }
            if (cp < 194 || cp > 244) {
                return this.invalid(false, (byte)cp);
            }
            int cl = Token.cl((byte)cp);
            byte[] bytes = new byte[cl];
            bytes[0] = (byte)cp;
            for (int c = 1; c < cl; ++c) {
                cp = ti.readByte();
                bytes[c] = (byte)cp;
                if (cp >= 128) continue;
                return this.invalid(cp < 0, Arrays.copyOf(bytes, cp < 0 ? c : c + 1));
            }
            return Token.cp(bytes, 0);
        }
    }

    private static final class UTF32
    extends TextDecoder {
        UTF32() {
            super("UTF-32");
        }

        @Override
        int read(TextInput ti) throws IOException {
            int a = ti.readByte();
            if (a < 0) {
                return a;
            }
            int b = ti.readByte();
            if (b < 0) {
                return this.invalid(true, (byte)a);
            }
            int c = ti.readByte();
            if (c < 0) {
                return this.invalid(true, (byte)a, (byte)b);
            }
            int d = ti.readByte();
            if (d < 0) {
                return this.invalid(true, (byte)a, (byte)b, (byte)c);
            }
            return a << 24 | b << 16 | c << 8 | d;
        }
    }

    private static final class UTF16LE
    extends TextDecoder {
        UTF16LE() {
            super("UTF-16LE");
        }

        @Override
        int read(TextInput ti) throws IOException {
            return this.readUTF16(ti, false);
        }
    }

    private static final class UTF16BE
    extends TextDecoder {
        UTF16BE() {
            super("UTF-16BE");
        }

        @Override
        int read(TextInput ti) throws IOException {
            return this.readUTF16(ti, true);
        }
    }

    private static final class Generic
    extends TextDecoder {
        private final byte[] cache = new byte[4];
        private final ByteBuffer inc = ByteBuffer.wrap(this.cache);
        private final CharBuffer outc = CharBuffer.wrap(new char[4]);
        private final CharsetDecoder csd;

        private Generic(String encoding) throws IOException {
            super(encoding);
            try {
                this.csd = Charset.forName(encoding).newDecoder();
            }
            catch (Exception ex) {
                throw new DecodingException(ex);
            }
        }

        @Override
        int read(TextInput ti) throws IOException {
            int a;
            int c = -1;
            while (++c < 4 && (a = ti.readByte()) >= 0) {
                this.cache[c] = (byte)a;
                this.outc.position(0);
                this.inc.position(0);
                this.inc.limit(c + 1);
                this.csd.reset();
                CoderResult cr = this.csd.decode(this.inc, this.outc, true);
                if (cr.isMalformed()) continue;
                int i = 0;
                int os = this.outc.position();
                for (int o = 0; o < os; ++o) {
                    i |= this.outc.get(o) << (o << 3);
                }
                return i;
            }
            return c == 0 ? -1 : this.invalid(false, this.cache[0]);
        }
    }
}

