/*
 * Decompiled with CFR 0.152.
 */
package org.basex.io.out;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import org.basex.io.out.PrintOutput;
import org.basex.query.QueryError;
import org.basex.util.Token;
import org.basex.util.Util;
import org.basex.util.hash.IntObjectMap;

public final class EncoderOutput
extends PrintOutput {
    private final IntObjectMap<byte[]> cache = new IntObjectMap();
    private final CharsetEncoder encoder;
    private final Charset charset;

    public EncoderOutput(OutputStream os, Charset charset) {
        super(os);
        this.charset = charset;
        this.encoder = charset.newEncoder();
    }

    @Override
    public void print(int cp, PrintOutput.Fallback fallback) throws IOException {
        try {
            byte[] bytes = this.cache.get(cp);
            if (bytes == null) {
                bytes = this.encoder.encode(CharBuffer.wrap(Character.toChars(cp))).array();
                this.cache.put(cp, bytes);
            }
            this.write(bytes);
        }
        catch (CharacterCodingException ex) {
            if (fallback != null) {
                fallback.print(cp);
            }
            Util.debug(ex);
            throw QueryError.SERENC_X_X.getIO(Integer.toHexString(cp), this.charset);
        }
        this.lineLength = cp == 10 ? 0L : this.lineLength + 1L;
    }

    @Override
    public void print(byte[] token) throws IOException {
        this.print(Token.string(token));
    }

    @Override
    public void print(String string) throws IOException {
        for (int cp : string.codePoints().toArray()) {
            this.print(cp);
        }
    }
}

