/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query;

import org.basex.query.QueryException;
import org.basex.query.QueryIOException;
import org.basex.query.QueryText;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ParseExpr;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.query.value.type.Types;
import org.basex.util.Enums;
import org.basex.util.InputInfo;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.TokenParser;
import org.basex.util.Util;
import org.basex.util.list.IntList;

public enum QueryError {
    BASEX_ANNOTATION1_X_X(ErrType.BASEX, "annotation", "Annotation %% is unknown."),
    BASEX_ANN2_X_X(ErrType.BASEX, "annotation", "%: %."),
    BASEX_ANN3_X_X(ErrType.BASEX, "annotation", "Annotation %% is declared twice."),
    BASEX_ANN_X_X_X(ErrType.BASEX, "annotation", "%: % expected, % found."),
    BASEX_DBPATH1_X(ErrType.BASEX, "doc", "Database path '%' yields no documents."),
    BASEX_DBPATH2_X(ErrType.BASEX, "doc", "Database path '%' yields more than one document."),
    BASEX_FUNCTION_X(ErrType.BASEX, "function", "Value is a function: %."),
    BASEX_WHICH_X(ErrType.BASEX, "function", "Function not found: %."),
    BASEX_CLASSPATH_X_X(ErrType.BASEX, "function", "Function % requires missing class: %."),
    BASEX_ERROR_X(ErrType.BASEX, "error", "%"),
    BASEX_HTTP(ErrType.BASEX, "http", "HTTP connection required."),
    BASEX_LIMIT_X_X(ErrType.BASEX, "limit", "Too many % (limit: %)."),
    BASEX_STRIP_X(ErrType.BASEX, "strip", "Duplicate attribute name: %."),
    BASEX_OPTIONS_X(ErrType.BASEX, "options", "%"),
    BASEX_OPTIONSINV_X(ErrType.BASEX, "options", "Unknown database option: %."),
    BASEX_OPTIONSLIB_X(ErrType.BASEX, "options", "Database option not allowed in library module: %."),
    BASEX_OPTIONS_X_X(ErrType.BASEX, "options", "Database option '%' cannot be set to '%'."),
    BASEX_OVERFLOW(ErrType.BASEX, "overflow", "Stack Overflow: Try tail recursion?"),
    BASEX_PERMISSION_X_X(ErrType.BASEX, "permission", "No % permission: %."),
    BASEX_RESTXQ_X(ErrType.BASEX, "restxq", "%"),
    BASEX_WS_X(ErrType.BASEX, "ws", "%"),
    BASEX_UPDATE(ErrType.BASEX, "update", "Update target was not created by transform expression."),
    BASEX_WS(ErrType.BASEX, "ws", "WebSocket connection required."),
    ADMIN_DELETE_X(ErrType.ADMIN, "delete", "Log file cannot be deleted: %."),
    ADMIN_TODAY(ErrType.ADMIN, "today", "Today's log file cannot be deleted."),
    ADMIN_TYPE_X(ErrType.ADMIN, "type", "Type string contains whitespace: '%'."),
    ARCHIVE_NAME(ErrType.ARCHIVE, "descriptor", "Name of ZIP entry must not be empty."),
    ARCHIVE_LEVEL_X(ErrType.ARCHIVE, "descriptor", "Invalid compression level: '%'."),
    ARCHIVE_TIMESTAMP_X(ErrType.ARCHIVE, "descriptor", "xs:dateTime value is invalid : '%'."),
    ARCHIVE_ENCODE1_X(ErrType.ARCHIVE, "encode", "%"),
    ARCHIVE_ENCODE2_X(ErrType.ARCHIVE, "encode", "String conversion: %."),
    ARCHIVE_ERROR_X(ErrType.ARCHIVE, "error", "Operation failed: %."),
    ARCHIVE_FORMAT(ErrType.ARCHIVE, "format", "Packing format not supported."),
    ARCHIVE_FORMAT_X_X(ErrType.ARCHIVE, "format", "% not supported: '%'."),
    ARCHIVE_MODIFY_X(ErrType.ARCHIVE, "modify", "Entries of % archive cannot be modified."),
    ARCHIVE_NUMBER_X_X(ErrType.ARCHIVE, "number", "Number of entries and contents differs: % vs. %."),
    ARCHIVE_SINGLE_X(ErrType.ARCHIVE, "single", "% archives are limited to a single entry."),
    ARCHIVE_ZIP_X(ErrType.ARCHIVE, "zip", "Local ZIP file expected: %."),
    BIN_DLA_X_X(ErrType.BIN, "differing-length-arguments", "Inputs are of different length (%/%)."),
    BIN_IOOR_X_X(ErrType.BIN, "index-out-of-range", "Index '%' is out of range (0-%)."),
    BIN_ITL_X_X(ErrType.BIN, "integer-too-large", "Index '%' is too large: %."),
    BIN_NS_X(ErrType.BIN, "negative-size", "Size '%' is negative."),
    BIN_OOR_X(ErrType.BIN, "octet-out-of-range", "Octet '%' is out of range."),
    BIN_NNC(ErrType.BIN, "non-numeric-character", "Invalid character in constructor string."),
    BIN_UE_X(ErrType.BIN, "unknown-encoding", "%"),
    BIN_CE_X(ErrType.BIN, "conversion-error", "%."),
    BIN_USO_X(ErrType.BIN, "unknown-significance-order", "Unknown octet-order value: '%'."),
    CLIENT_COMMAND_X(ErrType.CLIENT, "command", "Command cannot be executed: %"),
    CLIENT_CONNECT_X(ErrType.CLIENT, "connect", "Connection failed: %"),
    CLIENT_ERROR_X(ErrType.CLIENT, "error", "An error occurred: %"),
    CLIENT_FITEM_X(ErrType.CLIENT, "function", "Result is a function item: %."),
    CLIENT_ID_X(ErrType.CLIENT, "id", "Session with ID % is not available or has been closed."),
    CLIENT_QUERY_X(ErrType.CLIENT, "query", "Query cannot be executed: %"),
    CONVERT_STRING_X(ErrType.CONVERT, "string", "String conversion: %."),
    CONVERT_BINARY_X_X(ErrType.CONVERT, "binary", "Conversion of '%' to encoding '%' failed."),
    CONVERT_ENCODING_X(ErrType.CONVERT, "encoding", "%"),
    CONVERT_BASE_X(ErrType.CONVERT, "base", "Unsupported base: %."),
    CONVERT_INTEGER_X_X(ErrType.CONVERT, "integer", "Invalid digit for base %: %."),
    CONVERT_KEY_X(ErrType.CONVERT, "key", "Key cannot be decoded: %."),
    CX_CANINV(ErrType.CX, 1, "Canonicalization algorithm is not supported."),
    CX_DIGINV(ErrType.CX, 2, "Digest algorithm is not supported."),
    CX_SIGINV(ErrType.CX, 3, "Signature algorithm is not supported."),
    CX_XPINV(ErrType.CX, 4, "XPath expression is invalid."),
    CX_INVNM(ErrType.CX, 5, "Invalid name for $digital-certificate root."),
    CX_KSNULL_X(ErrType.CX, 7, "Key store is null: %"),
    CX_NOKEY(ErrType.CX, 12, "Cannot find key for alias in given keystore."),
    CX_INVHASH_X(ErrType.CX, 13, "Hashing algorithm is not supported: %."),
    CX_ENC_X(ErrType.CX, 14, "The encoding method is not supported: %."),
    CX_NOSIG(ErrType.CX, 15, "Cannot find signature element."),
    CX_NOPAD_X(ErrType.CX, 16, "No such padding: %."),
    CX_BADPAD_X(ErrType.CX, 17, "Incorrect padding: %."),
    CX_ENCTYP_X(ErrType.CX, 18, "Encryption type is not supported: %."),
    CX_KEYINV_X(ErrType.CX, 19, "Secret key is invalid: %."),
    CX_ILLBLO_X(ErrType.CX, 20, "Illegal block size: %."),
    CX_INVALGO_X(ErrType.CX, 21, "Algorithm is not supported: %."),
    CX_ALINV_X(ErrType.CX, 23, "Invalid certificate alias %."),
    CX_ALGEXC(ErrType.CX, 24, "Invalid algorithm."),
    CX_IOEXC(ErrType.CX, 25, "IO Exception."),
    CX_KSEXC(ErrType.CX, 26, "Keystore exception."),
    CX_SIGEXC(ErrType.CX, 27, "Signature exception."),
    CX_SIGTYPINV(ErrType.CX, 28, "Signature type is not supported."),
    CSV_PARSE_X(ErrType.CSV, "parse", "%"),
    CSV_SERIALIZE_X(ErrType.CSV, "serialize", "%."),
    CSV_SERIALIZE_X_X(ErrType.CSV, "serialize", "%: %."),
    DB_ARGS_X_X(ErrType.DB, "args", "Number of specified inputs and paths differs: % vs. %."),
    DB_CONFLICT1_X_X(ErrType.DB, "conflict", "Database '%' can only be % once."),
    DB_CONFLICT2_X_X(ErrType.DB, "conflict", "Backup '%' can only be % once."),
    DB_CONFLICT3_X(ErrType.DB, "conflict", "Database '%' cannot be both altered and dropped."),
    DB_CONFLICT4_X(ErrType.DB, "conflict", "Name of source and target is equal: %."),
    DB_CONFLICT5_X(ErrType.DB, "conflict", "Resource '%' can only be stored once."),
    DB_LOCK1_X(ErrType.DB, "lock", "Database '%' cannot be updated, it is opened by another process."),
    DB_LOCK2_X(ErrType.DB, "lock", "%"),
    DB_MAINMEM_X(ErrType.DB, "mainmem", "Database '%' is in main memory."),
    DB_NAME_X(ErrType.DB, "name", "Invalid name: %."),
    DB_NOBACKUP_X(ErrType.DB, "no-backup", "No backup exists for database '%'."),
    DB_NODE_X(ErrType.DB, "node", "No database node: %."),
    DB_NOINDEX_X_X(ErrType.DB, "no-index", "Database '%' has no % index."),
    DB_GET1_X(ErrType.DB, "get", "Database '%' not found."),
    DB_GET2_X(ErrType.DB, "get", "%"),
    DB_OPTION_X(ErrType.DB, "option", "Unknown option: %."),
    DB_PATH_X(ErrType.DB, "path", "Invalid path: %."),
    DB_PROPERTY_X(ErrType.DB, "property", "Unknown database property: %."),
    DB_RANGE_X_X(ErrType.DB, "range", "Database '%' value out of range: %."),
    FETCH_OPEN_X(ErrType.FETCH, "open", "%"),
    FETCH_ENCODING_X(ErrType.FETCH, "encoding", "%"),
    FILE_NOT_FOUND_X(ErrType.FILE, "not-found", "'%' not found."),
    FILE_EXISTS_X(ErrType.FILE, "exists", "'%' already exists."),
    FILE_NO_DIR_X(ErrType.FILE, "no-dir", "'%' is no directory."),
    FILE_IS_DIR_X(ErrType.FILE, "is-dir", "'%' is a directory."),
    FILE_IS_DIR2_X(ErrType.FILE, "is-dir", "'%' is a non-empty directory."),
    FILE_IS_RELATIVE_X(ErrType.FILE, "is-relative", "Base directory is relative: '%'."),
    FILE_UNKNOWN_ENCODING_X(ErrType.FILE, "unknown-encoding", "%"),
    FILE_OUT_OF_RANGE_X_X(ErrType.FILE, "out-of-range", "Requested file chunk [%,%] exceeds file bounds."),
    FILE_INVALID_PATH_X(ErrType.FILE, "invalid-path", "Invalid file path: '%'."),
    FILE_IO_ERROR_X(ErrType.FILE, "io-error", "%"),
    FILE_ACCESS_X(ErrType.FILE, "io-error", "Access to '%' is denied."),
    FT_OPTIONS(ErrType.FT, "options", "Wildcards and fuzzy option cannot be specified both."),
    HC_URI_X(ErrType.HC, 1, "Invalid URI: %"),
    HC_ERROR_X(ErrType.HC, 1, "%"),
    HC_PARSE_X(ErrType.HC, 2, "Conversion failed: %"),
    HC_ATTR(ErrType.HC, 3, "No attribute allowed beside 'src' and 'media-type'."),
    HC_REQ_X(ErrType.HC, 4, "%."),
    HC_URL(ErrType.HC, 5, "No URL supplied."),
    INSPECT_UNKNOWN_X(ErrType.INSPECT, "unknown", "Component '%' does not exist."),
    INSPECT_PARSE_X(ErrType.INSPECT, "parse", "%"),
    JOBS_ID_EXISTS_X(ErrType.JOB, "id", "Job id already exists: %."),
    JOBS_ID_INVALID_X(ErrType.JOB, "id", "Invalid job name: %."),
    JOBS_OPTIONS(ErrType.JOB, "options", "Either 'cache' or 'interval' option is allowed."),
    JOBS_OVERFLOW(ErrType.JOB, "overflow", "Too many jobs registered."),
    JOBS_RANGE_X(ErrType.JOB, "range", "Value out of range: %."),
    JOBS_RUNNING_X(ErrType.JOB, "running", "Result is not available yet: %."),
    JOBS_SELF_X(ErrType.JOB, "self", "Cannot wait for own job: %"),
    JOBS_SERVICE(ErrType.JOB, "service", "No variables allowed."),
    JOBS_SERVICE_X_X(ErrType.JOB, "service", "Cannot write service: %."),
    JSON_PARSE_X(ErrType.JSON, "parse", "%"),
    JSON_SERIALIZE_X(ErrType.JSON, "serialize", "%."),
    JSON_OPTIONS_X(ErrType.JSON, "options", "'%':'%' is not supported by the target format."),
    PROC_ENCODING_X(ErrType.PROC, "encoding", "%"),
    PROC_ERROR_X(ErrType.PROC, "error", "%"),
    PROC_TIMEOUT(ErrType.PROC, "timeout", "The timeout was exceeded."),
    PROF_OPTION_X(ErrType.PROF, "option", "Unknown option: %."),
    RANDOM_BOUNDS_X(ErrType.RANDOM, "bounds", "Maximum value is out of bounds: %."),
    RANGE_NEGATIVE_X(ErrType.RANDOM, "negative", "Number of values is negative: %."),
    REPO_DELETE_X(ErrType.REPO, "delete", "File '%' cannot be deleted."),
    REPO_DELETE_X_X(ErrType.REPO, "delete", "Package '%' depends on package '%'."),
    REPO_DESCRIPTOR_X(ErrType.REPO, "descriptor", "%."),
    REPO_INSTALLED_X(ErrType.REPO, "installed", "Module % is already installed within another package."),
    REPO_NOTFOUND_X(ErrType.REPO, "not-found", "Package '%' not found."),
    REPO_PARSE_X_X(ErrType.REPO, "parse", "%: %."),
    REPO_VERSION(ErrType.REPO, "version", "Package version is not supported."),
    REQUEST_PARAMETER(ErrType.REQUEST, "parameter", "Query string cannot be decoded."),
    SESSION_NOTFOUND(ErrType.SESSIONS, "not-found", "Session not available."),
    SESSIONS_NOTFOUND_X(ErrType.SESSIONS, "not-found", "Session not available: %."),
    SQL_ATTRIBUTE_X(ErrType.SQL, "attribute", "Attribute not expected: %."),
    SQL_INIT_X(ErrType.SQL, "init", "Cannot find driver: %"),
    SQL_ERROR_X(ErrType.SQL, "error", "An SQL exception occurred: %"),
    SQL_TIMEOUT_X(ErrType.SQL, "timeout", "A query timeout has occurred: %"),
    SQL_ID1_X(ErrType.SQL, "id", "No connection with id %."),
    SQL_ID2_X(ErrType.SQL, "id", "No prepared statement with id %."),
    SQL_PARAMETERS(ErrType.SQL, "parameters", "No parameter type supplied."),
    SQL_TYPE_X_X(ErrType.SQL, "type", "Invalid type (%): %."),
    STORE_IO_X(ErrType.STORE, "io", "%"),
    STORE_NAME_X(ErrType.STORE, "name", "Invalid name: %."),
    STRING_FORMAT_X_X(ErrType.STRING, "format", "%: %."),
    STRING_BOUNDS_X(ErrType.STRING, "bounds", "String exceeds maximum supported length of % characters."),
    UNIT_FAIL(ErrType.UNIT, "fail", "Assertion failed."),
    UNIT_FAIL_X(ErrType.UNIT, "fail", "%"),
    UNIT_FAIL_X_X_X(ErrType.UNIT, "fail", "Item %: % expected, % returned."),
    UNIT_NOARGS_X(ErrType.UNIT, "no-args", "Test function '%' must have no arguments."),
    UNIT_PRIVATE_X(ErrType.UNIT, "private", "Test function '%' must not be private."),
    USER_ADMIN(ErrType.USER, "admin", "User 'admin' cannot be modified."),
    USER_CONFLICT_X(ErrType.USER, "conflict", "User '%' cannot be both altered and dropped."),
    USER_EQUAL_X(ErrType.USER, "equal", "Name of old and new user is equal: %."),
    USER_INFO_X(ErrType.USER, "info", "Info can only be % once."),
    USER_LOCAL(ErrType.USER, "local", "Local permission can only be 'none', 'read' or 'write'."),
    USER_LOGGEDIN_X(ErrType.USER, "logged-in", "User '%' is currently logged in."),
    USER_NAME_X(ErrType.USER, "name", "Invalid username: '%'."),
    USER_PASSWORD_X(ErrType.USER, "password", "Wrong password supplied for user '%'."),
    USER_PATTERN_X(ErrType.USER, "pattern", "Invalid database pattern: '%'."),
    USER_PERMISSION_X(ErrType.USER, "permission", "Invalid permission: '%'."),
    USER_UNKNOWN_X(ErrType.USER, "unknown", "User '%' does not exist."),
    USER_UPDATE1_X_X(ErrType.USER, "update", "User '%' can only be % once."),
    USER_UPDATE2_X(ErrType.USER, "update", "Pattern '%' is specified more than once."),
    USER_UPDATE3_X_X(ErrType.USER, "update", "User '%' can only be % once."),
    VALIDATE_ERROR_X(ErrType.VALIDATE, "error", "Validation failed: %"),
    VALIDATE_START_X(ErrType.VALIDATE, "init", "Validation cannot be started: %"),
    VALIDATE_NOTFOUND_X(ErrType.VALIDATE, "not-found", "RelaxNG validation is not available."),
    WEB_STATUS_X(ErrType.WEB, "status", "Invalid status code: %"),
    WS_NOTFOUND_X(ErrType.WS, "not-found", "Unknown WebSocket: %."),
    XQUERY_NOUPDATES(ErrType.XQUERY, "update", "No updating expression allowed."),
    XQUERY_UPDATEEXPECTED(ErrType.XQUERY, "update", "Updating expression expected."),
    XQUERY_PERM_X(ErrType.XQUERY, "permission", "%"),
    XQUERY_PERMREQUIRED_X(ErrType.XQUERY, "permission", "% permission required."),
    XQUERY_TIMEOUT(ErrType.XQUERY, "timeout", "The timeout was exceeded."),
    XQUERY_MEMORY(ErrType.XQUERY, "memory", "The memory limit was exceeded."),
    XQUERY_NESTED(ErrType.XQUERY, "nested", "Nested query evaluation is not allowed."),
    XQUERY_UNEXPECTED_X(ErrType.XQUERY, "error", "Unexpected error: %"),
    XSLT_ERROR_X(ErrType.XSLT, "error", "%"),
    APPLY_X_X(ErrType.FOAP, 1, "% supplied to %: %."),
    DIVZERO_X(ErrType.FOAR, 1, "% cannot be divided by zero."),
    INVIDIV(ErrType.FOAR, 2, "Invalid integer division: %."),
    RANGE_X(ErrType.FOAR, 2, "Value out of range: %."),
    ARRAYBOUNDS_X_X(ErrType.FOAY, 1, "Array index % out of bounds (1..%)."),
    ARRAYEMPTY(ErrType.FOAY, 1, "Array has no entries."),
    ARRAYNEG_X(ErrType.FOAY, 2, "Length is negative: %."),
    INVALUE_X_X(ErrType.FOCA, 2, "Cannot convert to %: %."),
    INTRANGE_X(ErrType.FOCA, 3, "Integer value out of range: %."),
    DATECALC_X_X(ErrType.FOCA, 5, "Invalid % calculation: %."),
    INVCODE_X(ErrType.FOCH, 1, "Invalid XML character: %."),
    WHICHCOLL_X(ErrType.FOCH, 2, "%."),
    NORMUNI_X(ErrType.FOCH, 3, "Unsupported normalization form ('%')."),
    CHARCOLL(ErrType.FOCH, 4, "Collation does not operate on character-by-character basis."),
    CHARINV_X(ErrType.FOCH, 5, "Invalid name, glyph or codepoint value: %."),
    CSV_ERROR_X(ErrType.FOCV, 1, "CSV processing error: %."),
    CSV_QUOTING_X(ErrType.FOCV, 1, "CSV field quoting error: %."),
    CSV_SINGLECHAR_X_X(ErrType.FOCV, 2, "The value of '%' is not a single character: '%'."),
    CSV_DELIMITER_X(ErrType.FOCV, 3, "Duplicate CSV delimiter error: %."),
    CSV_COLUMNNAME_X(ErrType.FOCV, 4, "Argument supplied is not a known column name: %."),
    IDDOC(ErrType.FODC, 1, "Specified node has no document node as root."),
    NODEERR_X_X(ErrType.FODC, 2, "% cannot be created: %."),
    NODEFCOLL(ErrType.FODC, 2, "No default collection available."),
    IOERR_X(ErrType.FODC, 2, "%"),
    WHICHRES_X(ErrType.FODC, 2, "Resource '%' not found."),
    RESDIR_X(ErrType.FODC, 2, "URI '%' points to a directory."),
    INVCOLL_X(ErrType.FODC, 4, "Invalid collection URI: %."),
    INVDOC_X(ErrType.FODC, 5, "Invalid document URI: %."),
    SAXERR_X(ErrType.FODC, 6, "SAX: %"),
    DTDVALIDATIONERR_X(ErrType.FODC, 7, "DTD Validation error: %"),
    INVALIDXSDOPT_X(ErrType.FODC, 8, "Unsupported value of option 'xsd-validation': '%'."),
    NOXSDVALIDATION_X(ErrType.FODC, 9, "The internal parser does not support 'xsd-validation': '%'."),
    NOXSDANDDTD_X(ErrType.FODC, 9, "DTD validation must not be enabled when 'xsd-validation' is '%'."),
    INVHTML_X(ErrType.FODC, 11, "HTML parsing failed: %"),
    NODTDVALIDATION(ErrType.FODC, 13, "The internal parser does not support DTD validation."),
    XSDVALIDATIONERR_X(ErrType.FODC, 14, "XSD Validation error: %"),
    FORMATWHICH_X(ErrType.FODF, 1280, "Unknown decimal format: %."),
    FORMATINV_X(ErrType.FODF, 1290, "%"),
    PICEMPTY(ErrType.FODF, 1310, "The picture string must not be empty: '%'"),
    PICNUM_X(ErrType.FODF, 1310, "Invalid picture string: '%'."),
    OPTAFTER_X(ErrType.FODF, 1310, "Optional digit sign follows mandatory digit signs: '%'."),
    OPTBEFORE_X(ErrType.FODF, 1310, "Mandatory digit sign follows optional digit signs: '%'."),
    INVGROUP_X(ErrType.FODF, 1310, "Invalid position of grouping separator signs: '%'."),
    DIFFMAND_X(ErrType.FODF, 1310, "Mandatory digits is not of the same group: '%'."),
    INVMODIFIER_X(ErrType.FODF, 1310, "Invalid specification of ordinal/cardinal numbering: '%'."),
    INVDDPATTERN_X(ErrType.FODF, 1310, "Invalid decimal-digit-pattern: '%'."),
    DATERANGE_X_X(ErrType.FODT, 1, "%: '%' out of range."),
    YEARRANGE_X(ErrType.FODT, 1, "Year '%' out of range."),
    SECRANGE_X(ErrType.FODT, 1, "Seconds '%' out of range."),
    DURRANGE_X_X(ErrType.FODT, 2, "%: '%' out of range."),
    MONTHRANGE_X(ErrType.FODT, 2, "Months '%' out of range."),
    SECDURRANGE_X(ErrType.FODT, 2, "Seconds '%' out of range."),
    DATEZERO_X_X(ErrType.FODT, 2, "Invalid % calculation: %."),
    INVALZONE_X(ErrType.FODT, 3, "Timezone out of range (-14:00 to +14:00): %."),
    ZONESEC_X(ErrType.FODT, 3, "No seconds allowed in timezone: %."),
    PLACE_X(ErrType.FODT, 4, "Unknown place: %."),
    FUNERR1(ErrType.FOER, 0, "Halted on error()."),
    INVCOMPSPEC_X(ErrType.FOFD, 1340, "Invalid variable marker: '[%]'."),
    PICDATE_X(ErrType.FOFD, 1340, "Invalid picture string: '%'."),
    CALWHICH_X(ErrType.FOFD, 1340, "Unknown calendar: '%'."),
    INVFDPATTERN_X(ErrType.FOFD, 1340, "%"),
    PICINVCOMP_X_X_X(ErrType.FOFD, 1350, "[%] not applicable to %: %."),
    HASH_ALGORITHM_X(ErrType.FOHA, 1, "Algorithm not supported: '%'."),
    PARSE_JSON_X(ErrType.FOJS, 1, "%"),
    PARSE_JSON_X_X_X(ErrType.FOJS, 1, "(%:%): %."),
    DUPLICATE_JSON_X(ErrType.FOJS, 3, "%"),
    MERGE_DUPLICATE_X(ErrType.FOJS, 3, "Key % occurs more than once."),
    OPTION_JSON_X(ErrType.FOJS, 5, "%"),
    INVALID_JSON_X(ErrType.FOJS, 6, "%"),
    ESCAPE_JSON_X(ErrType.FOJS, 7, "Invalid escape sequence: %."),
    PLAN_X_X(ErrType.FOJS, 8, "Layout '%' cannot be applied: %."),
    NSDECL_X(ErrType.FONS, 4, "Namespace prefix not declared: %."),
    MODULE_URI_EMPTY(ErrType.FOQM, 1, "Module URI is a zero-length string."),
    MODULE_NOT_FOUND_X(ErrType.FOQM, 2, "Module not found: '%'"),
    MODULE_FOUND_MAIN_X(ErrType.FOQM, 2, "Found main module instead of library module '%'."),
    MODULE_FOUND_OTHER_X(ErrType.FOQM, 2, "Did not find expected module '%'."),
    MODULE_FOUND_OTHER_X_X(ErrType.FOQM, 2, "Did not find expected module '%' in '%'."),
    MODULE_STATIC_ERROR_X_X(ErrType.FOQM, 3, "Static error in dynamically loaded XQuery module '%': %"),
    MODULE_PARAMETER_TYPE_X_X(ErrType.FOQM, 5, "Parameter for dynamically loaded XQuery module '%' has incorrect type: %"),
    MODULE_CONTEXT_TYPE_X_X(ErrType.FOQM, 5, "The context item for dynamically loaded XQuery module '%' has incorrect type: %"),
    MODULE_XQUERY_VERSION_X(ErrType.FOQM, 6, "XQuery version '%' not supported."),
    PATH_X(ErrType.FOPA, 1, "Node is not contained in path: %."),
    INVALIDZONE_X(ErrType.FORG, 1, "Invalid timezone: %."),
    MISSINGZONE_X(ErrType.FORG, 1, "xs:dateTimeStamp value must have a timezone: %."),
    FUNCCAST_X_X(ErrType.FORG, 1, "Cannot convert to %: %."),
    FUNCCAST_X_X_X(ErrType.FORG, 1, "Cannot convert % to %: %."),
    DATEFORMAT_X_X_X(ErrType.FORG, 1, "Wrong % format: '%' (try e.g. '%')."),
    URIARG_X(ErrType.FORG, 2, "Invalid URI: %."),
    ZEROORONE(ErrType.FORG, 3, "Zero or one item expected."),
    ONEORMORE(ErrType.FORG, 4, "One or more item expected."),
    EXACTLYONE(ErrType.FORG, 5, "Exactly one item expected."),
    ARGTYPE_X_X_X(ErrType.FORG, 6, "% expected, % found: %."),
    COMPARE_X_X(ErrType.FORG, 6, "Items of type % cannot be compared: %."),
    NUMDUR_X_X(ErrType.FORG, 6, "Number or duration expected, % found: %."),
    FUNZONE_X_X(ErrType.FORG, 8, "% and % have different timezones."),
    IETF_PARSE_X_X_X(ErrType.FORG, 10, "Invalid input (% expected, '%' found): '%'."),
    IETF_INV_X(ErrType.FORG, 10, "Invalid input: '%'."),
    INTRADIX_X(ErrType.FORG, 11, "Radix out of range (2-36): %."),
    INTINVALID_X_X(ErrType.FORG, 12, "Cannot parse input with radix %: %."),
    REGFLAG_X(ErrType.FORX, 1, "Invalid regular flag: '%'."),
    REGINVALID_X(ErrType.FORX, 2, "Invalid regular expression: %."),
    REGBACKSLASH_X(ErrType.FORX, 4, "Invalid backslash in replacement string: %."),
    REGDOLLAR_X(ErrType.FORX, 4, "Invalid dollar sign in replacement string: %."),
    FIATOMIZE_X(ErrType.FOTY, 13, "Atomic item required, function item found: %."),
    FISTRING_X(ErrType.FOTY, 14, "Function item has no string value: %."),
    UPFOTYPE_X(ErrType.FOUP, 1, "Document or element expected, % found."),
    UPDOCTYPE_X(ErrType.FOUP, 1, "Document expected, % found."),
    UPFOURI_X(ErrType.FOUP, 2, "Invalid URI: %."),
    UPPUTERR_X(ErrType.FOUP, 2, "File '%' cannot be written."),
    UPDBPUT_X(ErrType.FOUP, 2, "Resource '%' cannot be written."),
    UPDROPBACK_X_X(ErrType.FOUP, 2, "Backup '%' cannot be %."),
    UPDBERROR_X_X(ErrType.FOUP, 2, "Database '%' cannot be %."),
    UPDBERROR_X(ErrType.FOUP, 2, "%"),
    PARSE_URI_X(ErrType.FOUR, 1, "Invalid IPv6/IPvFuture authority: %."),
    RESWHICH_X(ErrType.FOUT, 1170, "Resource '%' cannot be retrieved."),
    RESFRAG_X(ErrType.FOUT, 1170, "URI contains a fragment identifier: %."),
    RESURI_X(ErrType.FOUT, 1170, "URI is invalid: %"),
    RESENCODING_X(ErrType.FOUT, 1190, "%"),
    RESINPUT_X(ErrType.FOUT, 1190, "%."),
    RECDECODING_X(ErrType.FOUT, 1200, "%."),
    FTWEIGHT_X(ErrType.FTDY, 16, "Weight value out of range: %."),
    FTMILD(ErrType.FTDY, 17, "Invalid 'mild not' selection."),
    FTWILDCARD_X(ErrType.FTDY, 20, "Invalid wildcard syntax: '%'."),
    FTIGNORE(ErrType.FTST, 7, "Ignore option not supported."),
    NOSTOPFILE_X(ErrType.FTST, 8, "Stop word file not found: '%'."),
    FTNOSTEM_X(ErrType.FTST, 9, "No stemmer available for language '%'."),
    FTNOTOK_X(ErrType.FTST, 9, "No tokenizer available for language '%'."),
    NOTHES_X(ErrType.FTST, 18, "Thesaurus not found: %."),
    FTDUP_X(ErrType.FTST, 19, "Match option '%' is declared twice."),
    IXML_GRM_X_X_X(ErrType.FOIX, 1, "Failed to parse ixml grammar: cannot match % at line %, column %."),
    IXML_GEN_X(ErrType.FOIX, 1, "Failed to generate ixml parser: %"),
    IXML_INP_X_X_X(ErrType.FOIX, 2, "Failed to parse ixml input: cannot match % at line %, column %."),
    IXML_RESULT_X(ErrType.FOIX, 2, "Failed to process ixml parser result: %"),
    SERATTR_X(ErrType.SENR, 1, "Attributes cannot be serialized:%."),
    SERNS_X(ErrType.SENR, 1, "Namespaces cannot be serialized:%."),
    SERFUNC_X(ErrType.SENR, 1, "% items cannot be serialized."),
    SERSA(ErrType.SEPM, 4, "If 'standalone' is specified, the root must be a single element."),
    SERDT(ErrType.SEPM, 4, "If 'doctype-system' is specified, the root must be a single element."),
    SERENCODING_X(ErrType.SESU, 7, "%"),
    SERENC_X_X(ErrType.SERE, 8, "Character '#x%;' cannot be mapped to '%'."),
    SERSTAND(ErrType.SEPM, 9, "Invalid combination of omit-xml-declaration and other parameters."),
    SERUNDECL(ErrType.SEPM, 10, "XML 1.0: undeclaring prefixes not allowed."),
    SERNORM_X(ErrType.SESU, 11, "Normalization form not supported: %."),
    SERNOTSUPP_X(ErrType.SESU, 13, "%"),
    SERILL_X(ErrType.SERE, 14, "Illegal HTML character found: #x%;."),
    SERPI(ErrType.SERE, 15, "Processing construction contains '>'."),
    SERPARAM_X(ErrType.SEPM, 16, "%"),
    SERDOC_X(ErrType.SEPM, 17, "%"),
    SERCHARDUP_X(ErrType.SEPM, 18, "Character '%' is specified twice."),
    SERDUP_X(ErrType.SEPM, 19, "Serialization parameter '%' is specified twice."),
    SERNUMBER_X(ErrType.SERE, 20, "Numeric value cannot be represented: '%'"),
    SERJSONFUNC_X(ErrType.SERE, 21, "% items cannot be serialized."),
    SERDUPL_X(ErrType.SERE, 22, "Duplicate name found: '%'"),
    SERJSON(ErrType.SERE, 23, "Only one item can be serialized with JSON."),
    SERJSONSEQ(ErrType.SERE, 23, "Value has more than one item."),
    NOCTX_X(ErrType.XPDY, 2, "%: Context value is undefined."),
    VAREMPTY_X(ErrType.XPDY, 2, "No value assigned to %."),
    NODOC_X(ErrType.XPDY, 50, "Value has no document node: %."),
    NOTREAT_X_X_X(ErrType.XPDY, 50, "Cannot treat % as %: %."),
    MAX_SIZE_X_X(ErrType.XPDY, 130, "Maximum size (%) exceeded: %."),
    QUERYEMPTY(ErrType.XPST, 3, "Empty query."),
    MODLEINV_X(ErrType.XPST, 3, "Module contains illegal character: %."),
    NOQUOTE_X(ErrType.XPST, 3, "Expecting quote%."),
    NUMBER_X(ErrType.XPST, 3, "Incomplete number: '%'."),
    QUERYEND_X(ErrType.XPST, 3, "Unexpected end of query: '%'."),
    MODEXPR(ErrType.XPST, 3, "No expression allowed in a library module."),
    MAINMOD(ErrType.XPST, 3, "Library modules cannot be evaluated."),
    CMPEXPR(ErrType.XPST, 3, "Comparison is incomplete."),
    NOELEMNAME(ErrType.XPST, 3, "Expecting element name."),
    ELEMNAME_X(ErrType.XPST, 3, "Element name expected, '%' found."),
    NOATTNAME(ErrType.XPST, 3, "Expecting attribute name."),
    NONSNAME(ErrType.XPST, 3, "Expecting name of namespace."),
    NOPINAME(ErrType.XPST, 3, "Expecting name of processing instruction."),
    NOEXPR(ErrType.XPST, 3, "Expecting expression."),
    NOCOMMENT(ErrType.XPST, 3, "Expecting comment."),
    PIXML_X(ErrType.XPST, 3, "Name of processing instruction is illegal: '%'."),
    NOPI(ErrType.XPST, 3, "Expecting processing instruction."),
    NOCDATA(ErrType.XPST, 3, "Expecting CDATA section."),
    WRONGCHAR_X_X(ErrType.XPST, 3, "Expecting '%'%."),
    INVENTITY_X(ErrType.XPST, 3, "Invalid entity: '%'."),
    INCOMPLETE(ErrType.XPST, 3, "Incomplete expression."),
    MAPCONSTR(ErrType.XPST, 3, "Incomplete map constructor."),
    ARRAYCONSTR(ErrType.XPST, 3, "Incomplete array constructor."),
    EVALUNARY(ErrType.XPST, 3, "Unary operator expects a numeric value."),
    STEPMISS_X(ErrType.XPST, 3, "Expecting step%."),
    AXISMISS_X(ErrType.XPST, 3, "Expecting node test after % axis."),
    DECLINCOMPLETE(ErrType.XPST, 3, "Expecting 'function', 'variable', ..."),
    FUNCNAME(ErrType.XPST, 3, "Expecting function name."),
    TYPENAME(ErrType.XPST, 3, "Expecting type name."),
    RESERVED_X(ErrType.XPST, 3, "'%' is a reserved keyword."),
    NOVARNAME(ErrType.XPST, 3, "Variable name expected, '%' found."),
    NOVARDECL(ErrType.XPST, 3, "Expecting variable declaration."),
    NOFTSELECT_X(ErrType.XPST, 3, "Expecting quote or opening curly brace%."),
    FUNCARG_X(ErrType.XPST, 3, "Expecting function argument%."),
    MAPTAAT_X(ErrType.XPST, 3, "Expecting atomic key type for map, found '%'."),
    TYPEINVALID(ErrType.XPST, 3, "Expecting type declaration."),
    NOTYPESWITCH(ErrType.XPST, 3, "Incomplete typeswitch expression."),
    NOSWITCH(ErrType.XPST, 3, "Incomplete switch expression."),
    PRAGMAINV(ErrType.XPST, 3, "Invalid pragma expression."),
    CALCEXPR(ErrType.XPST, 3, "Calculation is incomplete."),
    INVMAPKEY(ErrType.XPST, 3, "Invalid key, simple expression expected."),
    INVMAPVAL(ErrType.XPST, 3, "Invalid value, simple expression expected."),
    NORETURN(ErrType.XPST, 3, "Expecting return value."),
    NOWHERE(ErrType.XPST, 3, "Expecting valid expression after 'where'."),
    NOWHILE(ErrType.XPST, 3, "Expecting valid expression after 'while'."),
    ORDERBY(ErrType.XPST, 3, "Expecting valid expression after 'order by'."),
    FLWORRETURN(ErrType.XPST, 3, "Incomplete FLWOR expression, expecting 'return'."),
    NOSOME(ErrType.XPST, 3, "Incomplete quantifier expression."),
    IFPAR(ErrType.XPST, 3, "Expecting '(' after 'if' expression."),
    NOIF(ErrType.XPST, 3, "Incomplete 'if' expression."),
    NOFOR(ErrType.XPST, 3, "Incomplete 'for' expression."),
    NOLET(ErrType.XPST, 3, "Incomplete 'let' expression."),
    NOWINDOW(ErrType.XPST, 3, "Incomplete 'window' expression."),
    NOCOUNT(ErrType.XPST, 3, "Incomplete 'count' expression."),
    NOCLOSING_X(ErrType.XPST, 3, "Expecting closing tag </%>."),
    COMCLOSE(ErrType.XPST, 3, "Unclosed XQuery comment (: ..."),
    EXPREMPTY(ErrType.XPST, 3, "Unknown function or expression."),
    WHICHTYPE_X(ErrType.XPST, 3, "Unknown type: %."),
    INVNAME_X(ErrType.XPST, 3, "Invalid QName: '%'."),
    QNAME_X(ErrType.XPST, 3, "QName expected, '%' found."),
    PROLOGORDER(ErrType.XPST, 3, "Default declarations must be declared first."),
    FTRANGE(ErrType.XPST, 3, "Expecting full-text range."),
    FTSTOP(ErrType.XPST, 3, "Stop words expected."),
    FTMATCH_X(ErrType.XPST, 3, "Unknown match option '%...'."),
    INTEXP(ErrType.XPST, 3, "Integer expected."),
    VARFUNC(ErrType.XPST, 3, "Variable or function declaration expected."),
    NOANN(ErrType.XPST, 3, "No annotation allowed here."),
    NOCATCH(ErrType.XPST, 3, "Expecting catch clause."),
    ANNVALUE_X(ErrType.XPST, 3, "Literal expected, '%' found."),
    UPDATINGVAR(ErrType.XPST, 3, "Variable cannot be updating."),
    UPDATINGTYPE(ErrType.XPST, 3, "Type cannot be updating."),
    SIMPLETYPE_X(ErrType.XPST, 3, "Simple type expected, function found: %(."),
    KEYSPEC_X(ErrType.XPST, 3, "No specifier after lookup operator: '%'."),
    ARROWSPEC_X(ErrType.XPST, 3, "No specifier after arrow operator: '%'."),
    FORMPROP_X(ErrType.XPST, 3, "%."),
    CASTTYPE_X(ErrType.XPST, 3, "%"),
    NOSTRNCN_X(ErrType.XPST, 3, "Expecting string or NCName, found '%'."),
    NONCNAME_X(ErrType.XPST, 3, "Expecting NCName, found '%'."),
    INVPLACEHOLDER_X(ErrType.XPST, 3, "Method call must not have argument placeholders: '%'."),
    STATIC_X(ErrType.XPST, 5, "No XML Schema support: %."),
    VARUNDEF_X(ErrType.XPST, 8, "Undeclared variable: %."),
    INVISIBLEVAR_X(ErrType.XPST, 8, "Variable requires missing module import: %."),
    VARPRIVATE_X(ErrType.XPST, 8, "Variable % is private."),
    TYPEUNDEF_X(ErrType.XPST, 8, "Undefined type annotation: %."),
    SCHEMAINV_X(ErrType.XPST, 8, "Undefined schema name: %."),
    FUNCPRIVATE_X(ErrType.XPST, 17, "Function not visible: %."),
    INVNARGS_X_X(ErrType.XPST, 17, "%: %."),
    WHICHFUNC_X(ErrType.XPST, 17, "Unknown function: %."),
    INVISIBLEFUNC_X(ErrType.XPST, 17, "Function requires missing module import: %."),
    KEYWORDTWICE_X(ErrType.XPST, 17, "Keyword supplied twice: %."),
    ARGMISSING_X_X(ErrType.XPST, 17, "%: No argument supplied: %."),
    ARGTWICE_X_X(ErrType.XPST, 17, "%: Argument supplied twice: %."),
    KEYWORDUNKNOWN_X_X(ErrType.XPST, 17, "%: Unknown keyword: %."),
    ABSTRACTFUNC_X(ErrType.XPST, 17, "No function exists for abstract type: %."),
    FUNCNOIMPL_X(ErrType.XPST, 17, "External function not implemented: %."),
    NO_OPTIONS_WITH_DB_X(ErrType.XPST, 17, "No options allowed with database URI: %."),
    JAVAINIT_X_X(ErrType.XPST, 17, "%: %."),
    JAVACLASS_X(ErrType.XPST, 17, "Unknown class: %."),
    JAVAMEMBER_X(ErrType.XPST, 17, "Unknown method or field: %."),
    DUPFIELD_X(ErrType.XPST, 21, "Duplicate field name: '%'."),
    TYPEUNKNOWN_X(ErrType.XPST, 51, "Unknown type: %."),
    INVALIDCAST_X(ErrType.XPST, 80, "Invalid cast type: %."),
    NOURI_X(ErrType.XPST, 81, "Namespace prefix not declared: %."),
    PREFIXNOURI_X(ErrType.XPST, 154, "QName includes prefix, but no URI: %."),
    JAVANOINSTANCE_X_X(ErrType.XPTY, 4, "% instance expected as first argument, % found."),
    JAVAEXEC_X_X_X(ErrType.XPTY, 4, "%. Caused by: %%."),
    JAVAMULTIPLE_X_X(ErrType.XPTY, 4, "Multiple % candidates. Parameters: %."),
    JAVANONE_X_X_X(ErrType.XPTY, 4, "% cannot be called with %. Expected: %."),
    JAVAARGS_X_X_X(ErrType.XPTY, 4, "%% expected, % found."),
    JAVAARGS_X_X(ErrType.XPTY, 4, "% cannot be called with %."),
    NONAME_X(ErrType.XPTY, 4, "Name expected, '%' found."),
    NONUMBER_X_X(ErrType.XPTY, 4, "Number expected, % found: %."),
    NODUR_X_X(ErrType.XPTY, 4, "Duration expected, % found: %."),
    NOSUBDUR_X(ErrType.XPTY, 4, "Subtype of xs:duration expected: %."),
    NOSUB_X_X(ErrType.XPTY, 4, "Subtype of % expected: %."),
    STRQNM_X_X(ErrType.XPTY, 4, "String or QName expected, % found: %."),
    STRNCN_X_X(ErrType.XPTY, 4, "String or NCName expected, % found: %."),
    INVTYPE_X(ErrType.XPTY, 4, "%."),
    CALCTYPE_X_X_X_X_X(ErrType.XPTY, 4, "Arithmetics not defined for % and %: % % %."),
    INVFUNCITEM_X_X(ErrType.XPTY, 4, "Function expected, % found: %."),
    CMPTYPE_X_X_X(ErrType.XPTY, 4, "Items of type % cannot be compared: % vs. %."),
    CMPTYPES_X_X_X_X(ErrType.XPTY, 4, "% and % cannot be compared: % vs. %."),
    DOCATTS_X(ErrType.XPTY, 4, "Cannot add attributes to a document node: %."),
    DOCNS_X(ErrType.XPTY, 4, "Cannot add namespaces to a document node: %."),
    INVARITY_X_X(ErrType.XPTY, 4, "%: %."),
    INVNCNAME_X(ErrType.XPTY, 4, "Invalid NCName: '%'."),
    VALUETYPES_X_X(ErrType.XPTY, 4, "Incompatible types in context value declarations: % vs. %."),
    LOOKUP_X(ErrType.XPTY, 4, "Input of lookup must be map or array: %."),
    STRUCT_FILTER_X(ErrType.XPTY, 4, "Input of filter must be map or array: %."),
    EXP_FOUND_X_X(ErrType.XPTY, 4, "% expected, % found."),
    BINARY_X(ErrType.XPTY, 4, "Binary expected, % found."),
    STRBIN_X_X(ErrType.XPTY, 4, "String or binary expected, % found: %."),
    STRNOD_X_X(ErrType.XPTY, 4, "String or node expected, % found: %."),
    ELMMAP_X_X_X(ErrType.XPTY, 4, "element(%) or map expected, % found: %."),
    ELM_X_X_X(ErrType.XPTY, 4, "element(%) expected, % found: %."),
    FUNCUP_X(ErrType.XPTY, 4, "Function is updating: %."),
    FUNCNOTUP_X(ErrType.XPTY, 4, "Function is not updating: %."),
    UNKNOWNOP_X(ErrType.XPTY, 4, "Unknown operator: %."),
    INVALIDOPTION_X_X_X_X(ErrType.XPTY, 4, "Option %: % expected, % found: %."),
    INVALIDOPTION_X_X_X(ErrType.XPTY, 4, "Option: % expected, % found: %."),
    INVALIDOPTION_X(ErrType.XPTY, 4, "%"),
    UNKNOWNOPTION_X(ErrType.XPTY, 4, "Unknown option '%'."),
    JAVANULL(ErrType.XPTY, 17, "Java array contains null values."),
    MIXEDRESULTS(ErrType.XPTY, 18, "Path returns both nodes and non-nodes."),
    PATHNODE_X_X_X(ErrType.XPTY, 19, "%: node expected, % found: %."),
    NSSENS_X_X(ErrType.XPTY, 117, "Cannot convert % to %."),
    CATTDUPL_X(ErrType.XQDY, 25, "Duplicate attribute name: %."),
    CPICONT_X(ErrType.XQDY, 26, "Processing instruction has invalid content: '%'."),
    CPIINVAL_X(ErrType.XQDY, 41, "Processing instruction has invalid name: '%'."),
    CAXML(ErrType.XQDY, 44, "XML prefix and namespace cannot be rebound."),
    CAINV_(ErrType.XQDY, 44, "Invalid attribute prefix/namespace: %."),
    CIRCVAR_X(ErrType.XQDY, 54, "Static variable depends on itself: %"),
    CIRCCTX(ErrType.XQDY, 54, "Context value is not defined."),
    CPIXML_X(ErrType.XQDY, 64, "Processing instruction has illegal name: %."),
    COMINVALID(ErrType.XQDY, 72, "Comment must not contain '--' or end with '-'."),
    INVNSPREFIX_X(ErrType.XQDY, 74, "Invalid namespace prefix: %."),
    INVQNAME_X(ErrType.XQDY, 74, "Invalid QName: %."),
    NOQNNAMENS_X(ErrType.XQDY, 74, "Namespace prefix not declared: %."),
    CEXML(ErrType.XQDY, 96, "XML prefix or namespace cannot be rebound: %/%."),
    CEINV_X(ErrType.XQDY, 96, "Invalid element prefix/namespace: %."),
    CNXML(ErrType.XQDY, 101, "XML prefix and namespace cannot be rebound."),
    CNINV_X(ErrType.XQDY, 101, "Invalid namespace prefix: %."),
    CNINVNS_X(ErrType.XQDY, 101, "Invalid namespace URI: '%'."),
    EMPTYNSCONS(ErrType.XQDY, 102, "Element is in no namespace, no namespace can be assigned."),
    DUPLNSCONS_X(ErrType.XQDY, 102, "Duplicate declaration of namespace '%'."),
    MAPDUPLKEY_X(ErrType.XQDY, 137, "Map contains duplicate key: %."),
    IMPLSCHEMA(ErrType.XQST, 9, "No XML Schema support."),
    NSCONS(ErrType.XQST, 22, "Constant namespace value expected."),
    XQUERYVER_X(ErrType.XQST, 31, "XQuery version '%' not supported."),
    DUPLBASE(ErrType.XQST, 32, "Duplicate 'base-uri' declaration."),
    DUPLNSDECL_X(ErrType.XQST, 33, "Duplicate declaration of prefix '%'."),
    DUPLFUNC_X(ErrType.XQST, 34, "Duplicate declaration of function '%'."),
    DUPLCOLL(ErrType.XQST, 38, "Duplicate 'collation' declaration."),
    WHICHDEFCOLL_X(ErrType.XQST, 38, "%."),
    FUNCDUPL_X(ErrType.XQST, 39, "Duplicate parameter name: %."),
    ATTDUPL_X(ErrType.XQST, 40, "Duplicate attribute name: %."),
    FNRESERVED_X(ErrType.XQST, 45, "Function '%' is in reserved namespace."),
    ANNWHICH_X_X(ErrType.XQST, 45, "Annotation %% is in reserved namespace."),
    TYPERESERVED_X(ErrType.XQST, 45, "Type % is in reserved namespace."),
    INVURI_X(ErrType.XQST, 46, "Invalid URI: %."),
    DUPLMODULE_X(ErrType.XQST, 47, "Module namespace is declared twice: %."),
    MODULENS_X(ErrType.XQST, 48, "Declaration % does not match the module namespace."),
    VARDUPL_X(ErrType.XQST, 49, "Duplicate declaration of static variable $%."),
    WHICHCAST_X(ErrType.XQST, 52, "Unknown type: %."),
    DUPLCOPYNS(ErrType.XQST, 55, "Duplicate 'copy-namespace' declaration."),
    NSEMPTY(ErrType.XQST, 57, "Namespace URI cannot be empty."),
    WHICHMOD_X(ErrType.XQST, 59, "Module not found: %."),
    WHICHMODCLASS_X(ErrType.XQST, 59, "Java class not found: %."),
    MODINIT_X_X_X(ErrType.XQST, 59, "Cannot initialize %: % (%)."),
    MODINST_X_X(ErrType.XQST, 59, "Cannot instantiate %: %."),
    WHICHMODFILE_X(ErrType.XQST, 59, "Cannot retrieve module: %."),
    WRONGMODULE_X_X_X(ErrType.XQST, 59, "Imported module '%' has unexpected namespace: '%' vs '%'."),
    DUPLORD(ErrType.XQST, 65, "Duplicate 'ordering' declaration."),
    DUPLNS(ErrType.XQST, 66, "Duplicate 'default namespace' declaration."),
    DUPLCONS(ErrType.XQST, 67, "Duplicate 'construction' declaration."),
    DUPLBOUND(ErrType.XQST, 68, "Duplicate 'boundary-space' declaration."),
    DUPLORDEMP(ErrType.XQST, 69, "Duplicate 'order empty' declaration."),
    BINDXML_X(ErrType.XQST, 70, "Prefix '%' cannot be rebound."),
    XMLNSDEF_X(ErrType.XQST, 70, "'%' cannot be default namespace."),
    BINDXMLURI_X_X(ErrType.XQST, 70, "'%' can only be bound to '%'."),
    ILLEGALEQNAME_X(ErrType.XQST, 70, "Illegal namespace: %."),
    DUPLNSDEF_X(ErrType.XQST, 71, "Duplicate declaration of prefix '%'."),
    IMPLVAL(ErrType.XQST, 75, "Validation not supported."),
    FLWORCOLL_X(ErrType.XQST, 76, "%."),
    NOPRAGMA(ErrType.XQST, 79, "Expecting pragma expression."),
    NSEMPTYURI(ErrType.XQST, 85, "Namespace URI cannot be empty."),
    XQUERYENC2_X(ErrType.XQST, 87, "%"),
    NSMODURI(ErrType.XQST, 88, "Module namespace cannot be empty."),
    DUPLVAR_X(ErrType.XQST, 89, "Duplicate declaration of %."),
    INVCHARREF_X(ErrType.XQST, 90, "Invalid XML 1.0 character: %."),
    CIRCMODULE(ErrType.XQST, 93, "Circular module declaration."),
    GVARNOTDEFINED_X(ErrType.XQST, 94, "Undeclared grouping variable: %."),
    INVDECFORM_X_X(ErrType.XQST, 97, "Invalid decimal-format property: %='%'."),
    INVDECSINGLE_X_X(ErrType.XQST, 97, "Decimal-format property must be a single character: %='%'."),
    INVDECZERO_X(ErrType.XQST, 97, "Zero-digit property is no Unicode digit with value zero: %."),
    DUPLDECFORM_X(ErrType.XQST, 98, "Decimal-format character is assigned twice: '%'."),
    DUPLVALUE(ErrType.XQST, 99, "Duplicate context value declaration."),
    DUPLWIND_X(ErrType.XQST, 103, "Duplicate declaration: %."),
    DUPLUPD(ErrType.XQST, 106, "More than one updating annotation declared."),
    DUPLFUNVIS(ErrType.XQST, 106, "More than one visibility annotation declared."),
    OUTPUTLIB_X(ErrType.XQST, 108, "Declaration not allowed in library module: output:%."),
    OUTPUT_X(ErrType.XQST, 109, "%"),
    OUTDUPL_X(ErrType.XQST, 110, "Duplicate declaration: output:%."),
    DECDUPL(ErrType.XQST, 111, "Duplicate decimal-format declaration."),
    DECITEM(ErrType.XQST, 113, "Context value cannot be bound in library module."),
    DECDUPLPROP_X(ErrType.XQST, 114, "Property is defined twice: %."),
    DUPLVARVIS(ErrType.XQST, 116, "More than one visibility annotation declared."),
    TAGWRONG_X_X(ErrType.XQST, 118, "Different start and end tag: <%>...</%>."),
    PARAMDOC_X(ErrType.XQST, 119, "Parameter document: %."),
    NOVISALLOWED(ErrType.XQST, 125, "No visibility annotation allowed in inline function."),
    NSAXIS(ErrType.XQST, 134, "Namespace axis is not supported."),
    DUPLTYPE_X(ErrType.XQST, 146, "Duplicate declaration of type %."),
    PARAMOPTIONAL_X(ErrType.XQST, 148, "Parameter must be declared as optional: $%."),
    NOATTALL_X(ErrType.XQTY, 24, "Attribute does not follow root element: %."),
    NONSALL_X(ErrType.XQTY, 24, "Namespaces does not follow root element: %."),
    CONSFUNC_X(ErrType.XQTY, 105, "Invalid content: %."),
    FINALLY_X(ErrType.XQTY, 153, "Finally must not return a result: %."),
    UPNOPAR_X(ErrType.XUDY, 9, "Target has no parent: %."),
    UPNOTCOPIED_X(ErrType.XUDY, 14, "Node was not created by transform expression: %."),
    UPMULTREN_X(ErrType.XUDY, 15, "Node can only be renamed once: %."),
    UPPATHREN_X(ErrType.XUDY, 15, "Path can only be renamed once: %."),
    UPMULTREPL_X(ErrType.XUDY, 16, "Node can only be replaced once: %."),
    UPMULTDOC_X_X(ErrType.XUDY, 16, "Documents in path '%/%' can only be replaced once."),
    UPMULTREPV_X(ErrType.XUDY, 17, "Node can only be replaced once: %."),
    UPATTDUPL_X(ErrType.XUDY, 21, "Duplicate attribute name: %."),
    UPNSCONFL_X_X(ErrType.XUDY, 23, "Namespace conflicts: % vs. %."),
    UPNSCONFL2_X_X(ErrType.XUDY, 24, "Namespaces conflicts: % vs. %."),
    UPPAREMPTY_X(ErrType.XUDY, 29, "Target has no parent: %."),
    UPATTELM_X(ErrType.XUDY, 30, "Attribute cannot be added to %."),
    UPURIDUP_X(ErrType.XUDY, 31, "URI '%' is addressed multiple times."),
    UPNOT_X(ErrType.XUST, 1, "%: no updating expression allowed."),
    UPALL(ErrType.XUST, 1, "Expressions must all be updating or return an empty sequence."),
    UPCTX(ErrType.XUST, 1, "Context value may not declare an updating expression."),
    UPMODIFY(ErrType.XUST, 2, "Transformations must all be updating or return an empty sequence."),
    UPEXPECTF(ErrType.XUST, 2, "Expressions must all be updating or return an empty sequence."),
    DUPLREVAL(ErrType.XUST, 3, "Duplicate 'revalidation' declaration."),
    NOREVAL(ErrType.XUST, 26, "Revalidation mode not supported."),
    UUPFUNCTYPE(ErrType.XUST, 28, "No return type allowed in updating functions."),
    UPNOATTRPER_X(ErrType.XUTY, 4, "Attribute does not follow root element: %."),
    UPTRGTYP_X(ErrType.XUTY, 5, "Target is not an element or document: %."),
    UPTRGTYP2_X(ErrType.XUTY, 6, "Target is not an element, text, comment or pi: %."),
    UPTRGDELEMPT_X(ErrType.XUTY, 7, "Target is not a node: %."),
    UPTRGNODE_X(ErrType.XUTY, 8, "Target is not an element, text, attribute, comment or pi: %."),
    UPWRELM_X(ErrType.XUTY, 10, "Node cannot be replaced with attribute: %."),
    UPWRATTR_X(ErrType.XUTY, 11, "Target is no attribute: %."),
    UPWRTRGTYP_X(ErrType.XUTY, 12, "Target is not an element, attribute or pi: %."),
    UPSOURCE_X(ErrType.XUTY, 13, "Source is not a node: %."),
    UPSINGLE_X_X(ErrType.XUTY, 13, "Value of $% is not a single node: %."),
    UPATTELM2_X(ErrType.XUTY, 22, "Attribute cannot be added to %.");

    private final byte[] uri;
    private final String prefix;
    private final String code;
    private final String message;

    private QueryError(ErrType type, String code, String message) {
        this.code = code;
        this.message = message;
        this.uri = type.uri;
        this.prefix = type.prefix;
    }

    private QueryError(ErrType type, int number, String message) {
        String n2 = Integer.toString(number);
        this.code = String.valueOf((Object)type) + "0".repeat(4 - n2.length()) + n2;
        this.uri = type.uri;
        this.prefix = type.prefix;
        this.message = message;
    }

    public QueryException get(InputInfo info, Object ... ext) {
        return info != null && info.internal() ? QueryException.ERROR : new QueryException(info, this, ext);
    }

    public QueryIOException getIO(Object ... ext) {
        return new QueryIOException(this.get(null, ext));
    }

    public final boolean eq(QNm name) {
        return Token.eq(name.uri(), this.uri) && Token.eq(name.local(), Token.token(this.code));
    }

    public final QNm qname() {
        return new QNm(Token.token(this.prefix), this.code, this.uri);
    }

    public final String message() {
        return this.message;
    }

    public static QueryException get(String name, String msg, InputInfo info) {
        QueryError err = Enums.get(QueryError.class, name);
        return err != null ? new QueryException(info, err.qname(), msg, new Object[0]).error(err) : null;
    }

    public static QueryException compareError(Item item1, Item item2, InputInfo info) {
        Type type1 = item1.type;
        Type type2 = item2.type;
        return type1.eq(type2) ? CMPTYPE_X_X_X.get(info, type1, item1, item2) : CMPTYPES_X_X_X_X.get(info, type1, type2, item1, item2);
    }

    public static QueryException typeError(Value value, Type type, InputInfo info) {
        return QueryError.typeError((Expr)value, type.seqType(), info);
    }

    public static QueryException typeError(Expr expr, SeqType st, InputInfo info) {
        return QueryError.typeError(expr, st, null, info);
    }

    public static QueryException typeError(Expr expr, SeqType st, QNm name, InputInfo info) {
        return QueryError.typeError(st, expr.seqType(), expr, name, info);
    }

    public static QueryException typeError(SeqType st, SeqType ist, Expr expr, QNm name, InputInfo info) {
        TokenBuilder desc = new TokenBuilder();
        if (ist.occ.instanceOf(st.occ)) {
            desc.add(st.occ == Occ.EXACTLY_ONE ? "Item" : "Value").add(" of type ").add(st);
            desc.add(" expected, ").add(ist).add(" found");
        } else {
            desc.add(Strings.capitalize(st.occ.desc)).add(" expected");
            if (!ist.type.instanceOf(st.type) || !ist.testInstanceOf(st)) {
                desc.add(" (").add(st).add(")");
            }
            if (expr != null) {
                desc.add(", ");
                if (expr instanceof Value) {
                    Value value = (Value)expr;
                    desc.add(value.size());
                } else {
                    desc.add(expr.seqType());
                }
                desc.add(" found");
            }
        }
        if (name != null || !ist.eq(Types.EMPTY_SEQUENCE_Z)) {
            desc.add(": ");
            if (name != null) {
                desc.add(name.varString());
            }
            if (expr != null) {
                if (name != null) {
                    desc.add(" := ");
                }
                desc.add(expr.toErrorString());
            }
        }
        return INVTYPE_X.get(info, desc);
    }

    public static QueryException arityError(Expr expr, int supplied, int expected, boolean param, InputInfo info) {
        Object input = param ? "Function with " + QueryError.parameters(supplied) : QueryError.arguments(supplied);
        String arity = QueryError.arity((String)input, new IntList().add(expected));
        return INVARITY_X_X.get(info, arity, expr.toErrorString());
    }

    public static QueryException testError(Value value, boolean pos, InputInfo info) {
        String found;
        Object expected;
        Type type = value.seqType().type;
        if (type.instanceOf(AtomType.NUMERIC) || type.instanceOf(AtomType.STRING) || type.oneOf(AtomType.BOOLEAN, AtomType.ANY_URI)) {
            expected = "Single " + String.valueOf(type);
            found = "sequence";
        } else if (pos) {
            expected = "Numbers";
            found = value.itemAt(value.size() - 1L).seqType().toString();
        } else {
            expected = "Number, string, boolean, URI or nodes";
            found = value.itemAt(0L).seqType().toString();
        }
        return ARGTYPE_X_X_X.get(info, expected, found, value);
    }

    public static QueryException numberError(ParseExpr expr, Item item) {
        return NONUMBER_X_X.get(expr.info(), item.type, item);
    }

    public static QueryException valueError(Type type, byte[] value, InputInfo info) {
        return INVALUE_X_X.get(info, type, value);
    }

    public static String arguments(long number) {
        return number + " " + Strings.plural("argument", number);
    }

    public static String parameters(long number) {
        return number + " " + Strings.plural("parameter", number);
    }

    public static String arity(String supplied, IntList arities) {
        Object expected;
        int as = arities.ddo().size();
        if (as == 1 && arities.peek() < 0) {
            expected = "at least " + -arities.peek();
        } else {
            int min = Integer.MAX_VALUE;
            int max = Integer.MIN_VALUE;
            for (int a = 0; a < as; ++a) {
                int m = arities.get(a);
                if (m < min) {
                    min = m;
                }
                if (m <= max) continue;
                max = m;
            }
            TokenBuilder tb = new TokenBuilder();
            if (as > 2 && max - min + 1 == as) {
                tb.addInt(min).add(45).addInt(max);
            } else {
                for (int a = 0; a < as; ++a) {
                    if (a != 0) {
                        tb.add(a + 1 < as ? ", " : " or ");
                    }
                    tb.addInt(arities.get(a));
                }
            }
            expected = tb.toString();
        }
        return Util.info("% supplied, % expected", supplied, expected);
    }

    public static String similar(Object string, Object similar) {
        return similar == null ? Util.info(string, new Object[0]) : Util.info("% (similar: %)", string, similar);
    }

    public static byte[] normalize(Object value, InputInfo info) {
        if (info != null && info.internal()) {
            return Token.EMPTY;
        }
        TokenBuilder tb = new TokenBuilder();
        int last = 0;
        int c = 0;
        TokenParser tp = new TokenParser(Token.token(value));
        while (tp.more()) {
            if (c == 200) {
                tb.add("...");
                break;
            }
            int cp = Math.max(tp.next(), 32);
            if (cp != 32 || last != 32) {
                tb.add(cp);
                ++c;
            }
            last = cp;
        }
        return tb.finish();
    }

    public String toString() {
        return this.code;
    }

    public static enum ErrType {
        ADMIN(QueryText.ADMIN_PREFIX, QueryText.ADMIN_URI),
        BASEX(QueryText.BASEX_PREFIX, QueryText.BASEX_URI),
        ARCHIVE(QueryText.ADMIN_PREFIX, QueryText.ARCHIVE_URI),
        CLIENT(QueryText.CLIENT_PREFIX, QueryText.CLIENT_URI),
        CONVERT(QueryText.CONVERT_PREFIX, QueryText.CONVERT_URI),
        CSV(QueryText.CSV_PREFIX, QueryText.CSV_URI),
        DB(QueryText.DB_PREFIX, QueryText.DB_URI),
        FETCH(QueryText.FETCH_PREFIX, QueryText.FETCH_URI),
        FT(QueryText.FT_PREFIX, QueryText.FT_URI),
        HTML(QueryText.HTML_PREFIX, QueryText.HTML_URI),
        INSPECT(QueryText.INSPECT_PREFIX, QueryText.INSPECT_URI),
        JOB(QueryText.JOB_PREFIX, QueryText.JOB_URI),
        JSON(QueryText.JSON_PREFIX, QueryText.JSON_URI),
        PROC(QueryText.PROC_PREFIX, QueryText.PROC_URI),
        PROF(QueryText.PROF_PREFIX, QueryText.PROF_URI),
        RANDOM(QueryText.RANDOM_PREFIX, QueryText.RANDOM_URI),
        REPO(QueryText.REPO_PREFIX, QueryText.REPO_URI),
        REQUEST(QueryText.REQUEST_PREFIX, QueryText.REQUEST_URI),
        SESSIONS(QueryText.SESSIONS_PREFIX, QueryText.SESSIONS_URI),
        SQL(QueryText.SQL_PREFIX, QueryText.SQL_URI),
        STORE(QueryText.STORE_PREFIX, QueryText.STORE_URI),
        STRING(QueryText.STRING_PREFIX, QueryText.STRING_URI),
        UNIT(QueryText.UNIT_PREFIX, QueryText.UNIT_URI),
        USER(QueryText.USER_PREFIX, QueryText.USER_URI),
        VALIDATE(QueryText.VALIDATE_PREFIX, QueryText.VALIDATE_URI),
        WEB(QueryText.WEB_PREFIX, QueryText.WEB_URI),
        WS(QueryText.WS_PREFIX, QueryText.WS_URI),
        XQUERY(QueryText.XQUERY_PREFIX, QueryText.XQUERY_URI),
        XSLT(QueryText.XSLT_PREFIX, QueryText.XSLT_URI),
        BIN(QueryText.BIN_PREFIX, QueryText.BIN_URI),
        CX(QueryText.EXPERR_PREFIX, QueryText.EXPERROR_URI),
        FILE(QueryText.FILE_PREFIX, QueryText.FILE_URI),
        HC(QueryText.EXPERR_PREFIX, QueryText.EXPERROR_URI),
        FOAP,
        FOAR,
        FOAY,
        FOCA,
        FOCH,
        FOCV,
        FODC,
        FODF,
        FODT,
        FOFD,
        FOER,
        FOHA,
        FOIX,
        FOJS,
        FONS,
        FOPA,
        FORG,
        FOQM,
        FORX,
        FOTY,
        FOUP,
        FOUR,
        FOUT,
        FTDY,
        FTST,
        SENR,
        SEPM,
        SERE,
        SESU,
        XPDY,
        XPST,
        XPTY,
        XQDY,
        XQST,
        XQTY,
        XUDY,
        XUST,
        XUTY;

        public final String prefix;
        public final byte[] uri;

        private ErrType(byte[] prefix, byte[] uri) {
            this.prefix = Token.string(prefix);
            this.uri = uri;
        }

        private ErrType() {
            this(QueryText.ERR_PREFIX, QueryText.ERROR_URI);
        }
    }
}

