/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.options;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import org.basex.core.BaseXException;
import org.basex.core.Text;
import org.basex.io.IOFile;
import org.basex.io.in.NewlineInput;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryFunction;
import org.basex.query.value.Value;
import org.basex.query.value.array.XQArray;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.map.XQMap;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Types;
import org.basex.util.Enums;
import org.basex.util.InputInfo;
import org.basex.util.Prop;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.http.MediaType;
import org.basex.util.list.IntList;
import org.basex.util.list.StringList;
import org.basex.util.options.BooleanOption;
import org.basex.util.options.Comment;
import org.basex.util.options.EnumOption;
import org.basex.util.options.NumberOption;
import org.basex.util.options.NumbersOption;
import org.basex.util.options.Option;
import org.basex.util.options.OptionsOption;
import org.basex.util.options.StringOption;
import org.basex.util.options.StringsOption;
import org.basex.util.options.ValueOption;
import org.basex.util.similarity.Levenshtein;

public class Options
implements Iterable<Option<?>> {
    private static final String PROPUSER = "# Local Options";
    private final TreeMap<String, Option<?>> definitions;
    private final TreeMap<String, Object> values;
    private final HashMap<String, String> free;
    private final StringList user = new StringList();
    private IOFile file;

    public Options() {
        this((IOFile)null);
    }

    protected Options(IOFile opts) {
        this.definitions = new TreeMap();
        this.values = new TreeMap();
        this.free = new HashMap();
        try {
            for (Option<?> opt : Options.options(this.getClass())) {
                if (opt instanceof Comment) continue;
                String name = opt.name();
                this.definitions.put(name, opt);
                this.values.put(name, opt.value());
            }
        }
        catch (Exception ex) {
            throw Util.notExpected(ex, new Object[0]);
        }
        if (opts != null) {
            this.read(opts);
        }
    }

    protected Options(Options opts) {
        this.definitions = (TreeMap)opts.definitions.clone();
        this.values = (TreeMap)opts.values.clone();
        this.free = (HashMap)opts.free.clone();
        this.user.add(opts.user);
        this.file = opts.file;
    }

    public final synchronized void write() {
        StringList lines = new StringList();
        try {
            for (Option<?> option : Options.options(this.getClass())) {
                String name = option.name();
                if (option instanceof Comment) {
                    if (!lines.isEmpty()) {
                        lines.add("");
                    }
                    lines.add("# " + name);
                    continue;
                }
                if (option instanceof NumbersOption) {
                    NumbersOption no = (NumbersOption)option;
                    int[] ints = this.get(no);
                    int is = ints == null ? 0 : ints.length;
                    for (int i = 0; i < is; ++i) {
                        lines.add(name + i + " = " + ints[i]);
                    }
                    continue;
                }
                if (option instanceof StringsOption) {
                    StringsOption so = (StringsOption)option;
                    String[] strings = this.get(so);
                    int ss = strings == null ? 0 : strings.length;
                    lines.add(name + " = " + ss);
                    for (int s = 0; s < ss; ++s) {
                        lines.add(name + (s + 1) + " = " + strings[s]);
                    }
                    continue;
                }
                lines.add(name + " = " + String.valueOf(this.get(option)));
            }
            ((StringList)((Object)((StringList)((Object)lines.add(""))).add(PROPUSER))).add(this.user);
            TokenBuilder tb = new TokenBuilder();
            for (String line : lines) {
                tb.add(line).add(Prop.NL);
            }
            byte[] contents = tb.finish();
            boolean skip = this.file.exists();
            if (skip) {
                TokenBuilder tmp = new TokenBuilder(contents.length);
                try (NewlineInput nli = new NewlineInput(this.file);){
                    String line;
                    while ((line = nli.readLine()) != null) {
                        tmp.add(line).add(Prop.NL);
                    }
                }
                skip = Token.eq(contents, tmp.finish());
            }
            if (!skip) {
                this.file.parent().md();
                this.file.write(contents);
            }
        }
        catch (Exception ex) {
            Util.errln("% could not be written.", this.file);
            Util.debug(ex);
        }
    }

    public final synchronized Option<?> option(String name) {
        return this.definitions.get(name);
    }

    public final synchronized Object get(Option<?> option) {
        return this.get(option.name());
    }

    public final synchronized Object get(String name) {
        return this.values.get(name);
    }

    public final synchronized void put(Option<?> option, Object value) {
        this.values.put(option.name(), value);
    }

    public final synchronized boolean contains(Option<?> option) {
        return this.get(option) != null;
    }

    public final synchronized String get(StringOption option) {
        return (String)this.get((Option<?>)option);
    }

    public final synchronized Integer get(NumberOption option) {
        return (Integer)this.get((Option<?>)option);
    }

    public final synchronized Boolean get(BooleanOption option) {
        return (Boolean)this.get((Option<?>)option);
    }

    public final synchronized Value get(ValueOption option) {
        return (Value)this.get((Option<?>)option);
    }

    public final synchronized String[] get(StringsOption option) {
        return (String[])this.get((Option<?>)option);
    }

    public final synchronized int[] get(NumbersOption option) {
        return (int[])this.get((Option<?>)option);
    }

    public final synchronized <O extends Options> O get(OptionsOption<O> option) {
        return (O)((Options)this.get((Option<?>)option));
    }

    public final synchronized <E extends Enum<E>> E get(EnumOption<E> option) {
        return (E)((Enum)this.get((Option<?>)option));
    }

    public final synchronized void set(StringOption option, String value) {
        this.put(option, value);
    }

    public final synchronized void set(NumberOption option, int value) {
        this.put(option, value);
    }

    public final synchronized void set(BooleanOption option, boolean value) {
        this.put(option, value);
    }

    public final synchronized void set(StringsOption option, String[] value) {
        this.put(option, value);
    }

    public final synchronized void set(NumbersOption option, int[] value) {
        this.put(option, value);
    }

    public final synchronized <O extends Options> void set(OptionsOption<O> option, O value) {
        this.put(option, value);
    }

    public final synchronized <V extends Enum<V>> void set(EnumOption<V> option, Enum<V> value) {
        this.put(option, value);
    }

    public final synchronized <V extends Enum<V>> void set(EnumOption<V> option, String value) {
        this.put(option, option.get(value));
    }

    public final synchronized void set(ValueOption option, Value value) {
        this.put(option, value);
    }

    public synchronized void assign(String name, String value) throws BaseXException {
        if (this.definitions.isEmpty()) {
            this.free.put(name, value);
        } else {
            this.assign(name, value, -1, true);
        }
    }

    public synchronized void assign(Item name, Value value, InputInfo info) throws QueryException {
        String nm;
        if (name instanceof QNm) {
            QNm qnm = (QNm)name;
            nm = Token.string(qnm.unique());
        } else if (name.type.isStringOrUntyped()) {
            nm = Token.string(name.string(info));
        } else {
            throw QueryError.INVALIDOPTION_X_X_X.get(info, AtomType.STRING, name.type, name);
        }
        if (this.definitions.isEmpty()) {
            this.free.put(nm, Options.serialize(value, info));
        } else {
            this.assign(nm, value, info);
        }
    }

    private static String serialize(Value value, InputInfo info) throws QueryException {
        TokenBuilder tb = new TokenBuilder();
        for (Item item : value) {
            if (!tb.isEmpty()) {
                tb.add(32);
            }
            if (item instanceof XQMap) {
                XQMap map = (XQMap)item;
                map.forEach((Item key, Value v) -> {
                    if (!tb.isEmpty()) {
                        tb.add(44);
                    }
                    tb.add(key.string(info)).add(61);
                    if (v.size() != 1L) {
                        throw QueryError.INVALIDOPTION_X_X_X.get(info, AtomType.STRING, v.seqType(), v);
                    }
                    tb.add(Token.string(((Item)v).string(info)).replace(",", ",,"));
                });
                continue;
            }
            if (item instanceof XQArray) {
                XQArray array = (XQArray)item;
                for (Value member : array.iterable()) {
                    if (!tb.isEmpty()) {
                        tb.add(32);
                    }
                    tb.add(Options.serialize(member, info));
                }
                continue;
            }
            if (item instanceof QNm) {
                QNm qnm = (QNm)item;
                tb.add(qnm.unique());
                continue;
            }
            tb.add(item.string(info));
        }
        return tb.toString();
    }

    public final synchronized HashMap<String, String> free() {
        return this.free;
    }

    public final Map<String, String> toMap(StringOption option) {
        return Options.toMap(this.get(option));
    }

    public final synchronized String similar(Object option) {
        return Options.similar(option, this.definitions);
    }

    public static String similar(Object option, Map<String, Option<?>> options) {
        Object similar = Levenshtein.similar(Token.token(option), options.keySet().toArray(String[]::new));
        return similar != null ? Util.info(Text.UNKNOWN_OPT_SIMILAR_X_X, option, similar) : Options.unknown(option);
    }

    public static String unknown(Object option) {
        return Util.info(Text.UNKNOWN_OPTION_X, option);
    }

    public final synchronized boolean invert(BooleanOption option) {
        boolean val = this.get(option) == false;
        this.set(option, val);
        return val;
    }

    public void setSystem() {
        for (Map.Entry<String, String> entry : Prop.entries()) {
            String name = entry.getKey();
            String value = entry.getValue();
            if (!name.startsWith("org.basex.")) continue;
            name = name.substring("org.basex.".length()).toUpperCase(Locale.ENGLISH);
            try {
                if (!this.assign(name, value, -1, false)) continue;
                Util.debugln(name + ": " + value, new Object[0]);
            }
            catch (BaseXException ex) {
                Util.errln(ex, new Object[0]);
            }
        }
    }

    public final synchronized void assign(MediaType type) throws BaseXException {
        for (Map.Entry<String, String> entry : type.parameters()) {
            if (this.definitions.isEmpty()) {
                this.free.put(entry.getKey(), entry.getValue());
                continue;
            }
            this.assign(entry.getKey(), entry.getValue(), -1, false);
        }
    }

    public final synchronized void assign(String string) throws BaseXException {
        for (Map.Entry<String, String> entry : Options.toMap(string).entrySet()) {
            this.assign(entry.getKey(), entry.getValue());
        }
    }

    public final synchronized void assign(XQMap map, InputInfo info) throws QueryException {
        map.forEach((Item key, Value value) -> this.assign((Item)key, (Value)value, info));
    }

    public final synchronized String[] names() {
        StringList sl = new StringList(this.definitions.size());
        for (Option<?> option : this) {
            sl.add(option.name());
        }
        return (String[])sl.finish();
    }

    @Override
    public final synchronized Iterator<Option<?>> iterator() {
        return this.definitions.values().iterator();
    }

    public final synchronized String toString() {
        StringBuilder sb = new StringBuilder();
        this.values.forEach((? super K name, ? super V value) -> {
            if (value != null) {
                StringList list = new StringList();
                Object value2 = this.definitions.get(name).value();
                if (value instanceof String[]) {
                    String[] strings;
                    for (String s : strings = (String[])value) {
                        list.add(s);
                    }
                } else if (value instanceof int[]) {
                    int[] ints;
                    for (int i : ints = (int[])value) {
                        list.add(Integer.toString(i));
                    }
                } else if (value instanceof Options) {
                    String string = value.toString();
                    if (value2 == null || !string.equals(value2.toString())) {
                        list.add(string);
                    }
                } else if (!value.equals(value2)) {
                    if (value instanceof Value) {
                        Value value3 = (Value)value;
                        for (Item item : value3) {
                            list.add(item.toString().replaceAll("[\"()]", ""));
                        }
                    } else {
                        list.add(value.toString());
                    }
                }
                for (String s : list) {
                    if (!sb.isEmpty()) {
                        sb.append(',');
                    }
                    sb.append((String)name).append('=').append(s.replace(",", ",,"));
                }
            }
        });
        return sb.toString();
    }

    public static String assign(Option<?> option, String value, int index, Consumer<Object> assign, Options options) {
        String name = option.name();
        if (option instanceof BooleanOption) {
            Boolean v;
            BooleanOption bo = (BooleanOption)option;
            if (value.isEmpty() && options != null) {
                v = options.get(bo);
                if (v != null) {
                    v = v == false;
                }
            } else {
                v = Strings.toBoolean(value);
            }
            if (v == null) {
                return Util.info("Invalid '%' value '%'; expected: 'yes', 'no', or boolean.", name, value);
            }
            assign.accept(v);
        } else if (option instanceof NumberOption) {
            int v = Strings.toInt(value);
            if (v == Integer.MIN_VALUE) {
                return Util.info("Invalid '%' value '%'; expected: number.", name, value);
            }
            assign.accept(v);
        } else if (option instanceof StringOption) {
            assign.accept(value);
        } else if (option instanceof ValueOption) {
            Boolean b = Strings.toBoolean(value);
            assign.accept(b != null ? Bln.get(b) : Str.get(value));
        } else if (option instanceof EnumOption) {
            EnumOption eo = (EnumOption)option;
            Object v = eo.get(Options.normalize(value));
            if (v == null) {
                return Options.allowed(eo, value, eo.values());
            }
            assign.accept(v);
        } else if (option instanceof OptionsOption) {
            OptionsOption oo = (OptionsOption)option;
            Object o = oo.newInstance();
            try {
                ((Options)o).assign(value);
            }
            catch (BaseXException ex) {
                return Util.message(ex);
            }
            assign.accept(o);
        } else if (option instanceof NumbersOption && options != null) {
            int v = Strings.toInt(value);
            if (v == Integer.MIN_VALUE) {
                return Util.info("Invalid '%' value '%'; expected: number.", name, value);
            }
            int[] ii = (int[])options.get(option);
            if (index == -1) {
                if (ii == null) {
                    ii = new int[]{};
                }
                IntList il = new IntList(ii.length + 1);
                for (int i : ii) {
                    il.add(i);
                }
                assign.accept(il.add(v).finish());
            } else {
                if (index < 0 || index >= ii.length) {
                    return Util.info("List counter for '%' is invalid.", name);
                }
                ii[index] = v;
            }
        } else if (option instanceof StringsOption && options != null) {
            String[] ss = (String[])options.get(option);
            if (index == -1) {
                if (ss == null) {
                    ss = new String[]{};
                }
                StringList sl = new StringList(ss.length + 1);
                for (String s : ss) {
                    sl.add(s);
                }
                assign.accept(((StringList)((Object)sl.add(value))).finish());
            } else if (index == 0) {
                int i = Strings.toInt(value);
                if (i < 0) {
                    return Util.info("Invalid '%' value '%'; expected: number.", name, value);
                }
                options.values.put(name, new String[i]);
            } else {
                if (index <= 0 || index > ss.length) {
                    return Util.info("List counter for '%' is invalid.", name);
                }
                ss[index - 1] = value;
            }
        } else {
            throw Util.notExpected("Unsupported option (%): %", Util.className(option), option);
        }
        return null;
    }

    public static String allowed(Option<?> option, String value, Object ... all) {
        TokenBuilder vals = new TokenBuilder();
        for (Object a : all) {
            if (!vals.isEmpty()) {
                vals.add(44);
            }
            vals.add(a);
        }
        return Util.info("Invalid '%' value '%'; expected: one of %.", option.name(), value, vals);
    }

    private static Option<?>[] options(Class<? extends Options> clz) throws IllegalAccessException {
        ArrayList<Option> options = new ArrayList<Option>();
        for (Field f : clz.getFields()) {
            Object object;
            if (!Modifier.isStatic(f.getModifiers()) || !((object = f.get(null)) instanceof Option)) continue;
            Option opt = (Option)object;
            options.add(opt);
        }
        return (Option[])options.toArray(Option[]::new);
    }

    private synchronized void read(IOFile io) {
        this.file = io;
        StringList read = new StringList();
        StringList errs = new StringList();
        boolean exists = this.file.exists();
        if (exists) {
            try (NewlineInput ni = new NewlineInput(io);){
                String line;
                boolean local = false;
                while ((line = ni.readLine()) != null) {
                    if ((line = line.trim()).equals(PROPUSER)) {
                        local = true;
                        continue;
                    }
                    if (local) {
                        this.user.add(line);
                    }
                    if (line.isEmpty() || line.charAt(0) == '#') continue;
                    int d = line.indexOf(61);
                    if (d < 0) {
                        errs.add("line \"" + line + "\" ignored.");
                        continue;
                    }
                    String val = line.substring(d + 1).trim();
                    String name = line.substring(0, d).trim();
                    int num = 0;
                    int ss = name.length();
                    for (int s = 0; s < ss; ++s) {
                        if (!Character.isDigit(name.charAt(s))) continue;
                        num = Strings.toInt(name.substring(s));
                        name = name.substring(0, s);
                        break;
                    }
                    if (local) {
                        Prop.put("org.basex." + name.toLowerCase(Locale.ENGLISH), val);
                        continue;
                    }
                    try {
                        this.assign(name, val, num, true);
                        read.add(name);
                    }
                    catch (BaseXException ex) {
                        errs.add(ex.getMessage());
                    }
                }
            }
            catch (IOException ex) {
                errs.add("file could not be parsed.");
                Util.errln(ex, new Object[0]);
            }
        }
        boolean ok = true;
        if (errs.isEmpty()) {
            try {
                for (Option<?> opt : Options.options(this.getClass())) {
                    if (!ok || opt instanceof Comment) continue;
                    ok = read.contains(opt.name());
                }
            }
            catch (IllegalAccessException ex) {
                throw Util.notExpected(ex, new Object[0]);
            }
        }
        if (!(ok && exists && errs.isEmpty())) {
            this.write();
            errs.add("writing new configuration file.");
            for (String s : errs) {
                Util.errln(String.valueOf(this.file) + ": " + s, new Object[0]);
            }
        }
    }

    private synchronized void assign(String name, Value value, InputInfo info) throws QueryException {
        Option<?> option = this.definitions.get(name);
        if (option == null) {
            if (this.getClass() == Options.class || name.startsWith("Q{")) {
                return;
            }
            throw QueryError.INVALIDOPTION_X.get(info, this.similar(name));
        }
        Item item = value.size() == 1L ? (Item)value : null;
        SeqType st = value.seqType();
        QueryFunction<Object, QueryException> expected = type -> QueryError.INVALIDOPTION_X_X_X_X.get(info, name, type, st, value);
        Object result = null;
        if (option instanceof ValueOption) {
            ValueOption vo = (ValueOption)option;
            SeqType est = vo.seqType();
            if (!st.instanceOf(est)) {
                throw expected.apply(est);
            }
            result = value;
        } else if (option instanceof BooleanOption) {
            Boolean b;
            Boolean bl = b = item != null ? Strings.toBoolean(Token.string(item.string(info))) : null;
            if (b == null) {
                throw expected.apply(AtomType.BOOLEAN);
            }
            result = b;
        } else if (option instanceof NumberOption) {
            if (item == null) {
                throw expected.apply(AtomType.INTEGER);
            }
            result = (int)item.itr(info);
        } else if (option instanceof StringOption) {
            result = Options.serialize(value, info);
        } else if (option instanceof StringsOption) {
            StringList list = new StringList();
            for (Item it : value) {
                list.add(Options.serialize(it, info));
            }
            result = list.finish();
        } else if (option instanceof NumbersOption) {
            IntList list = new IntList();
            for (Item it : value) {
                list.add(Strings.toInt(Token.string(it.string(info))));
            }
            result = list.finish();
        } else if (option instanceof EnumOption) {
            EnumOption eo = (EnumOption)option;
            String string = Options.normalize(Options.serialize(value, info));
            result = eo.get(string);
            if (result == null) {
                throw QueryError.INVALIDOPTION_X.get(info, Options.allowed(eo, string, eo.values()));
            }
        } else if (option instanceof OptionsOption) {
            OptionsOption oo = (OptionsOption)option;
            if (!(item instanceof XQMap)) {
                throw expected.apply(Types.MAP);
            }
            XQMap map = (XQMap)item;
            result = oo.newInstance();
            ((Options)result).assign(map, info);
        }
        this.put(option, result);
    }

    private static synchronized String normalize(String value) {
        String v = value.trim();
        if (v.isEmpty()) {
            return YesNoOmit.OMIT.toString();
        }
        Boolean b = Strings.toBoolean(v);
        return b == Boolean.TRUE ? "yes" : (b == Boolean.FALSE ? "no" : v);
    }

    private synchronized boolean assign(String name, String value, int index, boolean error) throws BaseXException {
        Option<?> option = this.definitions.get(name);
        if (option == null) {
            if (error) {
                throw new BaseXException(this.similar(name), new Object[0]);
            }
            return false;
        }
        String err = Options.assign(option, value, index, v -> this.put(option, v), this);
        if (error && err != null) {
            throw new BaseXException(err, new Object[0]);
        }
        return true;
    }

    private static Map<String, String> toMap(String string) {
        HashMap<String, String> map = new HashMap<String, String>();
        StringBuilder key = new StringBuilder();
        StringBuilder value = new StringBuilder();
        Runnable add = () -> map.put(key.toString().trim(), value.toString());
        boolean left = true;
        int sl = string.length();
        for (int s = 0; s < sl; ++s) {
            char ch = string.charAt(s);
            if (left) {
                if (ch == '=') {
                    left = false;
                    continue;
                }
                key.append(ch);
                continue;
            }
            if (ch == ',') {
                if (s + 1 == sl || string.charAt(s + 1) != ',') {
                    add.run();
                    key.setLength(0);
                    value.setLength(0);
                    left = true;
                    continue;
                }
                ++s;
            }
            value.append(ch);
        }
        if (!left) {
            add.run();
        }
        return map;
    }

    public static enum YesNoOmit {
        YES,
        NO,
        OMIT;


        public String toString() {
            return Enums.string(this);
        }
    }

    public static enum YesNo {
        YES,
        NO;


        public String toString() {
            return Enums.string(this);
        }
    }
}

