/*
 * Decompiled with CFR 0.152.
 */
package org.intabulas.sandler;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.intabulas.sandler.builders.SyndicationBuilder;
import org.intabulas.sandler.builders.XPPBuilder;
import org.intabulas.sandler.elements.Entry;
import org.intabulas.sandler.elements.Feed;
import org.intabulas.sandler.exceptions.MarshallException;
import org.intabulas.sandler.serialization.SandlerSerializer;
import org.intabulas.sandler.serialization.SerializationException;

public class Sandler {
    private static final String DEFAULT_SERIALIZER = "org.intabulas.sandler.serialization.StringSerializer";

    private Sandler() {
    }

    public static Feed unmarshallFeed(String feed, SyndicationBuilder builder) {
        return Sandler.unmarshallFeed(new ByteArrayInputStream(feed.getBytes()), builder);
    }

    public static Feed unmarshallFeed(String feed) {
        return Sandler.unmarshallFeed(new ByteArrayInputStream(feed.getBytes()), (SyndicationBuilder)new XPPBuilder());
    }

    public static Feed unmarshallFeed(InputStream stream, SyndicationBuilder builder) {
        Feed result = null;
        result = builder.parseInput(stream);
        return result;
    }

    public static Feed unmarshallFeed(InputStream stream, SyndicationBuilder builder, String encoding) {
        Feed result = null;
        result = builder.parseInput(stream, encoding);
        return result;
    }

    public static Entry unmarshallEntry(String entry) {
        return Sandler.unmarshallEntry(new ByteArrayInputStream(entry.getBytes()), (SyndicationBuilder)new XPPBuilder());
    }

    public static Entry unmarshallEntry(String entry, SyndicationBuilder builder) {
        return Sandler.unmarshallEntry(new ByteArrayInputStream(entry.getBytes()), builder);
    }

    public static Entry unmarshallEntry(InputStream stream, SyndicationBuilder builder) {
        Entry result = null;
        result = builder.parseEntryInput(stream);
        return result;
    }

    public static Entry unmarshallEntry(InputStream stream, SyndicationBuilder builder, String encoding) {
        Entry result = null;
        result = builder.parseEntryInput(stream, encoding);
        return result;
    }

    public static String marshallEntry(Entry entry, boolean isDocument) throws MarshallException, SerializationException {
        SandlerSerializer serializer = Sandler.getDefaultSerializer();
        Sandler.marshallEntry(entry, serializer, isDocument);
        return serializer.toString();
    }

    public static String marshallEntry(Entry entry) throws MarshallException, SerializationException {
        SandlerSerializer serializer = Sandler.getDefaultSerializer();
        Sandler.marshallEntry(entry, serializer);
        return serializer.toString();
    }

    public static void marshallEntry(Entry entry, SandlerSerializer serializer) throws SerializationException {
        Sandler.marshallEntry(entry, serializer, true);
    }

    public static void marshallEntry(Entry entry, SandlerSerializer serializer, boolean isDocument) throws SerializationException {
        if (serializer != null) {
            serializer.serialize(entry, isDocument);
        }
    }

    public static String marshallFeed(Feed feed) throws MarshallException, SerializationException {
        SandlerSerializer serializer = Sandler.getDefaultSerializer();
        Sandler.marshallFeed(feed, serializer);
        return serializer.toString();
    }

    public static void marshallFeed(Feed feed, SandlerSerializer serializer) throws SerializationException {
        if (serializer != null) {
            serializer.serialize(feed);
        }
    }

    private static SandlerSerializer getDefaultSerializer() throws MarshallException {
        SandlerSerializer serializer = null;
        try {
            Class<?> clazz = Class.forName(DEFAULT_SERIALIZER);
            serializer = (SandlerSerializer)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new MarshallException("Unable to locate serializer: org.intabulas.sandler.serialization.StringSerializer", e);
        }
        catch (InstantiationException e) {
            throw new MarshallException("Unable to instantiate serializer: org.intabulas.sandler.serialization.StringSerializer", e);
        }
        catch (IllegalAccessException e) {
            throw new MarshallException("Unable to locate serializer: org.intabulas.sandler.serialization.StringSerializer", e);
        }
        return serializer;
    }
}

