/*
 * Decompiled with CFR 0.152.
 */
package org.intabulas.sandler.discovery;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.intabulas.sandler.elements.AtomElement;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

public class LinkTagParser
implements AtomElement {
    private Logger _logger = Logger.getLogger((class$org$intabulas$sandler$discovery$LinkTagParser == null ? (class$org$intabulas$sandler$discovery$LinkTagParser = LinkTagParser.class$("org.intabulas.sandler.discovery.LinkTagParser")) : class$org$intabulas$sandler$discovery$LinkTagParser).getName());
    private String _type = null;
    private String _feedUrl = null;
    static /* synthetic */ Class class$org$intabulas$sandler$discovery$LinkTagParser;

    public LinkTagParser(String type) {
        this._type = type;
    }

    public String parseInput(InputStream in) throws XmlPullParserException, IOException {
        XmlPullParser parser = this.getXPPInstance(in);
        this.loadDocument(parser);
        return this._feedUrl;
    }

    public void loadDocument(XmlPullParser parser) throws XmlPullParserException, IOException {
        int eventType = parser.getEventType();
        do {
            if (eventType == 2 && parser.getName().equalsIgnoreCase("link")) {
                this.processDocumentAttributes(parser);
                if (this._feedUrl != null) break;
            }
            try {
                eventType = parser.next();
            }
            catch (XmlPullParserException e) {
                this._logger.log(Level.SEVERE, "Unable to load document", e);
                throw e;
            }
            catch (IOException e) {
                this._logger.log(Level.SEVERE, "Unable to load document", e);
                throw e;
            }
        } while (eventType != 1);
    }

    private void processDocumentAttributes(XmlPullParser parser) {
        boolean hasAtomType = false;
        String result = null;
        int attributeCount = parser.getAttributeCount();
        for (int x = 0; x < attributeCount; ++x) {
            if (parser.getAttributeName(x).equals("type")) {
                String type = parser.getAttributeValue(x);
                hasAtomType = "application/atom+xml".equals(type);
            }
            if (!parser.getAttributeName(x).equals("href")) continue;
            result = parser.getAttributeValue(x);
        }
        if (hasAtomType && result != null) {
            this._feedUrl = result;
        }
    }

    private XmlPullParser getXPPInstance(InputStream in) throws XmlPullParserException {
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance(System.getProperty("org.xmlpull.v1.XmlPullParserFactory"), null);
        factory.setNamespaceAware(true);
        XmlPullParser parser = factory.newPullParser();
        parser.setInput(new InputStreamReader(in));
        return parser;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

