/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast;

import groovy.lang.CompilerConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ModuleNode;

public class CompileUnit {
    private List modules = new ArrayList();
    private Map classes = new HashMap();
    private CompilerConfig config;
    private ClassLoader classLoader;

    public CompileUnit(ClassLoader classLoader, CompilerConfig config) {
        this.classLoader = classLoader;
        this.config = config;
    }

    public List getModules() {
        return this.modules;
    }

    public void addModule(ModuleNode node) {
        this.modules.add(node);
        node.setUnit(this);
        node.addClasses(this.classes);
    }

    public ClassNode getClass(String name) {
        return (ClassNode)this.classes.get(name);
    }

    public List getClasses() {
        ArrayList answer = new ArrayList();
        Iterator iter = this.modules.iterator();
        while (iter.hasNext()) {
            ModuleNode module = (ModuleNode)iter.next();
            answer.addAll(module.getClasses());
        }
        return answer;
    }

    public CompilerConfig getConfig() {
        return this.config;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public Class loadClass(String type) throws ClassNotFoundException {
        try {
            return this.getClassLoader().loadClass(type);
        }
        catch (ClassNotFoundException e) {
            try {
                return this.getClass().getClassLoader().loadClass(type);
            }
            catch (ClassNotFoundException e2) {
                try {
                    return Class.forName(type);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw e;
                }
            }
        }
    }
}

