/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.expr;

import org.codehaus.groovy.ast.GroovyCodeVisitor;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ExpressionTransformer;

public class PropertyExpression
extends Expression {
    private Expression objectExpression;
    private String property;
    private boolean safe;

    public PropertyExpression(Expression objectExpression, String property) {
        this(objectExpression, property, false);
    }

    public PropertyExpression(Expression objectExpression, String property, boolean safe) {
        this.objectExpression = objectExpression;
        this.property = property;
        this.safe = safe;
    }

    public void visit(GroovyCodeVisitor visitor) {
        visitor.visitPropertyExpression(this);
    }

    public Expression transformExpression(ExpressionTransformer transformer) {
        return this;
    }

    public Expression getObjectExpression() {
        return this.objectExpression;
    }

    public String getProperty() {
        return this.property;
    }

    public String getText() {
        return this.objectExpression.getText() + "." + this.property;
    }

    public boolean isSafe() {
        return this.safe;
    }

    public String toString() {
        return super.toString() + "[object: " + this.objectExpression + " property: " + this.property + "]";
    }
}

