/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.syntax.lexer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.codehaus.groovy.syntax.ReadException;
import org.codehaus.groovy.syntax.lexer.CharStream;
import org.codehaus.groovy.syntax.lexer.InputStreamCharStream;

public class FileCharStream
implements CharStream {
    private File file;
    private CharStream charStream;

    public FileCharStream(File file) {
        this.file = file;
    }

    public File getFile() {
        return this.file;
    }

    protected CharStream getCharStream() throws ReadException {
        try {
            if (this.charStream == null) {
                this.charStream = new InputStreamCharStream(new FileInputStream(this.getFile()));
            }
        }
        catch (IOException e) {
            throw new ReadException(e);
        }
        return this.charStream;
    }

    public String getDescription() {
        return this.getFile().getPath();
    }

    public char consume() throws ReadException {
        return this.getCharStream().consume();
    }

    public void close() throws ReadException {
        this.getCharStream().close();
    }
}

