/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.syntax.parser;

import java.util.Iterator;
import org.codehaus.groovy.syntax.ReadException;
import org.codehaus.groovy.syntax.SyntaxException;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.syntax.TokenStream;
import org.codehaus.groovy.syntax.lexer.Lexer;
import org.codehaus.groovy.syntax.lexer.LexerTokenStream;
import org.codehaus.groovy.syntax.lexer.StringCharStream;
import org.codehaus.groovy.syntax.parser.CSTNode;
import org.codehaus.groovy.syntax.parser.ParserException;
import org.codehaus.groovy.syntax.parser.UnexpectedTokenException;
import org.codehaus.groovy.tools.ExceptionCollector;

public class Parser {
    private TokenStream tokenStream = null;
    private ExceptionCollector collector = null;
    protected static final int[] TYPE_DEFINERS = new int[]{506, 521};
    protected static final int[] STATEMENT_TERMINATORS = new int[]{301, 5, 20};
    protected static final int[] GENERAL_CLAUSE_TERMINATOR = new int[]{60};
    protected static final int[] PARAMETER_TERMINATORS = new int[]{60, 295};
    protected static final int[] ARRAY_ITEM_TERMINATORS = new int[]{40, 295};
    protected static final int[] EXTENDS_CLAUSE_TERMINATORS = new int[]{518, 10};
    protected static final int[] IMPLEMENTS_CLAUSE_TERMINATORS = new int[]{10};
    protected static final int[] THROWS_CLAUSE_TERMINATORS = new int[]{10};
    public static final int[] OPTIONAL_DATATYPE_FOLLOWER = new int[]{340, 30, 70};
    public static final int[] SWITCH_STATEMENT_BLOCK_TERMINATORS = new int[]{20, 504, 509};

    public Parser(TokenStream tokenStream) {
        this.tokenStream = tokenStream;
        this.collector = new ExceptionCollector(1);
    }

    public Parser(TokenStream tokenStream, ExceptionCollector collector) {
        this.tokenStream = tokenStream;
        this.collector = collector;
    }

    public static Parser create(String text, int errorTolerance) {
        ExceptionCollector collector = new ExceptionCollector(errorTolerance);
        Lexer lexer = new Lexer(new StringCharStream(text));
        LexerTokenStream stream = new LexerTokenStream(lexer);
        Parser parser = new Parser(stream, collector);
        return parser;
    }

    public TokenStream getTokenStream() {
        return this.tokenStream;
    }

    public void optionalNewlines() throws ReadException, SyntaxException {
        while (this.lt_bare() == 5) {
            this.consume_bare(this.lt_bare());
        }
    }

    public void endOfStatement(boolean allowRightCurlyBrace) throws ReadException, SyntaxException {
        int lt_bare = this.lt_bare();
        if (lt_bare == 301 || lt_bare == 5) {
            this.consume_bare(lt_bare);
        } else if (allowRightCurlyBrace) {
            if (lt_bare != -1 && lt_bare != 20) {
                this.throwExpected(new int[]{301, 5, 20});
            }
        } else if (lt_bare != -1) {
            this.throwExpected(new int[]{301, 5});
        }
    }

    public void endOfStatement() throws ReadException, SyntaxException {
        this.endOfStatement(true);
    }

    public void recover(int[] safe, boolean useBare) throws ReadException, SyntaxException {
        Token leading = useBare ? this.la_bare() : this.la();
        while ((useBare ? this.lt_bare() : this.lt()) != -1 && !(useBare ? this.la_bare() : this.la()).isA(safe)) {
            if (useBare) {
                this.consume_bare(this.lt_bare());
                continue;
            }
            this.consume(this.lt());
        }
        if ((useBare ? this.la_bare() : this.la()) == leading) {
            if (useBare) {
                this.consume_bare(this.lt_bare());
            } else {
                this.consume(this.lt());
            }
        }
    }

    public void recover(int[] safe) throws ReadException, SyntaxException {
        this.recover(safe, false);
    }

    public void recover() throws ReadException, SyntaxException {
        this.recover(STATEMENT_TERMINATORS, true);
    }

    public CSTNode compilationUnit() throws ReadException, SyntaxException, ExceptionCollector, ExceptionCollector {
        CSTNode compilationUnit = new CSTNode();
        CSTNode packageDeclaration = null;
        if (this.lt() == 524) {
            try {
                packageDeclaration = this.packageDeclaration();
            }
            catch (SyntaxException e) {
                this.collector.add(e);
                this.recover();
            }
        }
        if (packageDeclaration == null) {
            packageDeclaration = new CSTNode(Token.keyword(-1, -1, "package"));
            packageDeclaration.addChild(new CSTNode());
        }
        compilationUnit.addChild(packageDeclaration);
        CSTNode imports = new CSTNode();
        compilationUnit.addChild(imports);
        while (this.lt() == 519) {
            try {
                imports.addChild(this.importStatement());
            }
            catch (SyntaxException e) {
                this.collector.add(e);
                this.recover();
            }
        }
        while (this.lt() != -1) {
            try {
                compilationUnit.addChild(this.topLevelStatement());
            }
            catch (SyntaxException e) {
                this.collector.add(e);
                this.recover();
            }
        }
        return compilationUnit;
    }

    public CSTNode packageDeclaration() throws ReadException, SyntaxException, ExceptionCollector {
        CSTNode packageDeclaration = this.rootNode(524);
        CSTNode cur = this.rootNode(340);
        while (this.lt() == 70) {
            CSTNode dot = this.rootNode(70, cur);
            this.consume(dot, 340);
            cur = dot;
        }
        this.endOfStatement(false);
        packageDeclaration.addChild(cur);
        return packageDeclaration;
    }

    public CSTNode importStatement() throws ReadException, SyntaxException, ExceptionCollector {
        CSTNode importStatement = this.rootNode(519);
        CSTNode packageNode = null;
        if (this.lt(2) == 70) {
            packageNode = this.rootNode(340);
            while (this.lt(3) == 70) {
                packageNode = this.rootNode(70, packageNode);
                packageNode.addChild(this.rootNode(340));
            }
            this.consume(70);
        }
        if (packageNode == null) {
            packageNode = new CSTNode();
        }
        importStatement.addChild(packageNode);
        if (!packageNode.isEmpty() && this.lt() == 280) {
            importStatement.addChild(this.rootNode(280));
        } else {
            boolean done = false;
            while (!done) {
                CSTNode clause = this.rootNode(340);
                if (this.lt() == 502) {
                    this.consume(502);
                    clause.addChild(this.rootNode(340));
                }
                importStatement.addChild(clause);
                if (this.lt() == 295) {
                    this.consume(295);
                    continue;
                }
                done = true;
            }
        }
        this.endOfStatement(false);
        return importStatement;
    }

    public CSTNode topLevelStatement() throws ReadException, SyntaxException, ExceptionCollector {
        CSTNode result = null;
        if (this.lt() == 560) {
            this.consume(this.lt());
            CSTNode modifiers = this.modifierList(false, false);
            CSTNode type = this.optionalDatatype(false, true);
            CSTNode identifier = this.nameDeclaration(false);
            result = this.methodDeclaration(modifiers, type, identifier, false);
        } else if (this.lt() == 532 && this.lt(2) == 50) {
            result = this.synchronizedStatement();
        } else if (this.lt() != -1 && (this.la().isModifier() || this.lt() == 506 || this.lt() == 521)) {
            CSTNode modifiers = this.modifierList(true, true);
            switch (this.lt()) {
                case 506: {
                    result = this.classDeclaration(modifiers);
                    break;
                }
                case 521: {
                    result = this.interfaceDeclaration(modifiers);
                    break;
                }
                default: {
                    this.throwExpected(new int[]{506, 521});
                    break;
                }
            }
        } else {
            result = this.statement();
        }
        return result;
    }

    public CSTNode typeDeclaration() throws ReadException, SyntaxException, ExceptionCollector {
        return this.topLevelStatement();
    }

    public CSTNode modifierList(boolean allowStatic, boolean allowAbstract) throws ReadException, SyntaxException, ExceptionCollector {
        CSTNode modifiers = new CSTNode();
        while (this.lt() != -1 && this.la().isModifier()) {
            if (this.lt() == 501 && !allowAbstract) {
                this.collector.add(new ParserException("keyword 'abstract' not valid in this setting", this.la()));
            } else if (this.lt() == 529 && !allowStatic) {
                this.collector.add(new ParserException("keyword 'static' not valid in this setting", this.la()));
            }
            this.consume(modifiers, this.lt());
        }
        return modifiers;
    }

    public CSTNode classDeclaration(CSTNode modifiers) throws ReadException, SyntaxException, ExceptionCollector {
        CSTNode classDeclaration = this.rootNode(506);
        classDeclaration.addChild(modifiers);
        this.consume(classDeclaration, 340);
        try {
            CSTNode extendsNode = this.typeList(512, EXTENDS_CLAUSE_TERMINATORS, true, 1);
            classDeclaration.addChild(extendsNode);
        }
        catch (SyntaxException e) {
            this.collector.add(e);
            classDeclaration.addChild(new CSTNode());
        }
        try {
            CSTNode implementsNode = this.typeList(518, IMPLEMENTS_CLAUSE_TERMINATORS, true, 0);
            classDeclaration.addChild(implementsNode);
        }
        catch (SyntaxException e) {
            this.collector.add(e);
            classDeclaration.addChild(new CSTNode());
        }
        classDeclaration.addChild(this.typeBody(true, true, false));
        return classDeclaration;
    }

    public CSTNode interfaceDeclaration(CSTNode modifiers) throws ReadException, SyntaxException, ExceptionCollector {
        CSTNode interfaceDeclaration = this.rootNode(521);
        interfaceDeclaration.addChild(modifiers);
        this.consume(interfaceDeclaration, 340);
        interfaceDeclaration.addChild(new CSTNode());
        try {
            CSTNode extendsNode = this.typeList(512, IMPLEMENTS_CLAUSE_TERMINATORS, true, 0);
            interfaceDeclaration.addChild(extendsNode);
        }
        catch (SyntaxException e) {
            this.collector.add(e);
            interfaceDeclaration.addChild(new CSTNode());
        }
        interfaceDeclaration.addChild(this.typeBody(false, true, true));
        return interfaceDeclaration;
    }

    public CSTNode typeList(int declarator, int[] until, boolean optional, int limit) throws ReadException, SyntaxException, ExceptionCollector {
        CSTNode typeList = null;
        if (this.lt() == declarator) {
            typeList = this.rootNode(declarator);
            while (limit == 0 || typeList.children() < limit) {
                try {
                    if (typeList.children() > 0) {
                        this.consume(295);
                    }
                    CSTNode datatype = this.datatype(false);
                    typeList.addChild(datatype);
                }
                catch (SyntaxException e) {
                    this.collector.add(e);
                    if (limit > 0 && typeList.children() >= limit) {
                        this.recover(until);
                    }
                    int[] safe = new int[until.length + 1];
                    safe[0] = 295;
                    for (int i = 0; i < until.length; ++i) {
                        safe[i + 1] = until[i];
                    }
                    this.recover(safe);
                }
                if (this.lt() != -1 && !this.la().isA(until)) continue;
                break;
            }
        } else if (optional) {
            typeList = new CSTNode();
        } else {
            this.throwExpected(new int[]{declarator});
        }
        return typeList;
    }

    public CSTNode typeBody(boolean allowStatic, boolean allowAbstract, boolean requireAbstract) throws ReadException, SyntaxException, ExceptionCollector {
        CSTNode body = new CSTNode();
        this.consume(10);
        while (this.lt() != -1 && this.lt() != 20) {
            try {
                body.addChild(this.typeBodyStatement(allowStatic, allowAbstract, requireAbstract));
            }
            catch (SyntaxException e) {
                this.collector.add(e);
                this.recover();
            }
        }
        this.consume(20);
        return body;
    }

    public CSTNode typeBodyStatement(boolean allowStatic, boolean allowAbstract, boolean requireAbstract) throws ReadException, SyntaxException, ExceptionCollector {
        CSTNode statement = null;
        if (this.lt() == 529 && this.lt(2) == 10) {
            if (!allowStatic) {
                this.collector.add(new ParserException("static initializers not valid in this context", this.la()));
            }
            CSTNode modifiers = this.modifierList(true, false);
            CSTNode identifier = new CSTNode(Token.identifier(-1, -1, ""));
            statement = this.methodDeclaration(modifiers, new CSTNode(), identifier, false);
        } else {
            CSTNode modifiers = this.modifierList(allowStatic, allowAbstract);
            if (this.lt() == 506) {
                statement = this.classDeclaration(modifiers);
            } else if (this.lt() == 521) {
                statement = this.interfaceDeclaration(modifiers);
            } else {
                if (this.lt() == 538) {
                    this.consume(this.lt());
                }
                while (this.lt_bare() == 5) {
                    this.consume_bare(this.lt_bare());
                }
                CSTNode type = this.optionalDatatype(true, true);
                CSTNode identifier = this.nameDeclaration(true);
                switch (this.lt_bare()) {
                    case 50: {
                        boolean methodIsAbstract = requireAbstract;
                        if (!methodIsAbstract) {
                            Iterator iterator = modifiers.childIterator();
                            while (iterator.hasNext()) {
                                CSTNode child = (CSTNode)iterator.next();
                                if (child.getToken().getType() != 501) continue;
                                methodIsAbstract = true;
                                break;
                            }
                        }
                        statement = this.methodDeclaration(modifiers, type, identifier, methodIsAbstract);
                        break;
                    }
                    case -1: 
                    case 5: 
                    case 20: 
                    case 100: 
                    case 301: {
                        statement = this.propertyDeclaration(modifiers, type, identifier);
                        this.endOfStatement();
                        break;
                    }
                    default: {
                        this.throwExpected(new int[]{50, 100, 301, 5, 20});
                    }
                }
            }
        }
        return statement;
    }

    public CSTNode bodyStatement() throws ReadException, SyntaxException, ExceptionCollector {
        return this.typeBodyStatement(true, true, false);
    }

    protected CSTNode nameDeclaration(boolean useBare) throws ReadException, SyntaxException {
        if (useBare) {
            return new CSTNode(this.consume_bare(340));
        }
        return new CSTNode(this.consume(340));
    }

    protected CSTNode nameReference(boolean useBare) throws ReadException, SyntaxException {
        Token token;
        Token token2 = token = useBare ? this.la_bare() : this.la();
        if (token == null || !token.isValidNameReference()) {
            this.throwExpected(new int[]{340});
        }
        return new CSTNode(this.consume(this.lt()).toIdentifier());
    }

    protected CSTNode optionalDatatype(boolean useBare, boolean allowVoid) throws ReadException, SyntaxException, ExceptionCollector {
        Token la;
        CSTNode type = new CSTNode();
        Token token = la = useBare ? this.la_bare() : this.la();
        if (la != null) {
            if (la.isA(340)) {
                if (useBare) {
                    if (this.lt_bare(2) != -1 && this.la_bare(2).isA(OPTIONAL_DATATYPE_FOLLOWER)) {
                        type = this.datatype(allowVoid);
                    }
                } else if (this.lt(2) != -1 && this.la(2).isA(OPTIONAL_DATATYPE_FOLLOWER)) {
                    type = this.datatype(allowVoid);
                }
            } else if (la.isPrimitiveTypeKeyword(true)) {
                type = this.datatype(allowVoid);
            }
        }
        return type;
    }

    public CSTNode propertyDeclaration(CSTNode modifiers, CSTNode type, CSTNode identifier) throws ReadException, SyntaxException, ExceptionCollector {
        CSTNode property = new CSTNode(Token.keyword(-1, -1, "property"));
        property.addChild(modifiers);
        property.addChild(identifier);
        property.addChild(type);
        if (this.lt() == 100) {
            this.consume(this.lt());
            property.addChild(this.expression());
        }
        return property;
    }

    public CSTNode methodDeclaration(CSTNode modifiers, CSTNode type, CSTNode identifier, boolean emptyOnly) throws ReadException, SyntaxException, ExceptionCollector {
        CSTNode method = new CSTNode(Token.syntheticMethod());
        method.addChild(modifiers);
        method.addChild(identifier);
        method.addChild(type);
        Token label = this.consume(50);
        CSTNode parameters = this.parameterDeclarationList();
        parameters.setToken(label);
        method.addChild(parameters);
        this.consume(60);
        CSTNode throwsClause = new CSTNode();
        try {
            throwsClause = this.typeList(535, THROWS_CLAUSE_TERMINATORS, true, 0);
        }
        catch (SyntaxException e) {
            this.collector.add(e);
        }
        CSTNode body = null;
        if (emptyOnly) {
            if (this.lt() == 10) {
                this.collector.add(new ParserException("abstract and interface methods cannot have a body", this.la()));
            } else {
                body = new CSTNode();
                this.endOfStatement();
            }
        }
        if (body == null) {
            body = this.statementBody(true);
        }
        method.addChild(body);
        method.addChild(throwsClause);
        return method;
    }

    protected CSTNode parameterDeclarationList() throws ReadException, SyntaxException, ExceptionCollector {
        CSTNode list = new CSTNode();
        boolean expectDefaults = false;
        while (this.lt() != -1 && this.la().isIdentifierOrPrimitiveTypeKeyword()) {
            CSTNode parameter = this.parameterDeclaration();
            list.addChild(parameter);
            CSTNode value = new CSTNode();
            if (expectDefaults || this.lt() == 100) {
                expectDefaults = true;
                this.consume(100);
                value = this.expression();
            }
            parameter.addChild(value);
            if (this.lt() != 295) break;
            this.consume(295);
        }
        return list;
    }

    protected CSTNode parameterDeclaration() throws ReadException, SyntaxException, ExceptionCollector {
        CSTNode parameter = new CSTNode(Token.syntheticParameterDeclaration());
        parameter.addChild(this.optionalDatatype(false, false));
        parameter.addChild(this.nameDeclaration(false));
        return parameter;
    }

    protected CSTNode datatype(boolean allowVoid) throws ReadException, SyntaxException, ExceptionCollector {
        CSTNode datatype = this.scalarDatatype(allowVoid);
        while (this.lt_bare() == 30) {
            CSTNode array = this.rootNode(30, datatype);
            this.consume_bare(40);
            datatype = array;
        }
        return datatype;
    }

    protected CSTNode datatype() throws ReadException, SyntaxException, ExceptionCollector {
        return this.datatype(true);
    }

    protected CSTNode scalarDatatype(boolean allowVoid) throws ReadException, SyntaxException, ExceptionCollector {
        CSTNode datatype = null;
        if (this.lt() != -1 && this.la().isPrimitiveTypeKeyword(allowVoid)) {
            datatype = this.rootNode(this.lt());
        } else {
            datatype = this.rootNode(340);
            while (this.lt() == 70) {
                CSTNode dot = this.rootNode(70, datatype);
                this.consume(dot, 340);
                datatype = dot;
            }
        }
        return datatype;
    }

    protected CSTNode statementBody(boolean requireBraces) throws ReadException, SyntaxException, ExceptionCollector {
        CSTNode body = null;
        if (this.lt() == 10) {
            body = this.statementsUntilRightCurly(this.rootNode(10));
            body.getToken().setInterpretation(816);
            this.consume(20);
        } else if (requireBraces) {
            this.throwExpected(new int[]{10});
        } else {
            body = this.statement();
        }
        return body;
    }

    protected CSTNode statementsUntilRightCurly(CSTNode root) throws ReadException, SyntaxException, ExceptionCollector {
        while (this.lt() != 20) {
            try {
                root.addChild(this.statement());
            }
            catch (SyntaxException e) {
                this.collector.add(e);
                this.recover();
            }
        }
        return root;
    }

    protected CSTNode statement(boolean allowUnlabelledBlocks) throws ReadException, SyntaxException, ExceptionCollector {
        CSTNode statement = null;
        CSTNode label = null;
        if (this.lt() == 340 && this.lt(2) == 300) {
            label = this.rootNode(300, this.rootNode(this.lt()));
            label.getToken().setInterpretation(818);
        }
        switch (this.lt()) {
            case 515: {
                statement = this.forStatement();
                break;
            }
            case 537: {
                statement = this.whileStatement();
                break;
            }
            case 510: {
                statement = this.doWhileStatement();
                break;
            }
            case 508: {
                statement = this.continueStatement();
                break;
            }
            case 503: {
                statement = this.breakStatement();
                break;
            }
            case 517: {
                statement = this.ifStatement();
                break;
            }
            case 536: {
                statement = this.tryStatement();
                break;
            }
            case 534: {
                statement = this.throwStatement();
                break;
            }
            case 532: {
                statement = this.synchronizedStatement();
                break;
            }
            case 531: {
                statement = this.switchStatement();
                break;
            }
            case 528: {
                statement = this.returnStatement();
                break;
            }
            case 541: {
                statement = this.assertStatement();
                break;
            }
            case 301: {
                Token token = this.consume(this.lt());
                token.setInterpretation(816);
                statement = new CSTNode(token);
                break;
            }
            case 10: {
                statement = this.expression();
                if (statement.getToken().isA(10)) {
                    if (!statement.getChild(0).isEmpty()) break;
                    CSTNode block = new CSTNode(statement.getToken());
                    block.getToken().setInterpretation(816);
                    Iterator children = statement.getChild(1).childIterator();
                    while (children.hasNext()) {
                        block.addChild((CSTNode)children.next());
                    }
                    statement = block;
                    if (label != null || allowUnlabelledBlocks) break;
                    this.collector.add(new ParserException("groovy does not support anonymous blocks; please add a label", statement.getToken()));
                    break;
                }
                this.endOfStatement();
                break;
            }
            default: {
                try {
                    statement = this.expression();
                    this.endOfStatement();
                    break;
                }
                catch (SyntaxException e) {
                    this.collector.add(e);
                    this.recover();
                }
            }
        }
        if (label != null) {
            label.addChild(statement);
            statement = label;
        }
        return statement;
    }

    protected CSTNode statement() throws ReadException, SyntaxException, ExceptionCollector {
        return this.statement(false);
    }

    protected CSTNode switchStatement() throws ReadException, SyntaxException, ExceptionCollector {
        CSTNode statement = this.rootNode(531);
        this.consume(50);
        statement.addChild(this.expression());
        this.consume(60);
        this.consume(10);
        boolean defaultFound = false;
        while (this.lt() == 504 || this.lt() == 509) {
            CSTNode caseBlock = null;
            if (this.lt() == 504) {
                caseBlock = this.rootNode(504);
                caseBlock.addChild(this.expression());
            } else {
                if (defaultFound) {
                    this.collector.add(new ParserException("duplicate default entry in switch", this.la()));
                }
                caseBlock = this.rootNode(509);
                defaultFound = true;
            }
            this.consume(300);
            boolean first = true;
            while (this.lt() != -1 && !this.la().isA(SWITCH_STATEMENT_BLOCK_TERMINATORS)) {
                caseBlock.addChild(this.statement(first));
                first = false;
            }
            statement.addChild(caseBlock);
        }
        this.consume(20);
        return statement;
    }

    protected CSTNode breakStatement() throws ReadException, SyntaxException, ExceptionCollector {
        CSTNode statement = this.rootNode(503);
        if (this.lt() == 340) {
            statement.addChild(this.rootNode(this.lt()));
        }
        this.endOfStatement();
        return statement;
    }

    protected CSTNode continueStatement() throws ReadException, SyntaxException, ExceptionCollector {
        CSTNode statement = this.rootNode(508);
        if (this.lt() == 340) {
            statement.addChild(this.rootNode(this.lt()));
        }
        this.endOfStatement();
        return statement;
    }

    protected CSTNode throwStatement() throws ReadException, SyntaxException, ExceptionCollector {
        CSTNode statement = this.rootNode(534);
        statement.addChild(this.expression());
        this.endOfStatement();
        return statement;
    }

    protected CSTNode synchronizedStatement() throws ReadException, SyntaxException, ExceptionCollector {
        CSTNode statement = this.rootNode(532);
        this.consume(50);
        statement.addChild(this.expression());
        this.consume(60);
        statement.addChild(this.statementBody(true));
        return statement;
    }

    protected CSTNode ifStatement() throws ReadException, SyntaxException, ExceptionCollector {
        CSTNode statement = this.rootNode(517);
        this.consume(50);
        try {
            statement.addChild(this.expression());
        }
        catch (SyntaxException e) {
            this.collector.add(e);
            this.recover(GENERAL_CLAUSE_TERMINATOR);
        }
        this.consume(60);
        statement.addChild(this.statementBody(false));
        if (this.lt() == 511) {
            if (this.lt(2) == 517) {
                this.consume(511);
                statement.addChild(this.ifStatement());
            } else {
                CSTNode last = this.rootNode(511);
                statement.addChild(last);
                last.addChild(this.statementBody(false));
            }
        }
        return statement;
    }

    protected CSTNode tryStatement() throws ReadException, SyntaxException, ExceptionCollector {
        CSTNode statement = this.rootNode(536);
        statement.addChild(this.statementBody(true));
        CSTNode catches = new CSTNode();
        while (this.lt() == 505) {
            try {
                CSTNode catchBlock = this.rootNode(505);
                this.consume(50);
                try {
                    catchBlock.addChild(this.datatype(false));
                    this.consume(catchBlock, 340);
                }
                catch (SyntaxException e) {
                    this.collector.add(e);
                    this.recover(GENERAL_CLAUSE_TERMINATOR);
                }
                this.consume(60);
                catchBlock.addChild(this.statementBody(true));
                catches.addChild(catchBlock);
            }
            catch (SyntaxException e) {
                this.collector.add(e);
            }
        }
        if (this.lt() == 514) {
            this.consume(514);
            statement.addChild(this.statementBody(true));
        } else {
            statement.addChild(new CSTNode());
        }
        statement.addChild(catches);
        return statement;
    }

    protected CSTNode returnStatement() throws ReadException, SyntaxException, ExceptionCollector {
        CSTNode statement = this.rootNode(528);
        if (this.lt_bare() != -1 && !this.la_bare().isA(STATEMENT_TERMINATORS)) {
            statement.addChild(this.expression());
        }
        this.endOfStatement();
        return statement;
    }

    protected CSTNode whileStatement() throws ReadException, SyntaxException, ExceptionCollector {
        CSTNode statement = this.rootNode(537);
        this.consume(50);
        try {
            statement.addChild(this.expression());
        }
        catch (SyntaxException e) {
            this.collector.add(e);
            this.recover(GENERAL_CLAUSE_TERMINATOR);
        }
        this.consume(60);
        statement.addChild(this.statementBody(false));
        return statement;
    }

    protected CSTNode doWhileStatement() throws ReadException, SyntaxException, ExceptionCollector {
        CSTNode statement = this.rootNode(510);
        statement.addChild(this.statementBody(false));
        this.consume(537);
        this.consume(50);
        try {
            statement.addChild(this.expression());
        }
        catch (SyntaxException e) {
            this.collector.add(e);
            this.recover(GENERAL_CLAUSE_TERMINATOR);
        }
        this.consume(60);
        return statement;
    }

    protected CSTNode forStatement() throws ReadException, SyntaxException, ExceptionCollector {
        CSTNode statement = this.rootNode(515);
        this.consume(50);
        CSTNode identifierOrType = new CSTNode(this.consume(340));
        if (this.la_bare().getType() == 300) {
            this.consume(300);
        } else {
            Token potentialIn = this.consume(340);
            if (!potentialIn.getText().equals("in")) {
                if (this.la_bare().getType() == 300) {
                    this.consume(300);
                } else {
                    Token inToken = this.consume(340);
                    if (!inToken.getText().equals("in")) {
                        throw new UnexpectedTokenException(inToken, new int[]{300, 340});
                    }
                }
                CSTNode identifier = new CSTNode(potentialIn);
                identifier.addChild(identifierOrType);
                identifierOrType = identifier;
            }
        }
        statement.addChild(identifierOrType);
        CSTNode expr = this.expression();
        statement.addChild(expr);
        this.consume(60);
        statement.addChild(this.statementBody(false));
        return statement;
    }

    protected CSTNode assertStatement() throws ReadException, SyntaxException, ExceptionCollector {
        CSTNode statement = this.rootNode(541);
        statement.addChild(this.ternaryExpression());
        if (this.lt() == 300) {
            this.consume(300);
            statement.addChild(this.expression());
        } else {
            statement.addChild(new CSTNode());
        }
        this.endOfStatement();
        return statement;
    }

    protected CSTNode expression() throws ReadException, SyntaxException, ExceptionCollector {
        this.optionalNewlines();
        return this.assignmentExpression();
    }

    protected CSTNode assignmentExpression() throws ReadException, SyntaxException, ExceptionCollector {
        CSTNode expr = null;
        if (this.lt_bare() == 340 && this.lt_bare(2) == 340 && this.lt_bare(3) == 100) {
            CSTNode typeExpr = new CSTNode(this.consume_bare(this.lt_bare()));
            expr = new CSTNode(this.consume_bare(this.lt_bare()));
            expr.addChild(typeExpr);
        } else {
            expr = this.ternaryExpression();
        }
        switch (this.lt_bare()) {
            case 100: 
            case 200: 
            case 230: 
            case 250: 
            case 270: 
            case 290: {
                expr = this.rootNode(this.lt_bare(), expr);
                this.optionalNewlines();
                expr.addChild(this.ternaryExpression());
            }
        }
        return expr;
    }

    protected CSTNode ternaryExpression() throws ReadException, SyntaxException, ExceptionCollector {
        CSTNode expr = this.logicalOrExpression();
        if (this.lt_bare() == 310) {
            expr = this.rootNode(310, expr);
            this.optionalNewlines();
            expr.addChild(this.assignmentExpression());
            this.optionalNewlines();
            this.consume(300);
            this.optionalNewlines();
            expr.addChild(this.ternaryExpression());
        }
        return expr;
    }

    protected CSTNode logicalOrExpression() throws ReadException, SyntaxException, ExceptionCollector {
        CSTNode expr = this.logicalAndExpression();
        while (this.lt_bare() == 160) {
            expr = this.rootNode(160, expr);
            this.optionalNewlines();
            expr.addChild(this.logicalAndExpression());
        }
        return expr;
    }

    protected CSTNode logicalAndExpression() throws ReadException, SyntaxException, ExceptionCollector {
        CSTNode expr = this.equalityExpression();
        while (this.lt_bare() == 170) {
            expr = this.rootNode(170, expr);
            this.optionalNewlines();
            expr.addChild(this.equalityExpression());
        }
        return expr;
    }

    protected CSTNode equalityExpression() throws ReadException, SyntaxException, ExceptionCollector {
        CSTNode expr = this.relationalExpression();
        switch (this.lt_bare()) {
            case 90: 
            case 110: 
            case 115: {
                expr = this.rootNode(this.lt_bare(), expr);
                this.optionalNewlines();
                expr.addChild(this.relationalExpression());
            }
        }
        return expr;
    }

    protected CSTNode relationalExpression() throws ReadException, SyntaxException, ExceptionCollector {
        CSTNode expr = this.rangeExpression();
        switch (this.lt_bare()) {
            case 105: 
            case 106: 
            case 120: 
            case 130: 
            case 140: 
            case 150: 
            case 520: {
                expr = this.rootNode(this.lt_bare(), expr);
                this.optionalNewlines();
                expr.addChild(this.rangeExpression());
            }
        }
        return expr;
    }

    protected CSTNode rangeExpression() throws ReadException, SyntaxException, ExceptionCollector {
        CSTNode expr = this.additiveExpression();
        if (this.lt_bare() == 75) {
            expr = this.rootNode(75, expr);
            this.optionalNewlines();
            expr.addChild(this.additiveExpression());
        } else if (this.lt_bare() == 77) {
            expr = this.rootNode(77, expr);
            this.optionalNewlines();
            expr.addChild(this.additiveExpression());
        }
        return expr;
    }

    protected CSTNode additiveExpression() throws ReadException, SyntaxException, ExceptionCollector {
        CSTNode expr = this.multiplicativeExpression();
        block3: while (true) {
            switch (this.lt_bare()) {
                case 180: 
                case 210: 
                case 317: 
                case 318: {
                    expr = this.rootNode(this.lt_bare(), expr);
                    this.optionalNewlines();
                    expr.addChild(this.multiplicativeExpression());
                    continue block3;
                }
            }
            break;
        }
        return expr;
    }

    protected CSTNode multiplicativeExpression() throws ReadException, SyntaxException, ExceptionCollector {
        CSTNode expr = this.unaryExpression();
        block3: while (true) {
            switch (this.lt_bare()) {
                case 155: 
                case 240: 
                case 260: 
                case 280: {
                    expr = this.rootNode(this.lt_bare(), expr);
                    this.optionalNewlines();
                    expr.addChild(this.unaryExpression());
                    continue block3;
                }
            }
            break;
        }
        return expr;
    }

    protected CSTNode unaryExpression() throws ReadException, SyntaxException, ExceptionCollector {
        CSTNode expr = null;
        switch (this.lt_bare()) {
            case 80: 
            case 180: 
            case 210: {
                expr = this.rootNode(this.lt_bare());
                expr.addChild(this.postfixExpression());
                break;
            }
            case 190: 
            case 220: {
                expr = new CSTNode(Token.syntheticPrefix());
                CSTNode prefixExpr = this.rootNode(this.lt_bare());
                expr.addChild(prefixExpr);
                prefixExpr.addChild(this.primaryExpression());
                break;
            }
            default: {
                expr = this.postfixExpression();
            }
        }
        return expr;
    }

    protected CSTNode postfixExpression() throws ReadException, SyntaxException, ExceptionCollector {
        CSTNode expr = this.primaryExpression();
        Token laToken = this.la();
        if (laToken != null) {
            switch (laToken.getType()) {
                case 190: 
                case 220: {
                    CSTNode primaryExpr = expr;
                    expr = new CSTNode(Token.syntheticPostfix());
                    expr.addChild(this.rootNode(this.lt_bare(), primaryExpr));
                }
            }
        }
        return expr;
    }

    protected CSTNode primaryExpression() throws ReadException, SyntaxException, ExceptionCollector {
        CSTNode expr = null;
        CSTNode identifier = null;
        switch (this.lt_bare()) {
            case 539: 
            case 540: 
            case 542: {
                expr = this.rootNode(this.lt_bare());
                break;
            }
            case 523: {
                expr = this.newExpression();
                break;
            }
            case 50: {
                expr = this.parentheticalExpression();
                break;
            }
            case 330: 
            case 350: 
            case 351: {
                expr = this.rootNode(this.lt_bare());
                break;
            }
            case 320: {
                expr = this.doubleQuotedString();
                break;
            }
            case 30: {
                expr = this.listOrMapExpression();
                break;
            }
            case 10: {
                expr = this.closureExpression();
                break;
            }
            case 533: {
                expr = this.thisExpression();
                identifier = this.rootNode(this.lt_bare());
                break;
            }
            case 530: {
                expr = new CSTNode(Token.keyword(-1, -1, "super"));
                identifier = this.rootNode(this.lt_bare());
                break;
            }
            case 107: {
                expr = this.regexPattern();
                break;
            }
            default: {
                expr = identifier = this.nameReference(true);
            }
        }
        if (identifier != null) {
            if (this.lt_bare() == 50 || this.lt_bare() == 10) {
                if (expr == identifier) {
                    CSTNode replacementExpr = new CSTNode();
                    CSTNode resultExpr = this.sugaryMethodCallExpression(replacementExpr, identifier, null);
                    if (resultExpr != replacementExpr) {
                        expr = resultExpr;
                    }
                } else {
                    expr = this.sugaryMethodCallExpression(expr, identifier, null);
                }
            } else {
                CSTNode methodCall = this.tryParseMethodCallWithoutParenthesis(this.thisExpression(), identifier);
                if (methodCall != null) {
                    expr = methodCall;
                }
            }
        }
        while (this.lt_bare() == 30 || this.lookAheadForMethodCall()) {
            if (this.lt_bare() == 30) {
                expr = this.subscriptExpression(expr);
                continue;
            }
            expr = this.methodCallOrPropertyExpression(expr);
        }
        return expr;
    }

    protected CSTNode thisExpression() {
        return new CSTNode(Token.keyword(-1, -1, "this"));
    }

    protected CSTNode subscriptExpression(CSTNode expr) throws ReadException, SyntaxException, ExceptionCollector {
        expr = this.rootNode_bare(this.lt_bare(), expr);
        this.optionalNewlines();
        CSTNode rangeExpr = this.rangeExpression();
        if (this.lt_bare() != 295) {
            expr.addChild(rangeExpr);
        } else {
            this.consume_bare(295);
            CSTNode listExpr = new CSTNode(Token.syntheticList());
            expr.addChild(listExpr);
            listExpr.addChild(rangeExpr);
            while (true) {
                this.optionalNewlines();
                listExpr.addChild(this.rangeExpression());
                if (this.lt_bare() != 295) break;
                this.consume_bare(295);
            }
        }
        this.optionalNewlines();
        this.consume(40);
        return expr;
    }

    protected CSTNode methodCallOrPropertyExpression(CSTNode expr) throws ReadException, SyntaxException, ExceptionCollector {
        CSTNode dotExpr = this.rootNode_bare(this.lt_bare());
        CSTNode identifier = this.rootNode_bare(this.lt_bare());
        switch (this.lt_bare()) {
            case 10: 
            case 50: {
                expr = this.sugaryMethodCallExpression(expr, identifier, dotExpr);
                break;
            }
            default: {
                CSTNode methodCall = this.tryParseMethodCallWithoutParenthesis(expr, identifier);
                if (methodCall != null) {
                    expr = methodCall;
                    break;
                }
                dotExpr.addChild(expr);
                dotExpr.addChild(identifier);
                expr = dotExpr;
                break;
            }
        }
        return expr;
    }

    protected CSTNode sugaryMethodCallExpression(CSTNode expr, CSTNode identifier, CSTNode dotExpr) throws ReadException, SyntaxException, ExceptionCollector {
        CSTNode methodExpr = null;
        CSTNode paramList = null;
        if (this.lt_bare() == 50) {
            methodExpr = this.rootNode_bare(50);
            this.optionalNewlines();
            methodExpr.addChild(expr);
            methodExpr.addChild(identifier);
            paramList = this.parameterList(60);
            methodExpr.addChild(paramList);
            this.optionalNewlines();
            this.consume_bare(60);
        }
        if (this.lt_bare() == 10) {
            if (methodExpr == null) {
                methodExpr = new CSTNode(Token.leftParenthesis(-1, -1));
                methodExpr.addChild(expr);
                methodExpr.addChild(identifier);
                paramList = this.parameterList(10);
                methodExpr.addChild(paramList);
            }
            paramList.addChild(this.closureExpression());
        }
        if (methodExpr != null) {
            expr = methodExpr;
            if (dotExpr != null) {
                expr.addChild(dotExpr);
            }
        }
        return expr;
    }

    protected CSTNode tryParseMethodCallWithoutParenthesis(CSTNode expr, CSTNode identifier) throws SyntaxException, ReadException {
        switch (this.lt_bare()) {
            case 320: 
            case 330: 
            case 340: 
            case 350: 
            case 351: 
            case 523: {
                this.getTokenStream().checkpoint();
                try {
                    return this.methodCallWithoutParenthesis(expr, identifier);
                }
                catch (Exception e) {
                    this.getTokenStream().restore();
                }
            }
        }
        return null;
    }

    protected CSTNode methodCallWithoutParenthesis(CSTNode expr, CSTNode identifier) throws ReadException, SyntaxException, ExceptionCollector {
        CSTNode methodExpr = new CSTNode(Token.leftParenthesis(-1, -1));
        methodExpr.addChild(expr);
        methodExpr.addChild(identifier);
        CSTNode parameterList = new CSTNode(Token.syntheticList());
        parameterList.addChild(this.expression());
        while (this.lt_bare() == 295) {
            this.consume_bare(this.lt_bare());
            this.optionalNewlines();
            parameterList.addChild(this.expression());
        }
        methodExpr.addChild(parameterList);
        return methodExpr;
    }

    protected boolean lookAheadForMethodCall() throws ReadException, SyntaxException, ExceptionCollector {
        return (this.lt_bare() == 70 || this.lt_bare() == 158) && this.lt(2) != -1 && this.la(2).isValidNameReference();
    }

    protected CSTNode regexPattern() throws ReadException, SyntaxException, ExceptionCollector {
        Token token = this.consume(107);
        CSTNode expr = new CSTNode(token);
        CSTNode regexString = this.doubleQuotedString();
        expr.addChild(regexString);
        return expr;
    }

    protected CSTNode doubleQuotedString() throws ReadException, SyntaxException, ExceptionCollector {
        int exprStart;
        Token token = this.consume(320);
        String text = token.getText();
        CSTNode expr = new CSTNode(token);
        int textStart = 0;
        int cur = 0;
        int len = text.length();
        while (cur < len && (exprStart = text.indexOf("${", cur)) >= 0) {
            if (exprStart > 0 && text.charAt(exprStart - 1) == '$') {
                StringBuffer buf = new StringBuffer(text);
                buf.replace(exprStart - 1, exprStart, "");
                text = buf.toString();
                cur = exprStart + 1;
                continue;
            }
            expr.addChild(new CSTNode(Token.singleQuoteString(token.getStartLine(), token.getStartColumn() + cur + 1, text.substring(textStart, exprStart))));
            int exprEnd = text.indexOf("}", exprStart);
            String exprText = text.substring(exprStart + 2, exprEnd);
            StringCharStream exprStream = new StringCharStream(exprText);
            Lexer lexer = new Lexer(exprStream);
            Parser parser = new Parser(new LexerTokenStream(lexer));
            CSTNode embeddedExpr = parser.expression();
            expr.addChild(embeddedExpr);
            textStart = cur = exprEnd + 1;
        }
        if (textStart < len) {
            expr.addChild(new CSTNode(Token.singleQuoteString(token.getStartLine(), token.getStartColumn() + textStart + 1, text.substring(textStart))));
        }
        return expr;
    }

    protected CSTNode parentheticalExpression() throws ReadException, SyntaxException, ExceptionCollector {
        this.consume(50);
        if (this.lt_bare() == 340 && this.lt_bare(2) == 60) {
            boolean valid = true;
            switch (this.lt_bare(3)) {
                case -1: 
                case 5: 
                case 20: 
                case 301: {
                    valid = false;
                }
            }
            if (valid) {
                CSTNode castExpr = new CSTNode(Token.syntheticCast());
                castExpr.addChild(new CSTNode(this.consume_bare(this.lt_bare())));
                this.consume_bare(this.lt_bare());
                castExpr.addChild(this.expression());
                return castExpr;
            }
        }
        CSTNode expr = this.expression();
        this.consume(60);
        return expr;
    }

    protected CSTNode parameterList(int endOfListDemarc) throws ReadException, SyntaxException, ExceptionCollector {
        if (this.lt_bare() != -1 && this.la_bare().isValidNameReference() && this.lt_bare(2) == 300) {
            return this.namedParameterList(endOfListDemarc);
        }
        CSTNode parameterList = new CSTNode(Token.syntheticList());
        while (this.lt_bare() != endOfListDemarc) {
            parameterList.addChild(this.expression());
            if (this.lt_bare() != 295) break;
            this.consume_bare(295);
            this.optionalNewlines();
        }
        return parameterList;
    }

    protected CSTNode namedParameterList(int endOfListDemarc) throws ReadException, SyntaxException, ExceptionCollector {
        CSTNode parameterList = new CSTNode(Token.syntheticList());
        while (this.lt() != endOfListDemarc) {
            CSTNode name = this.nameReference(true);
            CSTNode namedParam = this.rootNode_bare(300, name);
            namedParam.addChild(this.expression());
            parameterList.addChild(namedParam);
            if (this.lt_bare() != 295) break;
            this.consume_bare(295);
            this.optionalNewlines();
        }
        return parameterList;
    }

    protected CSTNode newExpression() throws ReadException, SyntaxException, ExceptionCollector {
        CSTNode expr = this.rootNode(523);
        expr.addChild(this.scalarDatatype(false));
        if (this.lt_bare() == 50) {
            this.consume_bare(50);
            expr.addChild(this.parameterList(60));
            this.consume(60);
        } else if (this.lt_bare() == 10) {
            this.consume_bare(10);
            CSTNode paramList = this.parameterList(20);
            expr.addChild(paramList);
            paramList.addChild(this.closureExpression());
        } else if (this.lt_bare() == 30) {
            expr.addChild(new CSTNode(this.consume_bare(30)));
            if (this.lt_bare() == 40) {
                this.consume_bare(40);
                expr.addChild(new CSTNode(this.consume_bare(10)));
                CSTNode paramList = this.parameterList(20);
                this.consume(20);
                expr.addChild(paramList);
            } else {
                expr.addChild(this.expression());
                this.consume_bare(40);
            }
        }
        return expr;
    }

    protected CSTNode closureExpression() throws ReadException, SyntaxException, ExceptionCollector {
        return this.closureExpression(false);
    }

    protected CSTNode closureExpression(boolean pipeRequired) throws ReadException, SyntaxException, ExceptionCollector {
        CSTNode expr = this.rootNode(10);
        expr.getToken().setInterpretation(817);
        int value = this.lt(1);
        boolean canBeParamList = false;
        if (this.lt() != -1 && this.la().isIdentifierOrPrimitiveTypeKeyword()) {
            if (this.lt(2) != -1 && this.la(2).isIdentifierOrPrimitiveTypeKeyword()) {
                canBeParamList = this.lt(3) == 315 || this.lt(3) == 295;
            } else {
                boolean bl = canBeParamList = this.lt(2) == 315 || this.lt(2) == 295;
            }
        }
        if (canBeParamList) {
            expr.addChild(this.parameterDeclarationList());
            pipeRequired = true;
        } else {
            expr.addChild(new CSTNode());
        }
        CSTNode block = new CSTNode();
        if (this.lt_bare() != 20) {
            if (pipeRequired || this.lt() == 315) {
                this.consume(315);
            }
            this.statementsUntilRightCurly(block);
        }
        this.consume(20);
        expr.addChild(block);
        return expr;
    }

    protected CSTNode listOrMapExpression() throws ReadException, SyntaxException, ExceptionCollector {
        CSTNode expr = null;
        this.consume(30);
        if (this.lt() == 300) {
            this.consume(300);
            expr = new CSTNode(Token.syntheticMap());
        } else if (this.lt() == 40) {
            expr = new CSTNode(Token.syntheticList());
        } else {
            CSTNode firstExpr = this.expression();
            expr = this.lt() == 300 ? this.mapExpression(firstExpr) : this.listExpression(firstExpr);
        }
        this.consume(40);
        return expr;
    }

    protected CSTNode mapExpression(CSTNode key) throws ReadException, SyntaxException, ExceptionCollector {
        CSTNode expr = new CSTNode(Token.syntheticMap());
        CSTNode entry = this.rootNode(300, key);
        CSTNode value = this.expression();
        entry.addChild(value);
        expr.addChild(entry);
        while (this.lt() == 295) {
            this.consume(295);
            key = this.expression();
            entry = this.rootNode(300, key);
            entry.addChild(this.expression());
            expr.addChild(entry);
        }
        return expr;
    }

    protected CSTNode listExpression(CSTNode entry) throws ReadException, SyntaxException, ExceptionCollector {
        CSTNode expr = new CSTNode(Token.syntheticList());
        expr.addChild(entry);
        while (this.lt() == 295) {
            this.consume(295);
            entry = this.expression();
            expr.addChild(entry);
        }
        return expr;
    }

    protected CSTNode argumentList() throws ReadException, SyntaxException, ExceptionCollector {
        CSTNode argumentList = new CSTNode();
        while (this.lt() != 60) {
            argumentList.addChild(this.expression());
            if (this.lt() != 295) break;
            this.consume(295);
        }
        return argumentList;
    }

    protected void throwExpected(int[] expectedTypes) throws ReadException, SyntaxException {
        throw new UnexpectedTokenException(this.la(), expectedTypes);
    }

    protected Token require(Token token) throws ReadException, SyntaxException {
        if (token == null) {
            throw new ParserException("unexpected end of stream", null);
        }
        return token;
    }

    protected Token la() throws ReadException, SyntaxException {
        return this.la(1);
    }

    protected Token la(int k) throws ReadException, SyntaxException {
        Token token = null;
        int pivot = 1;
        int count = 0;
        while (count < k) {
            token = this.getTokenStream().la(pivot);
            if (token == null || token.getType() != 5) {
                ++count;
            }
            ++pivot;
        }
        return token;
    }

    protected int lt() throws ReadException, SyntaxException {
        return this.lt(1);
    }

    protected int lt(int k) throws ReadException, SyntaxException {
        Token token = this.la(k);
        if (token == null) {
            return -1;
        }
        return token.getType();
    }

    protected void consumeUntil(int type) throws ReadException, SyntaxException {
        boolean done = false;
        while (this.lt() != -1 && !done) {
            if (this.lt() == type) {
                done = true;
            }
            this.consume(this.lt());
        }
    }

    protected Token consume(int type) throws ReadException, SyntaxException {
        Token token;
        if (this.lt() != type) {
            throw new UnexpectedTokenException(this.la(), type);
        }
        while ((token = this.getTokenStream().la()) != null && token.getType() == 5) {
            this.getTokenStream().consume(5);
        }
        return this.getTokenStream().consume(type);
    }

    protected void consume(CSTNode root, int type) throws ReadException, SyntaxException {
        root.addChild(new CSTNode(this.consume(type)));
    }

    protected CSTNode rootNode(int type) throws ReadException, SyntaxException {
        return new CSTNode(this.consume(type));
    }

    protected CSTNode rootNode(int type, CSTNode child) throws ReadException, SyntaxException {
        CSTNode root = new CSTNode(this.consume(type));
        root.addChild(child);
        return root;
    }

    protected Token la_bare() throws ReadException, SyntaxException {
        return this.la_bare(1);
    }

    protected Token la_bare(int k) throws ReadException, SyntaxException {
        return this.getTokenStream().la(k);
    }

    protected int lt_bare() throws ReadException, SyntaxException {
        return this.lt_bare(1);
    }

    protected int lt_bare(int k) throws ReadException, SyntaxException {
        Token token = this.la_bare(k);
        if (token == null) {
            return -1;
        }
        return token.getType();
    }

    protected void consumeUntil_bare(int type) throws ReadException, SyntaxException {
        while (this.lt_bare() != -1) {
            this.consume_bare(this.lt_bare());
            if (this.lt_bare() != type) continue;
            this.consume(this.lt_bare());
            break;
        }
    }

    protected Token consume_bare(int type) throws ReadException, SyntaxException {
        if (this.lt_bare() != type) {
            throw new UnexpectedTokenException(this.la_bare(), type);
        }
        return this.getTokenStream().consume(type);
    }

    protected void consume_bare(CSTNode root, int type) throws ReadException, SyntaxException {
        root.addChild(new CSTNode(this.consume_bare(type)));
    }

    protected CSTNode rootNode_bare(int type) throws ReadException, SyntaxException {
        return new CSTNode(this.consume_bare(type));
    }

    protected CSTNode rootNode_bare(int type, CSTNode child) throws ReadException, SyntaxException {
        CSTNode root = new CSTNode(this.consume_bare(type));
        root.addChild(child);
        return root;
    }
}

