/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.tools;

import java.util.Iterator;
import java.util.LinkedHashMap;
import org.codehaus.groovy.GroovyException;
import org.codehaus.groovy.tools.ExceptionCollector;

public class CompilationFailuresException
extends GroovyException {
    private LinkedHashMap failures = new LinkedHashMap();

    public CompilationFailuresException() {
        super(true);
    }

    public void add(String source, ExceptionCollector exceptions) {
        if (this.failures.containsKey(source)) {
            try {
                ((ExceptionCollector)this.failures.get(source)).merge(exceptions, false);
            }
            catch (Exception exception) {}
        } else {
            this.failures.put(source, exceptions);
        }
    }

    public void merge(CompilationFailuresException other) {
        Iterator sources = other.iterator();
        while (sources.hasNext()) {
            String source = (String)sources.next();
            this.add(source, other.get(source));
        }
    }

    public boolean isEmpty() {
        return this.failures.isEmpty();
    }

    public int size() {
        return this.failures.size();
    }

    public int total() {
        int total = 0;
        Iterator sources = this.iterator();
        while (sources.hasNext()) {
            String source = (String)sources.next();
            ExceptionCollector collector = this.get(source);
            total += collector.size();
        }
        return total;
    }

    public Iterator iterator() {
        return this.failures.keySet().iterator();
    }

    public ExceptionCollector get(String source) {
        return (ExceptionCollector)this.failures.get(source);
    }

    public String getMessage() {
        if (this.failures.size() == 1) {
            return "failures in 1 source";
        }
        return "failures in " + this.failures.size() + " sources";
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        String endl = System.getProperty("line.separator", "\n");
        if (this.failures.size() == 1) {
            buffer.append("1 failure:");
        } else {
            buffer.append(this.failures.size()).append(" failures:");
        }
        buffer.append(endl);
        Iterator sources = this.iterator();
        while (sources.hasNext()) {
            String source = (String)sources.next();
            String message = this.get(source).getMessage();
            buffer.append("   ").append(source).append(": ").append(message).append(endl);
        }
        return buffer.toString();
    }
}

