/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.io.IOException;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.ldap.ber.stream.BERElement;
import netscape.ldap.ber.stream.BEROctetString;
import netscape.ldap.ber.stream.BERSequence;
import netscape.ldap.ber.stream.BERSet;

public class LDAPAttribute
implements Serializable {
    static final long serialVersionUID = -4594745735452202600L;
    private String name = null;
    private byte[] nameBuf = null;
    private Object[] values = new Object[0];

    public LDAPAttribute(LDAPAttribute lDAPAttribute) {
        this.name = lDAPAttribute.name;
        this.nameBuf = lDAPAttribute.nameBuf;
        this.values = new Object[lDAPAttribute.values.length];
        for (int i = 0; i < lDAPAttribute.values.length; ++i) {
            this.values[i] = new byte[((byte[])lDAPAttribute.values[i]).length];
            System.arraycopy((byte[])lDAPAttribute.values[i], 0, (byte[])this.values[i], 0, ((byte[])lDAPAttribute.values[i]).length);
        }
    }

    public LDAPAttribute(String string) {
        this.name = string;
    }

    public LDAPAttribute(String string, byte[] byArray) {
        this.name = string;
        this.addValue(byArray);
    }

    public LDAPAttribute(String string, String string2) {
        this.name = string;
        this.addValue(string2);
    }

    public LDAPAttribute(String string, String[] stringArray) {
        this.name = string;
        if (stringArray != null) {
            this.setValues(stringArray);
        }
    }

    public LDAPAttribute(BERElement bERElement) throws IOException {
        BERSequence bERSequence = (BERSequence)bERElement;
        BEROctetString bEROctetString = (BEROctetString)bERSequence.elementAt(0);
        this.nameBuf = bEROctetString.getValue();
        BERSet bERSet = (BERSet)bERSequence.elementAt(1);
        if (bERSet.size() > 0) {
            Object[] objectArray = new Object[bERSet.size()];
            for (int i = 0; i < bERSet.size(); ++i) {
                objectArray[i] = ((BEROctetString)bERSet.elementAt(i)).getValue();
                if (objectArray[i] != null) continue;
                objectArray[i] = new byte[0];
            }
            this.setValues(objectArray);
        }
    }

    public int size() {
        return this.values.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getStringValues() {
        Vector<String> vector = new Vector<String>();
        LDAPAttribute lDAPAttribute = this;
        synchronized (lDAPAttribute) {
            try {
                for (int i = 0; i < this.values.length; ++i) {
                    if (this.values[i] != null) {
                        vector.addElement(new String((byte[])this.values[i], "UTF8"));
                        continue;
                    }
                    vector.addElement(new String(""));
                }
            }
            catch (Exception exception) {
                return null;
            }
        }
        return vector.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getStringValueArray() {
        String[] stringArray = new String[this.values.length];
        LDAPAttribute lDAPAttribute = this;
        synchronized (lDAPAttribute) {
            try {
                for (int i = 0; i < this.values.length; ++i) {
                    stringArray[i] = this.values[i] != null ? new String((byte[])this.values[i], "UTF8") : new String("");
                }
            }
            catch (Exception exception) {
                return null;
            }
        }
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getByteValues() {
        Vector<Object> vector = new Vector<Object>();
        LDAPAttribute lDAPAttribute = this;
        synchronized (lDAPAttribute) {
            for (int i = 0; i < this.values.length; ++i) {
                if (this.values[i] != null) {
                    vector.addElement(this.values[i]);
                    continue;
                }
                vector.addElement(new byte[0]);
            }
        }
        return vector.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[][] getByteValueArray() {
        byte[][] byArrayArray = new byte[this.values.length][];
        LDAPAttribute lDAPAttribute = this;
        synchronized (lDAPAttribute) {
            try {
                for (int i = 0; i < this.values.length; ++i) {
                    byArrayArray[i] = new byte[((byte[])this.values[i]).length];
                    System.arraycopy((byte[])this.values[i], 0, byArrayArray[i], 0, ((byte[])this.values[i]).length);
                }
            }
            catch (Exception exception) {
                return null;
            }
        }
        return byArrayArray;
    }

    public String getName() {
        if (this.name == null && this.nameBuf != null) {
            try {
                this.name = new String(this.nameBuf, "UTF8");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.name;
    }

    public static String[] getSubtypes(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        if (stringTokenizer.hasMoreElements()) {
            stringTokenizer.nextElement();
            String[] stringArray = new String[stringTokenizer.countTokens()];
            int n = 0;
            while (stringTokenizer.hasMoreElements()) {
                stringArray[n++] = (String)stringTokenizer.nextElement();
            }
            return stringArray;
        }
        return null;
    }

    public String[] getSubtypes() {
        return LDAPAttribute.getSubtypes(this.getName());
    }

    public String getLangSubtype() {
        String[] stringArray = this.getSubtypes();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i].length() < 5 || !stringArray[i].substring(0, 5).equalsIgnoreCase("lang-")) continue;
                return stringArray[i];
            }
        }
        return null;
    }

    public static String getBaseName(String string) {
        String string2 = string;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        if (stringTokenizer.hasMoreElements()) {
            string2 = (String)stringTokenizer.nextElement();
        }
        return string2;
    }

    public String getBaseName() {
        return LDAPAttribute.getBaseName(this.getName());
    }

    public boolean hasSubtype(String string) {
        String[] stringArray = this.getSubtypes();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equalsIgnoreCase(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    public boolean hasSubtypes(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.hasSubtype(stringArray[i])) continue;
            return false;
        }
        return true;
    }

    public synchronized void addValue(String string) {
        if (string != null) {
            try {
                byte[] byArray = string.getBytes("UTF8");
                this.addValue(byArray);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected void setValues(String[] stringArray) {
        Object[] objectArray;
        if (stringArray != null) {
            objectArray = new Object[stringArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                try {
                    objectArray[i] = stringArray[i].getBytes("UTF8");
                    continue;
                }
                catch (Throwable throwable) {
                    objectArray[i] = new byte[0];
                }
            }
        } else {
            objectArray = new Object[]{};
        }
        this.setValues(objectArray);
    }

    public synchronized void addValue(byte[] byArray) {
        if (byArray != null) {
            Object[] objectArray = new Object[this.values.length + 1];
            for (int i = 0; i < this.values.length; ++i) {
                objectArray[i] = this.values[i];
            }
            objectArray[this.values.length] = byArray;
            this.values = objectArray;
        }
    }

    protected synchronized void setValues(Object[] objectArray) {
        this.values = objectArray;
    }

    public synchronized void removeValue(String string) {
        if (string != null) {
            try {
                byte[] byArray = string.getBytes("UTF8");
                this.removeValue(byArray);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public synchronized void removeValue(byte[] byArray) {
        if (byArray == null || this.values == null || this.values.length < 1) {
            return;
        }
        int n = -1;
        for (int i = 0; i < this.values.length; ++i) {
            if (!LDAPAttribute.equalValue(byArray, (byte[])this.values[i])) continue;
            n = i;
            break;
        }
        if (n >= 0) {
            Object[] objectArray = new Object[this.values.length - 1];
            int n2 = 0;
            for (int i = 0; i < this.values.length; ++i) {
                if (i == n) continue;
                objectArray[n2++] = this.values[i];
            }
            this.values = objectArray;
        }
    }

    private static boolean equalValue(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public BERElement getBERElement() {
        try {
            BERSequence bERSequence = new BERSequence();
            bERSequence.addElement(new BEROctetString(this.getName()));
            BERSet bERSet = new BERSet();
            for (int i = 0; i < this.values.length; ++i) {
                bERSet.addElement(new BEROctetString((byte[])this.values[i]));
            }
            bERSequence.addElement(bERSet);
            return bERSequence;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private String getParamString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.values.length > 0) {
            for (int i = 0; i < this.values.length; ++i) {
                if (i != 0) {
                    stringBuffer.append(",");
                }
                byte[] byArray = (byte[])this.values[i];
                try {
                    String string = new String(byArray, "UTF8");
                    if (string.length() == 0 && byArray.length > 0) {
                        stringBuffer.append("<binary value, length:");
                        stringBuffer.append(byArray.length);
                        stringBuffer.append(">");
                        continue;
                    }
                    stringBuffer.append(string);
                    continue;
                }
                catch (Exception exception) {
                    if (byArray != null) {
                        stringBuffer.append("<binary value, length:");
                        stringBuffer.append(byArray.length);
                        stringBuffer.append(">");
                        continue;
                    }
                    stringBuffer.append("null value");
                }
            }
        }
        return "{type='" + this.getName() + "', values='" + stringBuffer.toString() + "'}";
    }

    public String toString() {
        return "LDAPAttribute " + this.getParamString();
    }
}

