/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.util.Enumeration;
import java.util.Vector;
import netscape.ldap.LDAPSchemaElement;

public class LDAPDITContentRuleSchema
extends LDAPSchemaElement {
    static final long serialVersionUID = -8588488481097270056L;
    public static final String AUX = "AUX";
    public static final String MUST = "MUST";
    public static final String MAY = "MAY";
    public static final String NOT = "NOT";
    static final String[] NOVALS = new String[]{"OBSOLETE"};
    static final String[] IGNOREVALS;
    private Vector must = new Vector();
    private Vector may = new Vector();
    private Vector aux = new Vector();
    private Vector not = new Vector();

    protected LDAPDITContentRuleSchema() {
    }

    public LDAPDITContentRuleSchema(String string, String string2, String string3, boolean bl, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4) {
        super(string, string2, string3, null);
        int n;
        if (stringArray2 != null) {
            for (n = 0; n < stringArray2.length; ++n) {
                this.must.addElement(stringArray2[n]);
            }
        }
        if (stringArray3 != null) {
            for (n = 0; n < stringArray3.length; ++n) {
                this.may.addElement(stringArray3[n]);
            }
        }
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                this.aux.addElement(stringArray[n]);
            }
        }
        if (stringArray4 != null) {
            for (n = 0; n < stringArray4.length; ++n) {
                this.not.addElement(stringArray4[n]);
            }
        }
        if (bl) {
            this.setQualifier("OBSOLETE", "");
        }
    }

    public LDAPDITContentRuleSchema(String string) {
        this.attrName = "ditContentRules";
        this.parseValue(string);
        Object v = this.properties.get(MAY);
        if (v != null) {
            if (v instanceof Vector) {
                this.may = (Vector)v;
            } else {
                this.may.addElement(v);
            }
        }
        if ((v = this.properties.get(MUST)) != null) {
            if (v instanceof Vector) {
                this.must = (Vector)v;
            } else {
                this.must.addElement(v);
            }
        }
        if ((v = this.properties.get(NOT)) != null) {
            if (v instanceof Vector) {
                this.not = (Vector)v;
            } else {
                this.not.addElement(v);
            }
        }
        if ((v = this.properties.get(AUX)) != null) {
            if (v instanceof Vector) {
                this.aux = (Vector)v;
            } else {
                this.aux.addElement(v);
            }
        }
    }

    public String[] getRequiredAttributes() {
        Object[] objectArray = new String[this.must.size()];
        this.must.copyInto(objectArray);
        return objectArray;
    }

    public String[] getOptionalAttributes() {
        Object[] objectArray = new String[this.may.size()];
        this.may.copyInto(objectArray);
        return objectArray;
    }

    public String[] getPrecludedAttributes() {
        Object[] objectArray = new String[this.not.size()];
        this.not.copyInto(objectArray);
        return objectArray;
    }

    public String[] getAuxiliaryClasses() {
        Object[] objectArray = new String[this.aux.size()];
        this.aux.copyInto(objectArray);
        return objectArray;
    }

    public String getValue() {
        String string = this.getValuePrefix();
        String string2 = this.getOptionalValues(NOVALS);
        if (string2.length() > 0) {
            string = string + string2 + ' ';
        }
        if (this.aux.size() > 0) {
            string = string + "AUX " + this.vectorToList(this.aux);
            string = string + ' ';
        }
        if (this.must.size() > 0) {
            string = string + "MUST " + this.vectorToList(this.must);
            string = string + ' ';
        }
        if (this.may.size() > 0) {
            string = string + "MAY " + this.vectorToList(this.may);
            string = string + ' ';
        }
        if (this.not.size() > 0) {
            string = string + "NOT " + this.vectorToList(this.not);
            string = string + ' ';
        }
        if ((string2 = this.getCustomValues()).length() > 0) {
            string = string + string2 + ' ';
        }
        string = string + ')';
        return string;
    }

    protected String vectorToList(Vector vector) {
        String string = "( ";
        for (int i = 0; i < vector.size(); ++i) {
            string = string + (String)vector.elementAt(i) + ' ';
            if (i >= vector.size() - 1) continue;
            string = string + "$ ";
        }
        string = string + ')';
        return string;
    }

    public String toString() {
        String string = "Name: " + this.name + "; OID: " + this.oid;
        string = string + "; Description: " + this.description + "; Required: ";
        int n = 0;
        Enumeration enumeration = this.must.elements();
        while (enumeration.hasMoreElements()) {
            if (n > 0) {
                string = string + ", ";
            }
            ++n;
            string = string + (String)enumeration.nextElement();
        }
        string = string + "; Optional: ";
        enumeration = this.may.elements();
        n = 0;
        while (enumeration.hasMoreElements()) {
            if (n > 0) {
                string = string + ", ";
            }
            ++n;
            string = string + (String)enumeration.nextElement();
        }
        string = string + "; Auxiliary: ";
        enumeration = this.aux.elements();
        n = 0;
        while (enumeration.hasMoreElements()) {
            if (n > 0) {
                string = string + ", ";
            }
            ++n;
            string = string + (String)enumeration.nextElement();
        }
        string = string + "; Precluded: ";
        enumeration = this.not.elements();
        n = 0;
        while (enumeration.hasMoreElements()) {
            if (n > 0) {
                string = string + ", ";
            }
            ++n;
            string = string + (String)enumeration.nextElement();
        }
        if (this.isObsolete()) {
            string = string + "; OBSOLETE";
        }
        string = string + this.getQualifierString(IGNOREVALS);
        return string;
    }

    static {
        for (int i = 0; i < NOVALS.length; ++i) {
            novalsTable.put(NOVALS[i], NOVALS[i]);
        }
        IGNOREVALS = new String[]{"OBSOLETE", AUX, MUST, MAY, NOT};
    }
}

