/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap;

import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSchema;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSyntaxSchemaElement;

public class LDAPMatchingRuleSchema
extends LDAPAttributeSchema {
    static final long serialVersionUID = 6466155218986944131L;
    static final String[] EXPLICIT = new String[]{"OBSOLETE", "SYNTAX"};
    private String[] attributes = null;

    public LDAPMatchingRuleSchema(String string, String string2, String string3, String[] stringArray, int n) {
        this(string, string2, string3, stringArray, "1.3.6.1.4.1.1466.115.121.1.15");
        this.syntaxElement.syntax = n;
        String string4 = LDAPSyntaxSchemaElement.internalSyntaxToString(n);
        if (string4 != null) {
            this.syntaxElement.syntaxString = string4;
        }
        this.setQualifier("SYNTAX", this.syntaxElement.syntaxString);
    }

    public LDAPMatchingRuleSchema(String string, String string2, String string3, String[] stringArray, String string4) {
        this(string, string2, string3, stringArray, string4, null);
    }

    public LDAPMatchingRuleSchema(String string, String string2, String string3, String[] stringArray, String string4, String[] stringArray2) {
        if (string2 == null || string2.trim().length() < 1) {
            throw new IllegalArgumentException("OID required");
        }
        this.name = string;
        this.oid = string2;
        this.description = string3;
        this.attrName = "matchingrules";
        this.syntaxElement.syntax = this.syntaxElement.syntaxCheck(string4);
        this.syntaxElement.syntaxString = string4;
        this.setQualifier("SYNTAX", this.syntaxElement.syntaxString);
        this.attributes = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.attributes[i] = stringArray[i];
        }
        if (stringArray2 != null && stringArray2.length > 0) {
            this.aliases = stringArray2;
        }
    }

    public LDAPMatchingRuleSchema(String string, String string2) {
        String string3;
        Vector vector;
        this.attrName = "matchingrules";
        if (string != null) {
            this.parseValue(string);
        }
        if (string2 != null) {
            this.parseValue(string2);
        }
        if ((vector = (Vector)this.properties.get("APPLIES")) != null) {
            this.attributes = new String[vector.size()];
            vector.copyInto(this.attributes);
            vector.removeAllElements();
        }
        if ((string3 = (String)this.properties.get("SYNTAX")) != null) {
            this.syntaxElement.syntaxString = string3;
            this.syntaxElement.syntax = this.syntaxElement.syntaxCheck(string3);
        }
    }

    public String[] getAttributes() {
        return this.attributes;
    }

    String getValue(boolean bl) {
        String string;
        String string2 = this.getValuePrefix();
        if (this.syntaxElement.syntaxString != null) {
            string2 = string2 + "SYNTAX ";
            if (bl) {
                string2 = string2 + '\'';
            }
            string2 = string2 + this.syntaxElement.syntaxString;
            if (bl) {
                string2 = string2 + '\'';
            }
            string2 = string2 + ' ';
        }
        if ((string = this.getCustomValues()).length() > 0) {
            string2 = string2 + string + ' ';
        }
        string2 = string2 + ')';
        return string2;
    }

    public String getValue() {
        return this.getValue(false);
    }

    public String getUseValue() {
        String string = this.getValuePrefix();
        if (this.attributes != null && this.attributes.length > 0) {
            string = string + "APPLIES ( ";
            for (int i = 0; i < this.attributes.length; ++i) {
                if (i > 0) {
                    string = string + " $ ";
                }
                string = string + this.attributes[i];
            }
            string = string + " ) ";
        }
        string = string + ')';
        return string;
    }

    protected void update(LDAPConnection lDAPConnection, int n, String string, String string2) throws LDAPException {
        LDAPAttribute[] lDAPAttributeArray = new LDAPAttribute[]{new LDAPAttribute("matchingRules", this.getValue()), new LDAPAttribute("matchingRuleUse", this.getUseValue())};
        this.update(lDAPConnection, n, lDAPAttributeArray, string2);
    }

    public String toString() {
        String string = "Name: " + this.name + "; OID: " + this.oid + "; Type: ";
        string = string + this.syntaxElement.syntaxToString();
        string = string + "; Description: " + this.description;
        if (this.attributes != null) {
            string = string + "; Applies to: ";
            for (int i = 0; i < this.attributes.length; ++i) {
                if (i > 0) {
                    string = string + ", ";
                }
                string = string + this.attributes[i];
            }
        }
        string = string + this.getQualifierString(EXPLICIT);
        string = string + this.getAliasString();
        return string;
    }
}

