/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.client;

import java.io.UnsupportedEncodingException;
import java.util.Vector;
import netscape.ldap.ber.stream.BEROctetString;

public class JDAPFilterOpers {
    private static final String escapeKey = "\\";
    private static final boolean m_debug = false;

    static BEROctetString getOctetString(String string) {
        if (string.indexOf(escapeKey) >= 0) {
            byte[] byArray = JDAPFilterOpers.getByteValues(string);
            return new BEROctetString(byArray);
        }
        return new BEROctetString(string);
    }

    public static String convertLDAPv2Escape(String string) {
        if (string.indexOf(92) < 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        while (n2 < n3 && (n = string.indexOf(92, n2)) >= 0) {
            stringBuffer.append(string.substring(n2, n + 1));
            try {
                char c = string.charAt(n + 1);
                if (c >= ' ' && c < '\u007f' && !JDAPFilterOpers.isHexDigit(c)) {
                    stringBuffer.append(Integer.toHexString(c));
                } else {
                    stringBuffer.append(c);
                }
                n2 = n + 2;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new IllegalArgumentException("Bad search filter");
            }
        }
        if (n2 < n3) {
            stringBuffer.append(string.substring(n2));
        }
        return stringBuffer.toString();
    }

    private static boolean isHexDigit(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    static byte[] getByteValues(String string) {
        Object object;
        Object object2;
        int n = 0;
        Vector<Object> vector = new Vector<Object>();
        String string2 = new String(string);
        int n2 = 0;
        while ((n = string2.indexOf(escapeKey)) >= 0) {
            Object object3;
            object2 = string2.substring(0, n);
            try {
                object3 = ((String)object2).getBytes("UTF8");
                n2 += ((byte[])object3).length;
                vector.addElement(object3);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                JDAPFilterOpers.printDebug(unsupportedEncodingException.toString());
                return null;
            }
            object3 = null;
            try {
                object = "0x" + string2.substring(n + 1, n + 3);
                object3 = Integer.decode((String)object);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                JDAPFilterOpers.printDebug(indexOutOfBoundsException.toString());
                throw new IllegalArgumentException("Bad search filter");
            }
            catch (NumberFormatException numberFormatException) {
                JDAPFilterOpers.printDebug(numberFormatException.toString());
                throw new IllegalArgumentException("Bad search filter");
            }
            object = new byte[]{(byte)((Integer)object3).intValue()};
            n2 += ((byte[])object).length;
            vector.addElement(object);
            string2 = string2.substring(n + 3);
        }
        if (string2.length() > 0) {
            try {
                object2 = string2.getBytes("UTF8");
                n2 += ((Object)object2).length;
                vector.addElement(object2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                JDAPFilterOpers.printDebug(unsupportedEncodingException.toString());
                return null;
            }
        }
        object2 = new byte[n2];
        n = 0;
        for (int i = 0; i < vector.size(); ++i) {
            object = (byte[])vector.elementAt(i);
            System.arraycopy(object, 0, object2, n, ((byte[])object).length);
            n += ((byte[])object).length;
        }
        return object2;
    }

    private static void printDebug(String string) {
    }
}

