/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.ArithmeticEngine;
import freemarker.core.BuiltIn;
import freemarker.core.Environment;
import freemarker.template.TemplateException;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateModelListSequence;
import freemarker.template.TemplateNumberModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateSequenceModel;
import freemarker.template.utility.StringUtil;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

abstract class SequenceBuiltins {
    SequenceBuiltins() {
    }

    static class sort_byBI
    extends sortBI {
        sort_byBI() {
        }

        TemplateModel calculateResult(TemplateSequenceModel seq) {
            return new BIMethod(seq);
        }

        static class BIMethod
        implements TemplateMethodModelEx {
            TemplateSequenceModel seq;

            BIMethod(TemplateSequenceModel seq) {
                this.seq = seq;
            }

            public Object exec(List params) throws TemplateModelException {
                if (params.size() != 1) {
                    throw new TemplateModelException("?sort_by(key) needs exactly 1 argument.");
                }
                Object obj = params.get(0);
                if (!(obj instanceof TemplateScalarModel)) {
                    throw new TemplateModelException("The argument to sort_by(key) must be a string");
                }
                String key = ((TemplateScalarModel)obj).getAsString();
                if (key == null) {
                    throw new TemplateModelException("The argument to sort_by(key) is null");
                }
                return sortBI.sort(this.seq, key);
            }
        }
    }

    static class sortBI
    extends SequenceBuiltIn {
        static final int KEY_TYPE_STRING = 1;
        static final int KEY_TYPE_NUMBER = 2;

        sortBI() {
        }

        TemplateModel calculateResult(TemplateSequenceModel seq) throws TemplateModelException {
            return sortBI.sort(seq, null);
        }

        static String startErrorMessage(String key) {
            return (key == null ? "?sort" : "?sort_by(...)") + " failed: ";
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static TemplateSequenceModel sort(TemplateSequenceModel seq, String key) throws TemplateModelException {
            int i;
            void var7_5;
            int keyType;
            int ln = seq.size();
            ArrayList<Object> res = new ArrayList<Object>(ln);
            if (ln == 0) return new TemplateModelListSequence(res);
            TemplateModel item = seq.get(0);
            if (key != null) {
                if (!(item instanceof TemplateHashModel)) {
                    throw new TemplateModelException(sortBI.startErrorMessage(key) + "You can't use ?sort_by when the " + "sequence items are not hashes.");
                }
                if ((item = ((TemplateHashModel)item).get(key)) == null) {
                    throw new TemplateModelException(sortBI.startErrorMessage(key) + "The key " + StringUtil.jQuote(key) + " was not found in the sequence item.");
                }
            }
            if (item instanceof TemplateScalarModel) {
                keyType = 1;
            } else {
                if (!(item instanceof TemplateNumberModel)) throw new TemplateModelException(sortBI.startErrorMessage(key) + "Values used for sorting must be numbers or strings.");
                keyType = 2;
            }
            if (key == null) {
                if (var7_5 == true) {
                    for (i = 0; i < ln; ++i) {
                        item = seq.get(i);
                        if (!(item instanceof TemplateScalarModel)) {
                            throw new TemplateModelException(sortBI.startErrorMessage(key) + "All values in the sequence must be " + "strings, because the first value " + "was a string. " + "The value at index " + i + " is not string.");
                        }
                        res.add(new KVP(((TemplateScalarModel)item).getAsString(), item));
                    }
                } else {
                    if (var7_5 != 2) throw new RuntimeException("Bug: Bad key type");
                    for (i = 0; i < ln; ++i) {
                        item = seq.get(i);
                        if (!(item instanceof TemplateNumberModel)) {
                            throw new TemplateModelException(sortBI.startErrorMessage(key) + "All values in the sequence must be " + "numbers, because the first value " + "was a number. " + "The value at index " + i + " is not number.");
                        }
                        res.add(new KVP(((TemplateNumberModel)item).getAsNumber(), item));
                    }
                }
            } else {
                for (i = 0; i < ln; ++i) {
                    item = seq.get(i);
                    if (!(item instanceof TemplateHashModel)) {
                        throw new TemplateModelException(sortBI.startErrorMessage(key) + "All values in the sequence must be " + "hashes, because you use a key to " + "access the value used for the sorting. " + "The value at index " + i + " is not a hash.");
                    }
                    TemplateModel obj = ((TemplateHashModel)item).get(key);
                    if (obj == null) {
                        throw new TemplateModelException(sortBI.startErrorMessage(key) + "The key " + StringUtil.jQuote(key) + " was not found in the value at " + "index " + i);
                    }
                    if (var7_5 == true) {
                        if (!(obj instanceof TemplateScalarModel)) {
                            throw new TemplateModelException(sortBI.startErrorMessage(key) + "All key values in the sequence must be " + "strings, because the first key " + "value was a string. The key value at " + "index " + i + " is not a string.");
                        }
                        res.add(new KVP(((TemplateScalarModel)obj).getAsString(), item));
                        continue;
                    }
                    if (var7_5 != 2) throw new RuntimeException("Bug: Bad key type");
                    if (!(obj instanceof TemplateNumberModel)) {
                        throw new TemplateModelException(sortBI.startErrorMessage(key) + "All key values in the sequence must be " + "numbers, because the first key " + "value was a number. The key value at " + "index " + i + " is not a number.");
                    }
                    res.add(new KVP(((TemplateNumberModel)obj).getAsNumber(), item));
                }
            }
            if (var7_5 == true) {
                LexicalKVPComparator lexicalKVPComparator = new LexicalKVPComparator(Environment.getCurrentEnvironment().getCollator());
            } else {
                if (var7_5 != 2) throw new RuntimeException("Bug: Bad key type");
                NumericalKVPComparator numericalKVPComparator = new NumericalKVPComparator(Environment.getCurrentEnvironment().getArithmeticEngine());
            }
            try {
                void var8_10;
                Collections.sort(res, var8_10);
            }
            catch (ClassCastException exc) {
                throw new TemplateModelException(sortBI.startErrorMessage(key) + "Unexpected error while sorting:" + exc, exc);
            }
            for (i = 0; i < ln; ++i) {
                res.set(i, ((KVP)res.get(i)).value);
            }
            return new TemplateModelListSequence(res);
        }

        private static class LexicalKVPComparator
        implements Comparator {
            private Collator collator;

            LexicalKVPComparator(Collator collator) {
                this.collator = collator;
            }

            public int compare(Object arg0, Object arg1) {
                return this.collator.compare(((KVP)arg0).key, ((KVP)arg1).key);
            }
        }

        private static class NumericalKVPComparator
        implements Comparator {
            private ArithmeticEngine ae;

            private NumericalKVPComparator(ArithmeticEngine ae) {
                this.ae = ae;
            }

            public int compare(Object arg0, Object arg1) {
                try {
                    return this.ae.compareNumbers((Number)((KVP)arg0).key, (Number)((KVP)arg1).key);
                }
                catch (TemplateException e) {
                    throw new ClassCastException("Failed to compare numbers: " + e);
                }
            }
        }

        private static class KVP {
            private Object key;
            private Object value;

            private KVP(Object key, Object value) {
                this.key = key;
                this.value = value;
            }
        }
    }

    static class reverseBI
    extends SequenceBuiltIn {
        reverseBI() {
        }

        TemplateModel calculateResult(TemplateSequenceModel tsm) {
            if (tsm instanceof ReverseSequence) {
                return ((ReverseSequence)tsm).seq;
            }
            return new ReverseSequence(tsm);
        }

        private static class ReverseSequence
        implements TemplateSequenceModel {
            private final TemplateSequenceModel seq;

            ReverseSequence(TemplateSequenceModel seq) {
                this.seq = seq;
            }

            public int size() throws TemplateModelException {
                return this.seq.size();
            }

            public TemplateModel get(int index) throws TemplateModelException {
                return this.seq.get(this.seq.size() - 1 - index);
            }
        }
    }

    static class lastBI
    extends SequenceBuiltIn {
        lastBI() {
        }

        TemplateModel calculateResult(TemplateSequenceModel tsm) throws TemplateModelException {
            if (tsm.size() == 0) {
                return null;
            }
            return tsm.get(tsm.size() - 1);
        }
    }

    static class firstBI
    extends SequenceBuiltIn {
        firstBI() {
        }

        TemplateModel calculateResult(TemplateSequenceModel tsm) throws TemplateModelException {
            if (tsm.size() == 0) {
                return null;
            }
            return tsm.get(0);
        }
    }

    static abstract class SequenceBuiltIn
    extends BuiltIn {
        SequenceBuiltIn() {
        }

        TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
            TemplateModel model = this.target.getAsTemplateModel(env);
            if (!(model instanceof TemplateSequenceModel)) {
                throw SequenceBuiltIn.invalidTypeException(model, this.target, env, "sequence");
            }
            return this.calculateResult((TemplateSequenceModel)model);
        }

        abstract TemplateModel calculateResult(TemplateSequenceModel var1) throws TemplateModelException;
    }
}

