/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.extended;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.basic.ByteConverter;
import com.thoughtworks.xstream.core.util.Base64Encoder;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;

public class EncodedByteArrayConverter
implements Converter {
    private final Base64Encoder base64 = new Base64Encoder();
    private final ByteConverter byteConverter = new ByteConverter();

    public boolean canConvert(Class clazz) {
        return clazz.isArray() && clazz.getComponentType().equals(Byte.TYPE);
    }

    public void marshal(Object object, HierarchicalStreamWriter hierarchicalStreamWriter, MarshallingContext marshallingContext) {
        hierarchicalStreamWriter.setValue(this.base64.encode((byte[])object));
    }

    public Object unmarshal(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
        String string = hierarchicalStreamReader.getValue();
        if (!hierarchicalStreamReader.hasMoreChildren()) {
            return this.base64.decode(string);
        }
        return this.unmarshalIndividualByteElements(hierarchicalStreamReader, unmarshallingContext);
    }

    private Object unmarshalIndividualByteElements(HierarchicalStreamReader hierarchicalStreamReader, UnmarshallingContext unmarshallingContext) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        boolean bl = true;
        while (bl || hierarchicalStreamReader.hasMoreChildren()) {
            hierarchicalStreamReader.moveDown();
            arrayList.add(this.byteConverter.unmarshal(hierarchicalStreamReader, unmarshallingContext));
            hierarchicalStreamReader.moveUp();
            bl = false;
        }
        byte[] byArray = new byte[arrayList.size()];
        int n = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Byte by = (Byte)iterator.next();
            byArray[n] = by;
            ++n;
        }
        return byArray;
    }
}

