/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.ir.ts;

import com.googlecode.dex2jar.ir.IrMethod;
import com.googlecode.dex2jar.ir.Trap;
import com.googlecode.dex2jar.ir.Value;
import com.googlecode.dex2jar.ir.stmt.JumpStmt;
import com.googlecode.dex2jar.ir.stmt.LabelStmt;
import com.googlecode.dex2jar.ir.stmt.Stmt;
import com.googlecode.dex2jar.ir.stmt.StmtList;
import com.googlecode.dex2jar.ir.stmt.Stmts;
import com.googlecode.dex2jar.ir.ts.Cfg;
import com.googlecode.dex2jar.ir.ts.Transformer;
import java.util.ArrayList;
import java.util.HashMap;

public class EndRemover
implements Transformer {
    static boolean isSimple(Stmt stmt) {
        while (stmt != null) {
            block0 : switch (stmt.st) {
                case ASSIGN: 
                case IDENTITY: {
                    Stmt.E2Stmt e2 = (Stmt.E2Stmt)stmt;
                    if (e2.op1.value.vt != Value.VT.LOCAL) {
                        return false;
                    }
                    switch (e2.op2.value.vt) {
                        case CONSTANT: 
                        case LOCAL: {
                            break block0;
                        }
                    }
                    return false;
                }
                case LABEL: 
                case NOP: 
                case UNLOCK: {
                    break;
                }
                case IF: 
                case LOCK: 
                case LOOKUP_SWITCH: 
                case TABLE_SWITCH: 
                case THROW: {
                    return false;
                }
                case GOTO: 
                case RETURN: 
                case RETURN_VOID: {
                    return true;
                }
            }
            stmt = stmt.getNext();
        }
        return true;
    }

    static void directJump(StmtList list) {
        HashMap<LabelStmt, LabelStmt> map = new HashMap<LabelStmt, LabelStmt>();
        Stmt st = list.getFirst();
        while (st != null) {
            switch (st.st) {
                case GOTO: {
                    JumpStmt js = (JumpStmt)st;
                    if (EndRemover.isSimple(js.target)) {
                        boolean end = false;
                        Stmt p = js.target.getNext();
                        while (!end) {
                            switch (p.st) {
                                case LABEL: {
                                    break;
                                }
                                case GOTO: {
                                    LabelStmt target = ((JumpStmt)p).target;
                                    list.insertBefore(js, Stmts.nGoto(target));
                                    end = true;
                                    break;
                                }
                                case RETURN: 
                                case RETURN_VOID: {
                                    list.insertBefore(js, p.clone(null));
                                    end = true;
                                    break;
                                }
                                default: {
                                    list.insertBefore(js, p.clone(null));
                                }
                            }
                            p = p.getNext();
                        }
                        Stmt tmp = st.getNext();
                        list.remove(st);
                        st = tmp;
                        break;
                    }
                    st = st.getNext();
                    break;
                }
                case IF: {
                    JumpStmt js = (JumpStmt)st;
                    if (map.containsKey(js.target)) {
                        LabelStmt nTarget;
                        js.target = nTarget = (LabelStmt)map.get(js.target);
                    } else if (EndRemover.isSimple(js.target)) {
                        LabelStmt nTarget = Stmts.nLabel();
                        map.put(js.target, nTarget);
                        list.add(nTarget);
                        boolean end = false;
                        Stmt p = js.target.getNext();
                        while (!end) {
                            switch (p.st) {
                                case LABEL: {
                                    break;
                                }
                                case GOTO: {
                                    LabelStmt target = ((JumpStmt)p).target;
                                    list.add(Stmts.nGoto(target));
                                    end = true;
                                    break;
                                }
                                case RETURN: 
                                case RETURN_VOID: {
                                    list.add(p.clone(null));
                                    end = true;
                                    break;
                                }
                                default: {
                                    list.add(p.clone(null));
                                }
                            }
                            p = p.getNext();
                        }
                        js.target = nTarget;
                    }
                    st = st.getNext();
                    break;
                }
                default: {
                    st = st.getNext();
                }
            }
        }
    }

    @Override
    public void transform(IrMethod irMethod) {
        for (Trap trap : new ArrayList<Trap>(irMethod.traps)) {
            LabelStmt start = null;
            boolean removeTrap = true;
            Stmt p = trap.start.getNext();
            while (p != null && p != trap.end) {
                boolean notThrow = Cfg.notThrow(p);
                if (!notThrow) {
                    start = null;
                    p = p.getNext();
                    removeTrap = false;
                    continue;
                }
                switch (p.st) {
                    case LABEL: {
                        if (start != null) {
                            this.move4Label(irMethod.stmts, start, p.getPre(), (LabelStmt)p);
                        }
                        start = (LabelStmt)p;
                        p = p.getNext();
                        break;
                    }
                    case GOTO: 
                    case RETURN: 
                    case RETURN_VOID: {
                        if (start != null) {
                            Stmt tmp = p.getNext();
                            this.move4End(irMethod.stmts, start, p);
                            start = null;
                            p = tmp;
                            break;
                        }
                        p = p.getNext();
                        break;
                    }
                    default: {
                        p = p.getNext();
                    }
                }
            }
            if (!removeTrap) continue;
            irMethod.traps.remove(trap);
        }
        StmtList stmts = irMethod.stmts;
        Stmt p = stmts.getFirst();
        while (p != null) {
            LabelStmt target;
            Stmt next;
            if (p.st == Stmt.ST.GOTO && (next = (target = ((JumpStmt)p).target).getNext()) != null && (next.st == Stmt.ST.RETURN || next.st == Stmt.ST.RETURN_VOID)) {
                Stmt nnext = next.clone(null);
                stmts.insertAfter(p, nnext);
                stmts.remove(p);
                p = nnext;
            }
            p = p.getNext();
        }
    }

    private void move4Label(StmtList stmts, LabelStmt start, Stmt end, LabelStmt label) {
        this.move4End(stmts, start, end);
        stmts.insertAfter(end, Stmts.nGoto(label));
    }

    private void move4End(StmtList stmts, LabelStmt start, Stmt end) {
        JumpStmt g1 = Stmts.nGoto(start);
        stmts.insertBefore(start, g1);
        Stmt last = stmts.getLast();
        while (last.st == Stmt.ST.GOTO && ((JumpStmt)last).target == start) {
            stmts.remove(last);
            last = stmts.getLast();
        }
        stmts.move(start, end, last);
    }
}

