/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.util;

import com.googlecode.dex2jar.Field;
import com.googlecode.dex2jar.Method;
import com.googlecode.dex2jar.reader.DexFileReader;
import com.googlecode.dex2jar.util.DumpDexCodeAdapter;
import com.googlecode.dex2jar.visitors.DexClassVisitor;
import com.googlecode.dex2jar.visitors.DexCodeVisitor;
import com.googlecode.dex2jar.visitors.DexFieldVisitor;
import com.googlecode.dex2jar.visitors.DexMethodVisitor;
import com.googlecode.dex2jar.visitors.EmptyVisitor;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class Dump
extends EmptyVisitor {
    private int class_count = 0;
    private PrintWriter out;
    private WriterManager writerManager;
    StringBuilder deps = new StringBuilder();

    public static void doData(DexFileReader dexFileReader, File destJar) throws IOException {
        final ZipOutputStream zos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(destJar)));
        dexFileReader.accept(new Dump(new WriterManager(){

            @Override
            public PrintWriter get(String name) {
                try {
                    String s = String.valueOf(name.replace('.', '/')) + ".dump.txt";
                    ZipEntry zipEntry = new ZipEntry(s);
                    zos.putNextEntry(zipEntry);
                    return new PrintWriter(zos){

                        @Override
                        public void close() {
                            try {
                                zos.closeEntry();
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    };
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }));
        zos.finish();
        zos.close();
    }

    public static void doData(byte[] data, File destJar) throws IOException {
        Dump.doData(new DexFileReader(data), destJar);
    }

    public static void doFile(File srcDex) throws IOException {
        Dump.doFile(srcDex, new File(srcDex.getParentFile(), String.valueOf(srcDex.getName()) + "_dump.jar"));
    }

    public static void doFile(File srcDex, File destJar) throws IOException {
        Dump.doData(DexFileReader.readDex(srcDex), destJar);
    }

    public static String getAccDes(int acc) {
        StringBuilder sb = new StringBuilder();
        if ((acc & 1) != 0) {
            sb.append("public ");
        }
        if ((acc & 4) != 0) {
            sb.append("protected ");
        }
        if ((acc & 2) != 0) {
            sb.append("private ");
        }
        if ((acc & 8) != 0) {
            sb.append("static ");
        }
        if ((acc & 0x400) != 0 && (acc & 0x200) == 0) {
            sb.append("abstract ");
        }
        if ((acc & 0x2000) != 0) {
            sb.append("annotation ");
        }
        if ((acc & 0x40) != 0) {
            sb.append("bridge ");
        }
        if ((acc & 0x4000) != 0) {
            sb.append("enum ");
        }
        if ((acc & 0x10) != 0) {
            sb.append("final ");
        }
        if ((acc & 0x200) != 0) {
            sb.append("interace ");
        }
        if ((acc & 0x100) != 0) {
            sb.append("native ");
        }
        if ((acc & 0x800) != 0) {
            sb.append("strict ");
        }
        if ((acc & 0x20) != 0) {
            sb.append("synchronized ");
        }
        if ((acc & 0x80) != 0) {
            sb.append("transient ");
        }
        if ((acc & 0x80) != 0) {
            sb.append("varargs ");
        }
        if ((acc & 0x40) != 0) {
            sb.append("volatile ");
        }
        return sb.toString();
    }

    public static void main(String ... args) throws IOException {
        if (args.length < 2) {
            System.out.println("Dump in.dexORapk out.dump.jar");
            return;
        }
        Dump.doFile(new File(args[0]), new File(args[1]));
    }

    public Dump(WriterManager writerManager) {
        this.writerManager = writerManager;
    }

    public static String toJavaClass(String desc) {
        switch (desc.charAt(0)) {
            case 'L': {
                return desc.substring(1, desc.length() - 1).replace('/', '.');
            }
            case 'B': {
                return "byte";
            }
            case 'S': {
                return "short";
            }
            case 'C': {
                return "char";
            }
            case 'I': {
                return "int";
            }
            case 'J': {
                return "long";
            }
            case 'F': {
                return "float";
            }
            case 'D': {
                return "double";
            }
            case '[': {
                return String.valueOf(Dump.toJavaClass(desc.substring(1))) + "[]";
            }
        }
        return desc;
    }

    @Override
    public void visitDepedence(String name, byte[] checksum) {
        this.deps.append("dep: " + name + ", checksum: ");
        byte[] byArray = checksum;
        int n = checksum.length;
        int n2 = 0;
        while (n2 < n) {
            byte element = byArray[n2];
            this.deps.append(String.format("%02x", element));
            ++n2;
        }
        this.deps.append("\n");
    }

    @Override
    public void visitEnd() {
        if (this.deps.length() > 0) {
            PrintWriter out = this.writerManager.get("depedence");
            out.print(this.deps.toString());
            out.flush();
            out.close();
        }
    }

    @Override
    public DexClassVisitor visit(int access_flags, String className, String superClass, String[] interfaceNames) {
        String javaClassName = Dump.toJavaClass(className);
        this.out = this.writerManager.get(javaClassName);
        this.out.printf("//class:%04d  access:0x%04x\n", this.class_count++, access_flags);
        this.out.print(Dump.getAccDes(access_flags));
        if ((access_flags & 0x200) == 0) {
            this.out.print("class ");
        }
        this.out.print(javaClassName);
        if (superClass != null && !"Ljava/lang/Object;".equals(superClass)) {
            this.out.print(" extends ");
            this.out.print(Dump.toJavaClass(superClass));
        }
        if (interfaceNames != null && interfaceNames.length > 0) {
            this.out.print(" implements ");
            this.out.print(Dump.toJavaClass(interfaceNames[0]));
            int i = 1;
            while (i < interfaceNames.length) {
                this.out.print(',');
                this.out.print(Dump.toJavaClass(interfaceNames[i]));
                ++i;
            }
        }
        this.out.println();
        return new EmptyVisitor(){
            int field_count = 0;
            int method_count = 0;

            @Override
            public void visitEnd() {
                Dump.this.out.flush();
                Dump.this.out.close();
                Dump.this.out = null;
                super.visitEnd();
            }

            @Override
            public DexFieldVisitor visitField(int accesFlags, Field field, Object value) {
                Dump.this.out.printf("//field:%04d  access:0x%04x\n", this.field_count++, accesFlags);
                Dump.this.out.printf("//%s\n", field);
                Dump.this.out.printf("%s %s %s", Dump.getAccDes(accesFlags), Dump.toJavaClass(field.getType()), field.getName());
                if (value != null) {
                    Dump.this.out.print('=');
                    Dump.this.out.print(value);
                }
                Dump.this.out.println(';');
                return null;
            }

            @Override
            public DexMethodVisitor visitMethod(final int accesFlags, final Method method) {
                Dump.this.out.println();
                Dump.this.out.printf("//method:%04d  access:0x%04x\n", this.method_count++, accesFlags);
                Dump.this.out.printf("//%s\n", method);
                Dump.this.out.printf("%s%s %s(", Dump.getAccDes(accesFlags), Dump.toJavaClass(method.getReturnType()), method.getName());
                String[] ps = method.getParameterTypes();
                if (ps != null && ps.length > 0) {
                    Dump.this.out.print(Dump.toJavaClass(ps[0]));
                    int i = 1;
                    while (i < ps.length) {
                        Dump.this.out.print(',');
                        Dump.this.out.print(Dump.toJavaClass(ps[i]));
                        ++i;
                    }
                }
                Dump.this.out.println(')');
                return new EmptyVisitor(){

                    @Override
                    public DexCodeVisitor visitCode() {
                        return new DumpDexCodeAdapter((accesFlags & 8) != 0, method, Dump.this.out);
                    }
                };
            }
        };
    }

    public static interface WriterManager {
        public PrintWriter get(String var1);
    }
}

