/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.nav;

import com.adobe.epubcheck.messages.MessageId;
import com.adobe.epubcheck.opf.ValidationContext;
import com.adobe.epubcheck.ops.OPSHandler30;
import com.adobe.epubcheck.util.FeatureEnum;
import com.adobe.epubcheck.vocab.StructureVocab;
import com.adobe.epubcheck.xml.model.XMLElement;
import com.google.common.base.CaseFormat;
import com.google.common.base.Converter;
import io.mola.galimatias.URL;
import java.util.EnumSet;
import java.util.Set;
import org.w3c.epubcheck.core.references.Reference;

public class NavHandler
extends OPSHandler30 {
    private NavType currentNavType = NavType.NONE;
    private boolean isNavTypes = false;

    NavHandler(ValidationContext context) {
        super(context);
    }

    @Override
    public void startElement() {
        String href;
        URL url;
        super.startElement();
        XMLElement e = this.currentElement();
        if ("http://www.w3.org/1999/xhtml".equals(e.getNamespace()) && e.getName().equals("a") && (url = this.checkURL(href = e.getAttribute("href"))) != null) {
            if (this.currentNavType == NavType.TOC) {
                this.context.featureReport.report(FeatureEnum.TOC_LINKS, this.location());
            }
            if (NavType.TOC__PAGE_LIST__LANDMARKS.contains((Object)this.currentNavType) && this.context.isRemote(url)) {
                this.report.message(MessageId.NAV_010, this.location(), new Object[]{this.currentNavType, href});
            } else if (NavType.TOC__PAGE_LIST.contains((Object)this.currentNavType)) {
                this.registerReference(url, this.currentNavType == NavType.TOC ? Reference.Type.NAV_TOC_LINK : Reference.Type.NAV_PAGELIST_LINK);
            }
        }
    }

    @Override
    public void endElement() {
        super.endElement();
        XMLElement e = this.currentElement();
        if ("http://www.w3.org/1999/xhtml".equals(e.getNamespace()) && e.getName().equals("nav")) {
            this.currentNavType = NavType.NONE;
        }
    }

    @Override
    protected void checkType(String type) {
        XMLElement e = this.currentElement();
        this.isNavTypes = "http://www.w3.org/1999/xhtml".equals(e.getNamespace()) && e.getName().equals("nav");
        super.checkType(type);
        this.isNavTypes = false;
    }

    @Override
    protected void checkTypes(Set<StructureVocab.EPUB_TYPES> types) {
        super.checkTypes(types);
        if (this.isNavTypes) {
            if (types.contains(StructureVocab.EPUB_TYPES.TOC)) {
                this.currentNavType = NavType.TOC;
            }
            if (types.contains(StructureVocab.EPUB_TYPES.PAGE_LIST)) {
                this.currentNavType = NavType.PAGE_LIST;
                this.context.featureReport.report(FeatureEnum.PAGE_LIST, this.location());
            }
            if (types.contains(StructureVocab.EPUB_TYPES.LANDMARKS)) {
                this.currentNavType = NavType.LANDMARKS;
            }
            if (types.contains(StructureVocab.EPUB_TYPES.LOI)) {
                this.context.featureReport.report(FeatureEnum.LOI, this.location());
            }
            if (types.contains(StructureVocab.EPUB_TYPES.LOT)) {
                this.context.featureReport.report(FeatureEnum.LOT, this.location());
            }
            if (types.contains(StructureVocab.EPUB_TYPES.LOA)) {
                this.context.featureReport.report(FeatureEnum.LOA, this.location());
            }
            if (types.contains(StructureVocab.EPUB_TYPES.LOV)) {
                this.context.featureReport.report(FeatureEnum.LOV, this.location());
            }
        }
    }

    private static enum NavType {
        NONE,
        TOC,
        LANDMARKS,
        PAGE_LIST,
        OTHER;

        private Converter<String, String> formatter = CaseFormat.UPPER_UNDERSCORE.converterTo(CaseFormat.LOWER_HYPHEN);
        public static EnumSet<NavType> TOC__PAGE_LIST;
        public static EnumSet<NavType> TOC__PAGE_LIST__LANDMARKS;

        public String toString() {
            return (String)this.formatter.convert((Object)this.name());
        }

        static {
            TOC__PAGE_LIST = EnumSet.of(TOC, PAGE_LIST);
            TOC__PAGE_LIST__LANDMARKS = EnumSet.of(TOC, PAGE_LIST, LANDMARKS);
        }
    }
}

