/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.awt;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Library;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class SWT_AWT {
    public static String embeddedFrameClass;
    static String EMBEDDED_FRAME_KEY;
    static boolean loaded;
    static boolean swingInitialized;

    static {
        EMBEDDED_FRAME_KEY = "org.eclipse.swt.awt.SWT_AWT.embeddedFrame";
        System.setProperty("apple.awt.usingSWT", "true");
    }

    static final native long getAWTHandle(Canvas var0);

    static synchronized void loadLibrary() {
        if (loaded) {
            return;
        }
        loaded = true;
        Toolkit.getDefaultToolkit();
        try {
            System.loadLibrary("jawt");
        }
        catch (Throwable throwable) {}
        Library.loadLibrary("swt-awt");
    }

    static synchronized void initializeSwing() {
        if (swingInitialized) {
            return;
        }
        swingInitialized = true;
        try {
            Class[] classArray = new Class[]{};
            Object[] objectArray = new Object[]{};
            Class<?> clazz = Class.forName("javax.swing.UIManager");
            Method method = clazz.getMethod("getDefaults", classArray);
            if (method != null) {
                method.invoke(clazz, objectArray);
            }
        }
        catch (Throwable throwable) {}
    }

    public static Frame getFrame(Composite composite) {
        if (composite == null) {
            SWT.error(4);
        }
        if ((composite.getStyle() & 0x1000000) == 0) {
            return null;
        }
        return (Frame)composite.getData(EMBEDDED_FRAME_KEY);
    }

    public static Frame new_Frame(final Composite composite) {
        String string;
        if (composite == null) {
            SWT.error(4);
        }
        if ((composite.getStyle() & 0x1000000) == 0) {
            SWT.error(5);
        }
        long l = composite.view.id;
        Class<?> clazz = null;
        try {
            String string2 = string = embeddedFrameClass != null ? embeddedFrameClass : "apple.awt.CEmbeddedFrame";
            clazz = embeddedFrameClass == null ? Class.forName(string, true, ClassLoader.getSystemClassLoader()) : Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            SWT.error(20, classNotFoundException);
        }
        catch (Throwable throwable) {
            SWT.error(1, throwable, " [Error while starting AWT]");
        }
        SWT_AWT.initializeSwing();
        string = null;
        Constructor<?> constructor = null;
        try {
            constructor = clazz.getConstructor(Long.TYPE);
            string = constructor.newInstance(new Long(l));
        }
        catch (Throwable throwable) {
            SWT.error(20, throwable);
        }
        final Frame frame = (Frame)((Object)string);
        frame.addNotify();
        composite.setData(EMBEDDED_FRAME_KEY, frame);
        final Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 20: {
                        EventQueue.invokeLater(new Runnable(this, frame){
                            final /* synthetic */ 1 this$1;
                            private final /* synthetic */ Frame val$frame;
                            {
                                this.this$1 = var1_1;
                                this.val$frame = frame;
                            }

                            public void run() {
                                this.val$frame.dispatchEvent(new WindowEvent(this.val$frame, 204));
                            }
                        });
                        break;
                    }
                    case 19: {
                        EventQueue.invokeLater(new Runnable(this, frame){
                            final /* synthetic */ 1 this$1;
                            private final /* synthetic */ Frame val$frame;
                            {
                                this.this$1 = var1_1;
                                this.val$frame = frame;
                            }

                            public void run() {
                                this.val$frame.dispatchEvent(new WindowEvent(this.val$frame, 203));
                            }
                        });
                    }
                }
            }
        };
        Shell shell = composite.getShell();
        shell.addListener(20, listener);
        shell.addListener(19, listener);
        Listener listener2 = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        Shell shell = composite.getShell();
                        shell.removeListener(20, listener);
                        shell.removeListener(19, listener);
                        composite.setVisible(false);
                        EventQueue.invokeLater(new Runnable(this, frame){
                            final /* synthetic */ 4 this$1;
                            private final /* synthetic */ Frame val$frame;
                            {
                                this.this$1 = var1_1;
                                this.val$frame = frame;
                            }

                            public void run() {
                                try {
                                    this.val$frame.dispose();
                                }
                                catch (Throwable throwable) {}
                            }
                        });
                        break;
                    }
                    case 15: {
                        EventQueue.invokeLater(new Runnable(this, frame){
                            final /* synthetic */ 4 this$1;
                            private final /* synthetic */ Frame val$frame;
                            {
                                this.this$1 = var1_1;
                                this.val$frame = frame;
                            }

                            public void run() {
                                if (this.val$frame.isActive()) {
                                    return;
                                }
                                try {
                                    Class<?> clazz = this.val$frame.getClass();
                                    Method method = clazz.getMethod("synthesizeWindowActivation", Boolean.TYPE);
                                    if (method != null) {
                                        method.invoke((Object)this.val$frame, new Boolean(true));
                                    }
                                }
                                catch (Throwable throwable) {
                                    throwable.printStackTrace();
                                }
                            }
                        });
                        break;
                    }
                    case 27: {
                        EventQueue.invokeLater(new Runnable(this, frame){
                            final /* synthetic */ 4 this$1;
                            private final /* synthetic */ Frame val$frame;
                            {
                                this.this$1 = var1_1;
                                this.val$frame = frame;
                            }

                            public void run() {
                                if (!this.val$frame.isActive()) {
                                    return;
                                }
                                try {
                                    Class<?> clazz = this.val$frame.getClass();
                                    Method method = clazz.getMethod("synthesizeWindowActivation", Boolean.TYPE);
                                    if (method != null) {
                                        method.invoke((Object)this.val$frame, new Boolean(false));
                                    }
                                }
                                catch (Throwable throwable) {
                                    throwable.printStackTrace();
                                }
                            }
                        });
                    }
                }
            }
        };
        composite.addListener(15, listener2);
        composite.addListener(27, listener2);
        composite.addListener(12, listener2);
        composite.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (composite.isDisposed()) {
                    return;
                }
                Rectangle rectangle = composite.getClientArea();
                EventQueue.invokeLater(new Runnable(this, frame, rectangle){
                    final /* synthetic */ 8 this$1;
                    private final /* synthetic */ Frame val$frame;
                    private final /* synthetic */ Rectangle val$clientArea;
                    {
                        this.this$1 = var1_1;
                        this.val$frame = frame;
                        this.val$clientArea = rectangle;
                    }

                    public void run() {
                        this.val$frame.setSize(this.val$clientArea.width, this.val$clientArea.height);
                        this.val$frame.validate();
                        this.val$frame.setVisible(false);
                        this.val$frame.setVisible(true);
                    }
                });
            }
        });
        return frame;
    }

    public static Shell new_Shell(final Display display, final Canvas canvas) {
        if (display == null) {
            SWT.error(4);
        }
        if (canvas == null) {
            SWT.error(4);
        }
        long l = 0L;
        try {
            SWT_AWT.loadLibrary();
            l = SWT_AWT.getAWTHandle(canvas);
        }
        catch (Throwable throwable) {
            SWT.error(20, throwable);
        }
        if (l == 0L) {
            SWT.error(5, null, " [peer not created]");
        }
        final Shell shell = Shell.cocoa_new(display, l);
        final ComponentAdapter componentAdapter = new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                display.asyncExec(new Runnable(this, shell, canvas){
                    final /* synthetic */ 10 this$1;
                    private final /* synthetic */ Shell val$shell;
                    private final /* synthetic */ Canvas val$parent;
                    {
                        this.this$1 = var1_1;
                        this.val$shell = shell;
                        this.val$parent = canvas;
                    }

                    public void run() {
                        if (this.val$shell.isDisposed()) {
                            return;
                        }
                        Dimension dimension = this.val$parent.getSize();
                        this.val$shell.setSize(dimension.width, dimension.height);
                    }
                });
            }
        };
        canvas.addComponentListener(componentAdapter);
        shell.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                canvas.removeComponentListener(componentAdapter);
            }
        });
        shell.setVisible(true);
        return shell;
    }
}

