/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSControl;
import org.eclipse.swt.internal.cocoa.NSFileManager;
import org.eclipse.swt.internal.cocoa.NSMenu;
import org.eclipse.swt.internal.cocoa.NSMenuItem;
import org.eclipse.swt.internal.cocoa.NSOpenPanel;
import org.eclipse.swt.internal.cocoa.NSPopUpButton;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSResponder;
import org.eclipse.swt.internal.cocoa.NSSavePanel;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.SWTPanelDelegate;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FileDialog
extends Dialog {
    NSSavePanel panel;
    NSPopUpButton popup;
    String[] filterNames = new String[0];
    String[] filterExtensions = new String[0];
    String[] fileNames = new String[0];
    String filterPath = "";
    String fileName = "";
    int filterIndex = -1;
    boolean overwrite = false;
    static final char EXTENSION_SEPARATOR = ';';

    public FileDialog(Shell shell) {
        this(shell, 65536);
    }

    public FileDialog(Shell shell, int n) {
        super(shell, FileDialog.checkStyle(shell, n));
        if (Display.getSheetEnabled() && shell != null && (n & 0x10000000) != 0) {
            this.style |= 0x10000000;
        }
        this.checkSubclass();
    }

    public String getFileName() {
        return this.fileName;
    }

    public String[] getFileNames() {
        return this.fileNames;
    }

    public String[] getFilterExtensions() {
        return this.filterExtensions;
    }

    public int getFilterIndex() {
        return this.filterIndex;
    }

    public String[] getFilterNames() {
        return this.filterNames;
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public boolean getOverwrite() {
        return this.overwrite;
    }

    public String open() {
        Object object;
        Object object2;
        NSResponder nSResponder;
        NSSavePanel nSSavePanel;
        String string = null;
        this.fileNames = new String[0];
        long l = 0L;
        long l2 = 0L;
        Callback callback = null;
        if ((this.style & 0x2000) != 0) {
            this.panel = nSSavePanel = NSSavePanel.savePanel();
            if (!this.overwrite) {
                callback = new Callback(this, "_overwriteExistingFileCheck", 3);
                long l3 = callback.getAddress();
                if (l3 == 0L) {
                    this.error(3);
                }
                if ((l = OS.class_getInstanceMethod(OS.class_NSSavePanel, OS.sel_overwriteExistingFileCheck)) != 0L) {
                    l2 = OS.method_setImplementation(l, l3);
                }
            }
        } else {
            nSSavePanel = NSOpenPanel.openPanel();
            ((NSOpenPanel)nSSavePanel).setAllowsMultipleSelection((this.style & 2) != 0);
            this.panel = nSSavePanel;
        }
        this.panel.setCanCreateDirectories(true);
        OS.objc_msgSend(this.panel.id, OS.sel_setShowsHiddenFiles_, true);
        long l4 = 0L;
        SWTPanelDelegate sWTPanelDelegate = null;
        if (this.filterExtensions != null && this.filterExtensions.length != 0) {
            sWTPanelDelegate = (SWTPanelDelegate)new SWTPanelDelegate().alloc().init();
            l4 = OS.NewGlobalRef(this);
            if (l4 == 0L) {
                SWT.error(2);
            }
            OS.object_setInstanceVariable(sWTPanelDelegate.id, Display.SWT_OBJECT, l4);
            this.panel.setDelegate(sWTPanelDelegate);
            nSResponder = (NSPopUpButton)new NSPopUpButton().alloc();
            ((NSPopUpButton)nSResponder).initWithFrame(new NSRect(), false);
            ((NSControl)nSResponder).setTarget(sWTPanelDelegate);
            ((NSControl)nSResponder).setAction(OS.sel_sendSelection_);
            object2 = ((NSPopUpButton)nSResponder).menu();
            ((NSMenu)object2).setAutoenablesItems(false);
            int n = 0;
            while (n < this.filterExtensions.length) {
                object = this.filterExtensions[n];
                if (this.filterNames != null && this.filterNames.length > n) {
                    object = this.filterNames[n];
                }
                NSMenuItem nSMenuItem = (NSMenuItem)new NSMenuItem().alloc();
                nSMenuItem.initWithTitle(NSString.stringWith((String)object), 0L, NSString.string());
                ((NSMenu)object2).addItem(nSMenuItem);
                nSMenuItem.release();
                ++n;
            }
            ((NSPopUpButton)nSResponder).selectItemAtIndex(this.filterIndex >= 0 && this.filterIndex < this.filterExtensions.length ? this.filterIndex : 0);
            ((NSControl)nSResponder).sizeToFit();
            this.panel.setAccessoryView((NSView)nSResponder);
            this.popup = nSResponder;
        }
        this.panel.setTitle(NSString.stringWith(this.title != null ? this.title : ""));
        nSResponder = NSApplication.sharedApplication();
        if (this.parent != null && (this.style & 0x10000000) != 0) {
            ((NSApplication)nSResponder).beginSheet(this.panel, this.parent.view.window(), null, 0L, 0L);
        }
        object2 = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
        ((Display)object2).setModalDialog(this);
        NSString nSString = this.filterPath != null && this.filterPath.length() > 0 ? NSString.stringWith(this.filterPath) : null;
        object = this.fileName != null && this.fileName.length() > 0 ? NSString.stringWith(this.fileName) : null;
        long l5 = this.panel.runModalForDirectory(nSString, (NSString)object);
        if (this.parent != null && (this.style & 0x10000000) != 0) {
            ((NSApplication)nSResponder).endSheet(this.panel, 0L);
        }
        ((Display)object2).setModalDialog(null);
        if (!this.overwrite) {
            if (l != 0L) {
                OS.method_setImplementation(l, l2);
            }
            if (callback != null) {
                callback.dispose();
            }
        }
        this.filterIndex = this.popup != null ? (int)this.popup.indexOfSelectedItem() : -1;
        if (l5 == 1L) {
            NSString nSString2 = this.panel.filename();
            if ((this.style & 0x2000) != 0) {
                NSString nSString3;
                if (this.filterExtensions != null && this.filterExtensions.length != 0 && this.filterIndex >= 0 && this.filterIndex < this.filterExtensions.length && ((nSString3 = nSString2.pathExtension()) == null || nSString3.length() == 0L)) {
                    String string2;
                    String string3 = this.filterExtensions[this.filterIndex];
                    int n = string3.length();
                    int n2 = string3.indexOf(59);
                    if (n2 == -1) {
                        n2 = n;
                    }
                    if (!(string2 = string3.substring(0, n2).trim()).equals("*") && !string2.equals("*.*")) {
                        if (string2.startsWith("*.")) {
                            string2 = string2.substring(2);
                        }
                        nSString2 = nSString2.stringByAppendingPathExtension(NSString.stringWith(string2));
                    }
                }
                string = nSString2.getString();
                this.fileNames = new String[1];
                this.fileName = this.fileNames[0] = nSString2.lastPathComponent().getString();
                this.filterPath = nSString2.stringByDeletingLastPathComponent().getString();
            } else {
                string = nSString2.getString();
                NSArray nSArray = ((NSOpenPanel)this.panel).filenames();
                int n = (int)nSArray.count();
                this.fileNames = new String[n];
                int n3 = 0;
                while (n3 < n) {
                    nSString2 = new NSString(nSArray.objectAtIndex(n3));
                    NSString nSString4 = nSString2.lastPathComponent();
                    NSString nSString5 = nSString2.stringByDeletingLastPathComponent();
                    if (n3 == 0) {
                        this.filterPath = nSString5.getString();
                        this.fileName = this.fileNames[0] = nSString4.getString();
                    } else {
                        this.fileNames[n3] = nSString5.getString().equals(this.filterPath) ? nSString4.getString() : nSString2.getString();
                    }
                    ++n3;
                }
            }
        }
        if (this.popup != null) {
            this.panel.setAccessoryView(null);
            this.popup.release();
            this.popup = null;
        }
        if (sWTPanelDelegate != null) {
            this.panel.setDelegate(null);
            sWTPanelDelegate.release();
        }
        if (l4 != 0L) {
            OS.DeleteGlobalRef(l4);
        }
        this.panel = null;
        return string;
    }

    long _overwriteExistingFileCheck(long l, long l2, long l3) {
        return 1L;
    }

    long panel_shouldShowFilename(long l, long l2, long l3, long l4) {
        NSString nSString = new NSString(l4);
        if (this.filterExtensions != null && this.filterExtensions.length != 0) {
            NSFileManager nSFileManager = NSFileManager.defaultManager();
            long l5 = OS.malloc(1L);
            boolean bl = nSFileManager.fileExistsAtPath(nSString, l5);
            byte[] byArray = new byte[1];
            OS.memmove(byArray, l5, 1L);
            OS.free(l5);
            if (bl) {
                if (byArray[0] != 0) {
                    return 1L;
                }
                String string = nSString.lastPathComponent().getString();
                int n = (int)this.popup.indexOfSelectedItem();
                String string2 = this.filterExtensions[n];
                int n2 = 0;
                int n3 = string2.length();
                while (n2 < n3) {
                    String string3;
                    int n4 = string2.indexOf(59, n2);
                    if (n4 == -1) {
                        n4 = n3;
                    }
                    if ((string3 = string2.substring(n2, n4).trim()).equals("*") || string3.equals("*.*")) {
                        return 1L;
                    }
                    if (string3.startsWith("*.")) {
                        string3 = string3.substring(2);
                    }
                    if (string.toLowerCase().endsWith("." + string3.toLowerCase())) {
                        return 1L;
                    }
                    n2 = n4 + 1;
                }
                return 0L;
            }
        }
        return 1L;
    }

    void sendSelection(long l, long l2, long l3) {
        this.panel.validateVisibleColumns();
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setFilterExtensions(String[] stringArray) {
        this.filterExtensions = stringArray;
    }

    public void setFilterIndex(int n) {
        this.filterIndex = n;
    }

    public void setFilterNames(String[] stringArray) {
        this.filterNames = stringArray;
    }

    public void setFilterPath(String string) {
        this.filterPath = string;
    }

    public void setOverwrite(boolean bl) {
        this.overwrite = bl;
    }
}

