/*
 * Decompiled with CFR 0.152.
 */
package fan.sys;

import fan.sys.ArgErr;
import fan.sys.ClassType;
import fan.sys.Duration;
import fan.sys.Env;
import fan.sys.FanClassLoader;
import fan.sys.File;
import fan.sys.Func;
import fan.sys.InStream;
import fan.sys.List;
import fan.sys.LocalFile;
import fan.sys.Map;
import fan.sys.NotImmutableErr;
import fan.sys.OutStream;
import fan.sys.Pod;
import fan.sys.Sys;
import fan.sys.SysInStream;
import fan.sys.SysOutStream;
import fan.sys.Type;
import fan.sys.UnresolvedErr;
import fan.sys.Uri;
import fanx.emit.FPodEmit;
import fanx.emit.FTypeEmit;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.net.InetAddress;
import java.util.HashMap;

public class BootEnv
extends Env {
    private List args;
    private final Map vars;
    private final String host;
    private final String user;
    private final InStream in;
    private final OutStream out;
    private final OutStream err;
    private final File homeDir;
    private final File tempDir;
    private final HashMap shutdownHooks = new HashMap();

    public BootEnv() {
        this.args = BootEnv.initArgs();
        this.vars = BootEnv.initVars();
        this.host = BootEnv.initHost();
        this.user = BootEnv.initUser();
        this.in = new SysInStream(System.in);
        this.out = new SysOutStream(System.out);
        this.err = new SysOutStream(System.err);
        this.homeDir = new LocalFile(Sys.homeDir, true).normalize();
        this.tempDir = this.homeDir.plus(Uri.fromStr("temp/"), false);
    }

    private static List initArgs() {
        return (List)new List(Sys.StrType).toImmutable();
    }

    private static Map initVars() {
        Map map = new Map(Sys.StrType, Sys.StrType);
        try {
            String string;
            map.caseInsensitive(true);
            java.util.Map<String, String> map2 = System.getenv();
            for (String string2 : map2.keySet()) {
                string = map2.get(string2);
                map.set(string2, string);
            }
            for (String string2 : System.getProperties().keySet()) {
                string = System.getProperty(string2);
                map.set(string2, string);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return (Map)map.toImmutable();
    }

    private static String initHost() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Throwable throwable) {
            return "unknown";
        }
    }

    private static String initUser() {
        return System.getProperty("user.name", "unknown");
    }

    public void setArgs(String[] stringArray) {
        this.args = (List)new List(Sys.StrType, stringArray).toImmutable();
    }

    public Type typeof() {
        return Sys.BootEnvType;
    }

    public List args() {
        return this.args;
    }

    public Map vars() {
        return this.vars;
    }

    public String host() {
        return this.host;
    }

    public String user() {
        return this.user;
    }

    public void gc() {
        System.gc();
    }

    public InStream in() {
        return this.in;
    }

    public OutStream out() {
        return this.out;
    }

    public OutStream err() {
        return this.err;
    }

    public String promptPassword(String string) {
        char[] cArray = System.console().readPassword(string, new Object[0]);
        if (cArray == null) {
            return null;
        }
        return new String(cArray);
    }

    public File homeDir() {
        return this.homeDir;
    }

    public File workDir() {
        return this.homeDir;
    }

    public File tempDir() {
        return this.tempDir;
    }

    public void exit(long l) {
        System.exit((int)l);
    }

    public void addShutdownHook(Func func) {
        if (!func.isImmutable()) {
            throw NotImmutableErr.make();
        }
        ShutdownHookThread shutdownHookThread = new ShutdownHookThread(func);
        this.shutdownHooks.put(func, shutdownHookThread);
        Runtime.getRuntime().addShutdownHook(shutdownHookThread);
    }

    public boolean removeShutdownHook(Func func) {
        Thread thread = (Thread)this.shutdownHooks.get(func);
        if (thread == null) {
            return false;
        }
        return Runtime.getRuntime().removeShutdownHook(thread);
    }

    public Map diagnostics() {
        Map map = new Map(Sys.StrType, Sys.ObjType);
        MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
        map.add("mem.heap", memoryMXBean.getHeapMemoryUsage().getUsed());
        map.add("mem.nonHeap", memoryMXBean.getNonHeapMemoryUsage().getUsed());
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        long[] lArray = threadMXBean.getAllThreadIds();
        map.add("thread.size", lArray.length);
        for (int i = 0; i < lArray.length; ++i) {
            ThreadInfo threadInfo = threadMXBean.getThreadInfo(lArray[i]);
            map.add("thread." + i + ".name", threadInfo.getThreadName());
            map.add("thread." + i + ".state", threadInfo.getThreadState().toString());
            map.add("thread." + i + ".cpuTime", Duration.make(threadMXBean.getThreadCpuTime(lArray[i])));
        }
        ClassLoadingMXBean classLoadingMXBean = ManagementFactory.getClassLoadingMXBean();
        map.add("classes.loaded", classLoadingMXBean.getLoadedClassCount());
        map.add("classes.total", classLoadingMXBean.getTotalLoadedClassCount());
        map.add("classes.unloaded", classLoadingMXBean.getUnloadedClassCount());
        return map;
    }

    public File findFile(Uri uri, boolean bl) {
        if (uri.isPathAbs()) {
            throw ArgErr.make("Uri must be relative: " + uri);
        }
        File file = this.homeDir.plus(uri, false);
        if (file.exists()) {
            return file;
        }
        if (!bl) {
            return null;
        }
        throw UnresolvedErr.make("File not found in Env: " + uri);
    }

    public List findAllFiles(Uri uri) {
        File file = this.findFile(uri, false);
        if (file == null) {
            return Sys.FileType.emptyList();
        }
        return new List(Sys.FileType, new File[]{file});
    }

    public Class loadPodClass(Pod pod) {
        try {
            FPodEmit fPodEmit = FPodEmit.emit(pod.fpod);
            return pod.classLoader.loadFan(fPodEmit.className.replace('/', '.'), fPodEmit.classFile);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception.toString());
        }
    }

    public Class[] loadTypeClasses(ClassType classType) {
        try {
            FTypeEmit[] fTypeEmitArray = FTypeEmit.emit(classType, classType.ftype);
            Class[] classArray = new Class[fTypeEmitArray.length];
            for (int i = 0; i < fTypeEmitArray.length; ++i) {
                FTypeEmit fTypeEmit = fTypeEmitArray[i];
                classArray[i] = classType.pod().classLoader.loadFan(fTypeEmit.className.replace('/', '.'), fTypeEmit.classFile);
            }
            return classArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RuntimeException(exception.toString());
        }
    }

    public Class loadJavaClass(String string) throws Exception {
        if (string.charAt(0) == '[' && string.length() == 2) {
            switch (string.charAt(1)) {
                case 'Z': {
                    return boolean[].class;
                }
                case 'B': {
                    return byte[].class;
                }
                case 'S': {
                    return short[].class;
                }
                case 'I': {
                    return int[].class;
                }
                case 'J': {
                    return long[].class;
                }
                case 'F': {
                    return float[].class;
                }
                case 'D': {
                    return double[].class;
                }
            }
        }
        return FanClassLoader.extClassLoader.loadClass(string);
    }

    static class ShutdownHookThread
    extends Thread {
        private final Func func;

        ShutdownHookThread(Func func) {
            this.func = func;
        }

        public void run() {
            try {
                this.func.call();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }
}

