/*
 * Decompiled with CFR 0.152.
 */
package fan.sys;

import fan.sys.Env;
import fan.sys.FanNum;
import fan.sys.Locale;
import fan.sys.NumDigits;
import fan.sys.NumPattern;
import fan.sys.ParseErr;
import fan.sys.Sys;
import fan.sys.Type;
import fanx.serial.ObjEncoder;
import java.math.BigDecimal;
import java.text.DecimalFormatSymbols;

public final class FanDecimal {
    public static BigDecimal defVal = BigDecimal.ZERO;

    public static BigDecimal fromStr(String string) {
        return FanDecimal.fromStr(string, true);
    }

    public static BigDecimal fromStr(String string, boolean bl) {
        try {
            return new BigDecimal(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (!bl) {
                return null;
            }
            throw ParseErr.make("Decimal", string);
        }
    }

    public static boolean equals(BigDecimal bigDecimal, Object object) {
        if (object instanceof BigDecimal) {
            return bigDecimal.equals(object);
        }
        return false;
    }

    public static long compare(BigDecimal bigDecimal, Object object) {
        return bigDecimal.compareTo((BigDecimal)object);
    }

    public static long hash(BigDecimal bigDecimal) {
        return bigDecimal.hashCode();
    }

    public static Type typeof() {
        return Sys.DecimalType;
    }

    public static BigDecimal negate(BigDecimal bigDecimal) {
        return bigDecimal.negate();
    }

    public static BigDecimal increment(BigDecimal bigDecimal) {
        return bigDecimal.add(BigDecimal.ONE);
    }

    public static BigDecimal decrement(BigDecimal bigDecimal) {
        return bigDecimal.subtract(BigDecimal.ONE);
    }

    public static BigDecimal mult(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        return bigDecimal.multiply(bigDecimal2);
    }

    public static BigDecimal multInt(BigDecimal bigDecimal, long l) {
        return bigDecimal.multiply(BigDecimal.valueOf(l));
    }

    public static BigDecimal multFloat(BigDecimal bigDecimal, double d) {
        return bigDecimal.multiply(BigDecimal.valueOf(d));
    }

    public static BigDecimal div(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        return bigDecimal.divide(bigDecimal2);
    }

    public static BigDecimal divInt(BigDecimal bigDecimal, long l) {
        return bigDecimal.divide(BigDecimal.valueOf(l));
    }

    public static BigDecimal divFloat(BigDecimal bigDecimal, double d) {
        return bigDecimal.divide(BigDecimal.valueOf(d));
    }

    public static BigDecimal mod(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        return bigDecimal.remainder(bigDecimal2);
    }

    public static BigDecimal modInt(BigDecimal bigDecimal, long l) {
        return bigDecimal.remainder(BigDecimal.valueOf(l));
    }

    public static BigDecimal modFloat(BigDecimal bigDecimal, double d) {
        return bigDecimal.remainder(BigDecimal.valueOf(d));
    }

    public static BigDecimal plus(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        return bigDecimal.add(bigDecimal2);
    }

    public static BigDecimal plusInt(BigDecimal bigDecimal, long l) {
        return bigDecimal.add(BigDecimal.valueOf(l));
    }

    public static BigDecimal plusFloat(BigDecimal bigDecimal, double d) {
        return bigDecimal.add(BigDecimal.valueOf(d));
    }

    public static BigDecimal minus(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        return bigDecimal.subtract(bigDecimal2);
    }

    public static BigDecimal minusInt(BigDecimal bigDecimal, long l) {
        return bigDecimal.subtract(BigDecimal.valueOf(l));
    }

    public static BigDecimal minusFloat(BigDecimal bigDecimal, double d) {
        return bigDecimal.subtract(BigDecimal.valueOf(d));
    }

    public static BigDecimal abs(BigDecimal bigDecimal) {
        return bigDecimal.abs();
    }

    public static BigDecimal min(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        if (bigDecimal.compareTo(bigDecimal2) <= 0) {
            return bigDecimal;
        }
        return bigDecimal2;
    }

    public static BigDecimal max(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        if (bigDecimal.compareTo(bigDecimal2) >= 0) {
            return bigDecimal;
        }
        return bigDecimal2;
    }

    public static String toStr(BigDecimal bigDecimal) {
        return bigDecimal.toString();
    }

    public static void encode(BigDecimal bigDecimal, ObjEncoder objEncoder) {
        objEncoder.w(bigDecimal.toString()).w("d");
    }

    public static String toCode(BigDecimal bigDecimal) {
        return bigDecimal.toString() + "d";
    }

    public static String toLocale(BigDecimal bigDecimal) {
        return FanDecimal.toLocale(bigDecimal, null);
    }

    public static String toLocale(BigDecimal bigDecimal, String string) {
        Locale locale = Locale.cur();
        DecimalFormatSymbols decimalFormatSymbols = locale.decimal();
        if (string == null) {
            string = Env.cur().locale(Sys.sysPod, "decimal", "#,###.0##");
        }
        NumPattern numPattern = NumPattern.parse(string);
        NumDigits numDigits = new NumDigits(bigDecimal);
        return FanNum.toLocale(numPattern, numDigits, decimalFormatSymbols);
    }
}

