/*
 * Decompiled with CFR 0.152.
 */
package fan.sys;

import fan.sys.ArgErr;
import fan.sys.FanObj;
import fan.sys.FanStr;
import fan.sys.Func;
import fan.sys.List;
import fan.sys.MapType;
import fan.sys.NotImmutableErr;
import fan.sys.NullErr;
import fan.sys.ReadonlyErr;
import fan.sys.Sys;
import fan.sys.Type;
import fan.sys.UnsupportedErr;
import fanx.serial.Literal;
import fanx.serial.ObjEncoder;
import fanx.util.OpUtil;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public final class Map
extends FanObj
implements Literal {
    private MapType type;
    private HashMap map;
    private Map readonlyMap;
    private boolean readonly;
    private boolean immutable;
    private Object def;

    public static Map make(Type type) {
        return new Map((MapType)type, new HashMap());
    }

    public Map(Type type, Type type2) {
        this(new MapType(type, type2), new HashMap());
    }

    public Map(MapType mapType) {
        this(mapType, new HashMap());
    }

    public Map(MapType mapType, HashMap hashMap) {
        if (mapType == null || hashMap == null) {
            Thread.dumpStack();
            throw NullErr.make();
        }
        this.type = mapType;
        this.map = hashMap;
    }

    public final Type typeof() {
        return this.type;
    }

    public final boolean isEmpty() {
        return this.map.size() == 0;
    }

    public final long size() {
        return this.map.size();
    }

    public final Object get(Object object) {
        Object v = this.map.get(object);
        if (v != null) {
            return v;
        }
        if (this.def == null) {
            return null;
        }
        return this.map.containsKey(object) ? null : this.def;
    }

    public final Object get(Object object, Object object2) {
        Object v = this.map.get(object);
        if (v != null) {
            return v;
        }
        if (object2 == null) {
            return null;
        }
        return this.map.containsKey(object) ? null : object2;
    }

    public final boolean containsKey(Object object) {
        return this.map.containsKey(object);
    }

    public final List keys() {
        Object[] objectArray = new Object[this.map.size()];
        Iterator iterator = this.pairsIterator();
        int n = 0;
        while (iterator.hasNext()) {
            objectArray[n] = ((Map.Entry)iterator.next()).getKey();
            ++n;
        }
        return new List(this.type.k, objectArray);
    }

    public final List vals() {
        return new List(this.type.v, this.map.values());
    }

    public final Map set(Object object, Object object2) {
        this.modify();
        if (object == null) {
            throw NullErr.make("key is null");
        }
        if (!Map.isImmutable(object)) {
            throw NotImmutableErr.make("key is not immutable: " + Map.typeof(object));
        }
        this.map.put(object, object2);
        return this;
    }

    public final Map add(Object object, Object object2) {
        this.modify();
        if (object == null) {
            throw NullErr.make("key is null");
        }
        if (!Map.isImmutable(object)) {
            throw NotImmutableErr.make("key is not immutable: " + Map.typeof(object));
        }
        if (this.map.containsKey(object)) {
            throw ArgErr.make("Key already mapped: " + object);
        }
        this.map.put(object, object2);
        return this;
    }

    public final Object getOrAdd(Object object, Func func) {
        if (this.map.containsKey(object)) {
            return this.map.get(object);
        }
        Object object2 = func.call(object);
        this.add(object, object2);
        return object2;
    }

    public final Map setAll(Map map) {
        this.modify();
        Iterator iterator = map.pairsIterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            this.map.put(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public final Map addAll(Map map) {
        this.modify();
        Iterator iterator = map.pairsIterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            this.add(entry.getKey(), entry.getValue());
        }
        return this;
    }

    public final Map setList(List list) {
        return this.setList(list, null);
    }

    public final Map setList(List list, Func func) {
        this.modify();
        if (func == null) {
            for (int i = 0; i < list.sz(); ++i) {
                this.set(list.get(i), list.get(i));
            }
        } else if (func.arity() == 1L) {
            for (int i = 0; i < list.sz(); ++i) {
                this.set(func.call(list.get(i)), list.get(i));
            }
        } else {
            for (int i = 0; i < list.sz(); ++i) {
                this.set(func.call(list.get(i), i), list.get(i));
            }
        }
        return this;
    }

    public final Map addList(List list) {
        return this.addList(list, null);
    }

    public final Map addList(List list, Func func) {
        this.modify();
        if (func == null) {
            for (int i = 0; i < list.sz(); ++i) {
                this.add(list.get(i), list.get(i));
            }
        } else if (func.arity() == 1L) {
            for (int i = 0; i < list.sz(); ++i) {
                this.add(func.call(list.get(i)), list.get(i));
            }
        } else {
            for (int i = 0; i < list.sz(); ++i) {
                this.add(func.call(list.get(i), i), list.get(i));
            }
        }
        return this;
    }

    public final Object remove(Object object) {
        this.modify();
        return this.map.remove(object);
    }

    public final Map dup() {
        Map map = new Map(this.type);
        map.map = (HashMap)this.map.clone();
        return map;
    }

    public final Map clear() {
        this.modify();
        this.map.clear();
        return this;
    }

    public final boolean caseInsensitive() {
        return this.map instanceof CIHashMap;
    }

    public final void caseInsensitive(boolean bl) {
        this.modify();
        if (this.type.k != Sys.StrType) {
            throw UnsupportedErr.make("Map not keyed by Str: " + this.type);
        }
        if (this.map.size() != 0) {
            throw UnsupportedErr.make("Map not empty");
        }
        if (bl && this.ordered()) {
            throw UnsupportedErr.make("Map cannot be caseInsensitive and ordered");
        }
        if (this.caseInsensitive() == bl) {
            return;
        }
        this.map = bl ? new CIHashMap() : new HashMap();
    }

    public final boolean ordered() {
        return this.map instanceof LinkedHashMap;
    }

    public final void ordered(boolean bl) {
        this.modify();
        if (this.map.size() != 0) {
            throw UnsupportedErr.make("Map not empty");
        }
        if (bl && this.caseInsensitive()) {
            throw UnsupportedErr.make("Map cannot be caseInsensitive and ordered");
        }
        if (this.ordered() == bl) {
            return;
        }
        this.map = bl ? new LinkedHashMap() : new HashMap();
    }

    public final Object def() {
        return this.def;
    }

    public final void def(Object object) {
        this.modify();
        if (object != null && !Map.isImmutable(object)) {
            throw NotImmutableErr.make("def must be immutable: " + Map.typeof(object));
        }
        this.def = object;
    }

    public final boolean equals(Object object) {
        if (object instanceof Map) {
            return this.type.equals(Map.typeof(object)) && this.map.equals(((Map)object).map);
        }
        return false;
    }

    public final long hash() {
        return this.map.hashCode();
    }

    public final String toStr() {
        if (this.map.size() == 0) {
            return "[:]";
        }
        StringBuilder stringBuilder = new StringBuilder(32 + this.map.size() * 32);
        stringBuilder.append("[");
        boolean bl = true;
        Iterator iterator = this.pairsIterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            if (!bl) {
                stringBuilder.append(", ");
            } else {
                bl = false;
            }
            stringBuilder.append(entry.getKey()).append(':').append(entry.getValue());
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public final void encode(ObjEncoder objEncoder) {
        objEncoder.writeMap(this);
    }

    public final void each(Func func) {
        Iterator iterator = this.pairsIterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            func.call(entry.getValue(), entry.getKey());
        }
    }

    public final Object eachWhile(Func func) {
        Iterator iterator = this.pairsIterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Object object = func.call(entry.getValue(), entry.getKey());
            if (object == null) continue;
            return object;
        }
        return null;
    }

    public final Object find(Func func) {
        Iterator iterator = this.pairsIterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Object k = entry.getKey();
            Object v = entry.getValue();
            if (!func.callBool(v, k)) continue;
            return v;
        }
        return null;
    }

    public final Map findAll(Func func) {
        Map map = new Map(this.type);
        Iterator iterator = this.pairsIterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Object k = entry.getKey();
            Object v = entry.getValue();
            if (!func.callBool(v, k)) continue;
            map.set(k, v);
        }
        return map;
    }

    public final Map exclude(Func func) {
        Map map = new Map(this.type);
        Iterator iterator = this.pairsIterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Object k = entry.getKey();
            Object v = entry.getValue();
            if (func.callBool(v, k)) continue;
            map.set(k, v);
        }
        return map;
    }

    public final boolean any(Func func) {
        if (this.map.size() == 0) {
            return false;
        }
        Iterator iterator = this.pairsIterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Object k = entry.getKey();
            Object v = entry.getValue();
            if (!func.callBool(v, k)) continue;
            return true;
        }
        return false;
    }

    public final boolean all(Func func) {
        if (this.map.size() == 0) {
            return true;
        }
        Iterator iterator = this.pairsIterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Object k = entry.getKey();
            Object v = entry.getValue();
            if (func.callBool(v, k)) continue;
            return false;
        }
        return true;
    }

    public final Object reduce(Object object, Func func) {
        Iterator iterator = this.pairsIterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Object k = entry.getKey();
            Object v = entry.getValue();
            object = func.call(object, v, k);
        }
        return object;
    }

    public final Map map(Func func) {
        Type type = func.returns();
        if (type == Sys.VoidType) {
            type = Sys.ObjType.toNullable();
        }
        Map map = new Map(this.type.k, type);
        if (this.ordered()) {
            map.ordered(true);
        }
        if (this.caseInsensitive()) {
            map.caseInsensitive(true);
        }
        Iterator iterator = this.pairsIterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Object k = entry.getKey();
            Object v = entry.getValue();
            map.set(k, func.call(v, k));
        }
        return map;
    }

    public final String join(String string) {
        return this.join(string, null);
    }

    public final String join(String string, Func func) {
        int n = (int)this.size();
        if (n == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(32 + n * 32);
        Iterator iterator = this.pairsIterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Object k = entry.getKey();
            Object v = entry.getValue();
            if (stringBuilder.length() > 0) {
                stringBuilder.append(string);
            }
            if (func == null) {
                stringBuilder.append(k).append(": ").append(v);
                continue;
            }
            stringBuilder.append(func.call(v, k));
        }
        return stringBuilder.toString();
    }

    public final String toCode() {
        int n = (int)this.size();
        StringBuilder stringBuilder = new StringBuilder(32 + n * 32);
        stringBuilder.append(this.type.signature());
        stringBuilder.append('[');
        if (n == 0) {
            stringBuilder.append(':');
        }
        Iterator iterator = this.pairsIterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Object k = entry.getKey();
            Object v = entry.getValue();
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(',').append(' ');
            }
            stringBuilder.append(FanObj.trap(k, "toCode", null)).append(':').append(FanObj.trap(v, "toCode", null));
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public final boolean isRW() {
        return !this.readonly;
    }

    public final boolean isRO() {
        return this.readonly;
    }

    public final Map rw() {
        if (!this.readonly) {
            return this;
        }
        Map map = new Map(this.type);
        map.map = (HashMap)this.map.clone();
        map.readonly = false;
        map.readonlyMap = this;
        map.def = this.def;
        return map;
    }

    public final Map ro() {
        if (this.readonly) {
            return this;
        }
        if (this.readonlyMap == null) {
            Map map = new Map(this.type);
            map.map = this.map;
            map.def = this.def;
            map.readonly = true;
            this.readonlyMap = map;
        }
        return this.readonlyMap;
    }

    public final boolean isImmutable() {
        return this.immutable;
    }

    public final Object toImmutable() {
        Object object;
        if (this.immutable) {
            return this;
        }
        HashMap hashMap = this.caseInsensitive() ? new CIHashMap(this.map.size() * 2 + 3) : (this.ordered() ? new LinkedHashMap(this.map.size() * 2 + 3) : new HashMap(this.map.size() * 2 + 3));
        Iterator iterator = this.pairsIterator();
        while (iterator.hasNext()) {
            object = (Map.Entry)iterator.next();
            Object k = object.getKey();
            Object object2 = object.getValue();
            if (object2 != null) {
                object2 = FanObj.toImmutable(object2);
            }
            hashMap.put(k, object2);
        }
        object = new Map(this.type, hashMap);
        ((Map)object).readonly = true;
        ((Map)object).immutable = true;
        ((Map)object).def = this.def;
        return object;
    }

    private void modify() {
        if (this.readonly) {
            throw ReadonlyErr.make("Map is readonly");
        }
        if (this.readonlyMap != null) {
            this.readonlyMap.map = (HashMap)this.map.clone();
            this.readonlyMap = null;
        }
    }

    public int sz() {
        return this.map.size();
    }

    public Iterator pairsIterator() {
        if (this.map instanceof CIHashMap) {
            return ((CIHashMap)this.map).pairs().iterator();
        }
        return this.map.entrySet().iterator();
    }

    public Iterator keysIterator() {
        return this.map.keySet().iterator();
    }

    public HashMap toJava() {
        this.modify();
        return this.map;
    }

    static final class CIKey {
        final String key;
        final int hash;

        CIKey(String string) {
            this.key = string;
            this.hash = FanStr.caseInsensitiveHash(string);
        }

        public final int hashCode() {
            return this.hash;
        }

        public final boolean equals(Object object) {
            return FanStr.equalsIgnoreCase(this.key, ((CIKey)object).key);
        }

        public final String toString() {
            return this.key;
        }
    }

    static final class CIEntry
    implements Map.Entry {
        String key;
        Object val;

        CIEntry() {
        }

        public void set(Map.Entry entry) {
            this.key = ((CIKey)entry.getKey()).key;
            this.val = entry.getValue();
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.val;
        }

        public int hashCode() {
            return this.key.hashCode() ^ (this.val == null ? 0 : this.val.hashCode());
        }

        public boolean equals(Object object) {
            throw new UnsupportedOperationException();
        }

        public Object setValue(Object object) {
            throw new UnsupportedOperationException();
        }
    }

    static final class CIPairsIterator
    implements Iterator {
        Iterator it;
        CIEntry entry = new CIEntry();

        CIPairsIterator(Iterator iterator) {
            this.it = iterator;
        }

        public boolean hasNext() {
            return this.it.hasNext();
        }

        public Object next() {
            this.entry.set((Map.Entry)this.it.next());
            return this.entry;
        }

        public void remove() {
            this.it.remove();
        }
    }

    static final class CIPairs
    extends AbstractSet {
        Set set;

        CIPairs(Set set) {
            this.set = set;
        }

        public int size() {
            return this.set.size();
        }

        public Iterator iterator() {
            return new CIPairsIterator(this.set.iterator());
        }
    }

    static class CIHashMap
    extends HashMap {
        public CIHashMap() {
        }

        public CIHashMap(int n) {
            super(n);
        }

        public Object get(Object object) {
            return super.get(new CIKey((String)object));
        }

        public boolean containsKey(Object object) {
            return super.containsKey(new CIKey((String)object));
        }

        public Object put(Object object, Object object2) {
            return super.put(new CIKey((String)object), object2);
        }

        public Object remove(Object object) {
            return super.remove(new CIKey((String)object));
        }

        public Set keySet() {
            throw new UnsupportedOperationException();
        }

        public Set pairs() {
            return new CIPairs(this.entrySet());
        }

        public int hashCode() {
            int n = 0;
            Iterator iterator = this.pairs().iterator();
            while (iterator.hasNext()) {
                n += iterator.next().hashCode();
            }
            return n;
        }

        public boolean equals(Object object) {
            if (!(object instanceof HashMap)) {
                return false;
            }
            HashMap hashMap = (HashMap)object;
            if (this.size() != hashMap.size()) {
                return false;
            }
            for (CIEntry cIEntry : this.pairs()) {
                Object v = hashMap.get(cIEntry.key);
                if (OpUtil.compareEQ(cIEntry.val, v)) continue;
                return false;
            }
            return true;
        }
    }
}

