/*
 * Decompiled with CFR 0.152.
 */
package fan.sys;

import fan.sys.BootEnv;
import fan.sys.ClassType;
import fan.sys.DateTime;
import fan.sys.Duration;
import fan.sys.Env;
import fan.sys.FanObj;
import fan.sys.FanStr;
import fan.sys.JarDistEnv;
import fan.sys.List;
import fan.sys.LocalFile;
import fan.sys.Map;
import fan.sys.MemBuf;
import fan.sys.Pod;
import fan.sys.Type;
import java.io.File;

public final class Sys {
    public static final String os = Sys.initOs();
    public static final String arch = Sys.initArch();
    public static final String platform = os + "-" + arch;
    public static final boolean isJarDist = Sys.initIsJarDist();
    public static final File homeDir = Sys.initHomeDir();
    public static final File podsDir = Sys.initPodsDir();
    public static final Pod sysPod = Sys.initSysPod();
    public static final Type ObjType = Sys.initType("Obj");
    public static final Type NumType = Sys.initType("Num");
    public static final Type EnumType = Sys.initType("Enum");
    public static final Type FacetType = Sys.initType("Facet");
    public static final Type BoolType = Sys.initType("Bool");
    public static final Type DurationType = Sys.initType("Duration");
    public static final Type FuncType = Sys.initType("Func");
    public static final Type IntType = Sys.initType("Int");
    public static final Type DecimalType = Sys.initType("Decimal");
    public static final Type FloatType = Sys.initType("Float");
    public static final Type ListType = Sys.initType("List");
    public static final Type MapType = Sys.initType("Map");
    public static final Type MonthType = Sys.initType("Month");
    public static final Type PodType = Sys.initType("Pod");
    public static final Type RangeType = Sys.initType("Range");
    public static final Type StrType = Sys.initType("Str");
    public static final Type StrBufType = Sys.initType("StrBuf");
    public static final Type TestType = Sys.initType("Test");
    public static final Type DateTimeType = Sys.initType("DateTime");
    public static final Type DateType = Sys.initType("Date");
    public static final Type TimeType = Sys.initType("Time");
    public static final Type TimeZoneType = Sys.initType("TimeZone");
    public static final Type TypeType = Sys.initType("Type");
    public static final Type WeekdayType = Sys.initType("Weekday");
    public static final Type ThisType = Sys.initType("This");
    public static final Type VoidType = Sys.initType("Void");
    public static final Type EnvType = Sys.initType("Env");
    public static final Type BootEnvType = Sys.initType("BootEnv");
    public static final Type JarDistEnvType = Sys.initType("JarDistEnv");
    public static final Type SlotType = Sys.initType("Slot");
    public static final Type FieldType = Sys.initType("Field");
    public static final Type MethodType = Sys.initType("Method");
    public static final Type ParamType = Sys.initType("Param");
    public static final Type CharsetType = Sys.initType("Charset");
    public static final Type EndianType = Sys.initType("Endian");
    public static final Type InStreamType = Sys.initType("InStream");
    public static final Type SysInStreamType = Sys.initType("SysInStream");
    public static final Type OutStreamType = Sys.initType("OutStream");
    public static final Type SysOutStreamType = Sys.initType("SysOutStream");
    public static final Type FileType = Sys.initType("File");
    public static final Type LocalFileType = Sys.initType("LocalFile");
    public static final Type ZipEntryFileType = Sys.initType("ZipEntryFile");
    public static final Type BufType = Sys.initType("Buf");
    public static final Type MemBufType = Sys.initType("MemBuf");
    public static final Type FileBufType = Sys.initType("FileBuf");
    public static final Type MmapBufType = Sys.initType("MmapBuf");
    public static final Type UriType = Sys.initType("Uri");
    public static final Type ZipType = Sys.initType("Zip");
    public static final Type ClassLoaderFileType = Sys.initType("ClassLoaderFile");
    public static final Type DependType = Sys.initType("Depend");
    public static final Type LogType = Sys.initType("Log");
    public static final Type LogLevelType = Sys.initType("LogLevel");
    public static final Type LogRecType = Sys.initType("LogRec");
    public static final Type LocaleType = Sys.initType("Locale");
    public static final Type MimeTypeType = Sys.initType("MimeType");
    public static final Type ProcessType = Sys.initType("Process");
    public static final Type RegexType = Sys.initType("Regex");
    public static final Type RegexMatcherType = Sys.initType("RegexMatcher");
    public static final Type ServiceType = Sys.initType("Service");
    public static final Type VersionType = Sys.initType("Version");
    public static final Type UnitType = Sys.initType("Unit");
    public static final Type UnsafeType = Sys.initType("Unsafe");
    public static final Type UuidType = Sys.initType("Uuid");
    public static final Type UriSchemeType = Sys.initType("UriScheme");
    public static final Type FanSchemeType = Sys.initType("FanScheme");
    public static final Type FileSchemeType = Sys.initType("FileScheme");
    public static final Type TransientType = Sys.initType("Transient");
    public static final Type SerializableType = Sys.initType("Serializable");
    public static final Type JsType = Sys.initType("Js");
    public static final Type NoDocType = Sys.initType("NoDoc");
    public static final Type DeprecatedType = Sys.initType("Deprecated");
    public static final Type OperatorType = Sys.initType("Operator");
    public static final Type FacetMetaType = Sys.initType("FacetMeta");
    public static final Type ErrType = Sys.initType("Err");
    public static final Type ArgErrType = Sys.initType("ArgErr");
    public static final Type CancelledErrType = Sys.initType("CancelledErr");
    public static final Type CastErrType = Sys.initType("CastErr");
    public static final Type ConstErrType = Sys.initType("ConstErr");
    public static final Type FieldNotSetErrType = Sys.initType("FieldNotSetErr");
    public static final Type IOErrType = Sys.initType("IOErr");
    public static final Type IndexErrType = Sys.initType("IndexErr");
    public static final Type InterruptedErrType = Sys.initType("InterruptedErr");
    public static final Type NameErrType = Sys.initType("NameErr");
    public static final Type NotImmutableErrType = Sys.initType("NotImmutableErr");
    public static final Type NullErrType = Sys.initType("NullErr");
    public static final Type ParseErrType = Sys.initType("ParseErr");
    public static final Type ReadonlyErrType = Sys.initType("ReadonlyErr");
    public static final Type TestErrType = Sys.initType("TestErr");
    public static final Type TimeoutErrType = Sys.initType("TimeoutErr");
    public static final Type UnknownPodErrType = Sys.initType("UnknownPodErr");
    public static final Type UnknownServiceErrType = Sys.initType("UnknownServiceErr");
    public static final Type UnknownSlotErrType = Sys.initType("UnknownSlotErr");
    public static final Type UnknownFacetErrType = Sys.initType("UnknownFacetErr");
    public static final Type UnknownTypeErrType = Sys.initType("UnknownTypeErr");
    public static final Type UnresolvedErrType = Sys.initType("UnresolvedErr");
    public static final Type UnsupportedErrType = Sys.initType("UnsupportedErr");
    static final ClassType[] genericParamTypes = new ClassType[256];
    public static final ClassType AType = Sys.initGeneric(65);
    public static final ClassType BType = Sys.initGeneric(66);
    public static final ClassType CType = Sys.initGeneric(67);
    public static final ClassType DType = Sys.initGeneric(68);
    public static final ClassType EType = Sys.initGeneric(69);
    public static final ClassType FType = Sys.initGeneric(70);
    public static final ClassType GType = Sys.initGeneric(71);
    public static final ClassType HType = Sys.initGeneric(72);
    public static final ClassType KType = Sys.initGeneric(75);
    public static final ClassType LType = Sys.initGeneric(76);
    public static final ClassType MType = Sys.initGeneric(77);
    public static final ClassType RType = Sys.initGeneric(82);
    public static final ClassType VType = Sys.initGeneric(86);
    public static final Map emptyStrObjMap;
    public static final Map emptyStrStrMap;
    public static final Map emptyStrTypeMap;
    public static final BootEnv bootEnv;
    static Env curEnv;
    public static final Map sysConfig;
    public static final boolean debug;
    public static final DateTime bootDateTime;
    public static final Duration bootDuration;

    private static String initOs() {
        try {
            String string = System.getProperty("os.name", "unknown");
            string = Sys.sanitize(string);
            if (string.contains("win")) {
                return "win32";
            }
            if (string.contains("mac")) {
                return "macosx";
            }
            if (string.contains("sunos")) {
                return "solaris";
            }
            return string;
        }
        catch (Throwable throwable) {
            throw Sys.initFail("os", throwable);
        }
    }

    private static String initArch() {
        try {
            String string = System.getProperty("os.arch", "unknown");
            string = Sys.sanitize(string);
            if (string.contains("i386")) {
                return "x86";
            }
            if (string.contains("amd64")) {
                return "x86_64";
            }
            return string;
        }
        catch (Throwable throwable) {
            throw Sys.initFail("arch", throwable);
        }
    }

    private static String sanitize(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '_') {
                stringBuilder.append(c);
                continue;
            }
            if ('a' <= c && c <= 'z') {
                stringBuilder.append(c);
                continue;
            }
            if ('0' <= c && c <= '9') {
                stringBuilder.append(c);
                continue;
            }
            if ('A' > c || c > 'Z') continue;
            stringBuilder.append((char)(c | 0x20));
        }
        return stringBuilder.toString();
    }

    private static boolean initIsJarDist() {
        return System.getProperty("fan.jardist", "false").equals("true");
    }

    private static File initHomeDir() {
        try {
            return Sys.sysPropToDir("fan.home", "FAN_HOME", null);
        }
        catch (Throwable throwable) {
            throw Sys.initFail("homeDir", throwable);
        }
    }

    private static File initPodsDir() {
        try {
            return new File(homeDir, "lib" + File.separator + "fan");
        }
        catch (Throwable throwable) {
            throw Sys.initFail("podsDir", throwable);
        }
    }

    private static File sysPropToDir(String string, String string2, String string3) {
        File file;
        String string4 = System.getProperty(string);
        if (string4 == null) {
            string4 = System.getenv(string2);
        }
        if (string4 == null) {
            string4 = System.getenv(FanStr.lower(string2));
        }
        if (string4 == null && string3 != null) {
            string4 = string3;
        }
        if (string4 == null) {
            throw new RuntimeException("Missing " + string + " system property or " + string2 + " env var");
        }
        if (!string4.endsWith("/")) {
            string4 = string4 + "/";
        }
        if (!(file = new File(string4)).exists() || !file.isDirectory()) {
            throw new RuntimeException("Invalid " + string + " dir: " + file);
        }
        return file;
    }

    static Pod initSysPod() {
        try {
            return Pod.doFind("sys", true, null, null);
        }
        catch (Throwable throwable) {
            throw Sys.initFail("sysPod", throwable);
        }
    }

    static Type initType(String string) {
        try {
            return sysPod.type(string, true);
        }
        catch (Throwable throwable) {
            throw Sys.initFail("type " + string, throwable);
        }
    }

    private static ClassType initGeneric(int n) {
        String string = String.valueOf((char)n);
        try {
            Sys.genericParamTypes[n] = new ClassType(sysPod, string, 0, null);
            return Sys.genericParamTypes[n];
        }
        catch (Throwable throwable) {
            throw Sys.initFail("generic " + string, throwable);
        }
    }

    private static void initGenericParamTypes() {
        List list = new List(TypeType, 0).ro();
        for (int i = 0; i < genericParamTypes.length; ++i) {
            ClassType classType = genericParamTypes[i];
            if (classType == null) continue;
            classType.base = ObjType;
            classType.mixins = list;
        }
    }

    public static Type genericParamType(String string) {
        if (string.length() == 1 && string.charAt(0) < genericParamTypes.length) {
            return genericParamTypes[string.charAt(0)];
        }
        return null;
    }

    private static void initEnv() {
        try {
            if (isJarDist) {
                curEnv = JarDistEnv.make();
                return;
            }
            String string = (String)Env.cur().vars().get("FAN_ENV");
            if (string == null) {
                return;
            }
            curEnv = (Env)Type.find(string).make();
        }
        catch (Exception exception) {
            Sys.initWarn("curEnv", exception);
        }
    }

    private static Map initEmptyStrMap(Type type) {
        try {
            return (Map)new Map(StrType, type).toImmutable();
        }
        catch (Exception exception) {
            throw Sys.initFail("emptyStrMap", exception);
        }
    }

    private static Map initSysConfig() {
        try {
            String string = File.separator;
            LocalFile localFile = new LocalFile(new File(homeDir, "etc" + string + "sys" + string + "config.props"));
            if (localFile.exists()) {
                try {
                    return localFile.readProps();
                }
                catch (Exception exception) {
                    System.out.println("ERROR: Invalid props file: " + localFile);
                    System.out.println("  " + exception);
                }
            }
        }
        catch (Throwable throwable) {
            throw Sys.initFail("sysConfig", throwable);
        }
        return emptyStrStrMap;
    }

    static String sysConfig(String string) {
        return (String)sysConfig.get(string);
    }

    static boolean sysConfigBool(String string, boolean bl) {
        String string2 = Sys.sysConfig(string);
        if (string2 != null) {
            return string2.equals("true");
        }
        return bl;
    }

    private static Duration initBootDuration() {
        try {
            return Duration.now();
        }
        catch (Throwable throwable) {
            throw Sys.initFail("bootDuration", throwable);
        }
    }

    private static DateTime initBootDateTime() {
        try {
            return DateTime.now();
        }
        catch (Throwable throwable) {
            throw Sys.initFail("bootDuration", throwable);
        }
    }

    private static void initWarn(String string, Throwable throwable) {
        System.out.println("WARN: cannot init Sys." + string);
        throwable.printStackTrace();
    }

    private static RuntimeException initFail(String string, Throwable throwable) {
        System.out.println("ERROR: cannot init Sys." + string);
        throwable.printStackTrace();
        throw new RuntimeException("Cannot boot fan: " + throwable.toString());
    }

    public static Object safe(Object object) {
        if (object == null) {
            return null;
        }
        if (FanObj.isImmutable(object)) {
            return object;
        }
        MemBuf memBuf = new MemBuf(512);
        memBuf.out.writeObj(object);
        memBuf.flip();
        return memBuf.in.readObj();
    }

    public static void boot() {
    }

    static {
        Sys.initGenericParamTypes();
        emptyStrObjMap = Sys.initEmptyStrMap(ObjType.toNullable());
        emptyStrStrMap = Sys.initEmptyStrMap(StrType);
        emptyStrTypeMap = Sys.initEmptyStrMap(TypeType);
        bootEnv = new BootEnv();
        curEnv = bootEnv;
        sysConfig = Sys.initSysConfig();
        debug = Sys.sysConfigBool("debug", false);
        bootDateTime = Sys.initBootDateTime();
        bootDuration = Sys.initBootDuration();
        Sys.initEnv();
    }
}

