/*
 * Decompiled with CFR 0.152.
 */
package fan.sys;

import fan.sys.ArgErr;
import fan.sys.DateTime;
import fan.sys.FanObj;
import fan.sys.File;
import fan.sys.IOErr;
import fan.sys.InStream;
import fan.sys.LocalFile;
import fan.sys.Map;
import fan.sys.OutStream;
import fan.sys.Sys;
import fan.sys.SysInStream;
import fan.sys.SysOutStream;
import fan.sys.Type;
import fan.sys.UnsupportedErr;
import fan.sys.Uri;
import fan.sys.ZipEntryFile;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public final class Zip
extends FanObj {
    LocalFile file;
    ZipFile zipFile;
    Map contents;
    ZipInputStream zipIn;
    ZipOutputStream zipOut;

    public static Zip open(File file) {
        return new Zip(file);
    }

    private Zip(File file) {
        try {
            if (!(file instanceof LocalFile)) {
                throw IOErr.make("Only local files supported: " + file);
            }
            this.file = (LocalFile)file;
            this.zipFile = new ZipFile(this.file.file);
        }
        catch (IOException iOException) {
            throw IOErr.make(iOException);
        }
    }

    public static Zip read(InStream inStream) {
        return new Zip(inStream);
    }

    private Zip(InStream inStream) {
        this.zipIn = new ZipInputStream(SysInStream.java(inStream));
    }

    public static Zip write(OutStream outStream) {
        return new Zip(outStream);
    }

    private Zip(OutStream outStream) {
        this.zipOut = new ZipOutputStream(SysOutStream.java(outStream));
    }

    public Type typeof() {
        return Sys.ZipType;
    }

    public String toStr() {
        if (this.file != null) {
            return this.file.toStr();
        }
        return super.toStr();
    }

    public File file() {
        return this.file;
    }

    public Map contents() {
        if (this.contents == null) {
            if (this.zipFile == null) {
                return null;
            }
            this.contents = Zip.contents(this.zipFile);
        }
        return this.contents.ro();
    }

    public static Map contents(ZipFile zipFile) {
        Map map = new Map(Sys.UriType, Sys.FileType);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = enumeration.nextElement();
            ZipEntryFile zipEntryFile = new ZipEntryFile(zipFile, zipEntry);
            map.set(zipEntryFile.uri, zipEntryFile);
        }
        return map;
    }

    public File readNext() {
        if (this.zipIn == null) {
            throw UnsupportedErr.make("Zip not opened for reading");
        }
        try {
            ZipEntry zipEntry = this.zipIn.getNextEntry();
            if (zipEntry == null) {
                return null;
            }
            return new ZipEntryFile(this, zipEntry);
        }
        catch (IOException iOException) {
            throw IOErr.make(iOException);
        }
    }

    public OutStream writeNext(Uri uri) {
        return this.writeNext(uri, DateTime.now());
    }

    public OutStream writeNext(Uri uri, DateTime dateTime) {
        if (this.zipOut == null) {
            throw UnsupportedErr.make("Zip not opened for writing");
        }
        if (uri.frag() != null) {
            throw ArgErr.make("Path must not contain fragment: " + uri);
        }
        if (uri.queryStr() != null) {
            throw ArgErr.make("Path must not contain query: " + uri);
        }
        try {
            String string = uri.toString();
            if (string.startsWith("/")) {
                string = string.substring(1);
            }
            ZipEntry zipEntry = new ZipEntry(string);
            zipEntry.setTime(dateTime.toJava());
            this.zipOut.putNextEntry(zipEntry);
            return new SysOutStream(this.zipOut){

                public boolean close() {
                    try {
                        Zip.this.zipOut.closeEntry();
                        return true;
                    }
                    catch (IOException iOException) {
                        return false;
                    }
                }
            };
        }
        catch (IOException iOException) {
            throw IOErr.make(iOException);
        }
    }

    public boolean finish() {
        if (this.zipOut == null) {
            throw UnsupportedErr.make("Zip not opened for writing");
        }
        try {
            this.zipOut.finish();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public boolean close() {
        try {
            if (this.zipFile != null) {
                this.zipFile.close();
            }
            if (this.zipIn != null) {
                this.zipIn.close();
            }
            if (this.zipOut != null) {
                this.zipOut.close();
            }
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

