/*
 * Decompiled with CFR 0.152.
 */
package fanx.test;

import fan.sys.DateTime;
import fan.sys.Sys;
import fan.sys.TimeZone;
import fanx.test.Test;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Random;

public class DateTimeTest
extends Test {
    SimpleDateFormat f = new SimpleDateFormat("dd-MMM-yyyy EEE HH:mm:ss.SSS zzz");
    Calendar cal = new GregorianCalendar();
    TimeZone tzFan;
    java.util.TimeZone tzJava;
    int num;
    int curYear;
    HashMap errors = new HashMap();

    public void run() throws Exception {
        this.verifyTz("Etc/UTC", 1990);
        this.verifyTz("America/New_York", 1990);
        this.verifyTz("America/Chicago", 1990);
        this.verifyTz("America/Denver", 1990);
        this.verifyTz("America/Phoenix", 1990);
        this.verifyTz("America/Los_Angeles", 1990);
        this.verifyTz("Europe/London", 2000);
        this.verifyTz("Europe/Paris", 2000);
        this.verifyTz("Europe/Amsterdam", 2000);
        this.verifyTz("Europe/Riga", 1995);
        this.verifyTz("Australia/Sydney", 2000);
        this.verifyTz("America/Godthab", 2000);
        this.verifyTzInit();
    }

    public void verifyTz(String string, int n) {
        System.out.print("     " + string + ": ");
        this.tzFan = TimeZone.fromStr(string);
        this.tzJava = java.util.TimeZone.getTimeZone(string);
        this.num = 0;
        this.curYear = -1;
        this.cal.setTimeZone(this.tzJava);
        this.cal.set(14, 0);
        this.cal.set(n, 1, 1, 0, 0, 0);
        long l = this.cal.getTime().getTime();
        this.cal.set(2015, 1, 1, 0, 0, 0);
        long l2 = this.cal.getTime().getTime();
        Random random = new Random();
        long l3 = l + (long)random.nextInt(10000);
        while ((l3 += 600000L + (long)random.nextInt(50000000)) <= l2) {
            this.verifyTzAt(l3);
        }
        System.out.println();
    }

    public void verifyTzAt(long l) {
        Date date = new Date(l);
        this.cal.setTime(date);
        DateTime dateTime = DateTime.makeTicks((l - 946684800000L) * 1000000L, this.tzFan);
        int n = this.cal.get(1);
        String string = this.tzFan.name();
        try {
            this.verifyEq(n, dateTime.year());
            this.verifyEq(this.cal.get(2), dateTime.month().ordinal());
            this.verifyEq(this.cal.get(5), dateTime.day());
            this.verifyEq(this.cal.get(11), dateTime.hour());
            this.verifyEq(this.cal.get(12), dateTime.min());
            this.verifyEq(this.cal.get(13), dateTime.sec());
            this.verifyEq(this.cal.get(7) - 1, dateTime.weekday().ordinal());
            this.verifyEq(this.cal.getTimeZone().inDaylightTime(date), dateTime.dst());
        }
        catch (RuntimeException runtimeException) {
            ErrRec errRec = (ErrRec)this.errors.get(string);
            if (errRec == null) {
                errRec = new ErrRec(string);
                this.errors.put(string, errRec);
            }
            errRec.addYear(n);
        }
        if (n != this.curYear) {
            this.curYear = n;
            System.out.print(" " + (this.curYear % 100 < 10 ? "0" : "") + this.curYear % 100);
            System.out.flush();
        }
        ++this.num;
    }

    public void verifyTzInit() {
        String string = Sys.os;
        this.verifyTzInit("New_York", "America/New_York");
        this.verifyTzInit("America/New_York", "America/New_York");
        this.verifyTzInit("Europe/London", "Europe/London");
        this.verifyTzInit("GMT0", "Etc/UTC");
        this.verifyTzInit("GMT+00:00", "Etc/UTC");
        this.verifyTzInit("GMT-00:00", "Etc/UTC");
        this.verifyTzInit("GMT-13:00", "Etc/GMT-13");
        this.verifyTzInit("GMT-10:00", "Etc/GMT-10");
        this.verifyTzInit("GMT-05:00", "Etc/GMT-5");
        this.verifyTzInit("GMT+06:00", "Etc/GMT+6");
        this.verifyTzInit("GMT+12:00", "Etc/GMT+12");
        this.verifyTzInit("GMT+6:00", "Etc/GMT+6");
        this.verifyTzInit("GMT-5:00", "Etc/GMT-5");
        this.verifyTzInit("US/Eastern", "America/New_York");
        this.verifyTzInit("US/Central", "America/Chicago");
        this.verifyTzInit("US/Mountain", "America/Denver");
        this.verifyTzInit("US/Pacific", "America/Los_Angeles");
        this.verifyTzInit("US/Arizona", "America/Phoenix");
    }

    public void verifyTzInit(String string, String string2) {
        TimeZone timeZone = TimeZone.fromJava(string);
        this.verify(timeZone.fullName(), string2);
    }

    static class ErrRec
    implements Comparable {
        String name;
        ArrayList years = new ArrayList();

        ErrRec(String string) {
            this.name = string;
        }

        void addYear(int n) {
            Integer n2 = new Integer(n);
            if (!this.years.contains(n2)) {
                this.years.add(n2);
            }
        }

        public int compareTo(Object object) {
            return this.name.compareTo(((ErrRec)object).name);
        }
    }
}

