/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.NMCUSTOMDRAW;
import org.eclipse.swt.internal.win32.NMHDR;
import org.eclipse.swt.internal.win32.NMTBHOTITEM;
import org.eclipse.swt.internal.win32.NMTOOLBAR;
import org.eclipse.swt.internal.win32.NMTTDISPINFO;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TBBUTTON;
import org.eclipse.swt.internal.win32.TBBUTTONINFO;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TOOLINFO;
import org.eclipse.swt.internal.win32.WINDOWPOS;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class ToolBar
extends Composite {
    int lastFocusId;
    int lastArrowId;
    int lastHotId;
    ToolItem[] items;
    ToolItem[] tabItemList;
    boolean ignoreResize;
    boolean ignoreMouse;
    ImageList imageList;
    ImageList disabledImageList;
    ImageList hotImageList;
    static final int ToolBarProc;
    static final TCHAR ToolBarClass;
    static final int DEFAULT_WIDTH = 24;
    static final int DEFAULT_HEIGHT = 22;

    static {
        ToolBarClass = new TCHAR(0, "ToolbarWindow32", true);
        WNDCLASS wNDCLASS = new WNDCLASS();
        OS.GetClassInfo(0, ToolBarClass, wNDCLASS);
        ToolBarProc = wNDCLASS.lpfnWndProc;
    }

    public ToolBar(Composite composite, int n) {
        super(composite, ToolBar.checkStyle(n));
        if ((n & 0x200) != 0) {
            this.style |= 0x200;
            int n2 = OS.GetWindowLong(this.handle, -16);
            if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed() && (n & 0x20000) != 0) {
                n2 |= 0x1000;
            }
            OS.SetWindowLong(this.handle, -16, n2 | 0x80);
        } else {
            this.style |= 0x100;
        }
    }

    int callWindowProc(int n, int n2, int n3, int n4) {
        if (this.handle == 0) {
            return 0;
        }
        if (n2 == 262) {
            return OS.DefWindowProc(n, n2, n3, n4);
        }
        return OS.CallWindowProc(ToolBarProc, n, n2, n3, n4);
    }

    static int checkStyle(int n) {
        if ((n & 0x800000) == 0) {
            n |= 0x80000;
        }
        if ((n & 0x200) != 0) {
            n &= 0xFFFFFFBF;
        }
        return n & 0xFFFFFCFF;
    }

    void checkBuffered() {
        super.checkBuffered();
        if (OS.COMCTL32_MAJOR >= 6) {
            this.style |= 0x20000000;
        }
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public Point computeSize(int n, int n2, boolean bl) {
        Object object;
        this.checkWidget();
        int n3 = 0;
        int n4 = 0;
        if ((this.style & 0x200) != 0) {
            object = new RECT();
            TBBUTTON tBBUTTON = new TBBUTTON();
            int n5 = OS.SendMessage(this.handle, 1048, 0, 0);
            int n6 = 0;
            while (n6 < n5) {
                OS.SendMessage(this.handle, 1053, n6, (RECT)object);
                n4 = Math.max(n4, ((RECT)object).bottom);
                OS.SendMessage(this.handle, 1047, n6, tBBUTTON);
                if ((tBBUTTON.fsStyle & 1) != 0) {
                    TBBUTTONINFO tBBUTTONINFO = new TBBUTTONINFO();
                    tBBUTTONINFO.cbSize = TBBUTTONINFO.sizeof;
                    tBBUTTONINFO.dwMask = 64;
                    OS.SendMessage(this.handle, OS.TB_GETBUTTONINFO, tBBUTTON.idCommand, tBBUTTONINFO);
                    n3 = Math.max(n3, tBBUTTONINFO.cx);
                } else {
                    n3 = Math.max(n3, ((RECT)object).right);
                }
                ++n6;
            }
        } else {
            object = new RECT();
            OS.GetWindowRect(this.handle, (RECT)object);
            int n7 = ((RECT)object).right - ((RECT)object).left;
            int n8 = ((RECT)object).bottom - ((RECT)object).top;
            int n9 = this.getBorderWidth();
            int n10 = n == -1 ? 16383 : n + n9 * 2;
            int n11 = n2 == -1 ? 16383 : n2 + n9 * 2;
            boolean bl2 = this.getDrawing() && OS.IsWindowVisible(this.handle);
            this.ignoreResize = true;
            if (bl2) {
                OS.UpdateWindow(this.handle);
            }
            int n12 = 30;
            this.SetWindowPos(this.handle, 0, 0, 0, n10, n11, n12);
            int n13 = OS.SendMessage(this.handle, 1048, 0, 0);
            if (n13 != 0) {
                RECT rECT = new RECT();
                OS.SendMessage(this.handle, 1053, n13 - 1, rECT);
                n3 = Math.max(n3, rECT.right);
                n4 = Math.max(n4, rECT.bottom);
            }
            this.SetWindowPos(this.handle, 0, 0, 0, n7, n8, n12);
            if (bl2) {
                OS.ValidateRect(this.handle, null);
            }
            this.ignoreResize = false;
        }
        if (n3 == 0) {
            n3 = 24;
        }
        if (n4 == 0) {
            n4 = 22;
        }
        if (n != -1) {
            n3 = n;
        }
        if (n2 != -1) {
            n4 = n2;
        }
        object = this.computeTrim(0, 0, n3, n4);
        n3 = ((Rectangle)object).width;
        n4 = ((Rectangle)object).height;
        return new Point(n3, n4);
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        this.checkWidget();
        Rectangle rectangle = super.computeTrim(n, n2, n3, n4);
        int n5 = OS.GetWindowLong(this.handle, -16);
        if ((n5 & 0x40) == 0) {
            rectangle.height += 2;
        }
        return rectangle;
    }

    Widget computeTabGroup() {
        int n;
        ToolItem[] toolItemArray = this._getItems();
        if (this.tabItemList == null) {
            n = 0;
            while (n < toolItemArray.length && toolItemArray[n].control == null) {
                ++n;
            }
            if (n == toolItemArray.length) {
                return super.computeTabGroup();
            }
        }
        if ((n = OS.SendMessage(this.handle, 1095, 0, 0)) == -1) {
            n = this.lastHotId;
        }
        while (n >= 0) {
            ToolItem toolItem = toolItemArray[n];
            if (toolItem.isTabGroup()) {
                return toolItem;
            }
            --n;
        }
        return super.computeTabGroup();
    }

    Widget[] computeTabList() {
        ToolItem[] toolItemArray = this._getItems();
        if (this.tabItemList == null) {
            int n = 0;
            while (n < toolItemArray.length && toolItemArray[n].control == null) {
                ++n;
            }
            if (n == toolItemArray.length) {
                return super.computeTabList();
            }
        }
        Widget[] widgetArray = new Widget[]{};
        if (!(this.isTabGroup() && this.isEnabled() && this.isVisible())) {
            return widgetArray;
        }
        ToolItem[] toolItemArray2 = this.tabList != null ? this._getTabItemList() : toolItemArray;
        int n = 0;
        while (n < toolItemArray2.length) {
            ToolItem toolItem = toolItemArray2[n];
            Widget[] widgetArray2 = toolItem.computeTabList();
            if (widgetArray2.length != 0) {
                Widget[] widgetArray3 = new Widget[widgetArray.length + widgetArray2.length];
                System.arraycopy(widgetArray, 0, widgetArray3, 0, widgetArray.length);
                System.arraycopy(widgetArray2, 0, widgetArray3, widgetArray.length, widgetArray2.length);
                widgetArray = widgetArray3;
            }
            ++n;
        }
        if (widgetArray.length == 0) {
            widgetArray = new Widget[]{this};
        }
        return widgetArray;
    }

    void createHandle() {
        int n;
        super.createHandle();
        this.state &= 0xFFFFFFFD;
        if (!((this.style & 0x800000) == 0 || OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed())) {
            n = OS.GetWindowLong(this.handle, -16);
            OS.SetWindowLong(this.handle, -16, n &= 0xFFFF7FFF);
        }
        n = OS.GetStockObject(13);
        OS.SendMessage(this.handle, 48, n, 0);
        OS.SendMessage(this.handle, 1054, TBBUTTON.sizeof, 0);
        OS.SendMessage(this.handle, 1056, 0, 0);
        OS.SendMessage(this.handle, 1055, 0, 0);
        int n2 = 25;
        if (OS.COMCTL32_MAJOR >= 6) {
            n2 |= 0x80;
        }
        OS.SendMessage(this.handle, 1108, 0, n2);
    }

    void createItem(ToolItem toolItem, int n) {
        int n2 = OS.SendMessage(this.handle, 1048, 0, 0);
        if (n < 0 || n > n2) {
            this.error(6);
        }
        int n3 = 0;
        while (n3 < this.items.length && this.items[n3] != null) {
            ++n3;
        }
        if (n3 == this.items.length) {
            ToolItem[] toolItemArray = new ToolItem[this.items.length + 4];
            System.arraycopy(this.items, 0, toolItemArray, 0, this.items.length);
            this.items = toolItemArray;
        }
        int n4 = toolItem.widgetStyle();
        TBBUTTON tBBUTTON = new TBBUTTON();
        tBBUTTON.idCommand = n3;
        tBBUTTON.fsStyle = (byte)n4;
        tBBUTTON.fsState = (byte)4;
        if ((n4 & 1) == 0) {
            tBBUTTON.iBitmap = -2;
        }
        if (OS.SendMessage(this.handle, OS.TB_INSERTBUTTON, n, tBBUTTON) == 0) {
            this.error(14);
        }
        toolItem.id = n3;
        this.items[toolItem.id] = toolItem;
        if ((this.style & 0x200) != 0) {
            this.setRowCount(n2 + 1);
        }
        this.layoutItems();
    }

    void createWidget() {
        super.createWidget();
        this.items = new ToolItem[4];
        this.lastHotId = -1;
        this.lastArrowId = -1;
        this.lastFocusId = -1;
    }

    int defaultBackground() {
        if (OS.IsWinCE) {
            return OS.GetSysColor(OS.COLOR_BTNFACE);
        }
        return super.defaultBackground();
    }

    void destroyItem(ToolItem toolItem) {
        TBBUTTONINFO tBBUTTONINFO = new TBBUTTONINFO();
        tBBUTTONINFO.cbSize = TBBUTTONINFO.sizeof;
        tBBUTTONINFO.dwMask = 9;
        int n = OS.SendMessage(this.handle, OS.TB_GETBUTTONINFO, toolItem.id, tBBUTTONINFO);
        if ((tBBUTTONINFO.fsStyle & 1) == 0 && tBBUTTONINFO.iImage != -2) {
            if (this.imageList != null) {
                this.imageList.put(tBBUTTONINFO.iImage, null);
            }
            if (this.hotImageList != null) {
                this.hotImageList.put(tBBUTTONINFO.iImage, null);
            }
            if (this.disabledImageList != null) {
                this.disabledImageList.put(tBBUTTONINFO.iImage, null);
            }
        }
        OS.SendMessage(this.handle, 1046, n, 0);
        if (toolItem.id == this.lastFocusId) {
            this.lastFocusId = -1;
        }
        if (toolItem.id == this.lastArrowId) {
            this.lastArrowId = -1;
        }
        if (toolItem.id == this.lastHotId) {
            this.lastHotId = -1;
        }
        this.items[toolItem.id] = null;
        toolItem.id = -1;
        int n2 = OS.SendMessage(this.handle, 1048, 0, 0);
        if (n2 == 0) {
            if (this.imageList != null) {
                OS.SendMessage(this.handle, 1072, 0, 0);
                this.display.releaseToolImageList(this.imageList);
            }
            if (this.hotImageList != null) {
                OS.SendMessage(this.handle, 1076, 0, 0);
                this.display.releaseToolHotImageList(this.hotImageList);
            }
            if (this.disabledImageList != null) {
                OS.SendMessage(this.handle, 1078, 0, 0);
                this.display.releaseToolDisabledImageList(this.disabledImageList);
            }
            this.disabledImageList = null;
            this.hotImageList = null;
            this.imageList = null;
            this.items = new ToolItem[4];
        }
        if ((this.style & 0x200) != 0) {
            this.setRowCount(n2 - 1);
        }
        this.layoutItems();
    }

    void enableWidget(boolean bl) {
        super.enableWidget(bl);
        int n = 0;
        while (n < this.items.length) {
            ToolItem toolItem = this.items[n];
            if (toolItem != null && (toolItem.style & 2) == 0) {
                toolItem.updateImages(bl && toolItem.getEnabled());
            }
            ++n;
        }
    }

    ImageList getDisabledImageList() {
        return this.disabledImageList;
    }

    ImageList getHotImageList() {
        return this.hotImageList;
    }

    ImageList getImageList() {
        return this.imageList;
    }

    public ToolItem getItem(int n) {
        TBBUTTON tBBUTTON;
        int n2;
        this.checkWidget();
        int n3 = OS.SendMessage(this.handle, 1048, 0, 0);
        if (n < 0 || n >= n3) {
            this.error(6);
        }
        if ((n2 = OS.SendMessage(this.handle, 1047, n, tBBUTTON = new TBBUTTON())) == 0) {
            this.error(8);
        }
        return this.items[tBBUTTON.idCommand];
    }

    public ToolItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        ToolItem[] toolItemArray = this.getItems();
        int n = 0;
        while (n < toolItemArray.length) {
            Rectangle rectangle = toolItemArray[n].getBounds();
            if (rectangle.contains(point)) {
                return toolItemArray[n];
            }
            ++n;
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        return OS.SendMessage(this.handle, 1048, 0, 0);
    }

    public ToolItem[] getItems() {
        this.checkWidget();
        return this._getItems();
    }

    ToolItem[] _getItems() {
        int n = OS.SendMessage(this.handle, 1048, 0, 0);
        TBBUTTON tBBUTTON = new TBBUTTON();
        ToolItem[] toolItemArray = new ToolItem[n];
        int n2 = 0;
        while (n2 < n) {
            OS.SendMessage(this.handle, 1047, n2, tBBUTTON);
            toolItemArray[n2] = this.items[tBBUTTON.idCommand];
            ++n2;
        }
        return toolItemArray;
    }

    public int getRowCount() {
        this.checkWidget();
        if ((this.style & 0x200) != 0) {
            return OS.SendMessage(this.handle, 1048, 0, 0);
        }
        return OS.SendMessage(this.handle, 1064, 0, 0);
    }

    ToolItem[] _getTabItemList() {
        if (this.tabItemList == null) {
            return this.tabItemList;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.tabItemList.length) {
            if (!this.tabItemList[n2].isDisposed()) {
                ++n;
            }
            ++n2;
        }
        if (n == this.tabItemList.length) {
            return this.tabItemList;
        }
        ToolItem[] toolItemArray = new ToolItem[n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < this.tabItemList.length) {
            if (!this.tabItemList[n4].isDisposed()) {
                toolItemArray[n3++] = this.tabItemList[n4];
            }
            ++n4;
        }
        this.tabItemList = toolItemArray;
        return this.tabItemList;
    }

    public int indexOf(ToolItem toolItem) {
        this.checkWidget();
        if (toolItem == null) {
            this.error(4);
        }
        if (toolItem.isDisposed()) {
            this.error(5);
        }
        return OS.SendMessage(this.handle, 1049, toolItem.id, 0);
    }

    void layoutItems() {
        int n;
        int n2;
        int n3;
        int n4;
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed() && (this.style & 0x20000) != 0 && (this.style & 0x200) == 0) {
            n4 = 0;
            boolean bl = false;
            n3 = 0;
            while (n3 < this.items.length) {
                ToolItem toolItem = this.items[n3];
                if (toolItem != null) {
                    if (n4 == 0) {
                        int n5 = n4 = toolItem.text.length() != 0 ? 1 : 0;
                    }
                    if (!bl) {
                        boolean bl2 = bl = toolItem.image != null;
                    }
                    if (n4 != 0 && bl) break;
                }
                ++n3;
            }
            n2 = n3 = OS.GetWindowLong(this.handle, -16);
            n2 = n4 != 0 && bl ? (n2 |= 0x1000) : (n2 &= 0xFFFFEFFF);
            if (n2 != n3) {
                this.setDropDownItems(false);
                OS.SetWindowLong(this.handle, -16, n2);
                n = OS.SendMessage(this.handle, 49, 0, 0);
                OS.SendMessage(this.handle, 48, n, 0);
                this.setDropDownItems(true);
            }
        }
        if ((this.style & 0x40) != 0) {
            OS.SendMessage(this.handle, 1057, 0, 0);
        }
        if ((this.style & 0x200) != 0 && (n4 = OS.SendMessage(this.handle, 1048, 0, 0)) > 1) {
            TBBUTTONINFO tBBUTTONINFO = new TBBUTTONINFO();
            tBBUTTONINFO.cbSize = TBBUTTONINFO.sizeof;
            tBBUTTONINFO.dwMask = 64;
            n3 = OS.SendMessage(this.handle, 1082, 0, 0);
            tBBUTTONINFO.cx = (short)OS.LOWORD(n3);
            n2 = 0;
            while (n2 < this.items.length) {
                ToolItem toolItem = this.items[n2];
                if (toolItem != null && (toolItem.style & 4) != 0) break;
                ++n2;
            }
            if (n2 < this.items.length) {
                int n6 = OS.SendMessage(this.handle, 1110, 0, 0);
                tBBUTTONINFO.cx = (short)(tBBUTTONINFO.cx + OS.LOWORD(n6) * 2);
            }
            n = 0;
            while (n < this.items.length) {
                ToolItem toolItem = this.items[n];
                if (toolItem != null && (toolItem.style & 2) == 0) {
                    OS.SendMessage(this.handle, OS.TB_SETBUTTONINFO, toolItem.id, tBBUTTONINFO);
                }
                ++n;
            }
        }
        if ((this.style & 0x240) != 0 && ((n4 = OS.GetWindowLong(this.handle, -16)) & 0x1000) != 0) {
            TBBUTTONINFO tBBUTTONINFO = new TBBUTTONINFO();
            tBBUTTONINFO.cbSize = TBBUTTONINFO.sizeof;
            tBBUTTONINFO.dwMask = 64;
            n3 = 0;
            while (n3 < this.items.length) {
                ToolItem toolItem = this.items[n3];
                if (toolItem != null && toolItem.cx > 0) {
                    tBBUTTONINFO.cx = toolItem.cx;
                    OS.SendMessage(this.handle, OS.TB_SETBUTTONINFO, toolItem.id, tBBUTTONINFO);
                }
                ++n3;
            }
        }
        n4 = 0;
        while (n4 < this.items.length) {
            ToolItem toolItem = this.items[n4];
            if (toolItem != null) {
                toolItem.resizeControl();
            }
            ++n4;
        }
    }

    boolean mnemonicHit(char c) {
        int[] nArray;
        int n = Display.wcsToMbcs(c);
        if (OS.SendMessage(this.handle, OS.TB_MAPACCELERATOR, n, nArray = new int[1]) == 0) {
            return false;
        }
        if ((this.style & 0x800000) != 0 && !this.setTabGroupFocus()) {
            return false;
        }
        int n2 = OS.SendMessage(this.handle, 1049, nArray[0], 0);
        if (n2 == -1) {
            return false;
        }
        OS.SendMessage(this.handle, 1096, n2, 0);
        this.items[nArray[0]].click(false);
        return true;
    }

    boolean mnemonicMatch(char c) {
        int[] nArray;
        int n = Display.wcsToMbcs(c);
        if (OS.SendMessage(this.handle, OS.TB_MAPACCELERATOR, n, nArray = new int[1]) == 0) {
            return false;
        }
        int n2 = OS.SendMessage(this.handle, 1049, nArray[0], 0);
        if (n2 == -1) {
            return false;
        }
        return this.findMnemonic(this.items[nArray[0]].text) != '\u0000';
    }

    void releaseChildren(boolean bl) {
        if (this.items != null) {
            int n = 0;
            while (n < this.items.length) {
                ToolItem toolItem = this.items[n];
                if (toolItem != null && !toolItem.isDisposed()) {
                    toolItem.release(false);
                }
                ++n;
            }
            this.items = null;
        }
        super.releaseChildren(bl);
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.imageList != null) {
            OS.SendMessage(this.handle, 1072, 0, 0);
            this.display.releaseToolImageList(this.imageList);
        }
        if (this.hotImageList != null) {
            OS.SendMessage(this.handle, 1076, 0, 0);
            this.display.releaseToolHotImageList(this.hotImageList);
        }
        if (this.disabledImageList != null) {
            OS.SendMessage(this.handle, 1078, 0, 0);
            this.display.releaseToolDisabledImageList(this.disabledImageList);
        }
        this.disabledImageList = null;
        this.hotImageList = null;
        this.imageList = null;
    }

    void removeControl(Control control) {
        super.removeControl(control);
        int n = 0;
        while (n < this.items.length) {
            ToolItem toolItem = this.items[n];
            if (toolItem != null && toolItem.control == control) {
                toolItem.setControl(null);
            }
            ++n;
        }
    }

    void reskinChildren(int n) {
        if (this.items != null) {
            int n2 = 0;
            while (n2 < this.items.length) {
                ToolItem toolItem = this.items[n2];
                if (toolItem != null) {
                    toolItem.reskin(n);
                }
                ++n2;
            }
        }
        super.reskinChildren(n);
    }

    void setBackgroundImage(int n) {
        super.setBackgroundImage(n);
        this.setBackgroundTransparent(n != 0);
    }

    void setBackgroundPixel(int n) {
        super.setBackgroundPixel(n);
        this.setBackgroundTransparent(n != -1);
    }

    void setBackgroundTransparent(boolean bl) {
        if (!((this.style & 0x800000) == 0 || OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed())) {
            int n = OS.GetWindowLong(this.handle, -16);
            n = !bl && this.findBackgroundControl() == null ? (n &= 0xFFFF7FFF) : (n |= 0x8000);
            OS.SetWindowLong(this.handle, -16, n);
        }
    }

    void setBounds(int n, int n2, int n3, int n4, int n5) {
        if (this.parent.lpwp != null && this.getDrawing() && OS.IsWindowVisible(this.handle)) {
            this.parent.setResizeChildren(false);
            this.parent.setResizeChildren(true);
        }
        super.setBounds(n, n2, n3, n4, n5);
    }

    void setDefaultFont() {
        super.setDefaultFont();
        OS.SendMessage(this.handle, 1056, 0, 0);
        OS.SendMessage(this.handle, 1055, 0, 0);
    }

    void setDropDownItems(boolean bl) {
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            ToolItem toolItem;
            boolean bl2 = false;
            boolean bl3 = false;
            int n = 0;
            while (n < this.items.length) {
                toolItem = this.items[n];
                if (toolItem != null) {
                    if (!bl2) {
                        boolean bl4 = bl2 = toolItem.text.length() != 0;
                    }
                    if (!bl3) {
                        boolean bl5 = bl3 = toolItem.image != null;
                    }
                    if (bl2 && bl3) break;
                }
                ++n;
            }
            if (bl3 && !bl2) {
                n = 0;
                while (n < this.items.length) {
                    toolItem = this.items[n];
                    if (toolItem != null && (toolItem.style & 4) != 0) {
                        TBBUTTONINFO tBBUTTONINFO = new TBBUTTONINFO();
                        tBBUTTONINFO.cbSize = TBBUTTONINFO.sizeof;
                        tBBUTTONINFO.dwMask = 8;
                        OS.SendMessage(this.handle, OS.TB_GETBUTTONINFO, toolItem.id, tBBUTTONINFO);
                        tBBUTTONINFO.fsStyle = bl ? (byte)(tBBUTTONINFO.fsStyle | 8) : (byte)(tBBUTTONINFO.fsStyle & 0xFFFFFFF7);
                        OS.SendMessage(this.handle, OS.TB_SETBUTTONINFO, toolItem.id, tBBUTTONINFO);
                    }
                    ++n;
                }
            }
        }
    }

    void setDisabledImageList(ImageList imageList) {
        if (this.disabledImageList == imageList) {
            return;
        }
        int n = 0;
        this.disabledImageList = imageList;
        if (this.disabledImageList != null) {
            n = this.disabledImageList.getHandle();
        }
        this.setDropDownItems(false);
        OS.SendMessage(this.handle, 1078, 0, n);
        this.setDropDownItems(true);
    }

    public void setFont(Font font) {
        this.checkWidget();
        this.setDropDownItems(false);
        super.setFont(font);
        this.setDropDownItems(true);
        int n = 0;
        int n2 = 60;
        while (n < this.items.length) {
            ToolItem toolItem = this.items[n];
            if (toolItem != null && (toolItem.style & n2) != 0) break;
            ++n;
        }
        if (n == this.items.length) {
            OS.SendMessage(this.handle, 1056, 0, 0);
            OS.SendMessage(this.handle, 1055, 0, 0);
        }
        this.layoutItems();
    }

    void setHotImageList(ImageList imageList) {
        if (this.hotImageList == imageList) {
            return;
        }
        int n = 0;
        this.hotImageList = imageList;
        if (this.hotImageList != null) {
            n = this.hotImageList.getHandle();
        }
        this.setDropDownItems(false);
        OS.SendMessage(this.handle, 1076, 0, n);
        this.setDropDownItems(true);
    }

    void setImageList(ImageList imageList) {
        if (this.imageList == imageList) {
            return;
        }
        int n = 0;
        this.imageList = imageList;
        if (this.imageList != null) {
            n = imageList.getHandle();
        }
        this.setDropDownItems(false);
        OS.SendMessage(this.handle, 1072, 0, n);
        this.setDropDownItems(true);
    }

    public boolean setParent(Composite composite) {
        this.checkWidget();
        if (!super.setParent(composite)) {
            return false;
        }
        int n = composite.handle;
        OS.SendMessage(this.handle, 1061, n, 0);
        int n2 = composite.getShell().handle;
        int n3 = OS.SendMessage(this.handle, 1059, 0, 0);
        OS.SetWindowLongPtr(n3, -8, n2);
        return true;
    }

    public void setRedraw(boolean bl) {
        this.checkWidget();
        this.setDropDownItems(false);
        super.setRedraw(bl);
        this.setDropDownItems(true);
    }

    void setRowCount(int n) {
        if ((this.style & 0x200) != 0) {
            RECT rECT = new RECT();
            OS.GetWindowRect(this.handle, rECT);
            OS.MapWindowPoints(0, this.parent.handle, rECT, 2);
            this.ignoreResize = true;
            OS.SendMessage(this.handle, 1063, OS.MAKEWPARAM(n += 2, 1), 0);
            int n2 = 22;
            this.SetWindowPos(this.handle, 0, 0, 0, rECT.right - rECT.left, rECT.bottom - rECT.top, n2);
            this.ignoreResize = false;
        }
    }

    void setTabItemList(ToolItem[] toolItemArray) {
        this.checkWidget();
        if (toolItemArray != null) {
            int n = 0;
            while (n < toolItemArray.length) {
                ToolItem toolItem = toolItemArray[n];
                if (toolItem == null) {
                    this.error(5);
                }
                if (toolItem.isDisposed()) {
                    this.error(5);
                }
                if (toolItem.parent != this) {
                    this.error(32);
                }
                ++n;
            }
            ToolItem[] toolItemArray2 = new ToolItem[toolItemArray.length];
            System.arraycopy(toolItemArray, 0, toolItemArray2, 0, toolItemArray.length);
            toolItemArray = toolItemArray2;
        }
        this.tabItemList = toolItemArray;
    }

    boolean setTabItemFocus() {
        int n = 0;
        while (n < this.items.length) {
            ToolItem toolItem = this.items[n];
            if (toolItem != null && (toolItem.style & 2) == 0 && toolItem.getEnabled()) break;
            ++n;
        }
        if (n == this.items.length) {
            return false;
        }
        return super.setTabItemFocus();
    }

    String toolTipText(NMTTDISPINFO nMTTDISPINFO) {
        if ((nMTTDISPINFO.uFlags & 1) != 0) {
            return null;
        }
        if (!this.hasCursor()) {
            return "";
        }
        int n = nMTTDISPINFO.idFrom;
        int n2 = OS.SendMessage(this.handle, 1059, 0, 0);
        if (n2 == nMTTDISPINFO.hwndFrom) {
            ToolItem toolItem;
            nMTTDISPINFO.uFlags = (this.style & 0x4000000) != 0 ? (nMTTDISPINFO.uFlags |= 4) : (nMTTDISPINFO.uFlags &= 0xFFFFFFFB);
            if (this.toolTipText != null) {
                return "";
            }
            if (n >= 0 && n < this.items.length && (toolItem = this.items[n]) != null) {
                if (this.lastArrowId != -1) {
                    return "";
                }
                return toolItem.toolTipText;
            }
        }
        return super.toolTipText(nMTTDISPINFO);
    }

    int widgetStyle() {
        int n = super.widgetStyle() | 4 | 0x100 | 0x2000;
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            n |= 0x8000;
        }
        if ((this.style & 8) == 0) {
            n |= 0x40;
        }
        if ((this.style & 0x40) != 0) {
            n |= 0x200;
        }
        if ((this.style & 0x800000) != 0) {
            n |= 0x800;
        }
        if (!(OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed() || (this.style & 0x20000) == 0)) {
            n |= 0x1000;
        }
        return n;
    }

    TCHAR windowClass() {
        return ToolBarClass;
    }

    int windowProc() {
        return ToolBarProc;
    }

    LRESULT WM_CAPTURECHANGED(int n, int n2) {
        LRESULT lRESULT = super.WM_CAPTURECHANGED(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        int n3 = 0;
        while (n3 < this.items.length) {
            int n4;
            ToolItem toolItem = this.items[n3];
            if (toolItem != null && ((n4 = OS.SendMessage(this.handle, 1042, toolItem.id, 0)) & 2) != 0) {
                OS.SendMessage(this.handle, 1041, toolItem.id, n4 &= 0xFFFFFFFD);
            }
            ++n3;
        }
        return lRESULT;
    }

    LRESULT WM_CHAR(int n, int n2) {
        LRESULT lRESULT = super.WM_CHAR(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        switch (n) {
            case 32: {
                TBBUTTON tBBUTTON;
                int n3;
                int n4 = OS.SendMessage(this.handle, 1095, 0, 0);
                if (n4 == -1 || (n3 = OS.SendMessage(this.handle, 1047, n4, tBBUTTON = new TBBUTTON())) == 0) break;
                this.items[tBBUTTON.idCommand].click(false);
                return LRESULT.ZERO;
            }
        }
        return lRESULT;
    }

    LRESULT WM_COMMAND(int n, int n2) {
        LRESULT lRESULT = super.WM_COMMAND(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        return LRESULT.ZERO;
    }

    LRESULT WM_ERASEBKGND(int n, int n2) {
        LRESULT lRESULT = super.WM_ERASEBKGND(n, n2);
        if (this.findBackgroundControl() != null && OS.COMCTL32_MAJOR < 6) {
            this.drawBackground(n);
            return LRESULT.ONE;
        }
        return lRESULT;
    }

    LRESULT WM_GETDLGCODE(int n, int n2) {
        LRESULT lRESULT = super.WM_GETDLGCODE(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        return new LRESULT(8193);
    }

    LRESULT WM_KEYDOWN(int n, int n2) {
        LRESULT lRESULT = super.WM_KEYDOWN(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        switch (n) {
            case 32: {
                return LRESULT.ZERO;
            }
        }
        return lRESULT;
    }

    LRESULT WM_KILLFOCUS(int n, int n2) {
        TBBUTTON tBBUTTON;
        int n3 = OS.SendMessage(this.handle, 1095, 0, 0);
        int n4 = OS.SendMessage(this.handle, 1047, n3, tBBUTTON = new TBBUTTON());
        if (n4 != 0) {
            this.lastFocusId = tBBUTTON.idCommand;
        }
        return super.WM_KILLFOCUS(n, n2);
    }

    LRESULT WM_LBUTTONDOWN(int n, int n2) {
        if (this.ignoreMouse) {
            return null;
        }
        return super.WM_LBUTTONDOWN(n, n2);
    }

    LRESULT WM_LBUTTONUP(int n, int n2) {
        if (this.ignoreMouse) {
            return null;
        }
        return super.WM_LBUTTONUP(n, n2);
    }

    LRESULT WM_MOUSELEAVE(int n, int n2) {
        LRESULT lRESULT = super.WM_MOUSELEAVE(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (OS.COMCTL32_MAJOR >= 6) {
            TOOLINFO tOOLINFO = new TOOLINFO();
            tOOLINFO.cbSize = TOOLINFO.sizeof;
            int n3 = OS.SendMessage(this.handle, 1059, 0, 0);
            if (OS.SendMessage(n3, OS.TTM_GETCURRENTTOOL, 0, tOOLINFO) != 0 && (tOOLINFO.uFlags & 1) == 0) {
                OS.SendMessage(n3, OS.TTM_DELTOOL, 0, tOOLINFO);
                OS.SendMessage(n3, OS.TTM_ADDTOOL, 0, tOOLINFO);
            }
        }
        return lRESULT;
    }

    LRESULT WM_MOUSEMOVE(int n, int n2) {
        if (OS.GetMessagePos() != this.display.lastMouse) {
            this.lastArrowId = -1;
        }
        return super.WM_MOUSEMOVE(n, n2);
    }

    LRESULT WM_NOTIFY(int n, int n2) {
        LRESULT lRESULT = super.WM_NOTIFY(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        return LRESULT.ZERO;
    }

    LRESULT WM_SETFOCUS(int n, int n2) {
        LRESULT lRESULT = super.WM_SETFOCUS(n, n2);
        if (this.lastFocusId != -1 && this.handle == OS.GetFocus()) {
            int n3 = OS.SendMessage(this.handle, 1049, this.lastFocusId, 0);
            OS.SendMessage(this.handle, 1096, n3, 0);
        }
        return lRESULT;
    }

    LRESULT WM_SIZE(int n, int n2) {
        if (this.ignoreResize) {
            int n3 = this.callWindowProc(this.handle, 5, n, n2);
            if (n3 == 0) {
                return LRESULT.ZERO;
            }
            return new LRESULT(n3);
        }
        LRESULT lRESULT = super.WM_SIZE(n, n2);
        if (this.isDisposed()) {
            return lRESULT;
        }
        if ((this.style & 0x800) != 0 && (this.style & 0x40) != 0) {
            RECT rECT = new RECT();
            OS.GetWindowRect(this.handle, rECT);
            int n4 = 0;
            int n5 = this.getBorderWidth() * 2;
            RECT rECT2 = new RECT();
            int n6 = OS.SendMessage(this.handle, 1048, 0, 0);
            while (n4 < n6) {
                OS.SendMessage(this.handle, 1053, n4, rECT2);
                OS.MapWindowPoints(this.handle, 0, rECT2, 2);
                if (rECT2.right > rECT.right - n5 * 2) break;
                ++n4;
            }
            int n7 = OS.SendMessage(this.handle, 1109, 0, 0);
            n7 = n4 == n6 ? (n7 |= 0x10) : (n7 &= 0xFFFFFFEF);
            OS.SendMessage(this.handle, 1108, 0, n7);
        }
        this.layoutItems();
        return lRESULT;
    }

    LRESULT WM_WINDOWPOSCHANGING(int n, int n2) {
        LRESULT lRESULT = super.WM_WINDOWPOSCHANGING(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (this.ignoreResize) {
            return lRESULT;
        }
        if (!this.getDrawing()) {
            return lRESULT;
        }
        if ((this.style & 0x40) == 0) {
            return lRESULT;
        }
        if (!OS.IsWindowVisible(this.handle)) {
            return lRESULT;
        }
        if (OS.SendMessage(this.handle, 1064, 0, 0) == 1) {
            return lRESULT;
        }
        WINDOWPOS wINDOWPOS = new WINDOWPOS();
        OS.MoveMemory(wINDOWPOS, n2, WINDOWPOS.sizeof);
        if ((wINDOWPOS.flags & 9) != 0) {
            return lRESULT;
        }
        RECT rECT = new RECT();
        OS.GetClientRect(this.handle, rECT);
        RECT rECT2 = new RECT();
        OS.SetRect(rECT2, 0, 0, wINDOWPOS.cx, wINDOWPOS.cy);
        OS.SendMessage(this.handle, 131, 0, rECT2);
        int n3 = rECT.right - rECT.left;
        int n4 = rECT2.right - rECT2.left;
        if (n4 > n3) {
            RECT rECT3 = new RECT();
            int n5 = rECT2.bottom - rECT2.top;
            OS.SetRect(rECT3, n3 - 2, 0, n3, n5);
            OS.InvalidateRect(this.handle, rECT3, false);
        }
        return lRESULT;
    }

    LRESULT wmCommandChild(int n, int n2) {
        ToolItem toolItem = this.items[OS.LOWORD(n)];
        if (toolItem == null) {
            return null;
        }
        return toolItem.wmCommandChild(n, n2);
    }

    LRESULT wmNotifyChild(NMHDR nMHDR, int n, int n2) {
        switch (nMHDR.code) {
            case -710: {
                NMTOOLBAR nMTOOLBAR = new NMTOOLBAR();
                OS.MoveMemory(nMTOOLBAR, n2, NMTOOLBAR.sizeof);
                ToolItem toolItem = this.items[nMTOOLBAR.iItem];
                if (toolItem == null) break;
                Event event = new Event();
                event.detail = 4;
                int n3 = OS.SendMessage(this.handle, 1049, nMTOOLBAR.iItem, 0);
                RECT rECT = new RECT();
                OS.SendMessage(this.handle, 1053, n3, rECT);
                event.x = rECT.left;
                event.y = rECT.bottom;
                toolItem.sendSelectionEvent(13, event, false);
                break;
            }
            case -12: {
                if (OS.COMCTL32_MAJOR < 6) break;
                NMCUSTOMDRAW nMCUSTOMDRAW = new NMCUSTOMDRAW();
                OS.MoveMemory(nMCUSTOMDRAW, n2, NMCUSTOMDRAW.sizeof);
                switch (nMCUSTOMDRAW.dwDrawStage) {
                    case 3: {
                        int n4 = OS.GetWindowLong(this.handle, -16);
                        if ((n4 & 0x800) == 0) {
                            this.drawBackground(nMCUSTOMDRAW.hdc);
                        } else {
                            RECT rECT = new RECT();
                            OS.SetRect(rECT, nMCUSTOMDRAW.left, nMCUSTOMDRAW.top, nMCUSTOMDRAW.right, nMCUSTOMDRAW.bottom);
                            this.drawBackground(nMCUSTOMDRAW.hdc, rECT);
                        }
                        return new LRESULT(4);
                    }
                }
                break;
            }
            case -713: {
                if (OS.IsWinCE) break;
                NMTBHOTITEM nMTBHOTITEM = new NMTBHOTITEM();
                OS.MoveMemory(nMTBHOTITEM, n2, NMTBHOTITEM.sizeof);
                switch (nMTBHOTITEM.dwFlags) {
                    case 1: {
                        if (this.lastArrowId == -1) break;
                        return LRESULT.ONE;
                    }
                    case 2: {
                        RECT rECT = new RECT();
                        OS.GetClientRect(this.handle, rECT);
                        int n5 = OS.SendMessage(this.handle, 1049, nMTBHOTITEM.idNew, 0);
                        RECT rECT2 = new RECT();
                        OS.SendMessage(this.handle, 1053, n5, rECT2);
                        if (rECT2.right > rECT.right || rECT2.bottom > rECT.bottom) {
                            return LRESULT.ONE;
                        }
                        this.lastArrowId = nMTBHOTITEM.idNew;
                        break;
                    }
                    default: {
                        this.lastArrowId = -1;
                    }
                }
                if ((nMTBHOTITEM.dwFlags & 0x20) != 0) break;
                this.lastHotId = nMTBHOTITEM.idNew;
            }
        }
        return super.wmNotifyChild(nMHDR, n, n2);
    }
}

