/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.accessibility;

import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleActionListener;
import org.eclipse.swt.accessibility.AccessibleAttributeListener;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleFactory;
import org.eclipse.swt.accessibility.AccessibleHyperlinkListener;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.accessibility.AccessibleObject;
import org.eclipse.swt.accessibility.AccessibleTableCellListener;
import org.eclipse.swt.accessibility.AccessibleTableListener;
import org.eclipse.swt.accessibility.AccessibleTextExtendedListener;
import org.eclipse.swt.accessibility.AccessibleTextListener;
import org.eclipse.swt.accessibility.AccessibleValueListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class Accessible {
    Vector accessibleListeners = new Vector();
    Vector accessibleControlListeners = new Vector();
    Vector accessibleTextListeners = new Vector();
    Vector accessibleActionListeners = new Vector();
    Vector accessibleHyperlinkListeners = new Vector();
    Vector accessibleTableListeners = new Vector();
    Vector accessibleTableCellListeners = new Vector();
    Vector accessibleTextExtendedListeners = new Vector();
    Vector accessibleValueListeners = new Vector();
    Vector accessibleAttributeListeners = new Vector();
    Accessible parent;
    AccessibleObject accessibleObject;
    Control control;
    Vector relations;
    Vector children;

    public Accessible(Accessible accessible) {
        this.parent = Accessible.checkNull(accessible);
        this.control = accessible.control;
        if (accessible.children == null) {
            accessible.children = new Vector();
        }
        accessible.children.addElement(this);
    }

    protected Accessible() {
    }

    static Accessible checkNull(Accessible accessible) {
        if (accessible == null) {
            SWT.error(4);
        }
        return accessible;
    }

    Accessible(Control control) {
        this.control = control;
        AccessibleFactory.registerAccessible(this);
        control.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                AccessibleFactory.unregisterAccessible(Accessible.this);
                Accessible.this.release();
            }
        });
    }

    public void addAccessibleListener(AccessibleListener accessibleListener) {
        this.checkWidget();
        if (accessibleListener == null) {
            SWT.error(4);
        }
        this.accessibleListeners.addElement(accessibleListener);
    }

    public void addAccessibleControlListener(AccessibleControlListener accessibleControlListener) {
        this.checkWidget();
        if (accessibleControlListener == null) {
            SWT.error(4);
        }
        this.accessibleControlListeners.addElement(accessibleControlListener);
    }

    public void addAccessibleTextListener(AccessibleTextListener accessibleTextListener) {
        this.checkWidget();
        if (accessibleTextListener == null) {
            SWT.error(4);
        }
        if (accessibleTextListener instanceof AccessibleTextExtendedListener) {
            this.accessibleTextExtendedListeners.addElement(accessibleTextListener);
        } else {
            this.accessibleTextListeners.addElement(accessibleTextListener);
        }
    }

    public void addAccessibleActionListener(AccessibleActionListener accessibleActionListener) {
        this.checkWidget();
        if (accessibleActionListener == null) {
            SWT.error(4);
        }
        this.accessibleActionListeners.addElement(accessibleActionListener);
    }

    public void addAccessibleHyperlinkListener(AccessibleHyperlinkListener accessibleHyperlinkListener) {
        this.checkWidget();
        if (accessibleHyperlinkListener == null) {
            SWT.error(4);
        }
        this.accessibleHyperlinkListeners.addElement(accessibleHyperlinkListener);
    }

    public void addAccessibleTableListener(AccessibleTableListener accessibleTableListener) {
        this.checkWidget();
        if (accessibleTableListener == null) {
            SWT.error(4);
        }
        this.accessibleTableListeners.addElement(accessibleTableListener);
    }

    public void addAccessibleTableCellListener(AccessibleTableCellListener accessibleTableCellListener) {
        this.checkWidget();
        if (accessibleTableCellListener == null) {
            SWT.error(4);
        }
        this.accessibleTableCellListeners.addElement(accessibleTableCellListener);
    }

    public void addAccessibleValueListener(AccessibleValueListener accessibleValueListener) {
        this.checkWidget();
        if (accessibleValueListener == null) {
            SWT.error(4);
        }
        this.accessibleValueListeners.addElement(accessibleValueListener);
    }

    public void addAccessibleAttributeListener(AccessibleAttributeListener accessibleAttributeListener) {
        this.checkWidget();
        if (accessibleAttributeListener == null) {
            SWT.error(4);
        }
        this.accessibleAttributeListeners.addElement(accessibleAttributeListener);
    }

    public void addRelation(int n, Accessible accessible) {
        Relation relation;
        this.checkWidget();
        if (this.relations == null) {
            this.relations = new Vector();
        }
        if (this.relations.indexOf(relation = new Relation(n, accessible)) != -1) {
            return;
        }
        this.relations.add(relation);
        if (this.accessibleObject != null) {
            this.accessibleObject.addRelation(n, accessible);
        }
    }

    void addRelations() {
        if (this.relations == null) {
            return;
        }
        if (this.accessibleObject == null) {
            return;
        }
        int n = 0;
        while (n < this.relations.size()) {
            Relation relation = (Relation)this.relations.elementAt(n);
            this.accessibleObject.addRelation(relation.type, relation.target);
            ++n;
        }
    }

    public void dispose() {
        if (this.parent == null) {
            return;
        }
        this.release();
        this.parent.children.removeElement(this);
        this.parent = null;
    }

    public Control getControl() {
        return this.control;
    }

    void checkWidget() {
        if (!this.isValidThread()) {
            SWT.error(22);
        }
        if (this.control.isDisposed()) {
            SWT.error(24);
        }
    }

    AccessibleObject getAccessibleObject() {
        if (this.accessibleObject == null) {
            if (this.parent == null) {
                AccessibleFactory.createAccessible(this);
            } else {
                this.accessibleObject = AccessibleFactory.createChildAccessible(this, -1);
                this.accessibleObject.parent = this.parent.getAccessibleObject();
            }
        }
        return this.accessibleObject;
    }

    int getControlHandle() {
        int n;
        int n2 = this.control.handle;
        if (this.control instanceof Label && (n = OS.gtk_container_get_children(n2)) != 0) {
            int n3 = n;
            while (n3 != 0) {
                int n4 = OS.g_list_data(n3);
                if (OS.GTK_WIDGET_VISIBLE(n4)) {
                    n2 = n4;
                    break;
                }
                n3 = OS.g_list_next(n3);
            }
            OS.g_list_free(n);
        }
        return n2;
    }

    public static Accessible internal_new_Accessible(Control control) {
        return new Accessible(control);
    }

    boolean isValidThread() {
        return this.control.getDisplay().getThread() == Thread.currentThread();
    }

    void release() {
        if (this.children != null) {
            int n = 0;
            while (n < this.children.size()) {
                Accessible accessible = (Accessible)this.children.elementAt(n);
                accessible.dispose();
                ++n;
            }
        }
        if (this.accessibleObject != null) {
            this.accessibleObject.release();
            this.accessibleObject = null;
        }
    }

    public void removeAccessibleControlListener(AccessibleControlListener accessibleControlListener) {
        this.checkWidget();
        if (accessibleControlListener == null) {
            SWT.error(4);
        }
        this.accessibleControlListeners.removeElement(accessibleControlListener);
    }

    public void removeAccessibleListener(AccessibleListener accessibleListener) {
        this.checkWidget();
        if (accessibleListener == null) {
            SWT.error(4);
        }
        this.accessibleListeners.removeElement(accessibleListener);
    }

    public void removeAccessibleTextListener(AccessibleTextListener accessibleTextListener) {
        this.checkWidget();
        if (accessibleTextListener == null) {
            SWT.error(4);
        }
        if (accessibleTextListener instanceof AccessibleTextExtendedListener) {
            this.accessibleTextExtendedListeners.removeElement(accessibleTextListener);
        } else {
            this.accessibleTextListeners.removeElement(accessibleTextListener);
        }
    }

    public void removeAccessibleActionListener(AccessibleActionListener accessibleActionListener) {
        this.checkWidget();
        if (accessibleActionListener == null) {
            SWT.error(4);
        }
        this.accessibleActionListeners.removeElement(accessibleActionListener);
    }

    public void removeAccessibleHyperlinkListener(AccessibleHyperlinkListener accessibleHyperlinkListener) {
        this.checkWidget();
        if (accessibleHyperlinkListener == null) {
            SWT.error(4);
        }
        this.accessibleHyperlinkListeners.removeElement(accessibleHyperlinkListener);
    }

    public void removeAccessibleTableListener(AccessibleTableListener accessibleTableListener) {
        this.checkWidget();
        if (accessibleTableListener == null) {
            SWT.error(4);
        }
        this.accessibleTableListeners.removeElement(accessibleTableListener);
    }

    public void removeAccessibleTableCellListener(AccessibleTableCellListener accessibleTableCellListener) {
        this.checkWidget();
        if (accessibleTableCellListener == null) {
            SWT.error(4);
        }
        this.accessibleTableCellListeners.removeElement(accessibleTableCellListener);
    }

    public void removeAccessibleValueListener(AccessibleValueListener accessibleValueListener) {
        this.checkWidget();
        if (accessibleValueListener == null) {
            SWT.error(4);
        }
        this.accessibleValueListeners.removeElement(accessibleValueListener);
    }

    public void removeAccessibleAttributeListener(AccessibleAttributeListener accessibleAttributeListener) {
        this.checkWidget();
        if (accessibleAttributeListener == null) {
            SWT.error(4);
        }
        this.accessibleAttributeListeners.removeElement(accessibleAttributeListener);
    }

    public void removeRelation(int n, Accessible accessible) {
        this.checkWidget();
        if (this.relations == null) {
            return;
        }
        Relation relation = new Relation(n, accessible);
        int n2 = this.relations.indexOf(relation);
        if (n2 == -1) {
            return;
        }
        this.relations.remove(n2);
        if (this.accessibleObject != null) {
            this.accessibleObject.removeRelation(n, accessible);
        }
    }

    public void sendEvent(int n, Object object) {
        this.checkWidget();
        if (this.accessibleObject != null) {
            this.accessibleObject.sendEvent(n, object);
        }
    }

    public void selectionChanged() {
        this.checkWidget();
        if (this.accessibleObject != null) {
            this.accessibleObject.selectionChanged();
        }
    }

    public void setFocus(int n) {
        this.checkWidget();
        if (this.accessibleObject != null) {
            this.accessibleObject.setFocus(n);
        }
    }

    public void textCaretMoved(int n) {
        this.checkWidget();
        if (this.accessibleObject != null) {
            this.accessibleObject.textCaretMoved(n);
        }
    }

    public void textChanged(int n, int n2, int n3) {
        this.checkWidget();
        if (this.accessibleObject != null) {
            this.accessibleObject.textChanged(n, n2, n3);
        }
    }

    public void textSelectionChanged() {
        this.checkWidget();
        if (this.accessibleObject != null) {
            this.accessibleObject.textSelectionChanged();
        }
    }

    static class Relation {
        int type;
        Accessible target;

        public Relation(int n, Accessible accessible) {
            this.type = n;
            this.target = accessible;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Relation)) {
                return false;
            }
            Relation relation = (Relation)object;
            return relation.type == this.type && relation.target == this.target;
        }
    }
}

