// (c) Microsoft Corporation 2005-2007.

#light

namespace Microsoft.FSharp.Core

open Microsoft.FSharp.Core
open Microsoft.FSharp.Core.LanguagePrimitives.IntrinsicOperators
open Microsoft.FSharp.Collections
open Microsoft.FSharp.Core.Operators

[<CompilationRepresentation(CompilationRepresentationFlags.ModuleSuffix)>]
module Option = 

    let get = function None -> invalid_arg "Option.get" | Some x -> x
    let is_some = function None -> false | Some _ -> true
    let is_none = function None -> true | Some _ -> false
    let length = function None -> 0 | Some _ -> 1
    let nonempty = function None -> false | Some _ -> true
    let fold_left f s inp = match inp with None -> s | Some x -> f s x
    let fold_right f inp s =  match inp with None -> s | Some x -> f x s
    let exists p inp = match inp with None -> false | Some x -> p x
    let for_all p inp = match inp with None -> true | Some x -> p x
    let filter p inp = match inp with None -> None | Some x -> if p x then inp else None
    let partition p inp = match inp with None -> None,None | Some x -> if p x then inp,None else None,inp
    let iter f inp = match inp with None -> () | Some x -> f x
    let map f inp = match inp with None -> None | Some x -> Some (f x)
    let bind f inp = match inp with None -> None | Some x -> f x
    let to_array = function None -> [| |] | Some x -> [| x |]
    let to_list = function None -> [ ] | Some x -> [ x ]
