(*==========================================================================
 * (c) Microsoft Corporation 2005-2007.  The interface to the module 
 * is similar to that found in versions of other ML implementations, 
 * but is not an exact match.  The type signatures in this interface
 * are an edited version of those generated automatically by running 
 * "bin\fsc.exe -i" on the implementation file.
 *=========================================================================*)

/// Byte arrays. Arrays of bytes are guaranteed to be type-compatible
/// with the C# byte[] type, regardless of the version of .NET used.
module Microsoft.FSharp.Compatibility.OCaml.Bytearray
open Microsoft.FSharp.Compatibility.OCaml
open Microsoft.FSharp.Compatibility.OCaml.Pervasives

type bytearray = byte[]

val append: byte[] -> byte[] -> byte[]
val blit: byte[] -> int -> byte[] -> int -> int -> unit
val compare: byte[] -> byte[] -> int
val concat: byte[] list -> byte[]
val copy: byte[] -> byte[]
val create: int -> byte[]
val fill: byte[] -> int -> int -> byte -> unit

///Apply a function to each element of the collection, threading an 'accumulator' argument
///through the computation. If the elements are "i0...iN" then computes "f (... (f s i0)...) iN"
val fold_left: ('a -> byte -> 'a) -> 'a -> byte[] -> 'a

///Apply a function to each element of the collection, threading an 'accumulator' argument
///through the computation. If the elements are "i0...iN" then computes "f i0 (...(f iN s))".
val fold_right: (byte -> 'a -> 'a) -> byte[] -> 'a -> 'a
val get: byte[] -> int -> byte
val init: int -> (int -> byte) -> byte[]

///Apply the given function to each element of the collection. 
val iter: (byte -> unit) -> byte[] -> unit

///Apply the given function to each element of the collection. The integer passed to the
///function indicates the index of element.
val iteri: (int -> byte -> unit) -> byte[] -> unit

val length: byte[] -> int
val make: int -> byte[]
///Build a new collection whose elements are the results of applying the given function
///to each of the elements of the collection.
val map: (byte -> byte) -> byte[] -> byte[]

///Build a new collection whose elements are the results of applying the given function
///to each of the elements of the collection. The integer index passed to the
///function indicates the index of element being transformed.
val mapi: (int -> byte -> byte) -> byte[] -> byte[]

///Build a collection from the given list
val of_list: byte list -> byte[]
val set: byte[] -> int -> byte -> unit
val sub: byte[] -> int -> int -> byte[]

///Build a list from the given collection
val to_list: byte[] -> byte list
val zero_create: int -> byte[]

(* --------------------------------------------------------------------
 * Text encodings: convert between Unicode and AsciiTables encodings of
 * textual data.  Other encodings can be accessed very easily,
 * e.g. the functions below are defined as
 *
 * let ascii_to_string (b:byte[]) = System.Text.Encoding.ASCII.GetString(b)
 * let string_to_ascii (s:string) = System.Text.Encoding.ASCII.GetBytes(s)
 * -------------------------------------------------------------------- *)
 
type encoding = System.Text.Encoding
val ascii_to_string: byte[] -> string
val string_to_ascii: string -> byte[]
