(* (c) Microsoft Corporation 2005-2007.  *)

(* Rebind z,q,nums to implement the ocaml library APIs *)

module Microsoft.FSharp.Compatibility.OCaml.Num
open Microsoft.FSharp.Compatibility.OCaml
open Microsoft.FSharp.Compatibility.OCaml.Pervasives

open Microsoft.FSharp.Math
open Microsoft.FSharp.Math.BigInt

module N = Microsoft.FSharp.Math.BigNum
type num = bignum

let Big_int(x) = N.of_bigint x
let Int(x) = N.of_int x
//let Ratio(x) = N.of_rational x

//let of_float(x) = N.of_float x

let minus_num(x) = N.neg(x)
  
let add_num x y = N.add x y 
let sub_num x y = N.sub x y 
let mult_num x y = N.mul x y 
let div_num  x y = N.div x y 
// val quo_num  : num -> num -> num
// val mod_num  : num -> num -> num
let abs_num x = if N.sign x < 0 then N.neg x else x
let succ_num x = N.add x (N.of_int 1)
let pred_num x = N.sub x (N.of_int 1)
let pow_num x n = N.powi x n 
//NYI: val square_num   : num -> num
let incr_num r = r := succ_num !r
let decr_num r = (r := pred_num !r)

//NYI: val is_integer_num : num -> bool
//NYI: val floor_num: num -> num
//NYI: val round_num: num -> num
//NYI: val ceiling_num: num -> num
let sign_num(n) = N.sign n

let ( +/ ) x y = add_num x y 
let ( -/ ) x y = sub_num x y 
let ( */ ) x y = mult_num x y 
let ( >/ ) x y = N.gt x y 
let ( </ ) x y = N.lt x y 
let ( <=/ ) x y = N.lte x y 
let ( >=/ ) x y = N.gte x y 
// This value is not available in F# because the token is used
// for comments.
//  val (//)      : num -> num -> num 

//NYI: val power_num   : num -> num -> num
//NYI: val (**/): num -> num -> num


let compare_num x y = N.compare x y 
let max_num  x y = N.max x y 
let min_num  x y = N.min x y 
let to_float n = N.to_float n

let ( <>/ ) x y = not ((compare_num x y) = 0)
let ( =/ ) x y = ((compare_num x y) = 0)


//let int_of_num(n:num) = 
let big_int_of_num(n) = N.to_bigint(n)
let num_of_big_int(x) = Big_int(x)
let float_of_num(x) = N.to_float(x)
//let num_of_float(x) = N.of_float(x)
let int_of_num(x) = N.to_int(x)


let neg x = N.neg x
let add x y = N.add x y
let sub x y = N.sub x y 
let mul x y = N.mul x y 
let div x y = N.div x y 
let pow x y = N.powi x y 

let string_of_num n = N.to_string n
let num_of_string s = N.of_string s
