/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.containers;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.RandomAccess;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtilRt;
import org.jetbrains.kotlin.com.intellij.util.concurrency.AtomicFieldUpdater;
import org.jetbrains.kotlin.com.intellij.util.containers.ConcurrentList;
import org.jetbrains.kotlin.com.intellij.util.containers.EmptyIterator;
import org.jetbrains.kotlin.com.intellij.util.containers.EmptyListIterator;

class LockFreeCopyOnWriteArrayList<E>
implements ConcurrentList<E>,
List<E>,
RandomAccess {
    @NotNull
    private volatile Object[] array = ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    private static final AtomicFieldUpdater<LockFreeCopyOnWriteArrayList, Object[]> ARRAY_UPDATER = AtomicFieldUpdater.forFieldOfType(LockFreeCopyOnWriteArrayList.class, Object[].class);

    LockFreeCopyOnWriteArrayList() {
    }

    private boolean replaceArray(@NotNull Object[] oldArray, @NotNull Object[] newArray) {
        if (oldArray == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(2);
        }
        if (newArray == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(3);
        }
        return ARRAY_UPDATER.compareAndSet(this, oldArray, newArray);
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    private static int indexOf(Object o, @NotNull Object[] elements, int index2, int fence) {
        if (elements == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(4);
        }
        return ArrayUtilRt.indexOf(elements, o, index2, fence);
    }

    private static int lastIndexOf(Object o, @NotNull Object[] elements, int index2) {
        if (elements == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(5);
        }
        if (o == null) {
            for (int i = index2; i >= 0; --i) {
                if (elements[i] != null) continue;
                return i;
            }
        } else {
            for (int i = index2; i >= 0; --i) {
                if (!o.equals(elements[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public boolean contains(Object o) {
        Object[] elements = this.array;
        return LockFreeCopyOnWriteArrayList.indexOf(o, elements, 0, elements.length) >= 0;
    }

    @Override
    public int indexOf(Object o) {
        Object[] elements = this.array;
        return LockFreeCopyOnWriteArrayList.indexOf(o, elements, 0, elements.length);
    }

    @Override
    public int lastIndexOf(Object o) {
        Object[] elements = this.array;
        return LockFreeCopyOnWriteArrayList.lastIndexOf(o, elements, elements.length - 1);
    }

    @Override
    @NotNull
    public Object[] toArray() {
        Object[] elements = this.array;
        if (elements.length == 0) {
            if (ArrayUtilRt.EMPTY_OBJECT_ARRAY == null) {
                LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(6);
            }
            return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }
        Object[] objectArray = Arrays.copyOf(elements, elements.length, Object[].class);
        if (objectArray == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(7);
        }
        return objectArray;
    }

    @Override
    @NotNull
    public <T> T[] toArray(@NotNull T[] a) {
        Object[] elements;
        int len;
        if (a == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(8);
        }
        if (a.length < (len = (elements = this.array).length)) {
            T[] TArray = Arrays.copyOf(elements, len, a.getClass());
            if (TArray == null) {
                LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(9);
            }
            return TArray;
        }
        System.arraycopy(elements, 0, a, 0, len);
        if (a.length > len) {
            a[len] = null;
        }
        if (a == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(10);
        }
        return a;
    }

    private E get(@NotNull Object[] a, int index2) {
        if (a == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(11);
        }
        return (E)a[index2];
    }

    @Override
    public E get(int index2) {
        return this.get(this.array, index2);
    }

    @Override
    public E set(int index2, E element) throws IndexOutOfBoundsException {
        E oldValue;
        Object[] newElements;
        Object[] elements;
        while (!this.replaceArray(elements, newElements = (oldValue = this.get(elements = this.array, index2)) == element ? elements : LockFreeCopyOnWriteArrayList.createArraySet(elements, index2, element))) {
        }
        return oldValue;
    }

    @NotNull
    private static Object[] createArraySet(@NotNull Object[] elements, int index2, Object element) {
        if (elements == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(12);
        }
        int len = elements.length;
        Object[] newElements = Arrays.copyOf(elements, len, Object[].class);
        newElements[index2] = element;
        if (newElements == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(13);
        }
        return newElements;
    }

    @Override
    public boolean add(E e) {
        Object[] newElements;
        Object[] elements;
        while (!this.replaceArray(elements = this.array, newElements = this.createArrayAdd(elements, e))) {
        }
        return true;
    }

    @NotNull
    private Object[] createArrayAdd(@NotNull Object[] elements, E e) {
        if (elements == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(14);
        }
        int len = elements.length;
        Object[] newElements = new Object[len + 1];
        if (len != 0) {
            System.arraycopy(elements, 0, newElements, 0, len);
        }
        newElements[len] = e;
        if (newElements == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(15);
        }
        return newElements;
    }

    @Override
    public void add(int index2, E element) throws IndexOutOfBoundsException {
        Object[] newElements;
        Object[] elements;
        while (!this.replaceArray(elements = this.array, newElements = this.createArrayAdd(elements, index2, element))) {
        }
    }

    @NotNull
    private Object[] createArrayAdd(@NotNull Object[] elements, int index2, E element) {
        int numMoved;
        int len;
        if (elements == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(16);
        }
        if (index2 > (len = elements.length) || index2 < 0) {
            throw new IndexOutOfBoundsException("Index: " + index2 + ", Size: " + len);
        }
        Object[] newElements = new Object[len + 1];
        if (index2 != 0) {
            System.arraycopy(elements, 0, newElements, 0, index2);
        }
        if ((numMoved = len - index2) != 0) {
            System.arraycopy(elements, index2, newElements, index2 + 1, numMoved);
        }
        newElements[index2] = element;
        if (newElements == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(17);
        }
        return newElements;
    }

    @Override
    public E remove(int index2) throws IndexOutOfBoundsException {
        Object[] newElements;
        Object[] elements;
        while (!this.replaceArray(elements = this.array, newElements = LockFreeCopyOnWriteArrayList.createArrayRemove(elements, index2))) {
        }
        E oldValue = this.get(elements, index2);
        return oldValue;
    }

    @NotNull
    private static Object[] createArrayRemove(@NotNull Object[] elements, int index2) {
        int numMoved;
        int len;
        Object[] newElements;
        if (elements == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(18);
        }
        Object[] objectArray = newElements = (len = elements.length) == 1 ? ArrayUtilRt.EMPTY_OBJECT_ARRAY : new Object[len - 1];
        if (index2 != 0) {
            System.arraycopy(elements, 0, newElements, 0, index2);
        }
        if ((numMoved = len - index2 - 1) != 0) {
            System.arraycopy(elements, index2 + 1, newElements, index2, numMoved);
        }
        if (newElements == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(19);
        }
        return newElements;
    }

    @Override
    public boolean remove(Object o) {
        Object[] newElements;
        Object[] elements;
        do {
            if ((newElements = LockFreeCopyOnWriteArrayList.createArrayRemove(elements = this.array, o)) != null) continue;
            return false;
        } while (!this.replaceArray(elements, newElements));
        return true;
    }

    @Nullable
    private static Object[] createArrayRemove(@NotNull Object[] elements, Object o) {
        int i;
        int len;
        if (elements == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(20);
        }
        if ((len = elements.length) == 0) {
            return null;
        }
        int newLen = len - 1;
        Object[] newElements = newLen == 0 ? ArrayUtilRt.EMPTY_OBJECT_ARRAY : new Object[newLen];
        for (i = newLen; i != 0; --i) {
            Object element = elements[i];
            if (Objects.equals(o, element)) {
                System.arraycopy(elements, 0, newElements, 0, i);
                break;
            }
            newElements[i - 1] = element;
        }
        if (i == 0 && !Objects.equals(o, elements[0])) {
            return null;
        }
        return newElements;
    }

    @Override
    public boolean addIfAbsent(E e) {
        Object[] newElements;
        Object[] elements;
        do {
            elements = this.array;
            int len = elements.length;
            newElements = new Object[len + 1];
            for (int i = 0; i < len; ++i) {
                if (Objects.equals(e, elements[i])) {
                    return false;
                }
                newElements[i] = elements[i];
            }
            newElements[len] = e;
        } while (!this.replaceArray(elements, newElements));
        return true;
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        if (c == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(21);
        }
        Object[] elements = this.array;
        int len = elements.length;
        for (Object e : c) {
            if (LockFreeCopyOnWriteArrayList.indexOf(e, elements, 0, len) >= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        Object[] newElements;
        Object[] elements;
        if (c == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(22);
        }
        if (c.isEmpty()) {
            return false;
        }
        do {
            if ((newElements = LockFreeCopyOnWriteArrayList.createArrayRemoveAll(elements = this.array, c)) != null) continue;
            return false;
        } while (!this.replaceArray(elements, newElements));
        return true;
    }

    @Nullable
    private static Object[] createArrayRemoveAll(@NotNull Object[] elements, @NotNull Collection<?> c) {
        int len;
        if (elements == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(23);
        }
        if (c == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(24);
        }
        if ((len = elements.length) == 0) {
            return null;
        }
        int newLen = 0;
        Object[] temp = new Object[len];
        for (Object element : elements) {
            if (c.contains(element)) continue;
            temp[newLen++] = element;
        }
        if (newLen == len) {
            return null;
        }
        return Arrays.copyOf(temp, newLen, Object[].class);
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        Object[] newElements;
        Object[] elements;
        if (c == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(25);
        }
        do {
            if ((newElements = LockFreeCopyOnWriteArrayList.createArrayRetainAll(elements = this.array, c)) != null) continue;
            return false;
        } while (!this.replaceArray(elements, newElements));
        return true;
    }

    @Nullable
    private static Object[] createArrayRetainAll(@NotNull Object[] elements, @NotNull Collection<?> c) {
        int len;
        if (elements == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(26);
        }
        if (c == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(27);
        }
        if ((len = elements.length) == 0) {
            return null;
        }
        int newlen = 0;
        Object[] temp = new Object[len];
        for (Object element : elements) {
            if (!c.contains(element)) continue;
            temp[newlen++] = element;
        }
        if (newlen == len) {
            return null;
        }
        return Arrays.copyOf(temp, newlen, Object[].class);
    }

    @Override
    public void clear() {
        this.array = ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends E> c) {
        Object[] newElements;
        Object[] elements;
        if (c == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(29);
        }
        if (c.isEmpty()) {
            return false;
        }
        Object[] cs = c.toArray();
        if (cs.length == 0) {
            return false;
        }
        while (!this.replaceArray(elements = this.array, newElements = LockFreeCopyOnWriteArrayList.createArrayAddAll(elements, cs))) {
        }
        return true;
    }

    @NotNull
    private static Object[] createArrayAddAll(@NotNull Object[] elements, @NotNull Object[] cs) {
        if (elements == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(30);
        }
        if (cs == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(31);
        }
        int len = elements.length;
        Object[] newElements = Arrays.copyOf(elements, len + cs.length, Object[].class);
        System.arraycopy(cs, 0, newElements, len, cs.length);
        if (newElements == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(32);
        }
        return newElements;
    }

    @Override
    public boolean addAll(int index2, @NotNull Collection<? extends E> c) throws IndexOutOfBoundsException {
        Object[] newElements;
        Object[] elements;
        Object[] cs;
        if (c == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(33);
        }
        if ((cs = c.toArray()).length == 0) {
            return false;
        }
        while (!this.replaceArray(elements = this.array, newElements = LockFreeCopyOnWriteArrayList.createArrayAddAll(elements, index2, cs))) {
        }
        return true;
    }

    @NotNull
    private static Object[] createArrayAddAll(@NotNull Object[] elements, int index2, @NotNull Object[] cs) {
        Object[] newElements;
        int len;
        if (elements == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(34);
        }
        if (cs == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(35);
        }
        if (index2 > (len = elements.length) || index2 < 0) {
            throw new IndexOutOfBoundsException("Index: " + index2 + ", Size: " + len);
        }
        int numMoved = len - index2;
        if (numMoved == 0) {
            newElements = Arrays.copyOf(elements, len + cs.length, Object[].class);
        } else {
            newElements = new Object[len + cs.length];
            System.arraycopy(elements, 0, newElements, 0, index2);
            System.arraycopy(elements, index2, newElements, index2 + cs.length, numMoved);
        }
        System.arraycopy(cs, 0, newElements, index2, cs.length);
        if (newElements == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(36);
        }
        return newElements;
    }

    @NotNull
    public String toString() {
        String string2 = Arrays.toString(this.array);
        if (string2 == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(37);
        }
        return string2;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        List list2 = (List)o;
        Iterator it = list2.iterator();
        for (Object element : this.array) {
            if (it.hasNext() && Objects.equals(element, it.next())) continue;
            return false;
        }
        return !it.hasNext();
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        for (Object obj : this.array) {
            hashCode = 31 * hashCode + (obj == null ? 0 : obj.hashCode());
        }
        return hashCode;
    }

    @Override
    @NotNull
    public Iterator<E> iterator() {
        Object[] elements = this.array;
        if (elements.length == 0) {
            EmptyIterator emptyIterator = EmptyIterator.getInstance();
            if (emptyIterator == null) {
                LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(38);
            }
            return emptyIterator;
        }
        COWIterator cOWIterator = new COWIterator(elements, 0);
        if (cOWIterator == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(39);
        }
        return cOWIterator;
    }

    @Override
    @NotNull
    public ListIterator<E> listIterator() {
        ListIterator<E> listIterator = this.listIterator(0);
        if (listIterator == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(40);
        }
        return listIterator;
    }

    @Override
    @NotNull
    public ListIterator<E> listIterator(int index2) {
        Object[] elements = this.array;
        int len = elements.length;
        if (index2 < 0 || index2 > len) {
            throw new IndexOutOfBoundsException("Index: " + index2);
        }
        ListIterator listIterator = elements.length == 0 ? EmptyListIterator.getInstance() : new COWIterator(elements, index2);
        if (listIterator == null) {
            LockFreeCopyOnWriteArrayList.$$$reportNull$$$0(41);
        }
        return listIterator;
    }

    @Override
    @NotNull
    public List<E> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 32: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 32: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 32: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/containers/LockFreeCopyOnWriteArrayList";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldArray";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newArray";
                break;
            }
            case 4: 
            case 5: 
            case 12: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 23: 
            case 26: 
            case 30: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "a";
                break;
            }
            case 31: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cs";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/containers/LockFreeCopyOnWriteArrayList";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getArray";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "toArray";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createArraySet";
                break;
            }
            case 15: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createArrayAdd";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createArrayRemove";
                break;
            }
            case 32: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "createArrayAddAll";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "toString";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "iterator";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "listIterator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 32: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "replaceArray";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "indexOf";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "lastIndexOf";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "toArray";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createArraySet";
                break;
            }
            case 14: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createArrayAdd";
                break;
            }
            case 18: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createArrayRemove";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "containsAll";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "removeAll";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createArrayRemoveAll";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "retainAll";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createArrayRetainAll";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "addAllAbsent";
                break;
            }
            case 29: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "addAll";
                break;
            }
            case 30: 
            case 31: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "createArrayAddAll";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 9: 
            case 10: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 32: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private class COWIterator
    implements ListIterator<E> {
        private final Object[] snapshot;
        private int cursor;
        private int lastRet;

        private COWIterator(Object[] elements, int initialCursor) {
            if (elements == null) {
                COWIterator.$$$reportNull$$$0(0);
            }
            this.lastRet = -1;
            this.cursor = initialCursor;
            this.snapshot = elements;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.snapshot.length;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor > 0;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastRet = this.cursor;
            return this.snapshot[this.cursor++];
        }

        @Override
        public E previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.lastRet = --this.cursor;
            return this.snapshot[this.cursor];
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new NoSuchElementException();
            }
            Object e = this.snapshot[this.lastRet];
            this.lastRet = -1;
            LockFreeCopyOnWriteArrayList.this.remove(e);
        }

        @Override
        public void set(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(E e) {
            throw new UnsupportedOperationException();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "org/jetbrains/kotlin/com/intellij/util/containers/LockFreeCopyOnWriteArrayList$COWIterator", "<init>"));
        }
    }
}

