/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.quality;

import groovy.lang.Closure;
import groovy.lang.DelegatesTo;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.project.IsolatedAntBuilder;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.quality.CheckstyleReports;
import org.gradle.api.plugins.quality.internal.CheckstyleInvoker;
import org.gradle.api.plugins.quality.internal.CheckstyleReportsImpl;
import org.gradle.api.provider.Provider;
import org.gradle.api.reporting.Reporting;
import org.gradle.api.resources.TextResource;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Console;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.VerificationTask;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.util.ClosureBackedAction;

@CacheableTask
public class Checkstyle
extends SourceTask
implements VerificationTask,
Reporting<CheckstyleReports> {
    private FileCollection checkstyleClasspath;
    private FileCollection classpath;
    private TextResource config;
    private Map<String, Object> configProperties = new LinkedHashMap<String, Object>();
    private final CheckstyleReports reports;
    private boolean ignoreFailures;
    private int maxErrors;
    private int maxWarnings = Integer.MAX_VALUE;
    private boolean showViolations = true;
    private final DirectoryProperty configDirectory = this.getObjectFactory().directoryProperty();

    @Internal
    public File getConfigFile() {
        return this.getConfig() == null ? null : this.getConfig().asFile();
    }

    public void setConfigFile(File configFile) {
        this.setConfig(this.getProject().getResources().getText().fromFile((Object)configFile));
    }

    public Checkstyle() {
        this.reports = (CheckstyleReports)this.getObjectFactory().newInstance(CheckstyleReportsImpl.class, new Object[]{this});
    }

    @Inject
    protected ObjectFactory getObjectFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    public IsolatedAntBuilder getAntBuilder() {
        throw new UnsupportedOperationException();
    }

    public CheckstyleReports reports(@DelegatesTo(value=CheckstyleReports.class, strategy=1) Closure closure) {
        return this.reports((Action)new ClosureBackedAction(closure));
    }

    public CheckstyleReports reports(Action<? super CheckstyleReports> configureAction) {
        configureAction.execute((Object)this.reports);
        return this.reports;
    }

    @TaskAction
    public void run() {
        CheckstyleInvoker.invoke(this);
    }

    @PathSensitive(value=PathSensitivity.RELATIVE)
    public FileTree getSource() {
        return super.getSource();
    }

    @Classpath
    public FileCollection getCheckstyleClasspath() {
        return this.checkstyleClasspath;
    }

    public void setCheckstyleClasspath(FileCollection checkstyleClasspath) {
        this.checkstyleClasspath = checkstyleClasspath;
    }

    @Classpath
    public FileCollection getClasspath() {
        return this.classpath;
    }

    public void setClasspath(FileCollection classpath) {
        this.classpath = classpath;
    }

    @Nested
    public TextResource getConfig() {
        return this.config;
    }

    public void setConfig(TextResource config) {
        this.config = config;
    }

    @Nullable
    @Optional
    @Input
    public Map<String, Object> getConfigProperties() {
        return this.configProperties;
    }

    public void setConfigProperties(@Nullable Map<String, Object> configProperties) {
        this.configProperties = configProperties;
    }

    @Optional
    @PathSensitive(value=PathSensitivity.RELATIVE)
    @InputDirectory
    @Nullable
    @Deprecated
    public File getConfigDir() {
        ((DeprecationMessageBuilder.DeprecateMethod)DeprecationLogger.deprecateMethod(Checkstyle.class, (String)"getConfigDir()").replaceWith((Object)"Checkstyle.getConfigDirectory()")).willBeRemovedInGradle7().withDslReference(Checkstyle.class, "configDir").nagUser();
        File configDir = (File)this.getConfigDirectory().getAsFile().getOrNull();
        if (configDir != null && configDir.exists()) {
            return configDir;
        }
        return null;
    }

    @Deprecated
    public void setConfigDir(Provider<File> configDir) {
        ((DeprecationMessageBuilder.DeprecateMethod)DeprecationLogger.deprecateMethod(Checkstyle.class, (String)"setConfigDir()").replaceWith((Object)"Checkstyle.getConfigDirectory().set()")).willBeRemovedInGradle7().withDslReference(Checkstyle.class, "configDir").nagUser();
        this.configDirectory.set(this.getProject().getLayout().dir(configDir));
    }

    @Internal
    public DirectoryProperty getConfigDirectory() {
        return this.configDirectory;
    }

    @Nested
    public final CheckstyleReports getReports() {
        return this.reports;
    }

    public boolean getIgnoreFailures() {
        return this.ignoreFailures;
    }

    @Internal
    public boolean isIgnoreFailures() {
        return this.ignoreFailures;
    }

    public void setIgnoreFailures(boolean ignoreFailures) {
        this.ignoreFailures = ignoreFailures;
    }

    @Input
    public int getMaxErrors() {
        return this.maxErrors;
    }

    public void setMaxErrors(int maxErrors) {
        this.maxErrors = maxErrors;
    }

    @Input
    public int getMaxWarnings() {
        return this.maxWarnings;
    }

    public void setMaxWarnings(int maxWarnings) {
        this.maxWarnings = maxWarnings;
    }

    @Console
    public boolean isShowViolations() {
        return this.showViolations;
    }

    public void setShowViolations(boolean showViolations) {
        this.showViolations = showViolations;
    }
}

