/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api.condition;

import org.junit.jupiter.api.condition.EnabledForJreRange;
import org.junit.jupiter.api.condition.EnabledOnJreCondition;
import org.junit.jupiter.api.condition.JRE;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.Preconditions;

class EnabledForJreRangeCondition
implements ExecutionCondition {
    private static final ConditionEvaluationResult ENABLED_BY_DEFAULT = ConditionEvaluationResult.enabled("@EnabledForJreRange is not present");

    EnabledForJreRangeCondition() {
    }

    @Override
    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        return AnnotationUtils.findAnnotation(context.getElement(), EnabledForJreRange.class).map(enabledForJreRange -> {
            JRE min = enabledForJreRange.min();
            JRE max = enabledForJreRange.max();
            Preconditions.condition((min != JRE.JAVA_8 || max != JRE.OTHER ? 1 : 0) != 0, (String)"You must declare a non-default value for min or max in @EnabledForJreRange");
            Preconditions.condition((max.compareTo(min) >= 0 ? 1 : 0) != 0, (String)"@EnabledForJreRange.min must be less than or equal to @EnabledForJreRange.max");
            return JRE.isCurrentVersionWithinRange(min, max) ? EnabledOnJreCondition.ENABLED_ON_CURRENT_JRE : EnabledOnJreCondition.DISABLED_ON_CURRENT_JRE;
        }).orElse(ENABLED_BY_DEFAULT);
    }
}

