/*
 * Decompiled with CFR 0.152.
 */
package groovyx.gpars.activeobject;

import groovyx.gpars.activeobject.ActiveMethod;
import groovyx.gpars.activeobject.ActiveObject;
import groovyx.gpars.activeobject.InternalActor;
import groovyx.gpars.util.ASTUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeExpressionTransformer;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.ASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;

@GroovyASTTransformation(phase=CompilePhase.CANONICALIZATION)
public class ActiveObjectASTTransformation
implements ASTTransformation {
    public void visit(ASTNode[] nodes, SourceUnit source) {
        if (nodes.length != 2 || !(nodes[0] instanceof AnnotationNode) || !(nodes[1] instanceof AnnotatedNode)) {
            ASTUtils.addError("Internal error: expecting [AnnotationNode, AnnotatedNode] but got: " + Arrays.asList(nodes), nodes[0], source);
        }
        AnnotatedNode targetClass = (AnnotatedNode)nodes[1];
        AnnotationNode activeObjectAnnotation = (AnnotationNode)nodes[0];
        String actorFieldName = ActiveObjectASTTransformation.lookupActorFieldName(activeObjectAnnotation);
        String actorGroupName = ActiveObjectASTTransformation.lookupActorGroupName(activeObjectAnnotation);
        if (!(targetClass instanceof ClassNode)) {
            throw new GroovyBugError("Class annotation " + activeObjectAnnotation.getClassNode().getName() + " annotated no Class, this must not happen.");
        }
        ClassNode classNode = (ClassNode)targetClass;
        boolean rootActiveObject = ActiveObjectASTTransformation.isRootActiveObject(classNode);
        if (!rootActiveObject && !actorFieldName.equals("internalActiveObjectActor")) {
            ASTUtils.addError("Actor field name can only be specified at the top of the active object hierarchy. Apparently a superclass of this class is also an active object.", (ASTNode)classNode, source);
        }
        if (!rootActiveObject && actorGroupName.length() != 0) {
            ASTUtils.addError("Active object's actor group can only be specified at the top of the active object hierarchy. Apparently a superclass of this class is also an active object.", (ASTNode)classNode, source);
        }
        MyClassCodeExpressionTransformer transformer = new MyClassCodeExpressionTransformer(source, actorFieldName, actorGroupName);
        transformer.visitClass(classNode);
    }

    private static boolean isRootActiveObject(ClassNode classNode) {
        for (ClassNode superClass = classNode.getSuperClass(); superClass != null; superClass = superClass.getSuperClass()) {
            List annotations = superClass.getAnnotations(new ClassNode(ActiveObject.class));
            if (annotations.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private static String lookupActorFieldName(AnnotationNode logAnnotation) {
        Expression member = logAnnotation.getMember("actorName");
        if (member != null && member.getText() != null) {
            return member.getText();
        }
        return "internalActiveObjectActor";
    }

    private static String lookupActorGroupName(AnnotationNode logAnnotation) {
        Expression member = logAnnotation.getMember("value");
        if (member != null && member.getText() != null) {
            return member.getText();
        }
        return "";
    }

    private static class MyClassCodeExpressionTransformer
    extends ClassCodeExpressionTransformer {
        private FieldNode actorNode;
        private final SourceUnit source;
        private final String actorFieldName;
        private final String actorGroupName;

        private MyClassCodeExpressionTransformer(SourceUnit source, String actorFieldName, String actorGroupName) {
            this.source = source;
            this.actorFieldName = actorFieldName;
            this.actorGroupName = actorGroupName;
        }

        protected SourceUnit getSourceUnit() {
            return this.source;
        }

        public Expression transform(Expression exp) {
            if (exp == null) {
                return null;
            }
            return super.transform(exp);
        }

        public void visitClass(ClassNode node) {
            FieldNode actorField = node.getField(this.actorFieldName);
            if (actorField != null) {
                if (actorField.getType().getName().contains("groovyx.gpars.activeobject.InternalActor")) {
                    this.actorNode = actorField;
                } else {
                    this.addError("Active Object cannot have a field named " + this.actorFieldName + " declared", (ASTNode)actorField);
                }
            } else {
                this.actorNode = MyClassCodeExpressionTransformer.addActorFieldToClass(node, this.actorFieldName, this.actorGroupName);
            }
            ArrayList copyOfMethods = new ArrayList(node.getMethods());
            for (MethodNode method : copyOfMethods) {
                List annotations = method.getAnnotations(new ClassNode(ActiveMethod.class));
                if (annotations.isEmpty()) continue;
                if (method.isStatic()) {
                    this.addError("Static methods cannot be active", (ASTNode)method);
                }
                MyClassCodeExpressionTransformer.addActiveMethod(this.actorNode, node, method, this.checkBlockingMethod(method, annotations));
            }
            super.visitClass(node);
        }

        private boolean checkBlockingMethod(MethodNode method, Iterable<AnnotationNode> annotations) {
            boolean blocking = false;
            for (AnnotationNode annotation : annotations) {
                Expression member = annotation.getMember("blocking");
                if (member == null || member.getText() == null || !"true".equals(member.getText())) continue;
                blocking = true;
            }
            ClassNode returnType = method.getReturnType();
            String text = returnType.getName();
            if (!blocking && MyClassCodeExpressionTransformer.blockingMandated(text)) {
                this.addError("Non-blocking methods must not return a specific type. Use def or void instead.", (ASTNode)method);
                return true;
            }
            return blocking;
        }

        private static boolean blockingMandated(String text) {
            assert (text != null);
            return !"java.lang.Object".equals(text) && !"void".equals(text) && !text.contains("groovyx.gpars.dataflow.DataflowVariable") && !text.contains("groovyx.gpars.dataflow.Promise");
        }

        private static void addActiveMethod(FieldNode actorNode, ClassNode owner, MethodNode original, boolean blocking) {
            if (original.isSynthetic()) {
                return;
            }
            ArgumentListExpression args = new ArgumentListExpression();
            Parameter[] params = original.getParameters();
            Parameter[] newParams = new Parameter[params.length];
            args.addExpression((Expression)new VariableExpression("this"));
            args.addExpression((Expression)new ConstantExpression((Object)original.getName()));
            for (int i = 0; i < newParams.length; ++i) {
                Parameter newParam = new Parameter(MyClassCodeExpressionTransformer.nonGeneric(params[i].getType()), params[i].getName());
                newParam.setInitialExpression(params[i].getInitialExpression());
                newParams[i] = newParam;
                args.addExpression((Expression)new VariableExpression((Variable)newParam));
            }
            MethodNode newMethod = owner.addMethod(MyClassCodeExpressionTransformer.findSuitablePrivateMethodName(owner, original), 0, new ClassNode(Object.class), newParams, original.getExceptions(), original.getCode());
            newMethod.setGenericsTypes(original.getGenericsTypes());
            String submitMethodName = blocking ? "submitAndWait" : "submit";
            original.setCode((Statement)new ExpressionStatement((Expression)new MethodCallExpression((Expression)new VariableExpression((Variable)actorNode), submitMethodName, (Expression)args)));
        }

        private static String findSuitablePrivateMethodName(ClassNode owner, MethodNode original) {
            String newMethodName = "activeObject_" + original.getName();
            int counter = 1;
            while (owner.hasMethod(newMethodName, original.getParameters())) {
                newMethodName = "activeObject_" + original.getName() + counter;
                ++counter;
            }
            return newMethodName;
        }

        private static ClassNode nonGeneric(ClassNode type) {
            if (type.isUsingGenerics()) {
                ClassNode nonGen = ClassHelper.makeWithoutCaching((String)type.getName());
                nonGen.setRedirect(type);
                nonGen.setGenericsTypes(null);
                nonGen.setUsingGenerics(false);
                return nonGen;
            }
            return type;
        }

        private static FieldNode addActorFieldToClass(ClassNode classNode, String logFieldName, String actorGroupName) {
            ArgumentListExpression args = new ArgumentListExpression();
            args.addExpression((Expression)new ConstantExpression((Object)actorGroupName));
            return classNode.addField(logFieldName, 148, new ClassNode(InternalActor.class), (Expression)new MethodCallExpression((Expression)new ClassExpression(new ClassNode(InternalActor.class)), "create", (Expression)args));
        }
    }
}

