/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.testng.IMethodInstance;
import org.testng.ITestNGMethod;
import org.testng.annotations.ITestAnnotation;
import org.testng.collections.Lists;
import org.testng.collections.Sets;
import org.testng.internal.AbstractParallelWorker;
import org.testng.internal.IConfigInvoker;
import org.testng.internal.IInvoker;
import org.testng.internal.ITestInvoker;
import org.testng.internal.MethodInstance;
import org.testng.internal.TestMethodWorker;
import org.testng.thread.IWorker;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

class ClassBasedParallelWorker
extends AbstractParallelWorker {
    ClassBasedParallelWorker() {
    }

    private static Set<Class<?>> gatherClassesThatShouldRunSequentially(AbstractParallelWorker.Arguments arguments) {
        Set<Class<?>> sequentialClasses = Sets.newHashSet();
        for (ITestNGMethod m : arguments.getMethods()) {
            Class cls = m.getRealClass();
            ITestAnnotation test = arguments.getFinder().findAnnotation(cls, ITestAnnotation.class);
            if (!ClassBasedParallelWorker.isSequential(test, arguments.getTestContext().getCurrentXmlTest())) continue;
            sequentialClasses.add(cls);
        }
        return sequentialClasses;
    }

    @Override
    public List<IWorker<ITestNGMethod>> createWorkers(AbstractParallelWorker.Arguments arguments) {
        List<IWorker<ITestNGMethod>> result = Lists.newArrayList();
        Set<Class<?>> sequentialClasses = ClassBasedParallelWorker.gatherClassesThatShouldRunSequentially(arguments);
        List<IMethodInstance> methodInstances = Lists.newArrayList();
        for (ITestNGMethod tm : arguments.getMethods()) {
            methodInstances.addAll(this.methodsToMultipleMethodInstances(tm));
        }
        Set processedClasses = Sets.newHashSet();
        Map<String, String> params = null;
        Class<?> prevClass = null;
        for (IMethodInstance im : methodInstances) {
            TestMethodWorker worker;
            Class<?> c = im.getMethod().getTestClass().getRealClass();
            if (!c.equals(prevClass)) {
                params = ClassBasedParallelWorker.getParameters(im);
                prevClass = c;
            }
            if (ClassBasedParallelWorker.shouldRunSequentially(c, sequentialClasses)) {
                if (processedClasses.contains(c)) continue;
                processedClasses.add(c);
                worker = ClassBasedParallelWorker.createTestMethodWorker(arguments, methodInstances, params, c);
                result.add(worker);
                continue;
            }
            worker = ClassBasedParallelWorker.createTestMethodWorker(arguments, Collections.singletonList(im), params, c);
            result.add(worker);
        }
        return result;
    }

    private static boolean shouldRunSequentially(Class<?> c, Set<Class<?>> sequentialClasses) {
        return sequentialClasses.contains(c) || sequentialClasses.stream().anyMatch(each -> each.isAssignableFrom(c));
    }

    private static List<IMethodInstance> findClasses(List<IMethodInstance> methodInstances, Class<?> c) {
        return methodInstances.stream().filter(mi -> mi.getMethod().getTestClass().getRealClass() == c).collect(Collectors.toList());
    }

    private static TestMethodWorker createTestMethodWorker(AbstractParallelWorker.Arguments attributes, List<IMethodInstance> methodInstances, Map<String, String> params, Class<?> c) {
        IInvoker invoker = attributes.getInvoker();
        ITestInvoker testInvoker = invoker.getTestInvoker();
        IConfigInvoker configInvoker = invoker.getConfigInvoker();
        return new TestMethodWorker(testInvoker, configInvoker, ClassBasedParallelWorker.findClasses(methodInstances, c), params, attributes.getConfigMethods(), attributes.getClassMethodMap(), attributes.getTestContext(), attributes.getListeners());
    }

    private List<MethodInstance> methodsToMultipleMethodInstances(ITestNGMethod ... methods) {
        return Arrays.stream(methods).map(MethodInstance::new).collect(Collectors.toList());
    }

    private static boolean isSequential(ITestAnnotation test, XmlTest xmlTest) {
        return test != null && test.getSingleThreaded() || XmlSuite.ParallelMode.CLASSES.equals((Object)xmlTest.getParallel());
    }

    private static Map<String, String> getParameters(IMethodInstance im) {
        XmlTest xmlTest = im.getMethod().getXmlTest();
        return im.getMethod().findMethodParameters(xmlTest);
    }
}

