/*
 * Decompiled with CFR 0.152.
 */
package groovy.xml;

import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.codehaus.groovy.vmplugin.VMPluginFactory;

public class FactorySupport {
    static Object createFactory(PrivilegedExceptionAction action) throws ParserConfigurationException {
        Object factory;
        try {
            factory = VMPluginFactory.getPlugin().doPrivileged(action);
        }
        catch (PrivilegedActionException pae) {
            Exception e = pae.getException();
            if (e instanceof ParserConfigurationException) {
                throw (ParserConfigurationException)e;
            }
            throw new RuntimeException(e);
        }
        return factory;
    }

    public static DocumentBuilderFactory createDocumentBuilderFactory() throws ParserConfigurationException {
        return (DocumentBuilderFactory)FactorySupport.createFactory(DocumentBuilderFactory::newInstance);
    }

    public static SAXParserFactory createSaxParserFactory() throws ParserConfigurationException {
        return (SAXParserFactory)FactorySupport.createFactory(SAXParserFactory::newInstance);
    }
}

