/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.UnrecoverableExceptions;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.FilterResult;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestEngine;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.launcher.EngineDiscoveryResult;
import org.junit.platform.launcher.LauncherDiscoveryListener;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.PostDiscoveryFilter;
import org.junit.platform.launcher.core.EngineDiscoveryErrorDescriptor;
import org.junit.platform.launcher.core.EngineDiscoveryResultValidator;
import org.junit.platform.launcher.core.EngineFilterer;
import org.junit.platform.launcher.core.EngineIdValidator;
import org.junit.platform.launcher.core.LauncherDiscoveryResult;
import org.junit.platform.launcher.core.ListenerRegistry;

@API(status=API.Status.INTERNAL, since="1.7", consumers={"org.junit.platform.testkit", "org.junit.platform.suite.engine"})
public class EngineDiscoveryOrchestrator {
    private static final Logger logger = LoggerFactory.getLogger(EngineDiscoveryOrchestrator.class);
    private final EngineDiscoveryResultValidator discoveryResultValidator = new EngineDiscoveryResultValidator();
    private final Iterable<TestEngine> testEngines;
    private final Collection<PostDiscoveryFilter> postDiscoveryFilters;
    private final ListenerRegistry<LauncherDiscoveryListener> launcherDiscoveryListenerRegistry;

    public EngineDiscoveryOrchestrator(Iterable<TestEngine> testEngines, Collection<PostDiscoveryFilter> postDiscoveryFilters) {
        this(testEngines, postDiscoveryFilters, ListenerRegistry.forLauncherDiscoveryListeners());
    }

    EngineDiscoveryOrchestrator(Iterable<TestEngine> testEngines, Collection<PostDiscoveryFilter> postDiscoveryFilters, ListenerRegistry<LauncherDiscoveryListener> launcherDiscoveryListenerRegistry) {
        this.testEngines = EngineIdValidator.validate(testEngines);
        this.postDiscoveryFilters = postDiscoveryFilters;
        this.launcherDiscoveryListenerRegistry = launcherDiscoveryListenerRegistry;
    }

    public LauncherDiscoveryResult discover(LauncherDiscoveryRequest request, Phase phase) {
        Map<TestEngine, TestDescriptor> result = this.discover(request, phase, UniqueId::forEngine);
        return new LauncherDiscoveryResult(result, request.getConfigurationParameters());
    }

    public LauncherDiscoveryResult discover(LauncherDiscoveryRequest request, Phase phase, UniqueId parentId) {
        Map<TestEngine, TestDescriptor> testEngines = this.discover(request, phase, arg_0 -> ((UniqueId)parentId).appendEngine(arg_0));
        LauncherDiscoveryResult result = new LauncherDiscoveryResult(testEngines, request.getConfigurationParameters());
        return result.withRetainedEngines(TestDescriptor::containsTests);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<TestEngine, TestDescriptor> discover(LauncherDiscoveryRequest request, Phase phase, Function<String, UniqueId> uniqueIdCreator) {
        LauncherDiscoveryListener listener = this.getLauncherDiscoveryListener(request);
        listener.launcherDiscoveryStarted(request);
        try {
            Map<TestEngine, TestDescriptor> map = this.discoverSafely(request, phase, listener, uniqueIdCreator);
            return map;
        }
        finally {
            listener.launcherDiscoveryFinished(request);
        }
    }

    private Map<TestEngine, TestDescriptor> discoverSafely(LauncherDiscoveryRequest request, Phase phase, LauncherDiscoveryListener listener, Function<String, UniqueId> uniqueIdCreator) {
        LinkedHashMap<TestEngine, TestDescriptor> testEngineDescriptors = new LinkedHashMap<TestEngine, TestDescriptor>();
        EngineFilterer engineFilterer = new EngineFilterer(request.getEngineFilters());
        for (TestEngine testEngine : this.testEngines) {
            boolean engineIsExcluded = engineFilterer.isExcluded(testEngine);
            if (engineIsExcluded) {
                logger.debug(() -> String.format("Test discovery for engine '%s' was skipped due to an EngineFilter in %s phase.", new Object[]{testEngine.getId(), phase}));
                continue;
            }
            logger.debug(() -> String.format("Discovering tests during Launcher %s phase in engine '%s'.", new Object[]{phase, testEngine.getId()}));
            TestDescriptor rootDescriptor = this.discoverEngineRoot(testEngine, request, listener, uniqueIdCreator);
            testEngineDescriptors.put(testEngine, rootDescriptor);
        }
        engineFilterer.performSanityChecks();
        LinkedList<PostDiscoveryFilter> filters = new LinkedList<PostDiscoveryFilter>(this.postDiscoveryFilters);
        filters.addAll(request.getPostDiscoveryFilters());
        this.applyPostDiscoveryFilters(testEngineDescriptors, filters);
        this.prune(testEngineDescriptors);
        return testEngineDescriptors;
    }

    private TestDescriptor discoverEngineRoot(TestEngine testEngine, LauncherDiscoveryRequest request, LauncherDiscoveryListener listener, Function<String, UniqueId> uniqueIdCreator) {
        UniqueId uniqueEngineId = uniqueIdCreator.apply(testEngine.getId());
        try {
            listener.engineDiscoveryStarted(uniqueEngineId);
            TestDescriptor engineRoot = testEngine.discover((EngineDiscoveryRequest)request, uniqueEngineId);
            this.discoveryResultValidator.validate(testEngine, engineRoot);
            listener.engineDiscoveryFinished(uniqueEngineId, EngineDiscoveryResult.successful());
            return engineRoot;
        }
        catch (Throwable throwable) {
            UnrecoverableExceptions.rethrowIfUnrecoverable((Throwable)throwable);
            String message = String.format("TestEngine with ID '%s' failed to discover tests", testEngine.getId());
            JUnitException cause = new JUnitException(message, throwable);
            listener.engineDiscoveryFinished(uniqueEngineId, EngineDiscoveryResult.failed((Throwable)cause));
            return new EngineDiscoveryErrorDescriptor(uniqueEngineId, testEngine, (Throwable)cause);
        }
    }

    LauncherDiscoveryListener getLauncherDiscoveryListener(LauncherDiscoveryRequest discoveryRequest) {
        return ListenerRegistry.copyOf(this.launcherDiscoveryListenerRegistry).add(discoveryRequest.getDiscoveryListener()).getCompositeListener();
    }

    private void applyPostDiscoveryFilters(Map<TestEngine, TestDescriptor> testEngineDescriptors, List<PostDiscoveryFilter> filters) {
        Filter postDiscoveryFilter = Filter.composeFilters(filters);
        LinkedHashMap<String, List<TestDescriptor>> excludedTestDescriptorsByReason = new LinkedHashMap<String, List<TestDescriptor>>();
        TestDescriptor.Visitor removeExcludedTestDescriptors = descriptor -> {
            FilterResult filterResult = postDiscoveryFilter.apply((Object)descriptor);
            if (!descriptor.isRoot() && this.isExcluded(descriptor, filterResult)) {
                this.populateExclusionReasonInMap(filterResult.getReason(), descriptor, excludedTestDescriptorsByReason);
                descriptor.removeFromHierarchy();
            }
        };
        this.acceptInAllTestEngines(testEngineDescriptors, removeExcludedTestDescriptors);
        this.logTestDescriptorExclusionReasons(excludedTestDescriptorsByReason);
    }

    private void populateExclusionReasonInMap(Optional<String> reason, TestDescriptor testDescriptor, Map<String, List<TestDescriptor>> excludedTestDescriptorsByReason) {
        excludedTestDescriptorsByReason.computeIfAbsent(reason.orElse("Unknown"), list -> new LinkedList()).add(testDescriptor);
    }

    private void logTestDescriptorExclusionReasons(Map<String, List<TestDescriptor>> excludedTestDescriptorsByReason) {
        excludedTestDescriptorsByReason.forEach((exclusionReason, testDescriptors) -> {
            String displayNames = testDescriptors.stream().map(TestDescriptor::getDisplayName).collect(Collectors.joining(", "));
            long containerCount = testDescriptors.stream().filter(TestDescriptor::isContainer).count();
            long methodCount = testDescriptors.stream().filter(TestDescriptor::isTest).count();
            logger.config(() -> String.format("%d containers and %d tests were %s", containerCount, methodCount, exclusionReason));
            logger.debug(() -> String.format("The following containers and tests were %s: %s", exclusionReason, displayNames));
        });
    }

    private void prune(Map<TestEngine, TestDescriptor> testEngineDescriptors) {
        this.acceptInAllTestEngines(testEngineDescriptors, TestDescriptor::prune);
    }

    private boolean isExcluded(TestDescriptor descriptor, FilterResult filterResult) {
        return descriptor.getChildren().isEmpty() && filterResult.excluded();
    }

    private void acceptInAllTestEngines(Map<TestEngine, TestDescriptor> testEngineDescriptors, TestDescriptor.Visitor visitor) {
        testEngineDescriptors.values().forEach(descriptor -> descriptor.accept(visitor));
    }

    public static enum Phase {
        DISCOVERY,
        EXECUTION;


        public String toString() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

