/*
 * Decompiled with CFR 0.152.
 */
package groovyjarjarharmonybeans;

import groovyjarjarharmonybeans.Command;
import groovyjarjarharmonybeans.internal.nls.Messages;
import groovyjarjaropenbeans.XMLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Handler
extends DefaultHandler {
    private Vector<Object> result;
    private Vector<Command> commands;
    private XMLDecoder decoder;
    private Map<String, Command> references;
    private Stack<Command> stack;
    private int tabCount;

    public Handler(XMLDecoder decoder, Vector<Object> result) {
        this.decoder = decoder;
        this.result = result;
        this.commands = new Vector();
        this.references = new HashMap<String, Command>();
        this.stack = new Stack();
    }

    @Override
    public void startDocument() {
        this.references.clear();
        this.tabCount = 0;
    }

    @Override
    public void startElement(String namespaceURI, String localeName, String tagName, Attributes attrs) throws SAXException {
        Command.printAttrs(this.tabCount, tagName, attrs);
        Command cmd = tagName.equals("java") ? new Command(this.decoder, tagName, Command.parseAttrs(tagName, attrs)) : new Command(tagName, Command.parseAttrs(tagName, attrs));
        this.stack.push(cmd);
        ++this.tabCount;
    }

    @Override
    public void characters(char[] text, int start, int length) throws SAXException {
        String data;
        if (length > 0 && (data = String.valueOf(text, start, length).replace('\n', ' ').replace('\t', ' ').trim()).length() > 0) {
            Command.prn(this.tabCount, this.tabCount + ">setting data=" + data + "<EOL>");
            Command cmd = this.stack.peek();
            cmd.setData(data);
        }
    }

    @Override
    public void endElement(String namespaceURI, String localeName, String tagName) throws SAXException {
        Command cmd = this.stack.pop();
        if (!this.stack.isEmpty()) {
            Command ctx = this.stack.peek();
            ctx.addChild(cmd);
        }
        if (this.stack.size() == 1 && cmd.isExecutable()) {
            this.commands.add(cmd);
        }
        if (cmd.hasAttr("id")) {
            this.references.put(cmd.getAttr("id"), cmd);
        }
        try {
            cmd.exec(this.references);
        }
        catch (Exception e) {
            SAXException e2 = new SAXException(e.getMessage());
            e2.initCause(e);
            throw e2;
        }
        if (--this.tabCount < 0) {
            this.tabCount = 0;
        }
        Command.prn(this.tabCount, this.tabCount + ">...<" + tagName + "> end");
    }

    @Override
    public void endDocument() throws SAXException {
        Command cmd;
        int i;
        for (i = 0; i < this.commands.size(); ++i) {
            cmd = this.commands.elementAt(i);
            try {
                cmd.backtrack(this.references);
                continue;
            }
            catch (Exception e) {
                throw new SAXException(Messages.getString("beans.0B"));
            }
        }
        for (i = 0; i < this.commands.size(); ++i) {
            cmd = this.commands.elementAt(i);
            this.result.add(cmd.getResultValue());
        }
    }
}

