/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.core.LauncherDiscoveryResult;

class InternalTestPlan
extends TestPlan {
    private final AtomicBoolean executionStarted = new AtomicBoolean(false);
    private final LauncherDiscoveryResult discoveryResult;
    private final TestPlan delegate;

    static InternalTestPlan from(LauncherDiscoveryResult discoveryResult) {
        TestPlan delegate = TestPlan.from(discoveryResult.getEngineTestDescriptors(), discoveryResult.getConfigurationParameters());
        return new InternalTestPlan(discoveryResult, delegate);
    }

    private InternalTestPlan(LauncherDiscoveryResult discoveryResult, TestPlan delegate) {
        super(delegate.containsTests(), delegate.getConfigurationParameters());
        this.discoveryResult = discoveryResult;
        this.delegate = delegate;
    }

    void markStarted() {
        if (!this.executionStarted.compareAndSet(false, true)) {
            throw new PreconditionViolationException("TestPlan must only be executed once");
        }
    }

    LauncherDiscoveryResult getDiscoveryResult() {
        return this.discoveryResult;
    }

    public TestPlan getDelegate() {
        return this.delegate;
    }

    @Override
    public void add(TestIdentifier testIdentifier) {
        this.delegate.add(testIdentifier);
    }

    @Override
    public void addInternal(TestIdentifier testIdentifier) {
        this.delegate.addInternal(testIdentifier);
    }

    @Override
    public Set<TestIdentifier> getRoots() {
        return this.delegate.getRoots();
    }

    @Override
    public Optional<TestIdentifier> getParent(TestIdentifier child) {
        return this.delegate.getParent(child);
    }

    @Override
    public Set<TestIdentifier> getChildren(TestIdentifier parent) {
        return this.delegate.getChildren(parent);
    }

    @Override
    public Set<TestIdentifier> getChildren(String parentId) {
        return this.delegate.getChildren(parentId);
    }

    @Override
    public TestIdentifier getTestIdentifier(String uniqueId) throws PreconditionViolationException {
        return this.delegate.getTestIdentifier(uniqueId);
    }

    @Override
    public long countTestIdentifiers(Predicate<? super TestIdentifier> predicate) {
        return this.delegate.countTestIdentifiers(predicate);
    }

    @Override
    public Set<TestIdentifier> getDescendants(TestIdentifier parent) {
        return this.delegate.getDescendants(parent);
    }

    @Override
    public boolean containsTests() {
        return this.delegate.containsTests();
    }
}

